/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraModel;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostCameraModelDao
extends AbstractIdDao<ForpostCameraModel>
implements Directory<ForpostCameraModel> {
    private Logger logger = LogManager.getLogger();

    public ForpostCameraModelDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_forpost_camera_model");
    }

    public ForpostCameraModel get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }

    public List<ForpostCameraModel> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    protected ForpostCameraModel getFromRS(ResultSet rs) throws SQLException, BGException {
        return new ForpostCameraModel(rs.getInt("id"), rs.getInt("brand_id"), rs.getString("name"));
    }

    protected void updateImpl(ForpostCameraModel forpostCameraModel) throws BGException {
        if (forpostCameraModel != null) {
            try {
                int parameterIndex = 1;
                boolean insert = forpostCameraModel.getId() > 0;
                String sql = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET id=?, name=?, brand_id=?" + (insert ? "" : " WHERE id=?");
                PreparedStatement ps = this.con.prepareStatement(sql);
                ps.setInt(parameterIndex++, forpostCameraModel.getId());
                ps.setString(parameterIndex++, forpostCameraModel.getName());
                ps.setInt(parameterIndex++, forpostCameraModel.getBrandId());
                if (!insert) {
                    ps.setInt(parameterIndex++, forpostCameraModel.getId());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(ps.toString());
                }
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void searchForpostCameraModels(SearchResult<ForpostCameraModel> searchResult, int brandId) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + (brandId > 0 ? " WHERE brand_id=? " : "") + (page != null ? page.sqlLimit() : ""), 1);){
            if (brandId > 0) {
                ps.setInt(1, brandId);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void doSync(ForpostCameraModel[] cameraModels) throws BGException {
        if (cameraModels == null) {
            return;
        }
        long now = System.currentTimeMillis();
        try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, name=?, brand_id=?, sync_datetime=? ON DUPLICATE KEY UPDATE name=?, brand_id=?, sync_datetime=?");
             PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE sync_datetime<>?");){
            for (ForpostCameraModel forpostCameraModel : cameraModels) {
                int parameterIndex = 1;
                psInsert.setInt(parameterIndex++, forpostCameraModel.getId());
                psInsert.setString(parameterIndex++, forpostCameraModel.getName());
                psInsert.setInt(parameterIndex++, forpostCameraModel.getBrandId());
                psInsert.setLong(parameterIndex++, now);
                psInsert.setString(parameterIndex++, forpostCameraModel.getName());
                psInsert.setInt(parameterIndex++, forpostCameraModel.getBrandId());
                psInsert.setLong(parameterIndex++, now);
                psInsert.executeUpdate();
            }
            psDelete.setLong(1, now);
            psDelete.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

