/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import java.util.HashMap;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUtils;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostCameraService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseId;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseStatus;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostAccountDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostCameraDao;
import ru.bitel.bgbilling.modules.smarthouse.server.event.ForpostCameraAddEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostCameraService")
public class ForpostCameraServiceImpl
extends AbstractService
implements ForpostCameraService {
    public SearchResult<ForpostTMCAO<ForpostCamera>> searchForpostCameras(KeyValue filter, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setSort(sort);
        searchResult.setPage(page);
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            forpostCameraDao.searchForpostCameras((SearchResult<ForpostTMCAO<ForpostCamera>>)searchResult, filter);
        }
        return searchResult;
    }

    public SearchResult<ForpostCamera> searchForpostAccountCameras(int accountId) throws BGException {
        SearchResult searchResult = new SearchResult();
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            forpostCameraDao.searchForpostAccountCameras((SearchResult<ForpostCamera>)searchResult, accountId);
        }
        return searchResult;
    }

    public void doSync() throws BGException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
             ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            for (int accountId : forpostAccountDao.getIds()) {
                forpostCameraDao.doSync(forpostManager.getCameras(accountId, 0, 0));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void doSyncForpostCameras(int accountId) throws BGException {
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            forpostCameraDao.doSync(new ForpostManager(this.moduleId).getCameras(accountId, 0, 0));
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostCamera getDefaultForpostCamera() throws BGException {
        ModuleSetup moduleSetup = this.getModuleSetup();
        ForpostCamera forpostCamera = new ForpostCamera();
        forpostCamera.put("SkipCameraCheck", (Object)moduleSetup.get("forpost.camera.skip.check", String.valueOf(0)));
        return forpostCamera;
    }

    public int addForpostCamera(int contractId, ForpostCamera forpostCamera) throws BGException, BGMessageException {
        int n;
        ForpostCameraAddEvent event = new ForpostCameraAddEvent(this.moduleId, contractId, forpostCamera);
        forpostCamera = ((ForpostCameraAddEvent)EventProcessor.getInstance().request((QueueEvent)event)).getForpostCamera();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Name", forpostCamera.getName());
        params.put("AccountID", String.valueOf(forpostCamera.getAccountId()));
        params.put("IPOrDomain", forpostCamera.getIpOrDomain());
        params.put("Login", forpostCamera.getLogin());
        params.put("Password", String.valueOf(forpostCamera.get("Password")));
        params.put("MasterID", String.valueOf(forpostCamera.getMasterId()));
        params.put("Port", String.valueOf(forpostCamera.getPort()));
        params.put("MJPEG", forpostCamera.getString("MJPEG", ""));
        params.put("RecordType", forpostCamera.getString("RecordType", ""));
        params.put("IsActive", String.valueOf(forpostCamera.getIsActive()));
        params.put("HTTPPort", forpostCamera.getString("HTTPPort", "80"));
        String maxBandwidth = forpostCamera.getString("MaxBandwidth", null);
        if (maxBandwidth != null) {
            params.put("MaxBandwidth", maxBandwidth);
        }
        params.put("IsActive", String.valueOf(forpostCamera.getIsActive()));
        int cameraModelId = forpostCamera.getInt("CameraModelID", 0);
        if (cameraModelId > 0) {
            params.put("CameraModelID", String.valueOf(cameraModelId));
        }
        params.put("MasterID", String.valueOf(forpostCamera.getMasterId()));
        params.put("SkipCameraCheck", String.valueOf(forpostCamera.get("SkipCameraCheck")));
        ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);
        try {
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseId responseId = forpostManager.addCamera(params);
            if (responseId.getErrorCode() > 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
            }
            int cameraId = responseId.getId();
            forpostCamera.setId(cameraId);
            forpostCameraDao.update(forpostCamera);
            n = cameraId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    forpostCameraDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        forpostCameraDao.close();
        return n;
    }

    public void updateForpostCamera(ForpostCamera forpostCamera) throws BGException, BGMessageException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ID", String.valueOf(forpostCamera.getId()));
        ForpostUtils.putParams(params, (String)"Name", (String)forpostCamera.getName());
        ForpostUtils.putParams(params, (String)"AccountObjectID", (String)String.valueOf(forpostCamera.getAccountObjectId()));
        ForpostUtils.putParams(params, (String)"MasterID", (String)String.valueOf(forpostCamera.getMasterId()));
        ForpostUtils.putParams(params, (String)"Login", (String)forpostCamera.getLogin());
        ForpostUtils.putParams(params, (String)"Password", (String)forpostCamera.getString("Password"));
        ForpostUtils.putParams(params, (String)"IPOrDomain", (String)forpostCamera.getIpOrDomain());
        ForpostUtils.putParams(params, (String)"IsActive", (String)String.valueOf(forpostCamera.getIsActive()));
        ForpostUtils.putParams(params, (String)"Port", (String)String.valueOf(forpostCamera.getPort()));
        ForpostUtils.putParams(params, (String)"HTTPPort", (String)forpostCamera.getString("HTTPPort"));
        ForpostUtils.putParams(params, (String)"IsSound", (String)forpostCamera.getString("IsSound"));
        ForpostUtils.putParams(params, (String)"RecordType", (String)forpostCamera.getString("RecordType"));
        ForpostUtils.putParams(params, (String)"MaxBandwidth", (String)forpostCamera.getString("MaxBandwidth"));
        ForpostUtils.putParams(params, (String)"Address", (String)forpostCamera.getString("Address"));
        ForpostUtils.putParams(params, (String)"CameraModelID", (String)forpostCamera.getString("CameraModelID"));
        ForpostUtils.putParams(params, (String)"Protocol", (String)forpostCamera.getString("Protocol"));
        ForpostUtils.putParams(params, (String)"RtspTransport", (String)forpostCamera.getString("RtspTransport"));
        ForpostUtils.putParams(params, (String)"MJPEG", (String)forpostCamera.getString("MJPEG"));
        ForpostUtils.putParams(params, (String)"PTZTypeID", (String)forpostCamera.getString("PTZTypeID"));
        ForpostUtils.putParams(params, (String)"Quota", (String)forpostCamera.getString("Quota"));
        ForpostUtils.putParams(params, (String)"LightCameraBufferEnabled", (String)forpostCamera.getString("LightCameraBufferEnabled"));
        ForpostUtils.putParams(params, (String)"SecretKey", (String)forpostCamera.getString("SecretKey"));
        ForpostUtils.putParams(params, (String)"SyncCamera", (String)forpostCamera.getString("SyncCamera"));
        ForpostUtils.putParams(params, (String)"Channel", (String)forpostCamera.getString("Channel"));
        ForpostUtils.putParams(params, (String)"MAC", (String)forpostCamera.getString("MAC"));
        ForpostUtils.putParams(params, (String)"SkipCameraCheck", (String)forpostCamera.getString("SkipCameraCheck"));
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editCamera(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostCameraDao.update(forpostCamera);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void updateForpostCameraParam(int forpostCameraId, String name, String value) throws BGException, BGMessageException {
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            ForpostCamera forpostCamera = forpostCameraDao.getForpostCamera(forpostCameraId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ID", String.valueOf(forpostCamera.getId()));
            params.put(name, value);
            switch (name) {
                case "Name": {
                    forpostCamera.setName(value);
                    break;
                }
                case "AccountObjectID": {
                    forpostCamera.setAccountObjectId(Utils.parseInt((String)value));
                    break;
                }
                case "MasterID": {
                    forpostCamera.setMasterId(Utils.parseInt((String)value));
                    break;
                }
                case "Login": {
                    forpostCamera.setLogin(value);
                    break;
                }
                case "IPOrDomain": {
                    forpostCamera.setIpOrDomain(value);
                    break;
                }
                case "IsActive": {
                    forpostCamera.setIsActive(Utils.parseInt((String)value));
                    break;
                }
                case "Port": {
                    forpostCamera.setPort(Utils.parseInt((String)value));
                    break;
                }
                default: {
                    forpostCamera.put(name, (Object)value);
                }
            }
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editCamera(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostCameraDao.update(forpostCamera);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void deleteForpostCamera(int id) throws BGException, BGMessageException {
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseStatus responseStatus = forpostManager.deleteCamera(id);
            if (responseStatus.getErrorCode() > 0) {
                if (responseStatus.getErrorCode() == 1) {
                    forpostCameraDao.deleteForpostCamera(id);
                }
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
            }
            forpostCameraDao.deleteForpostCamera(id);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteForpostAccountCameras(int accountId) throws BGException, BGMessageException {
        try (ForpostCameraDao forpostCameraDao = new ForpostCameraDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            SearchResult searchResult = new SearchResult();
            forpostCameraDao.searchForpostAccountCameras((SearchResult<ForpostCamera>)searchResult, accountId);
            for (ForpostCamera forpostCamera : searchResult.getList()) {
                ResponseStatus responseStatus = forpostManager.deleteCamera(forpostCamera.getId());
                if (responseStatus.getErrorCode() > 0) {
                    if (responseStatus.getErrorCode() == 1) {
                        forpostCameraDao.deleteForpostCamera(forpostCamera.getId());
                    }
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
                }
                forpostCameraDao.deleteForpostCamera(forpostCamera.getId());
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

