/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.access.om;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.AbstractOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.ProductEntry;
import ru.bitel.bgbilling.apps.tv.access.om.ServiceEntry;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;

public class AccountOrderEvent
extends AbstractOrderEvent {
    public static final int EVENT_TYPE_ACCOUNT_CREATE = 1;
    public static final int EVENT_TYPE_ACCOUNT_MODIFY = 2;
    public static final int EVENT_TYPE_ACCOUNT_REMOVE = 3;
    public static final int EVENT_TYPE_ACCOUNT_STATE_MODIFY = 4;
    public static final int EVENT_TYPE_ACCOUNT_OPTIONS_MODIFY = 5;
    final AccountEntry entry;
    final List<AccountEntry> childrenEntryList;
    final int accessCode = 0;

    public AccountOrderEvent(TvAccess tvAccess, Event event, int deviceId, TvAccountRuntime tvAccountRuntime, int eventType, int tvAccountId, TvAccountSpec tvAccountSpec, TvAccount oldTvAccount, TvAccount newTvAccount, short oldDeviceState, short newDeviceState, Set<Integer> oldDeviceOptionIds, Set<Integer> newDeviceOptionIds, int accessCode) {
        super(tvAccess, event, deviceId, tvAccountRuntime, eventType, tvAccountId, tvAccountSpec, oldDeviceOptionIds, newDeviceOptionIds);
        this.entry = new AccountEntry(tvAccountId, oldTvAccount, oldDeviceState, newTvAccount, newDeviceState);
        Map oldChildrenMap = oldTvAccount == null || oldTvAccount.getChildren() == null ? Collections.emptyMap() : Id.newMap((List)oldTvAccount.getChildren());
        Map newChildrenMap = newTvAccount == null || newTvAccount.getChildren() == null ? Collections.emptyMap() : Id.newMap((List)newTvAccount.getChildren());
        this.childrenEntryList = new ArrayList<AccountEntry>(4);
        Date now = new Date();
        for (Map.Entry e : oldChildrenMap.entrySet()) {
            TvAccount oldChild = (TvAccount)e.getValue();
            TvAccount newChild = (TvAccount)newChildrenMap.remove(e.getKey());
            if (newDeviceState == -1 || newChild != null && !TimeUtils.dateInRange((Date)now, (Date)newChild.getDateFrom(), (Date)newChild.getDateTo())) {
                if (oldChild.getDeviceState() == -1) continue;
                newChild = null;
            }
            this.childrenEntryList.add(new AccountEntry(oldChild.getId(), oldChild, oldChild.getDeviceState(), newChild, newChild != null ? newDeviceState : (short)-1));
        }
        for (Map.Entry e : newChildrenMap.entrySet()) {
            TvAccount newChild = (TvAccount)e.getValue();
            if (newDeviceState == -1 || newChild != null && !TimeUtils.dateInRange((Date)now, (Date)newChild.getDateFrom(), (Date)newChild.getDateTo())) continue;
            this.childrenEntryList.add(new AccountEntry(newChild.getId(), null, -1, newChild, newDeviceState));
        }
    }

    public TvAccount getOldTvAccount() {
        return this.entry.oldTvAccount;
    }

    public TvAccount getNewTvAccount() {
        return this.entry.newTvAccount;
    }

    public int getOldState() {
        return this.entry.oldState;
    }

    public short getNewState() {
        return this.entry.newState;
    }

    @Override
    public Set<Integer> getOldDeviceOptionIds() {
        return this.oldDeviceOptionIds;
    }

    @Override
    public Set<Integer> getNewDeviceOptionIds() {
        return this.newDeviceOptionIds;
    }

    public AccountEntry getEntry() {
        return this.entry;
    }

    public List<AccountEntry> getChildrenEntryList() {
        return this.childrenEntryList;
    }

    @Override
    protected Map<Integer, ProductSpecRuntime> getFullProductSpecRuntimeMapToEnable() throws BGException {
        Map<Integer, ProductSpecRuntime> result = new HashMap<Integer, ProductSpecRuntime>();
        ProductSpecRuntimeMap productSpecRuntimeMap = this.tvAccess.productSpecRuntimeMap;
        ProductRuntimeList productRuntimeList = this.tvAccountRuntime.getProductRuntimeList();
        int size = productRuntimeList.size();
        for (int i = 0; i < size; ++i) {
            ProductSpecRuntime productSpecRuntime;
            ProductRuntimeList.ProductItem productItem = (ProductRuntimeList.ProductItem)productRuntimeList.get(i);
            if (productItem.deviceState != 1 || (productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(productItem.id)) == null) continue;
            result.put(productItem.id, productSpecRuntime);
        }
        if (this.filterByDepends) {
            result = this.filterProductSpecByDepends(result);
        }
        return result;
    }

    @Override
    public List<ProductEntry> getFullProductEntryListToEnable() throws BGException {
        ArrayList<ProductEntry> result = new ArrayList<ProductEntry>();
        ProductSpecRuntimeMap productSpecRuntimeMap = this.tvAccess.productSpecRuntimeMap;
        ServiceSpecRuntimeMap serviceSpecRuntimeMap = this.tvAccess.serviceSpecRuntimeMap;
        ProductRuntimeList productRuntimeList = this.tvAccountRuntime.getProductRuntimeList();
        ServiceRuntimeList serviceRuntimeList = this.tvAccountRuntime.getServiceRuntimeList();
        ProductPeriodRuntimeList productPeriodRuntimeList = this.tvAccountRuntime.getProductPeriodRuntimeList();
        int size = productRuntimeList.size();
        for (int i = 0; i < size; ++i) {
            int moduleId;
            ProductSpecRuntime productSpecRuntime;
            ProductRuntimeList.ProductItem productItem = (ProductRuntimeList.ProductItem)productRuntimeList.get(i);
            if (productItem.deviceState != 1 || (productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(productItem.id)) == null || (moduleId = productSpecRuntime.getProductSpec().getModuleId()) != this.tvAccess.moduleId) continue;
            List<ServiceRuntimeList.ServiceItem> serviceItemList = serviceRuntimeList.listByProductId(productItem.productId);
            ArrayList<ServiceEntry> serviceEntryList = new ArrayList<ServiceEntry>();
            for (ServiceRuntimeList.ServiceItem serviceItem : serviceItemList) {
                ServiceSpecRuntime serviceSpecRuntime = (ServiceSpecRuntime)serviceSpecRuntimeMap.get(serviceItem.serviceSpecId);
                if (serviceSpecRuntime == null) continue;
                Service service = serviceItem.toService(this.contractId, this.tvAccountId);
                serviceEntryList.add(new ServiceEntry(serviceSpecRuntime, service, service, serviceItem.deviceState, serviceItem.deviceState));
            }
            Product product = productItem.toProduct(this.contractId, this.tvAccountId);
            ProductPeriodRuntimeList.ProductPeriodItem productPeriodItem = productPeriodRuntimeList.getLast(productItem.productId);
            if (productPeriodItem != null) {
                product.setSubscriptionTimeFrom(productPeriodItem.prolongationTime != 0L ? new Date(productPeriodItem.prolongationTime) : new Date(productPeriodItem.timeFrom));
                product.setSubscriptionTimeTo(new Date(productPeriodItem.timeTo));
            }
            result.add(new ProductEntry(productSpecRuntime, product, product, productItem.deviceState, productItem.deviceState, serviceEntryList));
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("AccountOrderEvent type=");
        result.append(this.eventType);
        result.append("; cid: ");
        result.append(this.contractId);
        result.append("; aid: ");
        result.append(this.tvAccountId);
        result.append("; oldState: ");
        result.append(this.entry.oldState);
        result.append("; newState: ");
        result.append(this.entry.newState);
        result.append("; oldOptionSet: ");
        result.append(Utils.toString((Iterable)this.oldDeviceOptionIds));
        result.append("; newOptionSet: ");
        result.append(Utils.toString((Iterable)this.newDeviceOptionIds));
        return result.toString();
    }

    public static class AccountEntry {
        final int tvAccountId;
        final TvAccount oldTvAccount;
        final TvAccount newTvAccount;
        String deviceAccountId;
        final short oldState;
        final short newState;

        public AccountEntry(int tvAccountId, TvAccount oldTvAccount, short oldState, TvAccount newTvAccount, short newState) {
            this.tvAccountId = tvAccountId;
            this.oldTvAccount = oldTvAccount;
            this.newTvAccount = newTvAccount;
            this.oldState = oldState;
            this.newState = newState;
            if (oldTvAccount != null) {
                this.deviceAccountId = oldTvAccount.getDeviceAccountId();
            }
        }

        public TvAccount getOldTvAccount() {
            return this.oldTvAccount;
        }

        public TvAccount getNewTvAccount() {
            return this.newTvAccount;
        }

        public int getOldState() {
            return this.oldState;
        }

        public short getNewState() {
            return this.newState;
        }

        public String getDeviceAccountId() {
            return this.deviceAccountId;
        }

        public void setDeviceAccountId(String deviceAccountId) {
            this.deviceAccountId = deviceAccountId;
        }
    }
}

