/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.access.om;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.access.TvAccess;
import ru.bitel.bgbilling.apps.tv.access.om.AbstractOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.CompositeFuture;
import ru.bitel.bgbilling.apps.tv.access.om.OrderManagerSet;
import ru.bitel.bgbilling.apps.tv.access.om.ProductEntry;
import ru.bitel.bgbilling.apps.tv.access.om.ProductOrderEvent;
import ru.bitel.bgbilling.apps.tv.access.om.ServiceEntry;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.AsyncEventWorker;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.event.TvAccountCreatedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.TvAccountDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.TvProductsDeviceStateModifiedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.db.TvAccountDeviceStateAndOptionsModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.db.TvProductsDeviceStateModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvAccountModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvAccountOptionsModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvAccountServicesModify;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvAccountStateModifyEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvProductsModifyEvent;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.event.ProductStateEntry;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;
import ru.bitel.oss.systems.inventory.service.common.event.ServiceStateEntry;
import ru.bitel.oss.systems.inventory.service.server.bean.ServiceDao;

public class OrderManagerDeviceWorker
extends AsyncEventWorker<Event> {
    private final Logger logger = LogManager.getLogger();
    private final ScheduledExecutorService scheduledExecutorService;
    private final TvAccess access;
    private final int deviceId;
    private TvDeviceRuntime deviceRuntime;
    private OrderManagerSet serviceActivators;
    private EventProcessor ep;
    private ServerContext serverContext;
    private ConnectionSet connectionSet;
    private TvAccountDao tvAccountDao;
    private ProductDao productDao;
    private ServiceDao serviceDao;
    private volatile Future<?> future;
    private long errorAlarmCount;
    private long errorRedeliveryCount;
    private long errorRedeliveryTimeout;

    public OrderManagerDeviceWorker(TvAccess access, ScheduledExecutorService scheduledExecutorService, int deviceId) throws BGException {
        super(EventProcessor.getInstance(), OmTvAccountModifyEvent.class.getPackage().getName() + ".*", access.moduleId, -1, "deviceId=" + deviceId, false, new Class[]{OmTvAccountModifyEvent.class, OmTvAccountStateModifyEvent.class, OmTvProductsModifyEvent.class, OmTvAccountOptionsModifyEvent.class});
        this.scheduledExecutorService = scheduledExecutorService;
        this.access = access;
        this.deviceId = deviceId;
        this.future = scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), 3000L, 200L, TimeUnit.MILLISECONDS);
        this.logger.info("Starting deviceWorker for device " + deviceId);
    }

    protected synchronized void runImpl() throws Exception {
        int result = this.internalRunWorker(200L, false);
        if (result < 0) {
            this.logger.info("Execution error (" + this.errorCount + ") - waiting " + this.errorPause + "ms for next try.");
            this.future.cancel(false);
            this.future = this.scheduledExecutorService.scheduleWithFixedDelay((Runnable)((Object)this), this.errorPause, 200L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * Loose catch block
     */
    protected boolean runWorker() throws BGException {
        this.deviceRuntime = this.access.deviceMap.getAndLockSa(this.deviceId);
        try {
            this.serviceActivators = this.deviceRuntime.saInstances;
            this.errorPause = this.deviceRuntime.config.getLong("om.error.pause.millis", this.deviceRuntime.config.getLong("om.error.pause", -1L) * 1000L);
            if (this.errorPause < 0L) {
                this.errorPause = this.deviceRuntime.config.getLong("sa.error.pause.millis", this.deviceRuntime.config.getLong("sa.error.pause", TimeUnit.SECONDS.convert(1L, TimeUnit.MINUTES)) * 1000L);
            }
            this.errorRedeliveryCount = this.deviceRuntime.config.getLong("om.error.redelivery.count", this.deviceRuntime.config.getLong("sa.error.redelivery.count", 5L));
            this.errorAlarmCount = Math.min(this.deviceRuntime.config.getLong("om.error.alarm.count", this.deviceRuntime.config.getLong("sa.error.alarm.count", 20L)), this.errorRedeliveryCount);
            this.errorRedeliveryTimeout = this.deviceRuntime.config.getLong("om.error.redelivery.timeout.millis", this.deviceRuntime.config.getLong("om.error.redelivery.timeout", -1L) * 1000L);
            if (this.errorRedeliveryTimeout < 0L) {
                this.errorRedeliveryTimeout = this.deviceRuntime.config.getLong("sa.error.redelivery.timeout.millis", this.deviceRuntime.config.getLong("sa.error.redelivery.timeout", TimeUnit.SECONDS.convert(24L, TimeUnit.HOURS)) * 1000L);
            }
            this.batchSize = this.deviceRuntime.config.getInt("om.batch.size", this.deviceRuntime.config.getInt("sa.batch.size", 20));
            this.batchPause = this.deviceRuntime.config.getLong("om.batch.pause.millis", this.deviceRuntime.config.getLong("om.batch.pause", -1L) * 1000L);
            if (this.batchPause < 0L) {
                this.batchPause = this.deviceRuntime.config.getLong("sa.batch.pause.millis", this.deviceRuntime.config.getLong("sa.batch.pause", 0L) * 1000L);
            }
            this.batchWait = this.deviceRuntime.config.getLong("om.batch.wait.millis", this.deviceRuntime.config.getLong("om.batch.wait", -1L) * 1000L);
            if (this.batchWait < 0L) {
                this.batchWait = this.deviceRuntime.config.getLong("sa.batch.wait.millis", this.deviceRuntime.config.getLong("sa.batch.wait", 5L) * 1000L);
            }
            this.waitNextTask = this.deviceRuntime.config.getLong("om.batch.waitNext.millis", this.deviceRuntime.config.getLong("om.batch.waitNext", -1L) * 1000L);
            if (this.waitNextTask < 0L) {
                this.waitNextTask = this.deviceRuntime.config.getLong("sa.batch.waitNext.millis", this.deviceRuntime.config.getLong("sa.batch.waitNext", 5L) * 1000L);
            }
            this.ep = EventProcessor.getInstance();
            this.serverContext = new ServerContext(this.access.setup, ConnectionSet.newInstance((DefaultServerSetup)this.access.setup, (boolean)true), this.moduleId, 0);
            this.connectionSet = this.serverContext.getConnectionSet();
            try {
                this.tvAccountDao = new TvAccountDao(this.connectionSet.getConnection(), this.access.moduleId);
                this.productDao = new ProductDao(this.connectionSet.getConnection(), 0);
                this.serviceDao = new ServiceDao(this.connectionSet.getConnection());
            }
            catch (Exception ex) {
                this.logger.warn(ex.getMessage(), (Throwable)ex);
            }
            try {
                this.serviceActivators.connect(this.serverContext);
                boolean ex = this.doTasks();
                return ex;
            }
            catch (BGException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                this.serviceActivators.disconnect(this.serverContext);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.deviceRuntime != null) {
                this.deviceRuntime.saInstances.unlock();
                this.deviceRuntime = null;
            }
            this.serviceActivators = null;
            this.tvAccountDao = null;
            this.ep = null;
            if (this.serverContext != null) {
                this.serverContext.recycle();
                this.serverContext = null;
            }
            this.connectionSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTask(Object task) throws BGException {
        AbstractOrderEvent result;
        this.logger.info("Do task deviceId: " + this.deviceId + "; " + task);
        Date now = new Date();
        try {
            OmTvAccountModifyEvent e;
            if (task instanceof OmTvAccountModifyEvent) {
                e = (OmTvAccountModifyEvent)task;
                result = e.toOmEvent(this.access, this.connectionSet, now);
            } else if (task instanceof OmTvProductsModifyEvent) {
                e = (OmTvProductsModifyEvent)task;
                result = e.toOmEvent(this.access, this.connectionSet, now);
            } else if (task instanceof OmTvAccountStateModifyEvent) {
                e = (OmTvAccountStateModifyEvent)task;
                result = e.toOmEvent(this.access, this.connectionSet, now);
            } else if (task instanceof OmTvAccountOptionsModifyEvent) {
                e = (OmTvAccountOptionsModifyEvent)task;
                result = e.toOmEvent(this.access, this.connectionSet, now);
            } else if (task instanceof OmTvAccountServicesModify) {
                e = (OmTvAccountServicesModify)task;
                result = e.toOmEvent(this.access, this.connectionSet, now);
            } else {
                this.logger.error(task);
                return Boolean.TRUE;
            }
            if (result == null) {
                this.logger.debug("Skip event");
                return Boolean.TRUE;
            }
            this.logger.info("Command result event: " + result);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return Boolean.TRUE;
        }
        result.tvAccountRuntime.lock();
        try {
            Object[] ex = new Object[]{this.doCommand(result), result};
            result.tvAccountRuntime.unlock();
            return ex;
        }
        catch (Throwable throwable) {
            try {
                result.tvAccountRuntime.unlock();
                throw throwable;
            }
            catch (Throwable e) {
                throw new BGException(e);
            }
        }
    }

    private Object doCommand(AbstractOrderEvent e) throws Throwable {
        boolean result = true;
        this.logger.info("Processing deviceId:" + this.deviceId + "; command " + e);
        if (e instanceof AccountOrderEvent) {
            AccountOrderEvent event = (AccountOrderEvent)e;
            switch (event.eventType) {
                case 4: {
                    result = this.serviceActivators.accountStateModify(this, event, this.serverContext);
                    break;
                }
                case 5: {
                    result = this.serviceActivators.accountOptionsModify(this, event, this.serverContext);
                    break;
                }
                case 2: {
                    result = this.serviceActivators.accountModify(this, event, this.serverContext);
                    break;
                }
                case 3: {
                    result = this.serviceActivators.accountRemove(this, event, this.serverContext);
                    break;
                }
                case 1: {
                    result = this.serviceActivators.accountCreate(this, event, this.serverContext);
                    break;
                }
            }
        } else if (e instanceof ProductOrderEvent) {
            ProductOrderEvent event = (ProductOrderEvent)e;
            switch (event.eventType) {
                case 2: {
                    result = this.serviceActivators.productsModify(this, event, this.serverContext);
                    break;
                }
            }
        }
        this.logger.info("Process event type[" + e.eventType + "] result=" + result);
        this.serverContext.commit();
        if (result && e.futures != null) {
            if (e.futures.size() == 1) {
                return e.futures.get(0);
            }
            return new CompositeFuture(e.futures);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void taskDone(Object task, Object result) throws BGException {
        block15: {
            Object[] array;
            block14: {
                boolean optionsModified;
                boolean ok;
                boolean bl = ok = !Boolean.FALSE.equals(result);
                if (!ok) {
                    this.logger.warn("Task return false");
                    return;
                }
                if (!(task instanceof Object[])) {
                    return;
                }
                array = (Object[])task;
                if (!(array[1] instanceof AccountOrderEvent)) break block14;
                AccountOrderEvent event = (AccountOrderEvent)array[1];
                if (event.eventType != 4 && event.eventType != 5 && event.eventType != 2 && event.eventType != 1 && event.eventType != 3) break block15;
                boolean stateModified = event.getOldState() != event.getNewState() || event.getEntry().oldTvAccount != null && (event.getEntry().oldTvAccount.getDeviceAccountId() == null && event.getEntry().deviceAccountId != null || event.getEntry().oldTvAccount.getDeviceAccountId() != null && !event.getEntry().oldTvAccount.getDeviceAccountId().equals(event.getEntry().deviceAccountId));
                boolean bl2 = optionsModified = event.oldDeviceOptionIds == null && event.newDeviceOptionIds != null || event.newDeviceOptionIds != null && !event.oldDeviceOptionIds.equals(event.newDeviceOptionIds);
                if (stateModified) {
                    if (optionsModified) {
                        this.fireTvAccountDeviceStateAndOptionsModified(event, event.entry.oldState, event.entry.newState, (Set<Integer>)event.newDeviceOptionIds);
                    } else {
                        this.fireTvAccountDeviceStateAndOptionsModified(event, event.entry.oldState, event.entry.newState, null);
                    }
                } else if (optionsModified) {
                    this.fireTvAccountDeviceStateAndOptionsModified(event, event.entry.oldState, (short)-1000, (Set<Integer>)event.newDeviceOptionIds);
                }
                int size = event.childrenEntryList.size();
                for (int i = 0; i < size; ++i) {
                    AccountOrderEvent.AccountEntry child = event.childrenEntryList.get(i);
                    if (child.oldState == child.newState && (child.oldTvAccount == null || (child.oldTvAccount.getDeviceAccountId() != null || child.deviceAccountId == null) && (child.oldTvAccount.getDeviceAccountId() == null || child.oldTvAccount.getDeviceAccountId().equals(child.deviceAccountId)))) continue;
                    this.fireTvAccountDeviceStateAndOptionsModified(event, child, child.newState, null);
                }
                break block15;
            }
            if (array[1] instanceof ProductOrderEvent) {
                boolean optionsModified;
                ProductOrderEvent event = (ProductOrderEvent)array[1];
                boolean bl = optionsModified = event.oldDeviceOptionIds == null && event.newDeviceOptionIds != null || event.newDeviceOptionIds != null && !event.oldDeviceOptionIds.equals(event.newDeviceOptionIds);
                if (optionsModified) {
                    this.fireTvAccountDeviceOptionsModified(event, event.newDeviceOptionIds);
                }
                if (event.eventType == 2) {
                    event.tvAccountRuntime.lock();
                    try {
                        this.fireTvProductsStateModified(event);
                    }
                    finally {
                        event.tvAccountRuntime.unlock();
                    }
                }
            }
        }
    }

    private void fireTvProductsStateModified(ProductOrderEvent event) throws BGException {
        Short deviceState;
        int i;
        List<ProductEntry> productEntryList = event.getProductEntryList();
        if (productEntryList == null || productEntryList.size() == 0) {
            return;
        }
        ArrayList<ProductStateEntry> modifyProductEntryList = new ArrayList<ProductStateEntry>();
        HashMap<Integer, Short> productDeviceStateMap = new HashMap<Integer, Short>();
        HashMap<Integer, Short> serviceDeviceStateMap = new HashMap<Integer, Short>();
        for (ProductEntry productEntry : productEntryList) {
            boolean productStateModified = productEntry.oldState != productEntry.newState;
            List<ServiceEntry> serviceEntryList = productEntry.getServiceEntryList();
            ArrayList<ServiceStateEntry> modifyServiceEntryList = new ArrayList<ServiceStateEntry>();
            if (serviceEntryList != null) {
                for (ServiceEntry se : serviceEntryList) {
                    boolean serviceStateModified = se.oldState != se.newState;
                    if (!serviceStateModified) continue;
                    Service service = se.newService != null ? se.newService : se.oldService;
                    modifyServiceEntryList.add(new ServiceStateEntry(service.getId(), se.serviceSpec != null ? se.serviceSpec.getId() : -1, se.newState));
                    serviceDeviceStateMap.put(service.getId(), se.newState);
                }
            }
            if (!productStateModified && modifyServiceEntryList.size() == 0) continue;
            Product product = productEntry.newProduct != null ? productEntry.newProduct : productEntry.oldProduct;
            modifyProductEntryList.add(new ProductStateEntry(product.getId(), productEntry.productSpec.getId(), product.getDeviceProductId(), productEntry.newState, modifyServiceEntryList));
            productDeviceStateMap.put(product.getId(), productEntry.newState);
        }
        if (modifyProductEntryList.size() == 0) {
            return;
        }
        this.logger.info("Changing TvAccount:" + event.tvAccountId + " products state");
        try {
            for (ProductStateEntry productStateEntry : modifyProductEntryList) {
                this.productDao.updateDeviceState(event.contractId, event.tvAccountId, productStateEntry.productId, productStateEntry.deviceProductId, productStateEntry.deviceState);
                if (productStateEntry.serviceEntryList == null) continue;
                for (ServiceStateEntry se : productStateEntry.serviceEntryList) {
                    this.serviceDao.updateDeviceState(event.contractId, event.tvAccountId, se.serviceId, se.deviceState);
                }
            }
            this.connectionSet.commit();
            this.ep.publish((Event)new TvProductsDeviceStateModifiedEvent(this.access.moduleId, event.contractId, this.deviceId, event.tvAccountId, 0, modifyProductEntryList));
        }
        catch (Exception t) {
            this.ep.publish((Event)new TvProductsDeviceStateModifyEvent(this.access.moduleId, this.deviceId, event.contractId, event.tvAccountId, 0, modifyProductEntryList));
            this.logger.warn(t.getMessage(), (Throwable)t);
        }
        assert (event.tvAccountRuntime.isHeldByCurrentThread());
        ProductRuntimeList productRuntimeList = event.tvAccountRuntime.getProductRuntimeList();
        ServiceRuntimeList serviceRuntimeList = event.tvAccountRuntime.getServiceRuntimeList();
        int size = productRuntimeList.size();
        for (i = 0; i < size; ++i) {
            ProductRuntimeList.ProductItem productItem = (ProductRuntimeList.ProductItem)productRuntimeList.get(i);
            deviceState = (Short)productDeviceStateMap.get(productItem.productId);
            if (deviceState == null) continue;
            productItem.deviceState = deviceState;
        }
        size = serviceRuntimeList.size();
        for (i = 0; i < size; ++i) {
            ServiceRuntimeList.ServiceItem serviceItem = (ServiceRuntimeList.ServiceItem)serviceRuntimeList.get(i);
            deviceState = (Short)serviceDeviceStateMap.get(serviceItem.serviceId);
            if (deviceState == null) continue;
            serviceItem.deviceState = deviceState;
        }
    }

    private void fireTvAccountDeviceStateAndOptionsModified(AccountOrderEvent event, short oldState, short newState, Set<Integer> newOptionIds) throws BGException {
        this.logger.info("Changing TvAccount:" + event.tvAccountId + " state and/or options");
        try {
            this.tvAccountDao.updateDeviceStateAndOptions(event.tvAccountId, event.getEntry().deviceAccountId, newState, newOptionIds, event.accessCode);
            this.ep.publish((Event)new TvAccountDeviceStateAndOptionsModifiedEvent(this.access.moduleId, event.contractId, this.deviceId, event.tvAccountId, event.getEntry().deviceAccountId, newState, newOptionIds));
            if (oldState == -1) {
                this.ep.publish((Event)new TvAccountCreatedEvent(this.access.moduleId, event.getContractId(), this.deviceId, event.tvAccountId, event.getEntry().deviceAccountId, newState, newOptionIds));
            }
        }
        catch (Exception t) {
            this.ep.publish((Event)new TvAccountDeviceStateAndOptionsModifyEvent(this.access.moduleId, this.deviceId, event.contractId, event.tvAccountId, event.getEntry().deviceAccountId, oldState, newState, newOptionIds, event.accessCode));
            this.logger.warn(t.getMessage(), (Throwable)t);
        }
        event.tvAccountRuntime.setDeviceStateAndOptionIds(event.getEntry().deviceAccountId, newState, newOptionIds);
    }

    private void fireTvAccountDeviceOptionsModified(AbstractOrderEvent event, Set<Integer> newOptionIds) throws BGException {
        this.logger.info("Changing TvAccount:" + event.tvAccountId + " options");
        String deviceAccountId = event.getTvAccountRuntime().getTvAccount().getDeviceAccountId();
        try {
            this.tvAccountDao.updateDeviceStateAndOptions(event.tvAccountId, deviceAccountId, (short)-1000, newOptionIds, 0);
            this.ep.publish((Event)new TvAccountDeviceStateAndOptionsModifiedEvent(this.access.moduleId, event.contractId, this.deviceId, event.tvAccountId, deviceAccountId, -1000, newOptionIds));
        }
        catch (Exception t) {
            this.ep.publish((Event)new TvAccountDeviceStateAndOptionsModifyEvent(this.access.moduleId, this.deviceId, event.contractId, event.tvAccountId, deviceAccountId, -1000, -1000, newOptionIds, 0));
            this.logger.warn(t.getMessage(), (Throwable)t);
        }
        event.tvAccountRuntime.setDeviceStateAndOptionIds(deviceAccountId, (short)-1000, newOptionIds);
    }

    private void fireTvAccountDeviceStateAndOptionsModified(AccountOrderEvent event, AccountOrderEvent.AccountEntry entry, short newState, Set<Integer> newOptionIds) throws BGException {
        this.logger.info("Changing TvAccount:" + entry.tvAccountId + " state and/or options");
        try {
            this.tvAccountDao.updateDeviceStateAndOptions(entry.tvAccountId, entry.deviceAccountId, newState, newOptionIds, event.accessCode);
            this.ep.publish((Event)new TvAccountDeviceStateAndOptionsModifiedEvent(this.access.moduleId, event.contractId, this.deviceId, entry.tvAccountId, entry.deviceAccountId, newState, newOptionIds));
        }
        catch (Exception t) {
            this.ep.publish((Event)new TvAccountDeviceStateAndOptionsModifyEvent(this.access.moduleId, this.deviceId, event.contractId, entry.tvAccountId, entry.deviceAccountId, -1000, newState, newOptionIds, event.accessCode));
            this.logger.warn(t.getMessage(), (Throwable)t);
        }
        TvAccountRuntime tvAccountRuntime = this.access.tvAccountRuntimeMap.get(entry.tvAccountId);
        if (tvAccountRuntime == null && entry.newTvAccount != null) {
            tvAccountRuntime = this.access.tvAccountRuntimeMap.addRuntime(this.connectionSet, entry.newTvAccount);
        }
        if (tvAccountRuntime != null) {
            tvAccountRuntime.setDeviceStateAndOptionIds(entry.getDeviceAccountId(), newState, newOptionIds);
        }
    }

    private void initDevice(int initDeviceId, int userId) throws BGException {
        EventProcessor ep = EventProcessor.getInstance();
        boolean syncAllPath = this.deviceRuntime.config.getInt("sa.device.sync.allPath", 1) > 0;
        boolean onAccountingStart = this.deviceRuntime.config.getInt("sa.device.sync.onAccountingStart", 0) > 0;
        int initDeviceId2 = syncAllPath ? initDeviceId : this.deviceId;
        for (Integer n : this.deviceRuntime.descendantIds) {
            TvDeviceRuntime descendant;
            if (n != this.deviceId && (descendant = this.access.deviceMap.get(n)) != null && descendant.parent != null && descendant.parent.tvDeviceId == this.deviceId) continue;
        }
        boolean cancelBeforeCreate = this.deviceRuntime.config.getInt("sa.device.sync.cancelBeforeCreate", 1) > 0;
        try {
            for (TvAccountRuntime servRuntime : this.access.tvAccountRuntimeMap.values()) {
                this.initServ(initDeviceId, servRuntime, cancelBeforeCreate, onAccountingStart);
            }
        }
        catch (InterruptedException interruptedException) {
            this.logger.error(interruptedException.getMessage(), (Throwable)interruptedException);
        }
    }

    private void initServ(int inetServId, int userId) throws BGException {
        boolean onAccountingStart = this.deviceRuntime.config.getInt("sa.device.sync.onAccountingStart", 0) > 0;
        boolean cancelBeforeCreate = this.deviceRuntime.config.getInt("sa.device.sync.cancelBeforeCreate", 1) > 0;
        try {
            TvAccountRuntime servRuntime = this.access.tvAccountRuntimeMap.get(inetServId);
            this.initServ(0, servRuntime, cancelBeforeCreate, onAccountingStart);
        }
        catch (InterruptedException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void initServ(int initDeviceId, TvAccountRuntime servRuntime, boolean cancelBeforeCreate, boolean onAccountingStart) throws InterruptedException {
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + System.identityHashCode((Object)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processDoTaskException(Object task, boolean inDoTask, boolean putFirstIfInDoTask, BGException ex, boolean throwException) throws BGException {
        if (this.errorCount > this.errorAlarmCount) {
            try {
                String key = "inet.sa.error.count";
                long time = System.currentTimeMillis();
                if (AlarmSender.needAlarmSend((String)"inet.sa.error.count", (long)time, (long)600000L)) {
                    TvDeviceRuntime deviceRuntime = this.deviceRuntime;
                    StringWriter sw = new StringWriter(100);
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    AlarmErrorMessage message = new AlarmErrorMessage("inet.sa.error.count", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b OrderManager [" + deviceRuntime.tvDeviceId + "] " + deviceRuntime.tvDevice, ex.getMessage() + "\n" + sw.toString());
                    sw = null;
                    pw = null;
                    AlarmSender.sendAlarm((AlarmErrorMessage)message, (long)time);
                }
            }
            catch (Exception ex1) {
                this.logger.error(ex1.getMessage(), (Throwable)ex1);
            }
        }
        if (this.errorCount > this.errorRedeliveryCount) {
            super.processDoTaskException(task, inDoTask, false, ex, false);
            if (!(task instanceof Event)) throw ex;
            Event e = (Event)task;
            if (System.currentTimeMillis() - e.getTimestamp() < this.errorRedeliveryTimeout) {
                this.logger.info("Event redelivery: " + task);
                ((EventListenerContext)this.context).publishAfterCommit((Event)task);
                this.logger.error(ex.getMessage(), (Throwable)ex);
                return;
            } else {
                this.logger.error("Skip old event with error - " + ex.getMessage(), (Throwable)ex);
            }
            return;
        } else if (this.errorCount == this.errorRedeliveryCount) {
            super.processDoTaskException(task, inDoTask, false, ex, throwException);
            return;
        } else {
            super.processDoTaskException(task, inDoTask, putFirstIfInDoTask, ex, throwException);
        }
    }
}

