/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.tv.common.bean.TvChannelSpec;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityDao;

public class TvChannelSpecDao
extends AbstractEntityDao<TvChannelSpec>
implements Directory<TvChannelSpec> {
    private PreparedStatement insertPS = null;
    private PreparedStatement updatePS = null;

    public TvChannelSpecDao(Connection con, int moduleId) {
        this(con, moduleId, 0);
    }

    public TvChannelSpecDao(Connection con, int moduleId, int userId) {
        super(con, moduleId, userId, "tv_channel_spec", null);
    }

    protected TvChannelSpec getFromRSImpl(ResultSet rs) throws SQLException, BGException {
        TvChannelSpec result = new TvChannelSpec();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setEntityId(rs.getInt("entityId"));
        result.setServiceSpecId(rs.getInt("serviceSpecId"));
        result.setIdentifier(rs.getString("identifier"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    public TvChannelSpec get(String title) throws BGException {
        return (TvChannelSpec)this.get("identifier=?", new Object[]{title});
    }

    public List<TvChannelSpec> list() throws BGException {
        return this.list(null, null, new Object[0]);
    }

    public List<TvChannelSpec> list(int serviceSpecId, Date dateFrom, Date dateTo, String title, List<FilterEntityAttr> entityFilter) throws BGException {
        java.sql.Date sqlDateFrom = TimeUtils.convertDateToSqlDate((Date)dateFrom);
        java.sql.Date sqlDateTo = TimeUtils.convertDateToSqlDate((Date)dateTo);
        return super.list(true, null, null, null, entityFilter, "(? OR serviceSpecId=?) AND (? OR dateFrom IS NULL OR dateFrom<=?) AND (? OR dateTo IS NULL OR ?<=dateTo) AND (? OR " + this.tableName + ".title LIKE ?)", this.tableName + ".id", null, new Object[]{serviceSpecId < 0, serviceSpecId, sqlDateTo == null, sqlDateTo, sqlDateFrom == null, sqlDateFrom, Utils.isBlankString((String)title), "%" + title + "%"});
    }

    protected void updateImpl(TvChannelSpec b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getId() > 0) {
            ps = this.updatePS;
            if (ps == null) {
                ps = this.updatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET  entityId=?, title=?, identifier=?, dateFrom=?, dateTo=?, comment=? WHERE id=?");
            }
            ps.setInt(7, b.getId());
        } else {
            ps = this.insertPS;
            if (ps == null) {
                ps = this.insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (entityId, title, identifier, dateFrom, dateTo, comment, serviceSpecId) VALUES (?,?,?,?,?,?,?)", 1);
            }
            ps.setInt(7, b.getServiceSpecId());
        }
        ps.setInt(1, b.getEntityId());
        ps.setString(2, b.getTitle());
        ps.setString(3, b.getIdentifier());
        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)b.getDateFrom()));
        ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)b.getDateTo()));
        ps.setString(6, b.getComment());
        ps.executeUpdate();
    }

    public void recycle() throws BGException {
        try {
            if (this.insertPS != null) {
                this.insertPS.close();
                this.insertPS = null;
            }
            if (this.updatePS != null) {
                this.updatePS.close();
                this.updatePS = null;
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            super.recycle();
        }
    }
}

