/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffUtils;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class ProductTariffTreeNode
extends TariffTreeNode<TvTariffRequest, TvTariffContext, TreeContext, TvTariffWorkerContext> {
    protected final Integer[] productSpecIds;

    public ProductTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        Set<Integer> productSpecIds = Collections.newSetFromMap(new LinkedHashMap());
        productSpecIds.addAll(Utils.toIntegerList((String)parameterMap.get("productSpecIds", null)));
        this.productSpecIds = new Integer[productSpecIds.size()];
        int i = 0;
        for (Integer productSpecId : productSpecIds) {
            this.productSpecIds[i++] = -productSpecId.intValue();
        }
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest req, TvTariffContext context, TreeContext treeContext, TvTariffWorkerContext workerContext) {
        throw new UnsupportedOperationException();
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest tvTariffRequest, TariffTreeNodeHolder holder, TvTariffContext context, TreeContext treeContext, TvTariffWorkerContext workerContext) {
        int result = 0;
        Map pushed = tvTariffRequest.acceptedSetPush();
        for (Integer productSpecId : this.productSpecIds) {
            List serviceCostList = (List)tvTariffRequest.getServiceCost().get(productSpecId);
            if (serviceCostList == null || serviceCostList.size() == 0) continue;
            ArrayList newServiceCostList = new ArrayList(serviceCostList);
            result = 1;
            Calendar time = tvTariffRequest.getTime();
            int jsize = newServiceCostList.size();
            for (int j = 0; j < jsize; ++j) {
                tvTariffRequest.acceptedSetClear();
                tvTariffRequest.setTime((Calendar)time.clone());
                TvServiceCost serviceCost = (TvServiceCost)((Object)newServiceCostList.get(j));
                if (context.isProlongation()) {
                    this.processActivationAndProlongation(parentTreeNodeId, tvTariffRequest, holder, context, treeContext, workerContext, serviceCost);
                    continue;
                }
                serviceCostList.remove((Object)serviceCost);
                this.processRecalculate(parentTreeNodeId, tvTariffRequest, holder, context, treeContext, workerContext, serviceCost);
            }
            tvTariffRequest.setTime(time);
            tvTariffRequest.serviceCost = null;
        }
        tvTariffRequest.acceptedSetPop(pushed);
        return this.postExecute(treeNodeId, parentTreeNodeId, tvTariffRequest, holder, context, treeContext, (ThreadContext)workerContext, result);
    }

    private void processActivationAndProlongation(Long parentTreeNodeId, TvTariffRequest req, TariffTreeNodeHolder holder, TvTariffContext context, TreeContext treeContext, TvTariffWorkerContext workerContext, TvServiceCost serviceCost) {
        if (serviceCost.productItem != null) {
            req.getTime().setTime(serviceCost.productItem.productPeriodTimeTo);
            req.getTime().set(14, 0);
            req.getTime().add(13, 1);
        }
        int serviceId = serviceCost.serviceId;
        GregorianCalendar now = new GregorianCalendar();
        req.serviceCost = serviceCost;
        this.calculateServiceCost(now, parentTreeNodeId, req, holder, context, treeContext, workerContext, serviceCost);
        if (serviceCost.prolongation == 1) {
            req.getTime().setTime(serviceCost.periodTimeFrom);
            req.serviceCost = serviceCost;
            this.calculateServiceCost(now, parentTreeNodeId, req, holder, context, treeContext, workerContext, serviceCost);
            serviceCost.prolongation = 1;
        }
        ProductTariffTreeNode.calculateProportional(req, context, serviceCost, now, true);
        if (serviceId != serviceCost.serviceId) {
            TvTariffUtils.serviceSet(req, serviceCost, serviceId, serviceCost.serviceId);
        }
    }

    private Calendar calculateServiceCost(Calendar now, Long parentTreeNodeId, TvTariffRequest req, TariffTreeNodeHolder holder, TvTariffContext context, TreeContext treeContext, TvTariffWorkerContext workerContext, TvServiceCost serviceCost) {
        Map pushed = req.acceptedSetPush();
        this.executeChildren(parentTreeNodeId, req, holder, context, treeContext, (ThreadContext)workerContext);
        req.serviceCost = null;
        req.acceptedSetPop(pushed);
        if (serviceCost.cost != null && BigDecimal.ZERO != serviceCost.cost) {
            serviceCost.cost = serviceCost.cost.multiply(BigDecimal.valueOf(serviceCost.amount), context.mc);
        }
        boolean withoutDelays = serviceCost.productItem == null || (serviceCost.productItem.productPeriodFlags & 1) == 0;
        serviceCost.prolongation = ProductTariffTreeNode.calculatePeriod(serviceCost, req.getTime(), now, withoutDelays) ? 2 : 1;
        return now;
    }

    private static void calculateProportional(TvTariffRequest req, TvTariffContext context, TvServiceCost serviceCost, Calendar now, boolean serviceCostMap) {
        long timeTo;
        Set depends;
        if (!serviceCost.periodProportional) {
            return;
        }
        Date periodTimeFrom = serviceCost.periodTimeFrom;
        Date periodTimeTo = serviceCost.periodTimeTo;
        if (serviceCost.prolongation == 1 && !now.getTime().equals(periodTimeFrom)) {
            serviceCost.prolongation = 3;
            serviceCost.prolongationTime = serviceCost.periodTimeFrom;
            serviceCost.periodTimeFrom = now.getTime();
        }
        if ((depends = serviceCost.productSpecRuntime.getProductSpec().getDepends()) != null && depends.size() > 0 && (timeTo = req.getProportionalPeriodTimeTo(depends, serviceCost.periodTimeFrom.getTime(), serviceCost.periodTimeTo.getTime(), serviceCostMap)) > 0L) {
            serviceCost.prolongationTime = serviceCost.periodTimeFrom;
            serviceCost.periodTimeTo = new Date(timeTo);
            if (serviceCost.prolongation != 0) {
                serviceCost.prolongation = 3;
            }
        }
        if (serviceCost.prolongation == 3) {
            long realDuration = serviceCost.periodTimeTo.getTime() / 1000L - serviceCost.periodTimeFrom.getTime() / 1000L + 1L;
            long mustDuration = periodTimeTo.getTime() / 1000L - periodTimeFrom.getTime() / 1000L + 1L;
            serviceCost.cost = serviceCost.cost.multiply(BigDecimal.valueOf(realDuration), context.mc).divide(BigDecimal.valueOf(mustDuration), context.mc);
        }
    }

    private void processRecalculate(Long parentTreeNodeId, TvTariffRequest req, TariffTreeNodeHolder holder, TvTariffContext context, TreeContext treeContext, TvTariffWorkerContext workerContext, TvServiceCost parentServiceCost) {
        TvServiceCost currentServiceCost;
        Calendar time = req.getTime();
        Date breakTime = workerContext.getTariffPeriodEnd();
        boolean proportionalPeriod = context.getTariffMode() == TvTariffContext.TvTariffMode.precalculate ? false : (parentServiceCost.productItem.productPeriodFlags & 8) != 0;
        Date periodTimeFrom = parentServiceCost.periodTimeFrom;
        Date periodTimeTo = parentServiceCost.periodTimeTo;
        if (breakTime != null) {
            if (periodTimeTo.before(breakTime)) {
                breakTime = periodTimeTo;
            }
        } else {
            breakTime = periodTimeTo;
        }
        GregorianCalendar wantPeriodStart = new GregorianCalendar();
        if (proportionalPeriod) {
            wantPeriodStart.setTime(parentServiceCost.productItem.productPeriodProlongationTime);
        } else {
            wantPeriodStart.setTime(periodTimeFrom);
        }
        req.setTime(wantPeriodStart);
        TvServiceCost serviceCost = parentServiceCost.newCost();
        req.serviceCost = serviceCost;
        serviceCost.periodTimeFrom = null;
        serviceCost.periodTimeTo = null;
        boolean period = !periodTimeTo.before(periodTimeFrom);
        this.executeChildren(parentTreeNodeId, req, holder, context, treeContext, (ThreadContext)workerContext);
        if (serviceCost.cost != null && BigDecimal.ZERO != serviceCost.cost) {
            serviceCost.cost = serviceCost.cost.multiply(BigDecimal.valueOf(serviceCost.amount), context.mc);
        }
        int activationServiceId = ((TvServiceCost)req.serviceCost).activationServiceId;
        BigDecimal activationPrice = ((TvServiceCost)req.serviceCost).activationPrice;
        if (period) {
            if (context.getTariffMode() == TvTariffContext.TvTariffMode.precalculate) {
                GregorianCalendar now = new GregorianCalendar();
                boolean withoutDelays = now.before(wantPeriodStart);
                ProductTariffTreeNode.calculatePeriod((TvServiceCost)req.serviceCost, wantPeriodStart, now, withoutDelays);
                ProductTariffTreeNode.calculateProportional(req, context, parentServiceCost, now, false);
            } else {
                ProductTariffTreeNode.calculatePeriod((TvServiceCost)req.serviceCost, wantPeriodStart, null, true);
                if (proportionalPeriod) {
                    long realDuration = periodTimeTo.getTime() / 1000L - periodTimeFrom.getTime() / 1000L + 1L;
                    long mustDuration = ((TvServiceCost)req.serviceCost).periodTimeTo.getTime() / 1000L - ((TvServiceCost)req.serviceCost).periodTimeFrom.getTime() / 1000L + 1L;
                    ((TvServiceCost)req.serviceCost).cost = ((TvServiceCost)req.serviceCost).cost.multiply(BigDecimal.valueOf(realDuration), context.mc).divide(BigDecimal.valueOf(mustDuration), context.mc);
                }
            }
        } else {
            ((TvServiceCost)req.serviceCost).cost = BigDecimal.ZERO;
            serviceCost.periodTimeFrom = periodTimeFrom;
            serviceCost.periodTimeTo = periodTimeTo;
        }
        BigDecimal cost = ((TvServiceCost)req.serviceCost).cost;
        if (cost == null) {
            cost = BigDecimal.ZERO;
        }
        ((TvServiceCost)req.serviceCost).prolongation = 2;
        int currentServiceId = ((TvServiceCost)req.serviceCost).serviceId;
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setTime(((TvServiceCost)req.serviceCost).periodTimeFrom);
        TvServiceCost firstServiceCost = currentServiceCost = serviceCost.newCost();
        while (((TvServiceCost)req.serviceCost).periodTimeTo.before(breakTime)) {
            wantPeriodStart.setTime(serviceCost.periodTimeTo);
            wantPeriodStart.set(14, 0);
            ((Calendar)wantPeriodStart).add(13, 1);
            req.setTime(wantPeriodStart);
            req.serviceCost = serviceCost;
            serviceCost.periodTimeFrom = null;
            serviceCost.periodTimeTo = null;
            serviceCost.cost = null;
            serviceCost.serviceId = parentServiceCost.serviceId;
            req.acceptedSetClear();
            this.executeChildren(parentTreeNodeId, req, holder, context, treeContext, (ThreadContext)workerContext);
            if (serviceCost.cost != null && BigDecimal.ZERO != serviceCost.cost) {
                serviceCost.cost = serviceCost.cost.multiply(BigDecimal.valueOf(serviceCost.amount), context.mc);
            }
            if (serviceCost.periodAmount <= 0) {
                this.logger.error("Period amount is 0");
                break;
            }
            ProductTariffTreeNode.calculatePeriod(serviceCost, wantPeriodStart, null, true);
            if (serviceCost.cost != null && BigDecimal.ZERO != serviceCost.cost) {
                cost = cost.add(serviceCost.cost);
            }
            serviceCost.prolongation = 2;
            if (currentServiceId == serviceCost.serviceId) {
                wantPeriodStart.setTime(serviceCost.periodTimeFrom);
                if (TimeUtils.dateEqual((Calendar)currentDate, (Calendar)wantPeriodStart)) {
                    currentServiceCost.periodTimeTo = serviceCost.periodTimeTo;
                    if (serviceCost.cost == null || BigDecimal.ZERO == serviceCost.cost) continue;
                    currentServiceCost.cost = currentServiceCost.cost.add(serviceCost.cost);
                    continue;
                }
            }
            req.addServiceCost(currentServiceCost);
            currentServiceId = serviceCost.serviceId;
            currentDate.setTime(serviceCost.periodTimeFrom);
            currentServiceCost = serviceCost.newCost();
            currentServiceCost.activationServiceId = 0;
            currentServiceCost.activationPrice = null;
        }
        req.addServiceCost(currentServiceCost);
        firstServiceCost.activationServiceId = activationServiceId;
        firstServiceCost.activationPrice = activationPrice;
        if (period) {
            wantPeriodStart.setTime(currentServiceCost.periodTimeTo);
            wantPeriodStart.set(14, 0);
            ((Calendar)wantPeriodStart).add(13, 1);
            parentServiceCost.periodTimeFrom = wantPeriodStart.getTime();
        }
        req.serviceCost = null;
        req.setTime(time);
    }

    private static boolean calculatePeriod(TvServiceCost tvServiceCost, Calendar wantPeriodStart, Calendar now, boolean withoutDelays) {
        boolean result;
        Calendar periodStart;
        int field = ProductTariffTreeNode.toCalendarField(tvServiceCost.periodMode);
        int amount = tvServiceCost.periodAmount;
        if (withoutDelays) {
            periodStart = (Calendar)wantPeriodStart.clone();
            result = true;
        } else if (tvServiceCost.periodAlign) {
            now.set(14, 0);
            periodStart = (Calendar)now.clone();
            ProductTariffTreeNode.alignPerodStart(wantPeriodStart, now, field, amount, periodStart);
            Calendar utilCalendar = (Calendar)now.clone();
            if (ProductTariffTreeNode.mergePeriod(wantPeriodStart, periodStart, field, amount, utilCalendar)) {
                periodStart = (Calendar)wantPeriodStart.clone();
                result = tvServiceCost.periodProportional ? false : (ProductTariffTreeNode.mergePeriod(wantPeriodStart, now, field, amount, utilCalendar) ? true : field < 3);
            } else {
                result = false;
            }
        } else {
            now.set(14, 0);
            if (!tvServiceCost.periodProportional && ProductTariffTreeNode.mergePeriod(wantPeriodStart, now, field, amount, (Calendar)now.clone())) {
                periodStart = (Calendar)wantPeriodStart.clone();
                result = true;
            } else {
                periodStart = (Calendar)now.clone();
                result = false;
            }
        }
        tvServiceCost.periodTimeFrom = periodStart.getTime();
        periodStart.add(field, amount);
        periodStart.set(14, 0);
        periodStart.add(14, -1);
        tvServiceCost.periodTimeTo = periodStart.getTime();
        return result;
    }

    private static int toCalendarField(int periodMode) {
        switch (periodMode) {
            case 1: {
                return 12;
            }
            case 2: {
                return 11;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 2;
            }
        }
        return 5;
    }

    private static void alignPerodStart(Calendar wantPeriodStart, Calendar now, int field, int amount, Calendar periodStart) {
        switch (field) {
            case 12: {
                if (amount == 1) {
                    periodStart.set(13, wantPeriodStart.get(13));
                    if (!now.before(periodStart)) break;
                    periodStart.add(12, -amount);
                    break;
                }
                long periods = (now.getTimeInMillis() - wantPeriodStart.getTimeInMillis()) / 60000L / (long)amount;
                periodStart.setTimeInMillis(wantPeriodStart.getTimeInMillis());
                periodStart.add(12, (int)periods * amount);
                if (!now.before(periodStart)) break;
                periodStart.add(12, -amount);
                break;
            }
            case 11: {
                if (amount == 1) {
                    periodStart.set(13, wantPeriodStart.get(13));
                    periodStart.set(12, wantPeriodStart.get(12));
                    if (!now.before(periodStart)) break;
                    periodStart.add(11, -amount);
                    break;
                }
                long periods = (now.getTimeInMillis() - wantPeriodStart.getTimeInMillis()) / 3600000L / (long)amount;
                periodStart.setTimeInMillis(wantPeriodStart.getTimeInMillis());
                periodStart.add(11, (int)periods * amount);
                if (!now.before(periodStart)) break;
                periodStart.add(11, -amount);
                break;
            }
            case 5: {
                if (amount == 1) {
                    periodStart.set(13, 0);
                    periodStart.set(12, 0);
                    periodStart.set(11, wantPeriodStart.get(11));
                    periodStart.set(12, wantPeriodStart.get(12));
                    periodStart.set(13, wantPeriodStart.get(13));
                    if (!now.before(periodStart)) break;
                    periodStart.add(5, -amount);
                    break;
                }
                periodStart.setTimeInMillis(wantPeriodStart.getTimeInMillis());
                while (now.after(periodStart)) {
                    periodStart.add(5, amount);
                }
                if (!now.before(periodStart)) break;
                periodStart.add(5, -amount);
                break;
            }
            case 3: {
                if (amount == 1) {
                    periodStart.set(13, 0);
                    periodStart.set(12, 0);
                    periodStart.set(11, 0);
                    periodStart.set(5, wantPeriodStart.get(5));
                    periodStart.set(11, wantPeriodStart.get(11));
                    periodStart.set(12, wantPeriodStart.get(12));
                    periodStart.set(13, wantPeriodStart.get(13));
                    if (!now.before(periodStart)) break;
                    periodStart.add(3, -amount);
                    break;
                }
                periodStart.setTimeInMillis(wantPeriodStart.getTimeInMillis());
                while (now.after(periodStart)) {
                    periodStart.add(3, amount);
                }
                if (!now.before(periodStart)) break;
                periodStart.add(3, -amount);
                break;
            }
            case 2: {
                if (amount == 1) {
                    periodStart.set(13, 0);
                    periodStart.set(12, 0);
                    periodStart.set(11, 0);
                    periodStart.set(5, wantPeriodStart.get(5));
                    periodStart.set(11, wantPeriodStart.get(11));
                    periodStart.set(12, wantPeriodStart.get(12));
                    periodStart.set(13, wantPeriodStart.get(13));
                    if (!now.before(periodStart)) break;
                    periodStart.add(2, -amount);
                    break;
                }
                periodStart.setTimeInMillis(wantPeriodStart.getTimeInMillis());
                while (now.after(periodStart)) {
                    periodStart.add(2, amount);
                }
                if (!now.before(periodStart)) break;
                periodStart.add(2, -amount);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static final boolean mergePeriod(Calendar wantPeriodStart, Calendar periodStart, int field, int amount, Calendar utilCalendar) {
        utilCalendar.setTimeInMillis(wantPeriodStart.getTimeInMillis());
        if (field != 12 || amount > 60) {
            utilCalendar.add(12, 10);
        } else {
            utilCalendar.add(12, 1);
        }
        return utilCalendar.after(periodStart);
    }
}

