/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.task;

import bitel.billing.server.util.MailMsg;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.tv.server.ProductManager;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDetailDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeRoot;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvTarifficationManager;
import ru.bitel.bgbilling.modules.tv.server.runtime.bean.ProductRejectCause;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class TvRecalculator
extends RunTask {
    private static final Logger logger = LogManager.getLogger();
    private int moduleId;
    private Date dateFrom;
    private Date dateTo;
    private Set<Integer> contractGroupIds;
    private Set<Integer> contractIds;
    private String email;
    private TvTariffContext tvTariffContext;
    private TvTariffWorkerContext workerContext;
    private ConnectionSet connectionSet;
    private PoolEventPublisher<ContractBalanceChangedEvent> balanceEP;
    private ProductSpecRuntimeMap productSpecRuntimeMap;
    private TvAccountRuntimeMap tvAccountRuntimeMap;
    private TvTarifficationManager tvTarifficationManager;
    private PreparedStatement cleanAccountPS;
    private PreparedStatement cleanAccountBalancePS;
    private PreparedStatement lockPS;
    private PreparedStatement selectAccountPS;

    public TvRecalculator(int moduleId, Date dateFrom, Date dateTo, Set<Integer> contractGroupIds, Set<Integer> contractIds, String email) {
        this.moduleId = moduleId;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.contractGroupIds = contractGroupIds != null ? contractGroupIds : Collections.emptySet();
        this.contractIds = contractIds != null ? contractIds : Collections.emptySet();
        this.email = email;
    }

    public String getDescription() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c TV. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0430. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u041a\u043e\u0434\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + this.contractIds + ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        GregorianCalendar timeFrom = new GregorianCalendar();
        timeFrom.setTime(this.dateFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeFrom);
        timeFrom.set(5, 1);
        GregorianCalendar timeTo = new GregorianCalendar();
        timeTo.setTime(this.dateTo);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeTo);
        ((Calendar)timeTo).add(5, 1);
        ((Calendar)timeTo).add(14, -1);
        if (TimeUtils.compare((Calendar)timeTo, (Calendar)new GregorianCalendar(), (int)2) == 0) {
            timeTo = new GregorianCalendar();
            ((Calendar)timeTo).add(12, 5);
        }
        ServerContext parentContext = (ServerContext)ServerContext.get();
        long start = System.currentTimeMillis();
        try {
            this.workerContext = parentContext != null ? new TvTariffWorkerContext(parentContext, this.moduleId) : new TvTariffWorkerContext(Setup.getSetup(), this.moduleId);
            this.tvTariffContext = new TvTariffContext(this.workerContext.getConnectionSet(), this.moduleId, timeFrom.getTime(), TvTariffContext.TvTariffMode.recalculate);
            this.connectionSet = this.workerContext.getConnectionSet();
            this.balanceEP = this.contractIds.size() > 1 ? EventProcessor.getInstance().newPoolEventPublisher(ContractBalanceChangedEvent.class, 0) : null;
            ServerContext.push((ThreadContext)this.workerContext);
            try {
                this.calculate(timeFrom, timeTo);
                this.workerContext.commit();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (this.balanceEP != null) {
                    this.balanceEP.close();
                }
                if (parentContext == null) {
                    this.workerContext.destroy();
                }
                ThreadContext.set((ThreadContext)parentContext);
            }
        }
        catch (BGException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        long end = System.currentTimeMillis();
        if (this.email != null) {
            StringBuffer report = new StringBuffer("\u041f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0451\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d\n");
            report.append("\u0412\u0440\u0435\u043c\u044f: ");
            report.append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
            MailMsg msg = new MailMsg((Preferences)this.setup);
            try {
                msg.sendMessage(this.email, "\u041f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0451\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d", report.toString());
            }
            catch (BGException e) {
                e.printStackTrace();
            }
        }
    }

    private void calculate(Calendar timeFrom, Calendar timeTo) throws SQLException, BGException {
        logger.info("calculate");
        TvTariffWorkerContext serverContext = this.workerContext;
        Date timeFromDate = timeFrom.getTime();
        Date timeToDate = timeTo.getTime();
        Connection con = this.connectionSet.getConnection();
        this.productSpecRuntimeMap = ProductSpecRuntimeMap.getInstance(this.connectionSet);
        ContractRuntimeMap contractRuntimeMap = ContractRuntimeMap.getInstance();
        this.tvTarifficationManager = new TvTarifficationManager(serverContext.getSetup(), this.connectionSet, this.moduleId);
        this.tvAccountRuntimeMap = this.tvTariffContext.getTvAccountRuntimeMap();
        TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(con);
        String accountDetailTable = ServerUtils.getModuleMonthTableName((String)"tv_account_detail", (Date)this.dateFrom, (int)this.moduleId);
        TvAccountDetailDao.checkTable(con, accountDetailTable);
        StringBuilder sb = new StringBuilder(200);
        Set<Integer> affectedContractIds = this.affectedContractIds(con, accountDetailTable, sb);
        HashSet<Integer> remainContractIds = new HashSet<Integer>(affectedContractIds);
        String affectedServiceIds = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
        int yy = timeFrom.get(1);
        int mm = timeFrom.get(2) + 1;
        int dayFrom = timeFrom.get(5);
        int dayTo = timeTo.get(5);
        this.cleanAccountPS = con.prepareStatement("UPDATE " + accountDetailTable + " SET account=0 WHERE contractId=? AND accountId=? AND (? OR day>=?) AND (? OR day<=?)");
        this.cleanAccountPS.setBoolean(3, dayFrom <= timeFrom.getActualMinimum(5));
        this.cleanAccountPS.setInt(4, dayFrom);
        this.cleanAccountPS.setBoolean(5, dayTo >= timeFrom.getActualMaximum(5));
        this.cleanAccountPS.setInt(6, dayTo);
        this.cleanAccountBalancePS = con.prepareStatement("UPDATE contract_account SET summa=0 WHERE cid=? AND yy=? AND mm=? AND sid IN (" + affectedServiceIds + ")");
        this.cleanAccountBalancePS.setInt(2, yy);
        this.cleanAccountBalancePS.setInt(3, mm);
        this.lockPS = con.prepareStatement("SELECT mid FROM contract_module WHERE cid=? AND mid=? FOR UPDATE");
        this.selectAccountPS = con.prepareStatement("SELECT id, deviceId FROM tv_account_" + this.moduleId + " WHERE id=? AND contractId=?");
        sb.append("SELECT product.id, product.contractId, product.accountId, product.productSpecId, product.activationModeId, product.activationTime, product.activationPrice, product.timeFrom, product.timeTo, period.id, period.activationTime, period.timeFrom, period.timeTo, period.flags, period.prolongationTime, period.version FROM inv_product as product LEFT JOIN inv_product_period as period ON product.id=period.productId");
        if (this.contractGroupIds.size() > 0) {
            sb.append(" LEFT JOIN contract ON contract.id=product.contractId");
        }
        sb.append(" WHERE 1=1");
        if (this.contractIds.size() > 0) {
            String cids = Utils.toString(this.contractIds);
            sb.append(" AND product.contractId IN (").append(cids).append(")");
        }
        if (this.contractGroupIds.size() > 0) {
            long mask = Utils.enumToMask((String)Utils.toString(this.contractGroupIds));
            sb.append(" AND contract.gr&(").append(mask).append(")>0");
        }
        sb.append(" AND product.contractId=period.contractId AND DATE(period.timeFrom)<=? AND DATE(period.timeTo)>=? AND product.id IS NOT NULL");
        sb.append(" ORDER BY product.contractId, product.accountId, product.id, period.timeFrom");
        PreparedStatement ps = con.prepareStatement(sb.toString());
        ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)timeTo));
        ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)timeFrom));
        int currentAccountId = -1;
        int currentContractId = -1;
        ContractRuntime currentContractRuntime = null;
        TariffModuleTreeSet currentTariffTreeSet = null;
        ArrayList<ProductManager.Entry> entryList = new ArrayList<ProductManager.Entry>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int productId = rs.getInt(1);
            int contractId = rs.getInt(2);
            int accountId = rs.getInt(3);
            int productSpecId = rs.getInt(4);
            int activationModeId = rs.getInt(5);
            Timestamp activationTime = rs.getTimestamp(6);
            BigDecimal activationPrice = rs.getBigDecimal(7);
            Timestamp productTimeFrom = rs.getTimestamp(8);
            Timestamp productTimeTo = rs.getTimestamp(9);
            int productPeriodId = rs.getInt(10);
            Timestamp productPeriodActivationTime = rs.getTimestamp(11);
            Timestamp productPeriodTimeFrom = rs.getTimestamp(12);
            Timestamp productPeriodTimeTo = rs.getTimestamp(13);
            int productPeriodFlags = rs.getInt(14);
            Timestamp productPeriodProlongationTime = rs.getTimestamp(15);
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)this.productSpecRuntimeMap.get(productSpecId);
            ProductManager.Entry entry = new ProductManager.Entry(accountId, productPeriodId, productPeriodActivationTime, productPeriodTimeFrom, productPeriodTimeTo, productPeriodFlags, productId, productSpecId, productSpecRuntime.getProductSpec(), activationModeId, activationTime, activationPrice, productTimeFrom, productTimeTo, null, 1, productPeriodProlongationTime);
            if (currentAccountId == accountId) {
                entryList.add(entry);
                continue;
            }
            if (currentAccountId == -1) {
                currentAccountId = accountId;
                currentContractId = contractId;
                currentContractRuntime = contractRuntimeMap.getContractRuntime(this.connectionSet, Integer.valueOf(contractId));
                currentTariffTreeSet = treeSetDao.getRealtimeTariffTreeSet(contractId, timeFromDate, "tv", this.moduleId, this.moduleId, accountId);
                entryList.add(entry);
                continue;
            }
            this.calculateAccount(timeFromDate, timeToDate, currentContractId, currentContractRuntime, currentTariffTreeSet, currentAccountId, entryList, remainContractIds);
            entryList.clear();
            currentAccountId = accountId;
            currentContractId = contractId;
            currentContractRuntime = contractRuntimeMap.getContractRuntime(this.connectionSet, Integer.valueOf(contractId));
            currentTariffTreeSet = treeSetDao.getRealtimeTariffTreeSet(contractId, timeFromDate, "tv", this.moduleId, this.moduleId, accountId);
            entryList.add(entry);
        }
        rs.close();
        ps.close();
        treeSetDao.freeResources();
        if (entryList.size() > 0) {
            this.calculateAccount(timeFromDate, timeToDate, currentContractId, currentContractRuntime, currentTariffTreeSet, currentAccountId, entryList, remainContractIds);
            entryList.clear();
        }
        this.cleanAccountPS.close();
        this.cleanAccountPS = con.prepareStatement("UPDATE " + accountDetailTable + " SET account=0 WHERE contractId=?");
        this.cleanup(con, contractRuntimeMap, yy, mm, remainContractIds, affectedContractIds, affectedServiceIds);
        this.selectAccountPS.close();
        this.cleanAccountPS.close();
        this.cleanAccountBalancePS.close();
        this.lockPS.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Connection con, ContractRuntimeMap contractRuntimeMap, int yy, int mm, Set<Integer> remainContractIds, Set<Integer> affectedContractIds, String affectedServiceIds) throws SQLException, BGException {
        BalanceDao balanceDao = new BalanceDao(con);
        PreparedStatement deleteZeroAccountBalancePS = con.prepareStatement("DELETE FROM contract_account WHERE cid=? AND yy=? AND mm=? AND sid IN (" + affectedServiceIds + ") AND summa=0");
        deleteZeroAccountBalancePS.setInt(2, yy);
        deleteZeroAccountBalancePS.setInt(3, mm);
        for (Integer contractId : remainContractIds) {
            this.contractModuleLock(this.lockPS, contractId);
            this.cleanAccountPS.setInt(1, contractId);
            this.cleanAccountPS.executeUpdate();
            this.cleanAccountBalancePS.setInt(1, contractId);
            this.cleanAccountBalancePS.executeUpdate();
            ContractRuntime contractRuntime = contractRuntimeMap.getContractRuntime(this.connectionSet, contractId);
            if (contractRuntime == null) continue;
            contractRuntime.lock();
            try {
                BigDecimal balanceAccount = balanceDao.setBalanceAccount(contractId.intValue(), contractRuntime.getSuperContractId(), yy, mm);
                if (this.balanceEP != null) {
                    this.balanceEP.publish((Event)new ContractBalanceChangedEvent(contractId.intValue(), 2, yy, mm, balanceAccount));
                } else {
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contractId.intValue(), 2, yy, mm, balanceAccount));
                }
                con.commit();
            }
            finally {
                contractRuntime.unlock();
            }
        }
        for (Integer contractId : affectedContractIds) {
            deleteZeroAccountBalancePS.setInt(1, contractId);
            deleteZeroAccountBalancePS.executeUpdate();
            con.commit();
        }
        deleteZeroAccountBalancePS.close();
        balanceDao.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateAccount(Date timeFromDate, Date timeToDate, int currentContractId, ContractRuntime currentContractRuntime, TariffModuleTreeSet currentTariffTreeSet, int currentAccountId, List<ProductManager.Entry> entryList, Set<Integer> remainContractIds) throws SQLException, BGException {
        assert (currentAccountId != -1);
        assert (currentContractRuntime != null);
        currentContractRuntime.lock();
        try {
            this.contractModuleLock(this.lockPS, currentContractId);
            this.cleanAccountPS.setInt(1, currentContractId);
            this.cleanAccountPS.setInt(2, currentAccountId);
            this.cleanAccountPS.executeUpdate();
            if (remainContractIds.remove(currentContractId)) {
                this.cleanAccountBalancePS.setInt(1, currentContractId);
                this.cleanAccountBalancePS.executeUpdate();
            }
            this.calculateAccount0(currentContractRuntime, currentContractId, currentAccountId, currentTariffTreeSet, entryList, timeFromDate, timeToDate);
        }
        finally {
            currentContractRuntime.unlock();
        }
    }

    private void contractModuleLock(PreparedStatement lockPS, int contractId) throws SQLException {
        lockPS.setInt(1, contractId);
        lockPS.setInt(2, this.moduleId);
        lockPS.executeQuery().close();
    }

    private Set<Integer> affectedContractIds(Connection con, String accountDetailTable, StringBuilder sb) throws SQLException {
        if (this.contractIds.size() > 0) {
            return new HashSet<Integer>(this.contractIds);
        }
        HashSet<Integer> result = new HashSet<Integer>();
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery(this.buildQuery("SELECT DISTINCT(contractId)", accountDetailTable, sb).toString());
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        rs.close();
        stmt.close();
        sb.setLength(0);
        return result;
    }

    private StringBuilder buildQuery(String what, String tableName, StringBuilder sb) {
        sb.append(what);
        sb.append("FROM " + tableName + " as account_detail");
        if (this.contractGroupIds.size() > 0) {
            sb.append(" LEFT JOIN contract ON contract.id=account_detail.contractId");
        }
        sb.append(" WHERE 1=1");
        if (this.contractIds.size() > 0) {
            sb.append(" AND account_detail.contractId IN (").append(Utils.toString(this.contractIds)).append(")");
        }
        if (this.contractGroupIds.size() > 0) {
            long mask = Utils.enumToMask((String)Utils.toString(this.contractGroupIds));
            sb.append(" AND contract.gr&(").append(mask).append(")>0");
        }
        return sb;
    }

    private void calculateAccount0(ContractRuntime contractRuntime, int contractId, int accountId, TariffModuleTreeSet tariffTreeSet, List<ProductManager.Entry> entryList, Date filterTimeFrom, Date filterTimeTo) throws SQLException, BGException {
        assert (this.connectionSet == this.workerContext.getConnectionSet());
        if (accountId != 0) {
            this.selectAccountPS.setInt(1, accountId);
            this.selectAccountPS.setInt(2, contractId);
            ResultSet rs = this.selectAccountPS.executeQuery();
            if (!rs.next()) {
                logger.warn("TvAccount:" + accountId + " not found!");
                rs.close();
                return;
            }
            rs.close();
        }
        try {
            assert (filterTimeFrom != null);
            Set<Calendar> tariffPeriods = TvUtils.getTariffPeriods(filterTimeFrom, tariffTreeSet);
            List<TvServiceCost> serviceCostList = TvUtils.createServiceCostListForRecalculate(this.productSpecRuntimeMap, entryList);
            ArrayList<TvServiceCost> workingServiceCostList = new ArrayList<TvServiceCost>(serviceCostList.size());
            HashSet<TvServiceCost> processedSet = new HashSet<TvServiceCost>();
            this.tvAccountRuntimeMap.load(this.connectionSet, contractId);
            TvAccountRuntimeRoot tvAccountRuntime = (TvAccountRuntimeRoot)this.tvAccountRuntimeMap.get(accountId);
            Calendar tariffPeriodStart = null;
            for (Calendar tariffPeriod : tariffPeriods) {
                if (tariffPeriodStart != null) {
                    TvRecalculator.calculatePart(this.tvTariffContext, this.workerContext, this.tvTarifficationManager, contractRuntime, contractId, tvAccountRuntime, accountId, tariffTreeSet, tariffPeriodStart, tariffPeriod, serviceCostList, workingServiceCostList, processedSet, filterTimeFrom, filterTimeTo, true, true, null);
                }
                tariffPeriodStart = tariffPeriod;
            }
            TvRecalculator.calculatePart(this.tvTariffContext, this.workerContext, this.tvTarifficationManager, contractRuntime, contractId, tvAccountRuntime, accountId, tariffTreeSet, tariffPeriodStart, null, serviceCostList, workingServiceCostList, processedSet, filterTimeFrom, filterTimeTo, true, true, null);
            this.workerContext.commit();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static TvTarifficationManager.CalculateResult calculatePart(TvTariffContext tariffContext, TvTariffWorkerContext workerContext, TvTarifficationManager tvTarifficationManager, ContractRuntime contractRuntime, int contractId, TvAccountRuntimeRoot tvAccountRuntime, int accountId, TariffModuleTreeSet tariffTreeSet, Calendar tariffPeriodStart, Calendar tariffPeriodStop, List<TvServiceCost> serviceCostList, List<TvServiceCost> workingServiceCostList, Set<TvServiceCost> processedSet, Date filterTimeFrom, Date filterTimeTo, boolean detailAccount, boolean addAccount, BigDecimal balance) throws BGException {
        assert (tariffPeriodStart != null);
        if (tariffPeriodStop == null) {
            tariffPeriodStop = new GregorianCalendar();
            if (processedSet != null && processedSet.size() > 0) {
                serviceCostList.stream().filter(a -> !processedSet.contains(a)).collect(Collectors.toCollection(() -> workingServiceCostList));
            } else {
                workingServiceCostList.addAll(serviceCostList);
            }
        } else {
            TvUtils.filterServiceCostList(serviceCostList, tariffPeriodStart, tariffPeriodStop, workingServiceCostList, processedSet);
        }
        assert (tariffPeriodStop != null);
        if (workingServiceCostList.size() == 0) {
            return new TvTarifficationManager.CalculateResult(null, balance, detailAccount || addAccount ? new HashMap<TvTarifficationManager.MonthKey, Map<TvTarifficationManager.ProductAccountKey, TvTarifficationManager.AccountDelta>>() : null);
        }
        ContractTariffOptionList contractTariffOptions = contractRuntime.getTariffOptions(tariffPeriodStart.getTime());
        Map tariffOptionsMap = null;
        if (contractTariffOptions != null) {
            long millis = tariffPeriodStart.getTimeInMillis();
            tariffOptionsMap = contractTariffOptions.map(millis, millis);
        }
        logger.debug("TariffOptionMap: " + tariffOptionsMap);
        workerContext.setTariffPeriodEnd(tariffPeriodStop.getTime());
        TvTarifficationManager.CalculateResult calculateResult = tvTarifficationManager.calculate(detailAccount, addAccount, tariffContext, workerContext, true, true, contractRuntime, contractId, contractTariffOptions, tvAccountRuntime, accountId, workingServiceCostList, tariffTreeSet, tariffPeriodStart, null, balance, null, false, true, filterTimeFrom, filterTimeTo, new ProductRejectCause());
        balance = calculateResult.getBalance();
        int size = workingServiceCostList.size();
        for (int i = 0; i < size; ++i) {
            TvServiceCost serviceCost = workingServiceCostList.get(i);
            if (!serviceCost.periodTimeFrom.after(serviceCost.periodTimeTo)) continue;
            processedSet.add(serviceCost);
        }
        workingServiceCostList.clear();
        return calculateResult;
    }
}

