/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.costmap;

import bitel.billing.module.common.BGControlPanelDateNoB;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapExportPanel;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapImportDialog;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapItemEditorForm;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapPanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceCostMapService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;

class VoiceCostMapEditorForm
extends BGUPanel {
    private static final String SAVE = "save";
    private static final String WARNING_MODE = "warning";
    private static final String TABLE_MODE = "table";
    private BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.RESET, BGButtonPanel.GLUE, BGButtonPanel.OK, new BGButtonPanel.ButtonItem("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "save"), BGButtonPanel.CANCEL});
    private BGTextField costMapTitle = new BGTextField(50);
    private BGTextField comment = new BGTextField();
    private BGUTreeTable costMapItemTable;
    private VoiceCostMapItemTreeTableModel costMapItemModel;
    private BGDialogToolBar toolBar;
    private VoiceCostMapItemEditorForm itemEditor;
    private VoiceCostMapExportPanel exportPanel;
    private JLabel warningMessage = new JLabel("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0435 \u043a\u0430\u0440\u0442\u0443 \u0446\u0435\u043d \u043f\u0440\u0435\u0436\u0434\u0435, \u0447\u0435\u043c \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0432 \u043d\u0435\u0435! \u0412\u043e\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435\u0441\u044c \u043a\u043d\u043e\u043f\u043a\u043e\u0439 \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c!");
    private BGControlPanelDateNoB treeDate;
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);
    private VoiceCostMap currentCostMap;
    private VoiceCostMapService costMapService;
    private final VoiceCostMapPanel parentPanel;

    public VoiceCostMapEditorForm(ClientContext clientContext, VoiceCostMapPanel voiceCostMapPanel) {
        super((LayoutManager)new GridBagLayout(), clientContext);
        this.parentPanel = voiceCostMapPanel;
    }

    protected void jbInit() throws Exception {
        this.costMapService = (VoiceCostMapService)((ClientContext)this.getContext()).getPort(VoiceCostMapService.class);
        this.itemEditor = new VoiceCostMapItemEditorForm((ClientContext)this.getContext(), this);
        this.itemEditor.setVisible(false);
        BGSwingUtilites.wrapBorder((JPanel)((Object)this.itemEditor), (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0430");
        this.exportPanel = new VoiceCostMapExportPanel(this);
        this.exportPanel.setVisible(false);
        BGSwingUtilites.wrapBorder((JPanel)((Object)this.exportPanel), (String)"\u041e\u043f\u0446\u0438\u0438 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430");
        this.costMapItemModel = new VoiceCostMapItemTreeTableModel();
        this.costMapItemTable = new BGUTreeTable((BGTreeTableModel)this.costMapItemModel);
        this.warningMessage.setForeground(Color.RED);
        JPanel toolbarTablePanel = new JPanel(new GridBagLayout());
        toolbarTablePanel.add((Component)this.getToolbarFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbarTablePanel.add((Component)new JScrollPane((Component)this.costMapItemTable), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JPanel warningPanel = new JPanel();
        warningPanel.add((Component)this.warningMessage, "Center");
        this.cardPanel.add((Component)toolbarTablePanel, TABLE_MODE);
        this.cardPanel.add((Component)warningPanel, WARNING_MODE);
        this.add(this.getTitleCommentPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.cardPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)((Object)this.itemEditor), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.add((Component)((Object)this.exportPanel), new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.buttonPanel.addActionListener(e -> this.performAction(e.getActionCommand()));
        this.costMapItemTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VoiceCostMapEditorForm.this.performAction("editItem");
                }
            }
        });
    }

    private JPanel getTitleCommentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        panel.add((Component)this.costMapTitle, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 3), 0, 0));
        panel.add((Component)this.comment, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getToolbarFilterPanel() {
        this.toolBar = new BGDialogToolBar();
        this.toolBar.setDefaultButtons(e -> this.performAction(e.getActionCommand()));
        this.toolBar.setToolBar(Arrays.asList("newItem", "editItem", "deleteItem", "deleteAllItem", "separator", "import", "export"));
        this.toolBar.setFloatable(false);
        this.treeDate = new BGControlPanelDateNoB(Calendar.getInstance());
        this.treeDate.addPropertyChangeListener("date", e -> this.performAction("refresh"));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043e\u0434\u043e\u0432, \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0435 \u043d\u0430 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 3), 0, 0));
        filterPanel.add((Component)this.treeDate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        panel.add((Component)filterPanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Date date = VoiceCostMapEditorForm.this.treeDate.getDate();
                if (date == null) {
                    date = new Date();
                }
                Holder items = new Holder();
                VoiceCostMapEditorForm.this.costMapService.voiceCostMapItemTree(VoiceCostMapEditorForm.this.currentCostMap.getId(), date, items);
                VoiceCostMapItem root = (VoiceCostMapItem)VoiceCommonUtils.readFromHolder((Holder)items);
                if (root == null) {
                    return;
                }
                VoiceCostMapEditorForm.this.costMapItemModel.setData(root);
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapEditorForm.this.currentCostMap = new VoiceCostMap();
                VoiceCostMapEditorForm.this.costMapTitle.setText("");
                VoiceCostMapEditorForm.this.comment.setText("");
                VoiceCostMapItem emptyRoot = new VoiceCostMapItem();
                emptyRoot.setTitle("\u0414\u0435\u0440\u0435\u0432\u043e \u043a\u043e\u0434\u043e\u0432");
                VoiceCostMapEditorForm.this.costMapItemModel.setData(emptyRoot);
                VoiceCostMapEditorForm.this.enableTreeAndToolBar(false);
                VoiceCostMapEditorForm.this.cardLayout.show(VoiceCostMapEditorForm.this.cardPanel, VoiceCostMapEditorForm.WARNING_MODE);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapEditorForm.this.costMapTitle.setText(VoiceCostMapEditorForm.this.currentCostMap.getTitle());
                VoiceCostMapEditorForm.this.comment.setText(VoiceCostMapEditorForm.this.currentCostMap.getComment());
                VoiceCostMapEditorForm.this.performAction("refresh");
                VoiceCostMapEditorForm.this.enableTreeAndToolBar(true);
                VoiceCostMapEditorForm.this.cardLayout.show(VoiceCostMapEditorForm.this.cardPanel, VoiceCostMapEditorForm.TABLE_MODE);
            }
        };
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapEditorForm.this.performAction(VoiceCostMapEditorForm.SAVE);
                VoiceCostMapEditorForm.this.hideEditorAndRefresh();
            }
        };
        new AbstractBGUPanel.DefaultAction(SAVE, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                String title = VoiceCostMapEditorForm.this.costMapTitle.getText();
                if (Utils.isBlankString((String)title)) {
                    BGToolTip.showErrorMessage((JComponent)VoiceCostMapEditorForm.this.costMapTitle, (String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d!");
                    return;
                }
                if (VoiceCostMapEditorForm.this.currentCostMap == null) {
                    VoiceCostMapEditorForm.this.currentCostMap = new VoiceCostMap();
                }
                VoiceCostMapEditorForm.this.currentCostMap.setTitle(VoiceCostMapEditorForm.this.costMapTitle.getText());
                VoiceCostMapEditorForm.this.currentCostMap.setComment(VoiceCostMapEditorForm.this.comment.getText());
                VoiceCostMapEditorForm.this.currentCostMap.setOperatorId(VoiceCostMapEditorForm.this.parentPanel.getOperatorId());
                VoiceCostMapEditorForm.this.currentCostMap.setId(VoiceCostMapEditorForm.this.costMapService.voiceCostMapUpdate(VoiceCostMapEditorForm.this.currentCostMap));
                VoiceCostMapEditorForm.this.enableTreeAndToolBar(true);
                VoiceCostMapEditorForm.this.cardLayout.show(VoiceCostMapEditorForm.this.cardPanel, VoiceCostMapEditorForm.TABLE_MODE);
            }
        };
        new AbstractBGUPanel.DefaultAction("reset", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapEditorForm.this.performAction("edit");
            }
        };
        new AbstractBGUPanel.DefaultAction("cancel", "\u041e\u0442\u043c\u0435\u043d\u0430"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapEditorForm.this.hideEditorAndRefresh();
            }
        };
        new AbstractBGUPanel.DefaultAction("newItem", "\u041d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapItem newItem = new VoiceCostMapItem();
                newItem.setCostMapId(VoiceCostMapEditorForm.this.currentCostMap.getId());
                VoiceCostMapEditorForm.this.setVisibleBottomPanels(true, false);
                VoiceCostMapEditorForm.this.itemEditor.setCurrentItem(newItem);
                VoiceCostMapEditorForm.this.itemEditor.performAction("new");
            }
        };
        new AbstractBGUPanel.DefaultAction("editItem", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapItem selectedItem = (VoiceCostMapItem)VoiceCostMapEditorForm.this.costMapItemModel.getSelectedRow();
                if (selectedItem == null) {
                    BGToolTip.showErrorMessage((JComponent)VoiceCostMapEditorForm.this.costMapItemTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d!");
                    return;
                }
                VoiceCostMapEditorForm.this.setVisibleBottomPanels(true, false);
                VoiceCostMapEditorForm.this.itemEditor.setCurrentItem(selectedItem);
                VoiceCostMapEditorForm.this.itemEditor.performAction("edit");
            }
        };
        new AbstractBGUPanel.DefaultAction("deleteItem", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List selectedItems = VoiceCostMapEditorForm.this.costMapItemModel.getSelectedRows();
                if (selectedItems == null || selectedItems.size() < 1) {
                    BGToolTip.showErrorMessage((JComponent)VoiceCostMapEditorForm.this.costMapItemTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e \u043a\u0440\u0430\u0439\u043d\u0435\u0439 \u043c\u0435\u0440\u0435 \u043e\u0434\u0438\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d!");
                    return;
                }
                String confirmMessage = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + (selectedItems.size() > 1 ? "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b" : "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442?") + "?";
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), confirmMessage, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    List itemIdsForDelete = selectedItems.stream().map(code -> code.getId()).collect(Collectors.toList());
                    VoiceCostMapEditorForm.this.costMapService.voiceCostMapItemDelete(itemIdsForDelete);
                    VoiceCostMapEditorForm.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("deleteAllItem", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                String confirmMessage = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u0437 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d?";
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), confirmMessage, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    VoiceCostMapEditorForm.this.costMapService.voiceCostMapItemDeleteAll(VoiceCostMapEditorForm.this.currentCostMap.getId());
                    VoiceCostMapEditorForm.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("export", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapEditorForm.this.setVisibleBottomPanels(false, true);
                VoiceCostMapEditorForm.this.exportPanel.performActionOpen();
            }
        };
        new AbstractBGUPanel.DefaultAction("import", "\u0418\u043c\u043f\u043e\u0440\u0442 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                new VoiceCostMapImportDialog("\u0418\u043c\u043f\u043e\u0440\u0442 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d", VoiceCostMapEditorForm.this.currentCostMap, VoiceCostMapEditorForm.this.parentPanel.getOperatorId(), (VoiceCostMapService)((ClientContext)VoiceCostMapEditorForm.this.getContext()).getPort(VoiceCostMapService.class), VoiceCostMapEditorForm.this).getDialog().setVisible(true);
            }
        };
    }

    private void enableTreeAndToolBar(boolean enable) {
        this.costMapItemTable.setEnabled(enable);
        this.toolBar.setEnabled(enable);
    }

    BGButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setCostMap(VoiceCostMap costMap) {
        this.currentCostMap = costMap;
    }

    public BGTreeTableModel<VoiceCostMapItem> getCostMapItemTableModel() {
        return this.costMapItemModel;
    }

    public void setVisibleBottomPanels(boolean hideEditor, boolean hideExport) {
        this.itemEditor.setVisible(hideEditor);
        this.exportPanel.setVisible(hideExport);
    }

    public void hideEditorAndRefresh() {
        this.parentPanel.switchToTableMode();
        this.parentPanel.performAction("refresh");
    }

    public int getOperatorId() {
        return this.parentPanel.getOperatorId();
    }

    class VoiceCostMapItemTreeTableModel
    extends BGTreeTableModel<VoiceCostMapItem> {
        public VoiceCostMapItemTreeTableModel() {
            super(VoiceCostMapItemTreeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", VoiceGeographicCode.class, -1, 100, -1, "code", false);
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", -1, 200, -1, "destinationTitle");
            this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0441", -1, 130, 160, "dateFrom", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u043e", -1, 130, 160, "dateTo", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", -1, 160, 160, "itemCost", false, (TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("###,###,###,##0.00000")));
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 200, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(VoiceCostMapItem val, int column) throws BGException {
            if (column == 0 && val == this.root) {
                return val.getTitle();
            }
            return super.getValue((Object)val, column);
        }
    }
}

