/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecord;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecordArray;

public class VoiceRecordProcessor {
    private final int size;
    private final int outReaderCount;
    private final BlockingQueue<VoiceRecordArray> in;
    private final BlockingQueue<VoiceRecordArray> out;
    private AtomicInteger arrayIndex = new AtomicInteger(0);
    private VoiceRecordArray current;
    private static VoiceRecordArray QUEUE_END = new VoiceRecordArray(0, 0);

    public VoiceRecordProcessor(int size, int arraySize, int outReaderCount) {
        this.size = size;
        this.outReaderCount = outReaderCount;
        this.in = new ArrayBlockingQueue<VoiceRecordArray>(size);
        this.out = new ArrayBlockingQueue<VoiceRecordArray>(size);
        for (int i = 0; i < size; ++i) {
            this.in.add(new VoiceRecordArray(arraySize, this.arrayIndex.incrementAndGet()));
        }
        this.current = (VoiceRecordArray)this.in.poll();
    }

    public VoiceRecord next() throws InterruptedException {
        VoiceRecord result = this.current.next();
        if (result == null) {
            this.out.put(this.current);
            this.current = this.in.take();
            result = this.current.next();
        }
        return result;
    }

    public void finish() throws InterruptedException {
        this.out.put(this.current);
        this.current = null;
        for (int i = 0; i < this.outReaderCount; ++i) {
            this.out.put(QUEUE_END);
        }
    }

    public VoiceRecordArray take() throws InterruptedException {
        VoiceRecordArray result = this.out.poll(30L, TimeUnit.MINUTES);
        if (result == QUEUE_END) {
            return null;
        }
        return result;
    }

    public void put(VoiceRecordArray array) throws InterruptedException {
        array.recycle();
        array.setId(this.arrayIndex.incrementAndGet());
        this.in.put(array);
    }
}

