/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceReportsService;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.Operator;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.OperatorManager;
import ru.bitel.bgbilling.modules.voice.server.reports.VoiceReportBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceReportsService")
public class VoiceReportsServiceImpl
extends AbstractService
implements VoiceReportsService {
    public String getParameter(String key) throws BGException {
        return ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("voice_" + key + "_" + this.moduleId));
    }

    public String getParameters(String reportType) throws BGException, BGMessageException {
        JSONObject jsonObject = new JSONObject();
        String className = ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("voice_" + reportType.toLowerCase() + "_class_" + this.moduleId));
        if (className != null) {
            jsonObject.put("className", (Object)className);
            JSONArray array = new JSONArray();
            jsonObject.put("params", (Object)array);
            for (String key : ((VoiceReportBase)DynamicClassManager.getInstance().newInstance(VoiceReportBase.class, className)).getParamKeys(this.moduleId)) {
                JSONObject param = new JSONObject();
                param.put("name", (Object)key);
                param.put("value", (Object)ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("voice_" + reportType.toLowerCase() + "_" + key + "_" + this.moduleId), (String)""));
                array.put((Object)param);
            }
        }
        return jsonObject.toString();
    }

    public void updateParameter(String key, String value) throws BGException {
        if (Utils.isEmptyString((String)value)) {
            ServerUtils.removeSetupValue((Connection)this.getConnection(), (String)("voice_" + key + "_" + this.moduleId));
        } else {
            ServerUtils.setSetupValue((Connection)this.getConnection(), (String)("voice_" + key + "_" + this.moduleId), (String)value);
        }
    }

    public String getReportRecords(String reportType, LocalDate period) throws BGException {
        String className = ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("voice_" + reportType.toLowerCase() + "_class_" + this.moduleId));
        if (className == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430!");
        }
        return ((VoiceReportBase)DynamicClassManager.getInstance().newInstance(VoiceReportBase.class, className)).getRecords(this.moduleId, period);
    }

    public String getReportCSV(String reportType, LocalDate period) throws BGException {
        String className = ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("voice_" + reportType.toLowerCase() + "_class_" + this.moduleId));
        if (className == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430!");
        }
        return ((VoiceReportBase)DynamicClassManager.getInstance().newInstance(VoiceReportBase.class, className)).getCSV(this.moduleId, period);
    }

    public List<IdTitle> getOperatorList() throws BGException, BGMessageException {
        ArrayList<IdTitle> operatorList = new ArrayList<IdTitle>();
        for (Operator oper : new OperatorManager(this.moduleId, (ParameterMap)this.getModuleSetup()).getOperatorList()) {
            operatorList.add(new IdTitle(oper.getId(), oper.getTitle()));
        }
        return operatorList;
    }
}

