/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.task;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.AttributeValueManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.ForwardManager;

public class AccountController
extends TaskBase {
    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Email. \u0417\u0430\u0434\u0430\u0447\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    protected boolean initTask() {
        if (this.moduleId <= 0) {
            this.log.error("Param mid not found in task config");
            return false;
        }
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             DomainManager domainManager = new DomainManager(con, this.moduleId);){
            Domain domain;
            AccountManager accountManager = new AccountManager(con, this.moduleId);
            ForwardManager forwardManager = new ForwardManager(con, this.moduleId);
            AttributeValueManager attributeManager = new AttributeValueManager(con, this.moduleId);
            Date today = new Date();
            List<Account> needOpen = accountManager.getNeedOpenAccountList(today);
            List<Account> needClose = accountManager.getNeedCloseAccountList(today);
            for (Account account : needOpen) {
                this.log.info("Open account: " + account.getAccount() + "; domainId: " + account.getDomainId());
                domain = domainManager.get(account.getDomainId());
                if (domain == null) {
                    this.log.error("Not found domain with id=" + account.getDomainId());
                    continue;
                }
                account.setForwardList(forwardManager.getForwardList(account.getId()));
                account.setAttributes(attributeManager.getValueList(account.getId()));
                try {
                    domainManager.getServiceActivator(domain).create(account);
                    account.setNeedOpen(false);
                    accountManager.updateAccount(account);
                    this.log.info("Account " + account.getAccount() + "@" + domain.getName() + " opened ok..");
                }
                catch (BGException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            for (Account account : needClose) {
                this.log.info("Close account: " + account.getAccount() + "; domainId: " + account.getDomainId());
                domain = domainManager.get(account.getDomainId());
                if (domain == null) {
                    this.log.error("Not found domain with id=" + account.getDomainId());
                    continue;
                }
                try {
                    domainManager.getServiceActivator(domain).cancel(account);
                    account.setNeedClose(false);
                    accountManager.updateAccount(account);
                    this.log.info("Account " + account.getAccount() + "@" + domain.getName() + " closed ok..");
                }
                catch (BGException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }
}

