/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.task;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.AttributeValueManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.ForwardManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class Locker
extends TaskBase {
    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Email. \u0417\u0430\u0434\u0430\u0447\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0434\u043e\u043b\u0436\u043d\u0438\u043a\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    protected boolean initTask() {
        if (this.moduleId <= 0) {
            this.log.error("Param mid NOT Found in task config");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try (BalanceUtils bu = new BalanceUtils(conSlave);){
            DomainManager domainManager = new DomainManager(con, this.moduleId);
            ForwardManager forwardManager = new ForwardManager(con, this.moduleId);
            AttributeValueManager attributeManager = new AttributeValueManager(con, this.moduleId);
            AccountManager accountManager = new AccountManager(con, this.moduleId);
            ContractManager cm = new ContractManager(conSlave);
            String query = null;
            PreparedStatement ps = null;
            query = "SELECT DISTINCT cid FROM email_account_" + this.moduleId;
            ps = conSlave.prepareStatement(query);
            HashSet<Integer> accountForLock = new HashSet<Integer>();
            ResultSet rsContracts = ps.executeQuery();
            while (rsContracts.next()) {
                boolean open;
                int cid = rsContracts.getInt(1);
                Contract contract = cm.getContractById(cid);
                if (contract == null || (open = bu.getBalance(this.getOperatingTime().getTime(), cid).compareTo(contract.getBalanceLimit()) >= 0)) continue;
                List<Account> contractAccountList = accountManager.getContractAccountList(cid);
                for (Account account : contractAccountList) {
                    if (account.getStatus() != 0) continue;
                    accountForLock.add(account.getId());
                }
            }
            for (Integer accountId : accountForLock) {
                Account account = accountManager.getAccountById(accountId);
                account.setStatus(2);
                Domain domain = domainManager.get(account.getDomainId());
                if (domain == null) {
                    this.log.error("Not found domain with id=" + account.getDomainId());
                    continue;
                }
                account.setForwardList(forwardManager.getForwardList(accountId));
                account.setAttributes(attributeManager.getValueList(accountId));
                try {
                    if (TimeUtils.dateInRange((Date)new Date(), (Date)account.getDate1(), (Date)account.getDate2())) {
                        domainManager.getServiceActivator(domain).modify(account);
                    }
                    accountManager.updateAccount(account);
                    this.log.info("Account " + account.getAccount() + "@" + domain.getName() + " locked sucsessfull..");
                }
                catch (BGException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
        }
    }
}

