/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vidimax.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxCharge;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxClientPairData;
import ru.bitel.bgbilling.modules.vidimax.server.bean.VidimaxChargeDao;
import ru.bitel.bgbilling.modules.vidimax.server.bean.VidimaxClientPairDataDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

@WebServlet(name="VidimaxApi", urlPatterns={"/vidimax_api/*"})
public class VidimaxApi
extends CommonExecutor {
    protected static final Logger logger = LogManager.getLogger();
    private ModuleSetup moduleSetup = null;
    private int mid = 0;
    private String operation = null;
    private String sign;
    private String customerId;
    private String operationId;
    private String deviceId;
    private static final Pattern SLASH_PATTERN = Pattern.compile("/");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        this.mid = this.getModuleIdFromRequest(request);
        this.operation = this.getOperationFromRequest(request);
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.mid));
        boolean valid = this.basicAuth(request);
        if (!valid) {
            String s = "Basic realm=\"Login Vidimax Module Request\"";
            response.setHeader("WWW-Authenticate", s);
            response.setStatus(401);
        } else {
            try {
                this.sign = request.getParameter("sign");
                this.customerId = request.getParameter("customerId");
                this.operationId = request.getParameter("operationId");
                this.deviceId = request.getParameter("deviceId");
                if (!this.checkSign(this.sign, this.customerId, this.operationId)) {
                    this.sendResponse(response, "1", "\u041f\u043e\u0434\u043f\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u0430.");
                    logger.error("\u041f\u043e\u0434\u043f\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u0430. Sign = " + this.sign + ", operationid = " + this.operationId + ", customerId = " + this.customerId);
                    return;
                }
                switch (this.operation) {
                    case "pairAccountAuto": {
                        this.changePairAccount(true, this.mid, request, response);
                        break;
                    }
                    case "pairAccount": {
                        break;
                    }
                    case "charge": {
                        this.account(this.mid, request, response);
                        break;
                    }
                    case "cancelAccountPairing": {
                        this.changePairAccount(false, this.mid, request, response);
                    }
                }
            }
            catch (BGException e) {
                this.sendResponse(response, "1", "\u041d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
                logger.error("\u041e\u0448\u0438\u0431\u043a\u0430", e.getCause());
                return;
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().write("GET expected");
        response.getWriter().flush();
        response.getWriter().close();
    }

    protected void changePairAccount(boolean pair, int moduleId, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, BGException {
        JSONObject jsonObj = new JSONObject();
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try (VidimaxClientPairDataDao pairDataDao = new VidimaxClientPairDataDao(con, moduleId);){
            VidimaxClientPairData pairData = pairDataDao.getByCustomerId(this.customerId);
            if (pairData == null) {
                this.sendResponse(response, "1", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d.");
                logger.error("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d. CustomerId = " + this.customerId + ", deviceId = " + this.deviceId);
                return;
            }
            if (pair && pairData.isPair() || !pair && !pairData.isPair()) {
                String er = pair ? "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u0432\u044f\u0437\u0430\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0443\u0436\u0435 \u0431\u044b\u043b \u0441\u0432\u044f\u0437\u0430\u043d." : "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0432\u044f\u0437\u0430\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435 \u0441\u0432\u044f\u0437\u0430\u043d.";
                this.sendResponse(response, "1", er);
                logger.error(er + " CustomerId = " + this.customerId + ", deviceId = " + this.deviceId);
                return;
            }
            pairData.setDeviceId(this.deviceId);
            pairDataDao.pairAccountUpdate(pairData, pair);
            jsonObj.put("resultCode", (Object)"0");
            jsonObj.put("resultMessage", (Object)"");
            if (pair) {
                JSONArray ar = new JSONArray();
                for (Integer id : Utils.toIntegerList((String)pairData.getFirstTariffIds())) {
                    ar.put((Object)id);
                }
                jsonObj.put("newTariffIds", (Object)ar);
            }
        }
        catch (JSONException e) {
            logger.error("Could not build JSON object", (Throwable)e);
        }
        this.sendResponse(response, jsonObj);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void account(int mid, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, BGException {
        Date now = new Date();
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try (BalanceUtils bu = new BalanceUtils(con);
             ContractDao contractDao = new ContractDao(con, 0);
             VidimaxChargeDao vidimaxChargeDao = new VidimaxChargeDao(con, mid, now);
             VidimaxClientPairDataDao pairDataDao = new VidimaxClientPairDataDao(con, mid);){
            VidimaxCharge charge = new VidimaxCharge();
            charge.setDate(new Date());
            charge.setOperationId(this.operationId);
            charge.setCustomerId(this.customerId);
            charge.setDeviceId(this.deviceId);
            charge.setTariffId(Utils.parseInt((String)request.getParameter("tariffId"), (int)-1));
            charge.setServiceTypeId(Utils.parseInt((String)request.getParameter("serviceTypeId"), (int)-1));
            charge.setSum(new BigDecimal(Long.parseLong(request.getParameter("sum"))).divide(new BigDecimal(100)));
            charge.setComment(request.getParameter("comment"));
            charge.setPin(request.getParameter("pin"));
            VidimaxClientPairData pairData = pairDataDao.getByCustomerId(this.customerId);
            if (pairData == null) {
                this.sendResponse(response, "1", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d.");
                logger.error("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d. CustomerId = " + this.customerId + ", deviceId = " + this.deviceId);
                return;
            }
            charge.setContractId(pairData.getContractId());
            if (!pairData.isPair()) {
                this.sendResponse(response, "1", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d.");
                return;
            }
            Contract contract = (Contract)contractDao.get(pairData.getContractId());
            if (contract == null) {
                this.sendResponse(response, "1", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d.");
                logger.error("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d.. CustomerId = " + this.customerId + ", contractId = " + charge.getContractId() + ", deviceId = " + this.deviceId);
                return;
            }
            if (!StatusCache.getInstance().isModuleActiveStatus(mid, (int)contract.getStatus())) {
                this.sendResponse(response, "1", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043c\u0435\u0435\u0442 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0451\u043d\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441.");
                return;
            }
            int serviceId = this.moduleSetup.getInt("service." + charge.getServiceTypeId() + ".accountServiceId", -1);
            if (serviceId < 1) {
                serviceId = this.moduleSetup.getInt("account.default.serviceId", -1);
            }
            if (serviceId < 1) {
                this.sendResponse(response, "1", "\u0418\u0437\u0432\u0438\u043d\u0438\u0442\u0435. \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
                logger.error("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0443, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043a\u043e\u0434 \u0443\u0441\u043b\u0443\u0433\u0438 \u0434\u043b\u044f \u0440\u0430\u0441\u0445\u043e\u0434\u0430 \u0432\u0438\u0434\u0438\u043c\u0430\u043a\u0441\u0430.");
                return;
            }
            if (!vidimaxChargeDao.uniqueOperationId(this.operationId)) {
                this.sendResponse(response, "1", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u0430.");
                logger.error("\u0420\u0430\u0441\u0445\u043e\u0434 \u043d\u0435 \u0441 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439. operationid = " + this.operationId + " sum=" + charge.getSum() + " CustomerId = " + this.customerId + ", contractId = " + charge.getContractId());
                return;
            }
            vidimaxChargeDao.update(charge);
            List listIds = Utils.toIntegerList((String)this.moduleSetup.get("tariffsIds.notAccounting", null));
            if (!listIds.contains(charge.getTariffId()) || charge.getServiceTypeId() != 5) {
                BigDecimal balance = bu.getBalance(now, contract);
                if (balance.subtract(charge.getSum()).compareTo(BigDecimal.ZERO) < 0) {
                    this.sendResponse(response, "1", "\u041d\u0435 \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432.");
                    return;
                }
                bu.addContractAccount(contract.getId(), now, serviceId, charge.getSum().floatValue());
                bu.updateBalance(now, contract.getId());
                ServerUtils.commitConnection((Connection)con);
                bu.close();
            }
            this.sendResponse(response, "0", "");
            return;
        }
    }

    private boolean basicAuth(HttpServletRequest request) throws IOException {
        String credentials;
        String userPass;
        int p;
        String basic;
        StringTokenizer st;
        String userId = null;
        String password = null;
        boolean valid = false;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic") && (p = (userPass = Base64.decode((String)(credentials = st.nextToken()))).indexOf(":")) != -1) {
            userId = userPass.substring(0, p);
            password = userPass.substring(p + 1);
            if (userId.trim().equals(this.getBasicAuthLogin()) && password.trim().equals(this.getBasicAuthPassword())) {
                valid = true;
            }
        }
        return valid;
    }

    private void sendResponse(HttpServletResponse response, String resultCode, String resultMessage) throws IOException {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("resultCode", (Object)resultCode);
            jsonObj.put("resultMessage", (Object)resultMessage);
        }
        catch (JSONException e) {
            logger.error("Could not build JSON object", (Throwable)e);
        }
        this.sendResponse(response, jsonObj);
    }

    private void sendResponse(HttpServletResponse response, JSONObject jsonObj) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print(jsonObj.toString());
        out.flush();
        try {
            logger.info(jsonObj.get("resultMessage"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getModuleIdFromRequest(HttpServletRequest request) {
        int mid = 0;
        String[] params = this.getRequestParams(request);
        if (params.length > 1) {
            mid = Utils.parseInt((String)params[1], (int)0);
        }
        return mid;
    }

    private String getOperationFromRequest(HttpServletRequest request) {
        String operation = "";
        String[] params = this.getRequestParams(request);
        if (params.length > 2) {
            operation = params[2];
        }
        return operation;
    }

    private String[] getRequestParams(HttpServletRequest request) {
        String[] params = new String[]{};
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            params = SLASH_PATTERN.split(pathInfo);
        }
        return params;
    }

    private boolean checkSign(String sign, String customerId, String operationId) {
        String operatorSecret = this.moduleSetup.get("operator.secret", "");
        String secretString = "customerId:" + customerId + ",operationId:" + operationId + "{" + operatorSecret + "}";
        boolean signValid = true;
        try {
            MessageDigest md = MessageDigest.getInstance("md5");
            byte[] digest = md.digest(secretString.toString().getBytes());
            if (sign == null || !sign.toLowerCase().equals(Utils.bytesToHexString((byte[])digest).toLowerCase())) {
                signValid = false;
            }
        }
        catch (NoSuchAlgorithmException e) {
            signValid = false;
        }
        return signValid;
    }

    private String getBasicAuthLogin() {
        return this.moduleSetup.get("basic.auth.login", null);
    }

    private String getBasicAuthPassword() {
        return this.moduleSetup.get("basic.auth.password", null);
    }
}

