/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessageStatistic;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class DispatchMessageDao
extends AbstractIdDao<DispatchMessage> {
    private static final String MESSAGE_STATISTIC_TABLE = "dispatch_message_statistic";
    private static final String MESSAGE_CONTENT_TABLE = "dispatch_message_content";

    public DispatchMessageDao(Connection con) {
        super(con, 0, "dispatch_message");
    }

    protected void updateImpl(DispatchMessage b) throws BGException, SQLException {
        StringBuilder query = new StringBuilder(50);
        if (b.getId() > 0) {
            query.append("UPDATE ");
            query.append(this.tableName);
            query.append(" SET create_date=?, dispatch_id=?, is_sent=?, ");
            query.append("send_date=?, msg_body=?, msg_title=? ");
            query.append(" WHERE id=?");
        } else {
            query.append("INSERT INTO ");
            query.append(this.tableName);
            query.append("(create_date, dispatch_id, is_sent, send_date, msg_body, msg_title) ");
            query.append("VALUES(?,?,?,?,?,?)");
        }
        PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
        ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)b.getCreateDate()));
        ps.setInt(2, b.getDispatchId());
        ps.setBoolean(3, b.isSent());
        ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)b.getSendDate()));
        ps.setString(5, b.getMessageBody());
        ps.setString(6, b.getTitle());
        if (b.getId() > 0) {
            ps.setInt(7, b.getId());
        }
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    protected DispatchMessage getFromRS(ResultSet rs) throws SQLException, BGException {
        DispatchMessage msg = new DispatchMessage();
        msg.setId(rs.getInt("id"));
        msg.setCreateDate((Date)rs.getTimestamp("create_date"));
        msg.setDispatchId(rs.getInt("dispatch_id"));
        msg.setSendDate((Date)rs.getTimestamp("send_date"));
        msg.setMessageBody(rs.getString("msg_body"));
        msg.setTitle(rs.getString("msg_title"));
        msg.setSent(rs.getBoolean("is_sent"));
        return msg;
    }

    public List<DispatchMessage> getList(int dispatchId, boolean onlyNotSent) throws BGException {
        Object filter = "dispatch_id=?";
        if (onlyNotSent) {
            filter = (String)filter + " AND is_sent=0 AND send_date <= NOW()";
        }
        return this.list((String)filter, "id", new Object[]{dispatchId});
    }

    public void deleteByDispatch(int id) throws BGException {
        try {
            StringBuilder sb = new StringBuilder(100);
            sb.append("DELETE FROM ");
            sb.append(this.tableName);
            sb.append(" WHERE dispatch_id=?");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void addMessageStatistic(DispatchMessageStatistic statistic) throws BGException {
        String query = "INSERT INTO dispatch_message_statistic(contractId, messageId, dispatchId, contactId, sendDate, contractValue) VALUES (?,?,?,?,?,?)";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, statistic.getContractId());
            ps.setInt(index++, statistic.getMessageId());
            ps.setInt(index++, statistic.getDispatchId());
            ps.setInt(index++, statistic.getContactId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)(statistic.getSendDate() != null ? statistic.getSendDate() : new Date())));
            ps.setString(index, statistic.getContactValue());
            ps.executeUpdate();
            statistic.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            try (PreparedStatement textPs = this.con.prepareStatement("INSERT INTO dispatch_message_content (statisticId, text) VALUES (?,?)");){
                index = 1;
                textPs.setInt(index++, statistic.getId());
                textPs.setString(index++, statistic.getMessageText());
                textPs.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public DispatchMessageStatistic getMessageStatistic(int id) throws BGException {
        DispatchMessageStatistic result = null;
        String query = "SELECT mstat.*, c.title, d.title, cont.val, msg.text FROM dispatch_message_statistic mstat LEFT JOIN contract c ON c.id=mstat.contractId LEFT JOIN dispatch_dispatch d ON d.id=mstat.dispatchId LEFT JOIN dispatch_message dmes ON dmes.id=mstat.messageId LEFT JOIN dispatch_contact cont ON cont.id=mstat.contactId LEFT JOIN dispatch_message_content msg ON msg.statisticId=mstat.id WHERE mstat.id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getMessageStatisticFromRs(rs);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void getMessageStatisticList(int contractId, int dispatchId, int messageId, int contactId, SearchResult<DispatchMessageStatistic> searchResult) throws BGException {
        List result = searchResult.getList();
        Period period = searchResult.getPeriod();
        Page page = searchResult.getPage();
        Object query = "SELECT SQL_CALC_FOUND_ROWS mstat.*, c.title, d.title, cont.val, msg.text FROM dispatch_message_statistic mstat LEFT JOIN contract c ON c.id=mstat.contractId LEFT JOIN dispatch_dispatch d ON d.id=mstat.dispatchId LEFT JOIN dispatch_message dmes ON dmes.id=mstat.messageId LEFT JOIN dispatch_contact cont ON cont.id=mstat.contactId LEFT JOIN dispatch_message_content msg ON msg.statisticId=mstat.id WHERE 1=1 ";
        if (contractId > 0) {
            query = (String)query + " AND c.id=" + contractId;
        }
        if (dispatchId > 0) {
            query = (String)query + " AND d.id=" + dispatchId;
        }
        if (contactId > 0) {
            query = (String)query + " AND cont.id=" + contactId;
        }
        if (messageId > 0) {
            query = (String)query + " AND dmes.id=" + messageId;
        }
        if (period != null) {
            if (period.getDateFrom() != null) {
                query = (String)query + " AND sendDate>=?";
            }
            if (period.getDateTo() != null) {
                query = (String)query + " AND sendDate<=?";
            }
        }
        query = (String)query + " ORDER BY id";
        if (page != null) {
            query = (String)query + page.sqlLimit();
        }
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            int index = 1;
            if (period != null) {
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getMessageStatisticFromRs(rs));
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteMessageStatistic(int id) throws BGException {
        String query = "DELETE FROM dispatch_message_statistic WHERE id=" + id;
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private DispatchMessageStatistic getMessageStatisticFromRs(ResultSet rs) throws SQLException {
        DispatchMessageStatistic result = new DispatchMessageStatistic();
        result.setId(rs.getInt("mstat.id"));
        result.setMessageId(rs.getInt("mstat.messageId"));
        result.setDispatchId(rs.getInt("mstat.dispatchId"));
        result.setContactId(rs.getInt("mstat.contactId"));
        result.setContractId(rs.getInt("mstat.contractId"));
        result.setSendDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("mstat.sendDate")));
        result.setContractTitle(rs.getString("c.title"));
        result.setDispatchTitle(rs.getString("d.title"));
        result.setContactValue(rs.getString("mstat.contractValue"));
        result.setMessageText(rs.getString("msg.text"));
        return result;
    }
}

