/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.admin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.plugins.dispatch.client.condition.ConditionPanelFactory;
import ru.bitel.bgbilling.plugins.dispatch.client.condition.base.AbstractDispatchConditionPanel;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;

public class DispatchConditionPanel
extends BGUPanel {
    private boolean init = false;
    private List<AbstractDispatchConditionPanel> panelMap = new ArrayList<AbstractDispatchConditionPanel>();
    private List<BGModule> modules = null;
    private Map<AbstractDispatchConditionPanel, JLabel> labelMap = new HashMap<AbstractDispatchConditionPanel, JLabel>();

    protected void jbInit() {
        if (this.init || this.modules == null) {
            return;
        }
        this.init = true;
        this.panelMap = ConditionPanelFactory.values(this.modules);
        JPanel panel = new JPanel(new GridBagLayout());
        Dimension size = new Dimension(500, 1);
        int i = 0;
        for (AbstractDispatchConditionPanel value : this.panelMap) {
            JLabel label = new JLabel();
            label.setForeground(Color.RED);
            panel.add((Component)((Object)value), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 2, new Insets(i == 0 ? 5 : 0, 5, 5, 5), 0, 0));
            panel.add((Component)label, new GridBagConstraints(1, i++, 1, 1, 1.0, 0.0, 17, 2, new Insets(i == 0 ? 5 : 0, 5, 5, 5), 0, 0));
            this.labelMap.put(value, label);
        }
        Component box = Box.createGlue();
        box.setSize(size);
        box.setPreferredSize(size);
        box.setMinimumSize(size);
        box.setMaximumSize(size);
        Component boxRight = Box.createGlue();
        panel.add(box, new GridBagConstraints(0, i++, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(boxRight, new GridBagConstraints(1, 0, 1, i, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(null);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(" \u0423\u0441\u043b\u043e\u0432\u0438\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 "));
        this.add(scrollPane, "Center");
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                DispatchConditionPanel.this.modules = ((ModuleService)((ClientContext)DispatchConditionPanel.this.getContext()).getPort(ModuleService.class, 0)).moduleList();
                DispatchConditionPanel.this.jbInit();
            }
        };
    }

    public void setSelectedDispatch(Dispatch current) {
        for (AbstractDispatchConditionPanel value : this.panelMap) {
            value.clearFields();
            value.setActive(false);
            this.labelMap.get((Object)value).setText("");
        }
        for (DispatchCondition condition : current.getConditions()) {
            Class<? extends AbstractDispatchConditionPanel> clazz = ConditionPanelFactory.getClass(condition.getClass());
            if (clazz == null) continue;
            AbstractDispatchConditionPanel pane = null;
            for (AbstractDispatchConditionPanel value : this.panelMap) {
                if (!clazz.isInstance((Object)value)) continue;
                pane = value;
                break;
            }
            if (pane == null) continue;
            pane.setActive(true);
            pane.setCondition(condition);
        }
    }

    public List<DispatchCondition> getConditions() {
        ArrayList<DispatchCondition> result = new ArrayList<DispatchCondition>();
        for (AbstractDispatchConditionPanel value : this.panelMap) {
            if (!value.isActive()) continue;
            result.add(value.getCondition());
        }
        return result;
    }

    public boolean validateConditions() {
        boolean result = true;
        this.clearErrorLabels();
        for (AbstractDispatchConditionPanel value : this.panelMap) {
            String msg;
            if (!value.isActive() || !Utils.notBlankString((String)(msg = value.validateCondition()))) continue;
            result = false;
            JLabel label = this.labelMap.get((Object)value);
            label.setText(msg);
        }
        return result;
    }

    private void clearErrorLabels() {
        for (AbstractDispatchConditionPanel value : this.panelMap) {
            this.labelMap.get((Object)value).setText("");
        }
    }
}

