/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.condition;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.dispatch.client.condition.base.AbstractDispatchConditionPanel;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.DispatchAddressCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class DispatchAddressConditionPanel
extends AbstractDispatchConditionPanel {
    private JCheckBox useCondition = new JCheckBox("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u0435");
    private JPanel dataPanel = new JPanel(new GridBagLayout());
    private JComboBox<IdTitle> addressParamsCombo = new JComboBox();
    private JComboBox<IdTitle> countries = new JComboBox();
    private JComboBox<IdTitle> cities = new JComboBox();
    private JComboBox<IdTitle> streets = new JComboBox();
    private JComboBox<IdTitle> houses = new JComboBox();
    private DispatchService service;
    private AddressService addressService;

    public DispatchAddressConditionPanel(ClientContext context) {
        super(context);
    }

    protected void jbInit() throws Exception {
        this.service = (DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class);
        this.addressService = (AddressService)((ClientContext)this.getContext()).getPort(AddressService.class);
        List addressParamList = this.service.getAddressParamList();
        addressParamList.add(0, new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
        this.addressParamsCombo.setModel(new DefaultComboBoxModel<IdTitle>(addressParamList.toArray(new IdTitle[0])));
        List countryList = this.addressService.searchCountryList(null, null, null).getList();
        ArrayList<IdTitle> countryIdTitles = new ArrayList<IdTitle>(countryList.size() + 1);
        countryIdTitles.add(new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
        for (Country country : countryList) {
            countryIdTitles.add(new IdTitle(country.getId(), country.getTitle()));
        }
        this.countries.setModel(new DefaultComboBoxModel<IdTitle>(countryIdTitles.toArray(new IdTitle[0])));
        this.countries.setSelectedIndex(0);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443 \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0430"));
        this.dataPanel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.dataPanel.add(this.addressParamsCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 0, 3, 0), 0, 0));
        this.dataPanel.add((Component)new JLabel("\u0421\u0442\u0440\u0430\u043d\u044b"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
        this.dataPanel.add(this.countries, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.dataPanel.add((Component)new JLabel("\u0413\u043e\u0440\u043e\u0434\u0430"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
        this.dataPanel.add(this.cities, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.dataPanel.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u044b"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
        this.dataPanel.add(this.streets, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.dataPanel.add((Component)new JLabel("\u0414\u043e\u043c\u0430"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
        this.dataPanel.add(this.houses, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.countries.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DispatchAddressConditionPanel.this.cities.setModel(new DefaultComboBoxModel());
                DispatchAddressConditionPanel.this.streets.setModel(new DefaultComboBoxModel());
                DispatchAddressConditionPanel.this.houses.setModel(new DefaultComboBoxModel());
                IdTitle selectedCountry = (IdTitle)DispatchAddressConditionPanel.this.countries.getSelectedItem();
                try {
                    if (selectedCountry == null || selectedCountry.getId() > 0) {
                        // empty if block
                    }
                    List cityList = DispatchAddressConditionPanel.this.addressService.searchCityList(selectedCountry.getId(), null, null, null).getList();
                    ArrayList<IdTitle> citiesIdTitles = new ArrayList<IdTitle>(cityList.size() + 1);
                    citiesIdTitles.add(new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
                    for (City city : cityList) {
                        citiesIdTitles.add(new IdTitle(city.getId(), city.getTitle()));
                    }
                    DispatchAddressConditionPanel.this.cities.setModel(new DefaultComboBoxModel<IdTitle>(citiesIdTitles.toArray(new IdTitle[0])));
                }
                catch (BGException e1) {
                    ((ClientContext)DispatchAddressConditionPanel.this.getContext()).processException((Throwable)e1);
                }
            }
        });
        this.cities.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DispatchAddressConditionPanel.this.streets.setModel(new DefaultComboBoxModel());
                DispatchAddressConditionPanel.this.houses.setModel(new DefaultComboBoxModel());
                IdTitle selectedCity = (IdTitle)DispatchAddressConditionPanel.this.cities.getSelectedItem();
                try {
                    if (selectedCity != null && selectedCity.getId() > 0) {
                        List streetList = DispatchAddressConditionPanel.this.addressService.searchStreetList(selectedCity.getId(), null, null, null).getList();
                        ArrayList<IdTitle> streetIdTitles = new ArrayList<IdTitle>(streetList.size());
                        streetIdTitles.add(new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
                        for (Street street : streetList) {
                            streetIdTitles.add(new IdTitle(street.getId(), street.getTitle()));
                        }
                        DispatchAddressConditionPanel.this.streets.setModel(new DefaultComboBoxModel<IdTitle>(streetIdTitles.toArray(new IdTitle[0])));
                    }
                }
                catch (BGException e1) {
                    ((ClientContext)DispatchAddressConditionPanel.this.getContext()).processException((Throwable)e1);
                }
            }
        });
        this.streets.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DispatchAddressConditionPanel.this.houses.setModel(new DefaultComboBoxModel());
                IdTitle selectedCity = (IdTitle)DispatchAddressConditionPanel.this.cities.getSelectedItem();
                IdTitle selectedStreet = (IdTitle)DispatchAddressConditionPanel.this.streets.getSelectedItem();
                try {
                    if (selectedStreet != null && selectedStreet.getId() > 0) {
                        List houseList = DispatchAddressConditionPanel.this.addressService.houseList(selectedCity.getId(), -1, selectedStreet.getId(), -1, -1, "", null);
                        ArrayList<IdTitle> houseIdTitle = new ArrayList<IdTitle>(houseList.size());
                        houseIdTitle.add(new IdTitle(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
                        for (House house : houseList) {
                            houseIdTitle.add(new IdTitle(house.getId(), Utils.notBlankString((String)house.getHouseFrac()) ? house.getHouseFrac() : ""));
                        }
                        DispatchAddressConditionPanel.this.houses.setModel(new DefaultComboBoxModel<IdTitle>(houseIdTitle.toArray(new IdTitle[0])));
                    }
                }
                catch (BGException e1) {
                    ((ClientContext)DispatchAddressConditionPanel.this.getContext()).processException((Throwable)e1);
                }
            }
        });
        this.useCondition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DispatchAddressConditionPanel.this.setActive(DispatchAddressConditionPanel.this.useCondition.isSelected());
            }
        });
        this.add(this.useCondition, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.dataPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected DispatchCondition readConditionFromPanel() {
        DispatchAddressCondition result = new DispatchAddressCondition();
        IdTitle selectedCountry = (IdTitle)this.countries.getSelectedItem();
        IdTitle selectedCity = (IdTitle)this.cities.getSelectedItem();
        IdTitle selectedStreet = (IdTitle)this.streets.getSelectedItem();
        IdTitle selectedHouse = (IdTitle)this.houses.getSelectedItem();
        IdTitle selectedPid = (IdTitle)this.addressParamsCombo.getSelectedItem();
        result.setAddressPid(selectedPid.getId());
        if (selectedCountry != null && selectedCountry.getId() > 0) {
            result.setCountryId(selectedCountry.getId());
        }
        if (selectedCity != null && selectedCity.getId() > 0) {
            result.setCityId(selectedCity.getId());
        }
        if (selectedStreet != null && selectedStreet.getId() > 0) {
            result.setStreetId(selectedStreet.getId());
        }
        if (selectedHouse != null && selectedHouse.getId() > 0) {
            result.setHouseId(selectedHouse.getId());
        }
        return result;
    }

    @Override
    protected void fillFromCondition(DispatchCondition condition) {
        DispatchAddressCondition cond = (DispatchAddressCondition)condition;
        this.addressParamsCombo.setSelectedItem(new IdTitle(cond.getAddressPid(), null));
        this.countries.setSelectedItem(new IdTitle(cond.getCountryId(), null));
        this.cities.setSelectedItem(new IdTitle(cond.getCityId(), null));
        this.streets.setSelectedItem(new IdTitle(cond.getStreetId(), null));
        this.houses.setSelectedItem(new IdTitle(cond.getHouseId(), null));
    }

    @Override
    public void clearFields() {
        this.addressParamsCombo.setSelectedIndex(0);
        this.countries.setSelectedIndex(0);
    }

    @Override
    public boolean isActive() {
        return this.useCondition.isSelected();
    }

    @Override
    public void setActive(boolean active) {
        this.useCondition.setSelected(active);
        this.dataPanel.setVisible(active);
    }

    @Override
    public String validateCondition() {
        String result = "";
        int selectedParameter = this.addressParamsCombo.getSelectedIndex();
        int selectedCountry = this.countries.getSelectedIndex();
        if (selectedParameter <= 0 || selectedCountry <= 0) {
            result = "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0430\u0434\u0440\u0435\u0441\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0438, \u043f\u043e \u043a\u0440\u0430\u0439\u043d\u0435\u0439 \u043c\u0435\u0440\u0435, \u0441\u0442\u0440\u0430\u043d\u0443!";
        }
        return result;
    }
}

