/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action.web;

import bitel.billing.server.contract.bean.ContractService;
import bitel.billing.server.contract.bean.ContractServiceManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.ClientStatManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionShowStat
extends ActionBase {
    private int year = -1;
    private int dd = -1;
    private int mm = -1;
    private int yy = -1;
    private int unit = 1;
    private List<Integer> sid = null;
    private List<AddressRange> addrList = null;
    private List<Integer> aid = null;
    private String _aid = null;
    private Map<Integer, String> serviceMap = null;
    private String _sid = null;

    public void doAction() throws SQLException, BGException {
        GregorianCalendar nowDate = new GregorianCalendar();
        this.dd = this.getIntParameter("day", 0);
        this.mm = this.getIntParameter("month", nowDate.get(2) + 1);
        this.yy = this.getIntParameter("year", nowDate.get(1));
        this._sid = this.getParameterValues("services");
        this._aid = this.getParameterValues("addreses");
        this.unit = this.getIntParameter("unit", 1);
        if (!Utils.isArrayString((String)this._sid) || !Utils.isArrayString((String)this._aid)) {
            this._sid = null;
            this._aid = null;
        }
        if (this._sid == null) {
            this._sid = "0";
        }
        this.sid = Utils.toIntegerList((String)this._sid);
        if (this._aid != null) {
            this.aid = Utils.toIntegerList((String)this._aid);
        }
        if (this.mm == 0) {
            this.dd = 0;
        }
        this.year = nowDate.get(1);
        int allowService = this.moduleSetup.getInt("web.service.allow", 0);
        this.serviceMap = new HashMap<Integer, String>();
        if (allowService == 0) {
            for (Service srv : ModuleCache.getInstance().getModuleServicesList(this.mid)) {
                this.serviceMap.put(srv.getId(), srv.getTitle());
            }
        } else {
            for (ContractService srv : new ContractServiceManager(this.con).getContractServiceList(this.cid, this.mid)) {
                this.serviceMap.put(srv.getServiceId(), srv.getServiceTitle());
            }
        }
        AddressRangeManager man = new AddressRangeManager(this.con, this.mid);
        this.addrList = man.getContractAddressRange(this.cid);
        this.setData();
    }

    protected void setDataForXslt() throws DOMException, BGException {
        new ClientStatManager(this.con, this.mid).addStatInfo(this.rootNode, this.cid, this._aid, this._sid, this.yy, this.mm, this.dd);
        Element date = this.createElement(this.rootNode, "date");
        date.setAttribute("day", "" + this.dd);
        date.setAttribute("month", "" + this.mm);
        date.setAttribute("year", "" + this.yy);
        for (int i = this.year; i > this.year - 4; --i) {
            Element element = this.createElement(this.rootNode, "year");
            element.setAttribute("value", "" + i);
            date.appendChild(element);
        }
        Element services = this.createElement(this.rootNode, "services");
        for (Integer n : this.serviceMap.keySet()) {
            String selected = "0";
            for (Integer curr : this.sid) {
                if (!curr.equals(n)) continue;
                selected = "1";
                break;
            }
            Element service = this.createElement(this.rootNode, "service");
            service.setAttribute("title", this.serviceMap.get(n));
            service.setAttribute("value", String.valueOf(n));
            service.setAttribute("selected", selected);
            services.appendChild(service);
        }
        Element addreses = this.createElement(this.rootNode, "addreses");
        for (AddressRange ar : this.addrList) {
            String selected = "0";
            Element address = this.createElement(addreses, "address");
            addreses.setAttribute("ip1", IPUtils.convertLongIpToString((long)ar.getAddr1()));
            addreses.setAttribute("ip2", IPUtils.convertLongIpToString((long)ar.getAddr2()));
            addreses.setAttribute("date1", TimeUtils.formatDate((Calendar)ar.getDate1()));
            addreses.setAttribute("date2", TimeUtils.formatDate((Calendar)ar.getDate2()));
            addreses.setAttribute("ip_to", IPUtils.convertLongIpToString((long)ar.getAddr2()));
            address.setAttribute("value", String.valueOf(ar.getId()));
            address.setAttribute("title", ar.toStringWithoutSource());
            address.setAttribute("comment", ar.getComment());
            if (this._aid != null) {
                for (Integer curr : this.aid) {
                    if (!curr.equals(ar.getId())) continue;
                    selected = "1";
                    break;
                }
            }
            address.setAttribute("selected", selected);
        }
        if ("1".equals(this.getParameter("createDetail")) && this.createDetail()) {
            Element element = this.createElement(this.rootNode, "createDetail");
            element.setAttribute("created", "1");
        }
        Element element = this.createElement(this.rootNode, "unit");
        element.setAttribute("unit", String.valueOf(this.unit));
    }

    protected void setDataToRequest() throws BGException {
        new ClientStatManager(this.con, this.mid).addStatInfo(this.dataMap, this.cid, this._aid, this._sid, this.yy, this.mm, this.dd);
        this.dataMap.put("module", this.module);
        this.dataMap.put("mid", this.mid);
        this.dataMap.put("day", "" + this.dd);
        this.dataMap.put("month", "" + this.mm);
        this.dataMap.put("year", "" + this.yy);
        ArrayList<Integer> yearList = new ArrayList<Integer>();
        for (int i = this.year; i > this.year - 4; --i) {
            yearList.add(i);
        }
        this.dataMap.put("yearList", yearList);
        ArrayList<String[]> servList = new ArrayList<String[]>();
        for (Integer n : this.serviceMap.keySet()) {
            String[] str = new String[3];
            String selected = "0";
            for (Integer curr : this.sid) {
                if (!curr.equals(n)) continue;
                selected = "1";
                break;
            }
            str[0] = String.valueOf(n);
            str[1] = this.serviceMap.get(n);
            str[2] = selected;
            servList.add(str);
        }
        this.dataMap.put("serviceList", servList);
        ArrayList<String[]> adrList = new ArrayList<String[]>();
        for (AddressRange ar : this.addrList) {
            String[] str = new String[9];
            String selected = "0";
            str[0] = IPUtils.convertLongIpToString((long)ar.getAddr1());
            str[1] = IPUtils.convertLongIpToString((long)ar.getAddr2());
            str[2] = TimeUtils.formatDate((Calendar)ar.getDate1());
            str[3] = TimeUtils.formatDate((Calendar)ar.getDate2());
            str[4] = IPUtils.convertLongIpToString((long)ar.getAddr2());
            str[5] = String.valueOf(ar.getId());
            str[6] = ar.toStringWithoutSource();
            str[7] = ar.getComment();
            if (this._aid != null) {
                for (Integer curr : this.aid) {
                    if (curr.intValue() != ar.getId()) continue;
                    selected = "1";
                    break;
                }
            }
            str[8] = selected;
            adrList.add(str);
        }
        this.dataMap.put("addrList", adrList);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(this.yy, this.mm, 1);
        ArrayList<Integer> dayList = new ArrayList<Integer>();
        for (int i = 1; i <= ((Calendar)gregorianCalendar).getActualMaximum(5); ++i) {
            dayList.add(i);
        }
        this.dataMap.put("dayList", dayList);
        if ("1".equals(this.getParameter("createDetail")) && this.createDetail()) {
            this.dataMap.put("createDetail", "1");
        }
    }
}

