/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mtsbank.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.sql.Connection;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.modules.mtsbank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mtsbank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.mtsbank.server.bean.Constants;
import ru.bitel.bgbilling.modules.mtsbank.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebAction(title="MTSBank")
public class ActionDoTransaction
extends AbstractPaymentAction {
    private final String moduleName = "mtsbank";

    public ActionDoTransaction() {
        super("mtsbank");
    }

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
        if (this.context.getRequest().getParameter("check") != null) {
            try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
                transactionManager.doCheckRequest(this.contractId, ServletUtils.getIpFromHeader((HttpServletRequest)this.context.getRequest(), (Setup)this.setup));
            }
        }
        super.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws BGException {
        this.setResultParam("gateUrl", this.moduleSetup.get("mtsbank.gate.url", "https://payments.mtsbank.ru/ecomm/ClientHandler"));
        this.paymentForm("mtsbank", Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchParam searchParam = SearchParam.builder().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL)).build();
            SearchResult searchResult = new SearchResult(null, this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
            transactionManager.searchTransaction(searchResult, searchParam);
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("mtsbank.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("mtsbank.sum.max", new BigDecimal(5000));
        ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        this.setClientIpAddr();
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            transactionManager.registerOrder(contract.getId(), contract.getTitle(), sum, this.getResult(), false, false);
        }
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        int mode;
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        boolean autopaymentEnable = this.moduleSetup.getBoolean("mtsbank.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            Preferences modeDataMap;
            ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode().getCode()) {
                    autopayment.getPeriod().setLocalDateTimeFrom(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = new Autopayment();
                autopayment.setContractId(this.contractId);
            }
            this.setClientIpAddr();
            TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
            String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle();
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF.getCode()) {
                autopayment.setMode(AutopaymentMode.OFF);
                autopayment.setSum(BigDecimal.ZERO);
                autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                autopayment.setAccessToken(null);
            } else if (mode == AutopaymentMode.WEEK.getCode()) {
                this.autopaymentWeek("MTSBANK", modeDataMap, autopayment, Constants.class);
                transactionManager.registerOrder(this.contractId, contractTitle, autopayment.getSum(), this.getResult(), false, true);
            } else if (mode == AutopaymentMode.MONTH.getCode()) {
                this.autopaymentMonth("MTSBANK", modeDataMap, autopayment, Constants.class);
                transactionManager.registerOrder(this.contractId, contractTitle, autopayment.getSum(), this.getResult(), false, true);
            } else if (mode == AutopaymentMode.AUTO.getCode()) {
                this.autopaymentAuto("MTSBANK", modeDataMap, autopayment, Constants.class);
                transactionManager.registerOrder(this.contractId, contractTitle, autopayment.getSum(), this.getResult(), false, true);
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
            autopaymentManager.close();
            transactionManager.close();
            if (autopayment.getMode().getCode() != AutopaymentMode.OFF.getCode()) {
                this.doRedirect();
            } else {
                this.execute();
            }
        }
    }

    protected void doRedirect() throws BGException {
        Object transactionId = this.getResultParam("TRANSACTION_ID");
        if (transactionId != null) {
            try {
                this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.binary);
                this.context.getResponse().sendRedirect(this.moduleSetup.get("mtsbank.gate.url", "https://payments.mtsbank.ru/ecomm/ClientHandler") + "?trans_id=" + URLEncoder.encode(String.valueOf(transactionId), "UTF-8"));
                return;
            }
            catch (Exception ex) {
                this.execute();
                throw new BGMessageException(ex.getMessage());
            }
        }
        this.execute();
        throw new BGMessageException(this.getResultParam("errorMessage") + " [errorCode=" + this.getResultParam("errorCode") + "]");
    }

    private void setClientIpAddr() {
        this.setResultParam("mtsbank.client.ip.addr", ServletUtils.getIpFromHeader((HttpServletRequest)this.context.getRequest(), (Setup)this.setup));
    }
}

