/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client.admin;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.ListItem;
import bitel.billing.module.common.print.HtmlPrinter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGServiceConfig;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.plugins.crm.client.RegisterPanel;
import ru.bitel.bgbilling.plugins.crm.client.TaskManager;
import ru.bitel.bgbilling.plugins.crm.client.admin.ActionConfig;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ProblemEditor
extends RegisterPanel {
    private String problemExecutors;
    private boolean init = false;
    private BGControlPanelListSelect executors_L = new BGControlPanelListSelect();
    private JTextArea calls_TA = new JTextArea();
    private JTextArea comment_TA = new JTextArea();
    private JTextArea resolution_TA = new JTextArea();
    private BGComboBox<ComboBoxItem> group_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> category_CB = new BGComboBox();
    private JComboBox<ComboBoxItem> status_CB = new JComboBox();
    private DefaultListModel<ListItem> usedGroupsModel = new DefaultListModel();
    private JList<ListItem> usedGroups = new JList<ListItem>(this.usedGroupsModel);
    private DefaultListModel<ListItem> taskModel = new DefaultListModel();
    private JList<ListItem> taskList = new JList<ListItem>(this.taskModel);
    private JComboBox<ComboBoxItem> urgency_CB = new JComboBox();
    private boolean historyMode = false;
    private String time = null;
    protected List<Long> dates;

    public ProblemEditor() {
        this(false);
    }

    public ProblemEditor(boolean historyMode) {
        this.historyMode = historyMode;
        if (historyMode) {
            this.executors_L.setEnabled(false);
            this.calls_TA.setEditable(false);
            this.comment_TA.setEditable(false);
            this.resolution_TA.setEditable(false);
            this.group_CB.setEnabled(false);
            this.category_CB.setEnabled(false);
            this.status_CB.setEnabled(false);
            this.usedGroups.setEnabled(false);
            this.urgency_CB.setEnabled(false);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JLabel jLabel1 = new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430:");
        JLabel jLabel2 = new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:");
        JLabel jLabel4 = new JLabel("\u0421\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c:");
        JLabel jLabel5 = new JLabel("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f:");
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        JPanel jPanel6 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        JPanel jPanel9 = new JPanel(new GridBagLayout());
        JPanel jPanelComment = new JPanel(new GridBagLayout());
        JPanel jPanelResolution = new JPanel(new GridBagLayout());
        JPanel jPanelCalls = new JPanel(new GridBagLayout());
        jLabel2.setFont(new Font("Arial", 0, 14));
        jLabel4.setFont(new Font("Arial", 0, 14));
        JButton cancelButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        JButton okButton = new JButton("OK");
        JButton okEmailButton = new JButton("OK + E-Mail");
        JButton okPrintOrderButton = new JButton("OK + \u041f\u0435\u0447\u0430\u0442\u044c \u043d\u0430\u0440\u044f\u0434\u0430");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProblemEditor.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProblemEditor.this.okButton_actionPerformed(actionEvent);
            }
        });
        okEmailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProblemEditor.this.okEmailButton_actionPerformed(actionEvent);
            }
        });
        okPrintOrderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProblemEditor.this.okPrintOrderButton_actionPerformed(actionEvent);
            }
        });
        this.taskList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProblemEditor.this.showTask();
                }
            }
        });
        this.executors_L.setBorder((Border)new BGTitleBorder(" \u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u0438 "));
        jPanel2.setBorder(null);
        jPanel2.setMinimumSize(new Dimension(200, 84));
        jPanel2.setPreferredSize(new Dimension(400, 67));
        jPanel1.setMinimumSize(new Dimension(165, 300));
        jPanel1.setPreferredSize(new Dimension(291, 300));
        jPanel5.setMinimumSize(new Dimension(40, 100));
        jPanel5.setPreferredSize(new Dimension(25, 140));
        this.resolution_TA.setWrapStyleWord(true);
        this.resolution_TA.setLineWrap(true);
        this.resolution_TA.setMargin(new Insets(3, 3, 3, 3));
        this.comment_TA.setLineWrap(true);
        this.comment_TA.setWrapStyleWord(true);
        this.comment_TA.setMargin(new Insets(3, 3, 3, 3));
        this.calls_TA.setFont(new Font("Dialog", 0, 14));
        this.calls_TA.setEditable(false);
        this.calls_TA.setMargin(new Insets(3, 3, 3, 3));
        jPanel5.add((Component)new JScrollPane(this.usedGroups), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanel6.add(jPanel1);
        jPanel6.add(jPanel2);
        jPanel7.add((Component)jLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel7.add((Component)this.category_CB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel9.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel9.add(this.status_CB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        jPanel9.add((Component)jLabel4, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel9.add(this.urgency_CB, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        jPanel9.add((Component)jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel9.add((Component)this.group_CB, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel1.add((Component)jPanel9, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel1.add((Component)this.executors_L, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        jPanel2.add((Component)jPanel7, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanelComment.add((Component)new JScrollPane(this.comment_TA), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanelCalls.add((Component)new JScrollPane(this.calls_TA), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanelResolution.add((Component)new JScrollPane(this.resolution_TA), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel taskListPanel = new JPanel(new GridBagLayout());
        taskListPanel.add((Component)new JScrollPane(this.taskList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JTabbedPane jTabbedPane1 = new JTabbedPane();
        jTabbedPane1.add((Component)jPanelComment, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        jTabbedPane1.add((Component)jPanelResolution, "\u0425\u043e\u0434 \u0440\u0435\u0448\u0435\u043d\u0438\u044f");
        jTabbedPane1.add((Component)jPanel5, "\u0423\u0447\u0430\u0441\u0442\u0432\u043e\u0432\u0430\u0432\u0448\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b");
        jTabbedPane1.add((Component)jPanelCalls, "\u0417\u0432\u043e\u043d\u043a\u0438");
        jTabbedPane1.add((Component)taskListPanel, "\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u0434\u0430\u0447\u0438");
        jPanel2.add((Component)jTabbedPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)okButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        jPanel3.add(Box.createHorizontalStrut(8), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)okEmailButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel3.add((Component)okPrintOrderButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel3.add((Component)cancelButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.group_CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProblemEditor.this.setExecutors(ProblemEditor.this.executors_L, Utils.parseInt((String)ProblemEditor.this.group_CB.getSelectedId()));
                ProblemEditor.this.executors_L.setListValues(ProblemEditor.this.problemExecutors);
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(jPanel6, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        if (!this.historyMode) {
            jPanel3.add((Component)okButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            jPanel3.add(Box.createHorizontalStrut(8), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            jPanel3.add((Component)okEmailButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            jPanel3.add((Component)okPrintOrderButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            jPanel3.add((Component)cancelButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add(jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        }
    }

    public void setData() {
        if (!this.init) {
            this.init();
        }
        if (this.id.equals("-1")) {
            this.status_CB.setSelectedIndex(0);
            this.group_CB.setSelectedIndex(0);
            this.category_CB.setSelectedIndex(0);
            this.usedGroupsModel.clear();
            this.taskModel.clear();
            this.executors_L.getList().clearSelection();
            this.comment_TA.setText("");
            this.resolution_TA.setText("");
            this.calls_TA.setText("");
        } else {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetRegisterProblem");
            request.setAttribute("historymode", this.historyMode);
            request.setAttribute("id", this.getId());
            request.setAttribute("time", this.time);
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.setDocument(doc);
            }
        }
    }

    private void init() {
        this.init = true;
        for (int i = -2; i <= 2; ++i) {
            this.urgency_CB.addItem(new ComboBoxItem((Object)String.valueOf(i), String.valueOf(i)));
        }
        this.buildGroupList(this.group_CB);
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("RegisterCategoryList");
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.category_CB.setModel((ComboBoxModel)ClientUtils.buildComboBox((Node)XMLUtils.selectNode((Node)doc, (String)"//list"), (String)""));
        }
        this.category_CB.insertItemAt((Object)new ComboBoxItem((Object)"0", "---"), 0);
    }

    private void showTask() {
        BGServiceConfig serviceConfig = (BGServiceConfig)BGClientBase.getFrame().getTabbedPane().addTab(ActionConfig.class.getName(), BGServiceConfig.class);
        ListItem item = this.taskList.getSelectedValue();
        serviceConfig.selectTab(TaskManager.class.getName());
        TaskManager taskManager = (TaskManager)serviceConfig.getTab(TaskManager.class);
        if (String.valueOf(item.getAttribute("id")).startsWith("new:")) {
            String id = String.valueOf(item.getAttribute("id")).split(":")[1];
            taskManager.setContractId(Integer.valueOf(id));
            taskManager.setProblemId(Utils.parseInt((String)this.id));
            taskManager.setOpenFrom(true);
            taskManager.performAction("new");
        } else {
            taskManager.updateForId(String.valueOf(item.getAttribute("id")));
        }
    }

    public void setStatusData(Element list) {
        this.status_CB.setModel(ClientUtils.buildComboBox((Node)list, (String)""));
    }

    public void setDocument(Document doc) {
        this.comment_TA.setText(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)doc, (String)"//comment")));
        this.resolution_TA.setText(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)doc, (String)"//resolution")));
        Element register_item = XMLUtils.selectElement((Node)doc, (String)"//problem");
        if (register_item != null) {
            this.calls_TA.setText(register_item.getAttribute("calls"));
            ClientUtils.setComboBoxSelection(this.status_CB, (Object)register_item.getAttribute("status"));
            ClientUtils.setComboBoxSelection(this.urgency_CB, (Object)register_item.getAttribute("urgency"));
            ClientUtils.setComboBoxSelection(this.group_CB, (Object)register_item.getAttribute("group"));
            ClientUtils.setComboBoxSelection(this.category_CB, (Object)register_item.getAttribute("category"));
            ClientUtils.buildList(this.usedGroups, this.usedGroupsModel, (Node)XMLUtils.selectElement((Node)doc, (String)"//used_groups"));
            ClientUtils.buildList(this.taskList, this.taskModel, (Node)XMLUtils.selectElement((Node)doc, (String)"//task_list"));
            this.problemExecutors = register_item.getAttribute("executors");
            this.executors_L.setListValues(this.problemExecutors);
        }
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        Request request = this.getUpdateQuery();
        if (request != null && ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)request))) {
            this.setVisible(false);
        }
    }

    public void okEmailButton_actionPerformed(ActionEvent actionEvent) {
        Request request = this.getUpdateQuery();
        if (request != null) {
            request.setAttribute("send.mail", "1");
            if (ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)request))) {
                this.setVisible(false);
            }
        }
    }

    public void okPrintOrderButton_actionPerformed(ActionEvent actionEvent) {
        Request request = this.getUpdateQuery();
        Document doc = TransferManager.getDocument((Request)request);
        if (request != null && ClientUtils.checkStatus((Document)doc)) {
            String id = this.id;
            if (id.equals("new")) {
                Element problem = XMLUtils.selectElement((Node)doc, (String)"//problem");
                id = problem.getAttribute("id");
            }
            request = new Request();
            request.setModule(this.module);
            request.setAction("PrintRegisterProblemOrder");
            request.setAttribute("id", id);
            request.setAttribute("contentType", "html");
            try {
                String html = TransferManager.getString((Request)request);
                new HtmlPrinter(html, 800, 600);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setVisible(false);
        }
    }

    private Request getUpdateQuery() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateRegisterProblem");
        String status = (String)this.status_CB.getItemAt(this.status_CB.getSelectedIndex()).getObject();
        String category = (String)((ComboBoxItem)this.category_CB.getSelectedItem()).getObject();
        if (status.equals("2") && category.equals("0")) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b!");
            request = null;
        } else {
            request.setAttribute("id", this.getId());
            request.setAttribute("status", status);
            request.setAttribute("category", category);
            request.setAttribute("group", ((ComboBoxItem)this.group_CB.getSelectedItem()).getObject());
            request.setAttribute("urgency", ((ComboBoxItem)this.urgency_CB.getSelectedItem()).getObject());
            request.setAttribute("comment", this.comment_TA.getText());
            request.setAttribute("resolution", this.resolution_TA.getText());
            request.setAttribute("executors", this.executors_L.getListValues());
        }
        return request;
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setTimeList(List<Long> dates) {
        this.dates = dates;
    }
}

