/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterTask;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterTaskManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionGetRegisterTask
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        if (id < 0) {
            throw new BGIllegalArgumentException();
        }
        Element taskEl = this.createElement(this.rootNode, "task");
        RegisterTaskManager taskManager = new RegisterTaskManager(this.con);
        RegisterTask task = taskManager.getTaskById(id);
        if (task != null) {
            ContractManager cm;
            Contract contract;
            taskEl.setAttribute("type", String.valueOf(task.getTypeId()));
            taskEl.setAttribute("apid", String.valueOf(task.getAddressParamId()));
            taskEl.setAttribute("aObjectId", String.valueOf(task.getAddressObjectId()));
            taskEl.setAttribute("target_date", TimeUtils.formatDate((Date)task.getTargetDate()));
            taskEl.setAttribute("target_date_and_time", TimeUtils.format((Date)task.getTargetDate(), (String)"dd.MM.yyyy HH:mm"));
            taskEl.setAttribute("execute_date", TimeUtils.formatDate((Date)task.getExecuteDate()));
            taskEl.setAttribute("group", String.valueOf(task.getGroupId()));
            taskEl.setAttribute("executors", Utils.toString((Iterable)task.getExecutors()));
            taskEl.setAttribute("status", String.valueOf(task.getStatus()));
            taskEl.setAttribute("open", this.buildRef(task.getOpenUserId(), task.getOpenTime()));
            taskEl.setAttribute("accept", this.buildRef(task.getAcceptUserId(), task.getAcceptTime()));
            taskEl.setAttribute("close", this.buildRef(task.getCloseUserId(), task.getCloseTime()));
            taskEl.setAttribute("lastmod", this.buildRef(task.getLastmodUserId(), task.getLastmodTime()));
            taskEl.setAttribute("problemId", String.valueOf(task.getProblemId()));
            Element commentEl = this.createElement(taskEl, "comment");
            this.stringToLines(commentEl, task.getComment());
            Element resolutionEl = this.createElement(taskEl, "resolution");
            this.stringToLines(resolutionEl, task.getResolution());
            if (task.getContractId() > 0 && (contract = (cm = new ContractManager(this.con)).getContractById(task.getContractId())) != null) {
                taskEl.setAttribute("contract", contract.getTitle());
                taskEl.setAttribute("contract_id", String.valueOf(contract.getId()));
            }
        }
    }

    @Override
    protected String buildRef(int userID, Date time) {
        StringBuffer result = new StringBuffer();
        if (time != null) {
            User user = UserMap.getUser((Integer)userID);
            result.append(TimeUtils.format((Date)time, (String)"dd.MM.yyyy HH:mm:ss"));
            result.append(" - ");
            result.append(user.getName());
        }
        return result.toString();
    }
}

