#!/bin/bash

cd ${0%${0##*/}}.

#JAVA_HOME=/opt/jre
#BGCASHCHECK_SERVER_DIR=/opt/BGCashcheckServer

if [ -z "$JAVA_HOME" ]; then
  echo "The JAVA_HOME environment variable is not defined"
  echo "This environment variable is needed to run this program"
  exit 1
fi

if [ -z "$BGCASHCHECK_SERVER_DIR" ]; then
  echo "The BGCASHCHECK_SERVER_DIR environment variable is not defined"
  echo "This environment variable is needed to run this program"
  exit 1
fi

PATH=$PATH:$JAVA_HOME/bin

CLASSPATH=${BGCASHCHECK_SERVER_DIR}:${BGCASHCHECK_SERVER_DIR}/lib/*:${BGCASHCHECK_SERVER_DIR}/lib/app/*:${BGCASHCHECK_SERVER_DIR}/lib/ext/*

COMPAT_PARAMS="--add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.util.regex=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED"
COMMON_PARAMS="-Dnetworkaddress.cache.ttl=3600 -Djava.awt.headless=true -Djava.net.preferIPv4Stack=true ${COMPAT_PARAMS}"

if [ "$1" = "start" ]; then
    nohup  ${JAVA_HOME}/bin/java ${COMMON_PARAMS} -cp ${CLASSPATH} ru.bitel.bgbilling.apps.cashcheck.frk.server.CmdTcpServer $@ > ${BGCASHCHECK_SERVER_DIR}/log/cashserver.out 2>&1 &
else
    ${JAVA_HOME}/bin/java ${COMMON_PARAMS} -cp ${CLASSPATH}  ru.bitel.bgbilling.apps.cashcheck.frk.server.CmdTcpServer $@
fi