/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.agr.server;

import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.agr.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.agr.server.service.AGRServiceImpl;
import ru.bitel.common.jmx.MBeanPaymentModule;

public class Module
extends ModuleBase
implements MBeanPaymentModule {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.agr.server"};
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), AGRServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        Connection con = serverContext.getConnection();
        try (TransactionManager transactionDao = new TransactionManager(con, moduleId);){
            ContractDeleteEvent contractDeleteEvent;
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (contractCreateEvent.isCheck()) {
                    // empty if block
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                transactionDao.deleteTransactionByContractId(contractId);
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
        }
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

