/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.io.IOException;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.CDCAS30Connection;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class CDCAS30ServiceActivator
extends DigitalTVServiceActivator {
    private static final Logger log = LogManager.getLogger();
    private CDCAS30Connection con = null;

    private CDCAS30Connection getConnection(int serverId, UserCard userCard) throws BGException {
        if (this.con == null) {
            ParameterMap moduleSetup = this.getModuleSetup(userCard);
            ParameterMap connectionSetup = moduleSetup.sub("server." + serverId + ".");
            try {
                this.con = new CDCAS30Connection(connectionSetup, serverId);
                this.con.connect();
                this.con.createSession();
            }
            catch (IOException e) {
                throw new BGException((Throwable)e);
            }
        }
        return this.con;
    }

    @Override
    public void destroy() {
        if (this.con != null) {
            try {
                this.con.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.con = null;
        }
    }

    public CDCAS30ServiceActivator(ParameterMap moduleSetup, Connection conMaster, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, conMaster, conSlave, mid, time);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        CDCAS30Connection con = null;
        try {
            ParameterMap moduleSetup = this.getModuleSetup(card);
            con = this.getConnection(0, card);
            for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : this.getCardPacketCodePairList(cardPacketList, false, true)) {
                CardPacket cardPacket = pairCardPacketPacketCode.cardpacket;
                String packetCode = pairCardPacketPacketCode.packetCode;
                Date date1 = cardPacket.getDateFrom();
                Date date2 = null;
                if (cardPacket.getDateTo() != null) {
                    date2 = cardPacket.getDateTo();
                } else {
                    date2 = this.graduallySubscriptionManager.getDate(cardPacket.getId());
                    if (date2 == null) {
                        date2 = TimeUtils.nowPlusPeriod((int)5, (int)this.periodGraduallySubscription);
                    }
                }
                con.entitlement(card.getNumber(), Integer.parseInt(packetCode), date1, date2, true);
            }
        }
        catch (Exception ex) {
            log.error("Exception in modifyImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        CDCAS30Connection con = null;
        try {
            con = this.getConnection(0, card);
            for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : this.getCardPacketCodePairList(cardPacketList, false, true)) {
                String packetCode = pairCardPacketPacketCode.packetCode;
                con.entitlement(card.getNumber(), Integer.parseInt(packetCode), new Date(), new Date(), false);
            }
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardCode) throws BGException {
        CDCAS30Connection con = null;
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardCode, Calendar.getInstance());
            con = this.getConnection(0, userCard);
            con.closeAccount(cardCode);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) throws BGException {
        CDCAS30Connection con = null;
        try {
            if (cardNumbers == null) {
                cardNumbers = this.cardManager.getAllCardNumbers();
            }
            for (Long cardNumber : cardNumbers) {
                UserCard userCard = this.userCardManager.getUserCard((long)cardNumber, new Date());
                con = this.getConnection(0, userCard);
                if (ismail) {
                    con.sendMail(cardNumber, title, message);
                    continue;
                }
                con.sendOSD(cardNumber, message);
            }
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception sendMessagesImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult activateImpl(long cardNumber, UserCard card, List<CardPacket> cardPacketList) throws BGException {
        CDCAS30Connection con = null;
        try {
            con = this.getConnection(0, card);
            con.openAccount(cardNumber);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult deactivateImpl(long cardNumber) throws BGException {
        CDCAS30Connection con = null;
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, Calendar.getInstance());
            con = this.getConnection(0, userCard);
            con.closeAccount(cardNumber);
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
    }
}

