/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.io.IOException;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax.ConaxConnection;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ConaxServiceActivator
extends DigitalTVServiceActivator {
    private static final Logger log = LogManager.getLogger();
    private Map<Integer, ConaxConnection> connections = new HashMap<Integer, ConaxConnection>();

    public ConaxServiceActivator(ParameterMap moduleSetup, Connection con, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, con, conSlave, mid, time);
    }

    private ConaxConnection getConnection(Integer id) throws BGException {
        ConaxConnection con = this.connections.get(id);
        if (con == null) {
            ParameterMap moduleSetup = this.getModuleSetup(null);
            ParameterMap connectionSetup = moduleSetup.sub("server." + id + ".");
            try {
                con = new ConaxConnection(connectionSetup, id);
                con.connect();
            }
            catch (IOException e) {
                throw new BGException((Throwable)e);
            }
            this.connections.put(id, con);
        }
        return con;
    }

    @Override
    public void destroy() {
        for (ConaxConnection con : this.connections.values()) {
            con.disconnect();
        }
        this.connections.clear();
    }

    private int generateTransactionId() throws BGException {
        return (int)this.sequentialIdManager.generateSequentialId();
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        try {
            for (DigitalTVServiceActivator.CardPacketCodePair cardPacketPair : this.getCardPacketCodePairList(cardPacketList, false, true)) {
                int packetCode = Utils.parseInt((String)cardPacketPair.packetCode, (int)0);
                ConaxConnection con = this.getConnection(0);
                Date date1 = ConaxServiceActivator.getFirstMinutsMonth(Calendar.getInstance()).getTime();
                Date date2 = ConaxServiceActivator.getLastMinutsMonth(Calendar.getInstance()).getTime();
                con.addAuthorization(this.generateTransactionId(), card.getNumber(), packetCode, date1, date2);
            }
        }
        catch (Exception ex) {
            log.error("Exception in modifyImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    private static Calendar getFirstMinutsMonth(Calendar date) {
        date = (Calendar)date.clone();
        date.set(5, 1);
        date.set(11, 0);
        date.set(12, 0);
        date.clear(13);
        return date;
    }

    private static Calendar getLastMinutsMonth(Calendar date) {
        date = (Calendar)date.clone();
        date.set(5, date.getActualMaximum(5));
        date.set(11, 23);
        date.set(12, 59);
        date.clear(13);
        return date;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardCode) throws BGException {
        log.info("Closing card: " + cardCode);
        try {
            ConaxConnection con = this.getConnection(0);
            con.cancelAllAuthorization(this.generateTransactionId(), cardCode);
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        log.info("Closing card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size());
        try {
            for (DigitalTVServiceActivator.CardPacketCodePair cardPacketPair : this.getCardPacketCodePairList(cardPacketList, false, true)) {
                int packetCode = Utils.parseInt((String)cardPacketPair.packetCode, (int)0);
                ConaxConnection con = this.getConnection(0);
                Date date1 = ConaxServiceActivator.getFirstMinutsMonth(Calendar.getInstance()).getTime();
                Date date2 = ConaxServiceActivator.getLastMinutsMonth(TimeUtils.plusPeriod((Calendar)Calendar.getInstance(), (int)2, (int)11)).getTime();
                con.cancelAuthorization(this.generateTransactionId(), card.getNumber(), packetCode, date1, date2);
            }
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }
}

