/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class NordEServiceActivator
extends DigitalTVServiceActivator {
    private static final Logger log = LogManager.getLogger();
    private static final DecimalFormat format10 = new DecimalFormat("0000000000");
    private static final String COMMAND_OPEN = "0301";
    private static final String COMMAND_CLOSE = "0302";
    private Map<Integer, Con> connections = new HashMap<Integer, Con>();

    public NordEServiceActivator(ParameterMap moduleSetup, Connection con, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, con, conSlave, mid, time);
    }

    private Con getConnection(Integer id) throws BGException {
        Con result = this.connections.get(id);
        if (result == null) {
            ParameterMap moduleSetup = this.getModuleSetup(null);
            String driver = moduleSetup.get("server." + id + ".driver", null);
            String host = moduleSetup.get("server." + id + ".host", null);
            String port = moduleSetup.get("server." + id + ".port", null);
            String database = moduleSetup.get("server." + id + ".database", null);
            String login = moduleSetup.get("server." + id + ".login", null);
            String pswd = moduleSetup.get("server." + id + ".pswd", null);
            String smsId = moduleSetup.get("server." + id + ".sms.id", null);
            if (Utils.isBlankString((String)driver) || Utils.isBlankString((String)host) || Utils.isBlankString((String)port) || Utils.isBlankString((String)database) || Utils.isBlankString((String)login) || Utils.isBlankString((String)pswd) || Utils.isBlankString((String)smsId)) {
                throw new BGException("Incorrect server " + id + " options!");
            }
            try {
                String url = "jdbc:oracle:thin:@//" + host + ":" + port + "/" + database;
                Con con = new Con(driver, url, login, pswd, smsId);
                con.connect();
                result = con;
                this.connections.put(id, result);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
            this.connections.put(id, result);
        }
        return result;
    }

    @Override
    public void destroy() {
        for (Con con : this.connections.values()) {
            try {
                con.disconnect();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        this.connections.clear();
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        for (Map.Entry<Integer, List<String>> e : this.getCardServerMaskMap(cardPacketList).entrySet()) {
            try {
                this.sychOnServer(card.getNumber(), e.getKey(), e.getValue());
            }
            catch (Exception ex) {
                return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0432\u044f\u0437\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
            }
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardCode) throws BGException {
        for (int serverCode : this.serversManager.getServerCodes()) {
            try {
                this.sychOnServer(cardCode, serverCode, new ArrayList<String>());
            }
            catch (Exception ex) {
                return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0432\u044f\u0437\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
            }
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        for (Map.Entry<Integer, List<String>> e : this.getCardServerMaskMap(cardPacketList).entrySet()) {
            try {
                this.sychOnServer(card.getNumber(), e.getKey(), new ArrayList<String>());
            }
            catch (Exception ex) {
                return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0432\u044f\u0437\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", ex);
            }
        }
        return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
    }

    private void sychOnServer(long cardId, int serverId, List<String> openChannels) throws Exception {
        Con serverCon = null;
        serverCon = this.getConnection(serverId);
        Connection con = serverCon.getConnection();
        String query = null;
        PreparedStatement ps = null;
        HashSet<Object> currentChannels = new HashSet<Object>();
        query = "SELECT INTER_STYLE, OBJECT_NO FROM INTER_A004_TBL WHERE SMART_CARD=? ORDER BY TO_NUMBER(YUANDAN_NMBR)";
        ps = con.prepareStatement(query);
        ps.setString(1, format10.format(cardId));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String command = rs.getString(1);
            String channel = rs.getString(2);
            if (command.endsWith(COMMAND_OPEN)) {
                currentChannels.add(channel);
                continue;
            }
            if (!command.equals(COMMAND_CLOSE)) continue;
            currentChannels.remove(channel);
        }
        ps.close();
        HashSet<String> channelsForOpen = new HashSet<String>();
        for (String channel : openChannels) {
            if (!currentChannels.contains(channel)) {
                channelsForOpen.add(channel);
            }
            currentChannels.remove(channel);
        }
        HashSet<Object> channelsForClose = currentChannels;
        Date curDate = TimeUtils.convertDateToSqlDate((java.util.Date)new java.util.Date());
        Date futureDate = TimeUtils.convertCalendarToSqlDate((Calendar)new GregorianCalendar(2100, 1, 1));
        if (channelsForOpen.size() > 0) {
            log.info("Open channels card: " + cardId + "; channels: " + Utils.toString(channelsForOpen));
            query = "INSERT INTO INTER_A004_TBL (VERSION_NO, SMS_ID, INTER_STYLE, SMART_CARD, PROVIDER_NO,BEGIN_DATE, END_DATE, OPERTOR_DATE, STATUS, OBJECT_NO)VALUES ('0015', ?, '0301', ?, '1',?, ?, ?, 'Y', ? )";
            ps = con.prepareStatement(query);
            ps.setString(1, serverCon.getSmsId());
            ps.setString(2, format10.format(cardId));
            ps.setDate(3, curDate);
            ps.setDate(4, futureDate);
            ps.setDate(5, curDate);
            for (String string : channelsForOpen) {
                ps.setString(6, string);
                ps.executeUpdate();
            }
            ps.close();
        }
        if (channelsForClose.size() > 0) {
            log.info("Close channels card: " + cardId + "; channels: " + Utils.toString(channelsForClose));
            query = "INSERT INTO INTER_A004_TBL (VERSION_NO, SMS_ID, INTER_STYLE, SMART_CARD, PROVIDER_NO, OPERTOR_DATE, STATUS, OBJECT_NO)VALUES ('0015', ?, '0302', ?, '1', ?, 'Y', ? )";
            ps = con.prepareStatement(query);
            ps.setString(1, serverCon.getSmsId());
            ps.setString(2, format10.format(cardId));
            ps.setDate(3, curDate);
            for (String string : channelsForClose) {
                ps.setString(4, string);
                ps.executeUpdate();
            }
            ps.close();
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult parentalPinCodeImpl(long cardNumber, String pinCode) throws BGException {
        throw new UnsupportedOperationException();
    }

    private static class Con {
        private String driver;
        private String url;
        private String login;
        private String pswd;
        private String smsId;
        private Connection con;

        public Con(String driver, String url, String login, String pswd, String smsId) {
            this.driver = driver;
            this.url = url;
            this.login = login;
            this.pswd = pswd;
            this.smsId = smsId;
        }

        public void connect() throws Exception {
            Class.forName(this.driver).newInstance();
            this.con = DriverManager.getConnection(this.url, this.login, this.pswd);
        }

        public void disconnect() throws Exception {
            this.con.close();
        }

        public Connection getConnection() {
            return this.con;
        }

        public String getSmsId() {
            return this.smsId;
        }
    }
}

