/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.SynclogEntry;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public class SynclogManager
extends AbstractIdDao<SynclogEntry> {
    public SynclogManager(Connection con, int mid) {
        super(con, mid, "cerbercrypt_synclog", null);
    }

    protected SynclogEntry getFromRS(ResultSet rs) throws SQLException, BGException {
        SynclogEntry synclogEntry = new SynclogEntry();
        synclogEntry.setId(rs.getInt("log.id"));
        synclogEntry.setNumber(rs.getLong("log.number"));
        synclogEntry.setUsercardId(rs.getInt("log.ucid"));
        synclogEntry.setOperation(rs.getString("log.operation"));
        synclogEntry.setDate((Date)rs.getTimestamp("log.date"));
        synclogEntry.setSuccess(rs.getBoolean("log.success"));
        synclogEntry.setComment(rs.getString("log.comment"));
        if (synclogEntry.getUsercardId() > 0) {
            String contract_title = rs.getString("contract.title");
            synclogEntry.setContractTitleComment(contract_title + "[ " + rs.getString("contract.comment") + " ]");
            synclogEntry.setContractId(rs.getInt("contract.id"));
        }
        return synclogEntry;
    }

    protected void updateImpl(SynclogEntry b) throws BGException, SQLException {
        String tableName = ServerUtils.getModuleMonthTableName((String)"cerbercrypt_synclog", (Date)b.getDate(), (int)this.moduleId);
        if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
            Statement stmt = this.con.createStatement();
            stmt.executeUpdate("CREATE TABLE `" + tableName + "` (`id` int(11) NOT NULL AUTO_INCREMENT,`number` bigint(20) NOT NULL,`ucid` int(11) NOT NULL,`operation` varchar(16) NOT NULL,`date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,`success` tinyint(1) NOT NULL,`comment` text,PRIMARY KEY (`id`) );");
            stmt.close();
        }
        String query = null;
        PreparedStatement ps = null;
        if (b.getId() <= 0) {
            query = "INSERT INTO " + tableName + " (number, ucid, operation, date, success, comment) VALUES (?, ?, ?, ?, ?, ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE " + tableName + " SET number=?, ucid=?, operation=?, date=?, success=?, comment=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(7, b.getId());
        }
        ps.setLong(1, b.getNumber());
        ps.setInt(2, b.getUsercardId());
        ps.setString(3, b.getOperation());
        ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)b.getDate()));
        ps.setBoolean(5, b.isSuccess());
        ps.setString(6, b.getComment());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    public Result<SynclogEntry> getList(Period period, Page page, int cid, Set<Long> filterNumbers, Set<Integer> filterSuccess) throws BGException {
        String tableName = ServerUtils.getModuleMonthTableName((String)"cerbercrypt_synclog", (Date)period.getDateFrom(), (int)this.moduleId);
        ArrayList<SynclogEntry> result = new ArrayList<SynclogEntry>();
        try {
            if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                StringBuffer query = new StringBuffer(500);
                query.append("SELECT SQL_CALC_FOUND_ROWS log.*, user_card.*, contract.title, contract.comment, contract.id ");
                query.append("FROM " + tableName + " AS log ");
                query.append("LEFT JOIN user_card_" + this.moduleId + " AS user_card ON log.ucid=user_card.id ");
                query.append("LEFT JOIN contract ON user_card.cid=contract.id ");
                query.append("WHERE (1=1) ");
                if (period != null && period.getDateFrom() != null) {
                    query.append(" AND log.date>='");
                    query.append(TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd"));
                    query.append("'");
                }
                if (period != null && period.getDateTo() != null) {
                    query.append(" AND log.date<=DATE_ADD('");
                    query.append(TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd"));
                    query.append("', INTERVAL 1 DAY )");
                }
                if (cid > 0) {
                    query.append(" AND user_card.cid=" + cid);
                }
                if (filterNumbers != null && !filterNumbers.isEmpty()) {
                    query.append(" AND log.number IN (" + Utils.toString(filterNumbers) + ") ");
                }
                if (filterSuccess != null && !filterSuccess.isEmpty()) {
                    query.append(" AND log.success IN (" + Utils.toString(filterSuccess) + ") ");
                }
                query.append(" ORDER BY log.date LIMIT ");
                query.append(page.getPageFirstRecordNumber());
                query.append(", ");
                query.append(page.getPageSize());
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    SynclogEntry entry = this.getFromRS(rs);
                    result.add(entry);
                }
                rs.close();
                ps.close();
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            } else {
                page.setRecordCount(0);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return new Result(result, page);
    }

    public void commit() throws BGException {
        try {
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public SynclogEntry getEntry(int id, Date date) throws BGException {
        String tableName = ServerUtils.getModuleMonthTableName((String)"cerbercrypt_synclog", (Date)date, (int)this.moduleId);
        SynclogEntry result = null;
        try {
            String query = "SELECT log.*, user_card.*, contract.title, contract.comment, contract.id FROM " + tableName + " AS log LEFT JOIN user_card_" + this.moduleId + " AS user_card ON log.ucid=user_card.id LEFT JOIN contract ON user_card.cid=contract.id WHERE log.id=" + id;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                rs.close();
                ps.close();
                throw new BGException("\u0437\u0430\u043f\u0438\u0441\u044c id=" + id + " \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            result = this.getFromRS(rs);
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

