/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cticas4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cticas4.ByteDeserializer;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cticas4.ByteSerializer;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cticas4.CtiCas4Exception;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CtiCas4Con {
    private static final Logger log = LogManager.getLogger();
    private static final byte PROTOCOL_ID = 18;
    private String host;
    private int port;
    private int timeout;
    private int smsNumber;
    private long commandTimeout;
    private int emailDay = 1;
    private String emailFrom = null;
    private int osdDay = 1;
    private int osdAccount = 1;
    private String osdFrom = null;
    private boolean emailEnable;
    private boolean osdEnable;
    private int regionID = 1;
    private int gcano = 1;
    private int ctrcustwd = 1;
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private String emailCharset;
    private String osdCharset;
    private boolean sendUAonly;
    private boolean autoActivate;
    private static final int PI_TRN = 1;
    private static final int PI_SMARTCARDId = 4;
    private static final int PI_STBId = 6;
    private static final int PI_REGIONId = 7;
    private static final int PI_MATCHTYPE = 10;
    private static final int PI_CTRDISTRICT = 11;
    private static final int PI_CTRCUSTWD = 12;
    private static final int PI_OPERATIONTYPE = 13;
    private static final int PI_PACKAGEId = 16;
    private static final int PI_MESSSTART = 26;
    private static final int PI_MESSACCOUNT = 27;
    private static final int PI_MESSDAY = 28;
    private static final int PI_MESSTITLE = 29;
    private static final int PI_MESSCONT = 30;
    private static final int PI_MESSFROM = 31;
    private static final int PI_MESSTYPE = 57;
    private static final int PI_MESSAGEId = 58;
    private static final int PI_ENDDATE = 61;
    private static final int PI_SmartCardPrint = 68;
    private static final int PI_STAT_CAS = 255;
    private static final int PL_TRN = 4;
    private static final int PL_SMARTCARDId = 5;
    private static final int PL_STBId = -1;
    private static final int PL_REGIONId = -1;
    private static final int PL_MATCHTYPE = 1;
    private static final int PL_CTRDISTRICT = -1;
    private static final int PL_CTRCUSTWD = 2;
    private static final int PL_OPERATIONTYPE = 1;
    private static final int PL_PACKAGEId = 2;
    private static final int PL_MESSSTART = 7;
    private static final int PL_MESSACCOUNT = 1;
    private static final int PL_MESSDAY = 1;
    private static final int PL_MESSTITLE = -1;
    private static final int PL_MESSCONT = -1;
    private static final int PL_MESSFROM = -1;
    private static final int PL_MESSTYPE = 1;
    private static final int PL_MESSAGEId = 4;
    private static final int PL_ENDDATE = 7;
    private static final int PL_SmartCardPrint = -1;
    private static final int PL_STAT_CAS = 1;
    private final List<Integer> packageList = new ArrayList<Integer>();
    private long _lastSendedTime = 0L;

    public CtiCas4Con(ParameterMap preferences, int serverId) throws BGException {
        this.host = preferences.get("host", null);
        this.port = preferences.getInt("port", 7000);
        if (Utils.isEmptyString((String)this.host) || this.port <= 0) {
            throw new BGException("Host or port for server " + serverId + " undefined!");
        }
        this.timeout = preferences.getInt("timeout", 30000);
        this.smsNumber = preferences.getInt("smsNumber", 1);
        this.commandTimeout = preferences.getLong("commandTimeout", -1L);
        this.emailDay = preferences.getInt("emailDay", 1);
        this.emailFrom = preferences.get("emailFrom", "emailFrom");
        this.osdDay = preferences.getInt("osdDay", 1);
        this.osdAccount = preferences.getInt("osdAccount", 1);
        this.osdFrom = preferences.get("osdFrom", "osdFrom");
        this.emailEnable = preferences.getBoolean("emailEnable", false);
        this.osdEnable = preferences.getBoolean("osdEnable", false);
        this.regionID = preferences.getInt("regionID", 1);
        this.gcano = preferences.getInt("gcano", 1);
        this.ctrcustwd = preferences.getInt("ctrcustwd", 1);
        this.emailCharset = preferences.get("emailCharset", "utf-8");
        this.osdCharset = preferences.get("osdCharset", "utf-8");
        this.sendUAonly = preferences.getBoolean("sendUAonly", false);
        this.autoActivate = preferences.getBoolean("autoActivate", false);
    }

    private long convertCardnumber(long cardnumber) {
        if (this.sendUAonly) {
            String num = String.valueOf(cardnumber);
            if (num.length() >= 9) {
                num = num.substring(num.length() - 9, num.length() - 1);
                return Long.valueOf(num);
            }
            return cardnumber;
        }
        return cardnumber;
    }

    private void _sendRequest(int commandId, byte[] request, long cardNumber) throws BGException, IOException {
        CtiCas4Con.$trace("sendRequest: commandId=%d, request=%s", commandId, Utils.bytesToString((byte[])request));
        int ack_trn = -1;
        int ack_retcode = -1;
        this.packageList.clear();
        ByteSerializer bs = new ByteSerializer(17 + request.length);
        bs.put((byte)18, 1);
        bs.put(this.smsNumber, 2);
        bs.put(1, 4);
        bs.putSTMP(new Date());
        bs.put(commandId, 1);
        bs.put(request.length, 2);
        bs.put(request);
        long needWait = this._lastSendedTime + this.commandTimeout - System.currentTimeMillis();
        if (needWait > 0L) {
            try {
                CtiCas4Con.$trace("wait: %s ms", needWait);
                Thread.sleep(needWait);
            }
            catch (InterruptedException e) {
                throw new BGException("interrupt _sendRequest", (Throwable)e);
            }
        }
        this.os.write(bs.getBuffer());
        this.os.flush();
        CtiCas4Con.$trace("-> packet: %s", Utils.bytesToString((byte[])bs.getBuffer()));
        this._lastSendedTime = System.currentTimeMillis();
        byte[] responseHeader = new byte[17];
        Utils.readFullBuffer((InputStream)this.is, (byte[])responseHeader);
        CtiCas4Con.$trace("<- header: %s", Utils.bytesToString((byte[])responseHeader));
        ByteDeserializer bd = new ByteDeserializer(responseHeader);
        byte r_protocolId = bd.getByte(1);
        int r_smsNumber = bd.getInt(2);
        long r_transNumber = bd.getLong(4);
        Date r_date = bd.getSTMP();
        int r_commandId = bd.getInt(1);
        int r_dataLength = bd.getInt(2);
        CtiCas4Con.$trace("protocolId=%d, smsNumber=%d, transNumber=%d, date=%s, commandId=%d, dataLength=%d", r_protocolId, r_smsNumber, r_transNumber, TimeUtils.format((Date)r_date, (String)"dd.MM.yyyy HH:mm:ss"), r_commandId, r_dataLength);
        byte[] body = null;
        if (r_dataLength > 0) {
            body = new byte[r_dataLength];
            Utils.readFullBuffer((InputStream)this.is, (byte[])body);
        }
        CtiCas4Con.$trace("<- body: %s", Utils.bytesToString((byte[])body));
        this._lastSendedTime = System.currentTimeMillis();
        if (body != null) {
            bd = new ByteDeserializer(body);
            while (bd.available() >= 4) {
                int PI = bd.getInt(2);
                int PL = bd.getInt(2);
                switch (PI) {
                    case 1: {
                        ack_trn = bd.getInt(4);
                        CtiCas4Con.$trace("TRN: %d", ack_trn);
                        break;
                    }
                    case 255: {
                        ack_retcode = bd.getInt(1);
                        CtiCas4Con.$trace("STAT_CAS: %d", ack_retcode);
                        break;
                    }
                    case 16: {
                        int packId = bd.getInt(2);
                        this.packageList.add(packId);
                        CtiCas4Con.$trace("PACKAGEId: %d", packId);
                    }
                }
            }
            if (ack_retcode != 0) {
                throw new CtiCas4Exception(commandId, ack_retcode, cardNumber);
            }
        }
    }

    public void sendRequest(int commandId, byte[] request, long cardNumber) throws BGException, IOException {
        this._sendRequest(commandId, request, cardNumber, true);
    }

    private void _sendRequest(int commandId, byte[] request, long cardNumber, boolean firstrun) throws BGException, IOException {
        try {
            this._sendRequest(commandId, request, cardNumber);
        }
        catch (CtiCas4Exception ex) {
            if (ex.getErrorNumber() == 68) {
                CtiCas4Con.$trace("masking exception: %s", ex.getMessage());
                this.packageList.clear();
            }
            if (ex.getErrorNumber() == 19 && this.autoActivate && commandId != 101 && firstrun) {
                CtiCas4Con.$trace("enable auto activate, masking exception: %s, try activate...", ex.getMessage());
                this.registerSmartcard(cardNumber);
                this._sendRequest(commandId, request, cardNumber, false);
            }
            if (ex.getErrorNumber() == 32 && commandId == 36) {
                CtiCas4Con.$trace("masking exception: %s", ex.getMessage());
                this.packageList.clear();
            }
            throw ex;
        }
    }

    public void connect() throws IOException, BGException {
        this.socket = new Socket();
        this.socket.setSoTimeout(this.timeout);
        this.socket.connect(new InetSocketAddress(this.host, this.port), this.timeout);
        this.os = this.socket.getOutputStream();
        this.is = this.socket.getInputStream();
        this.connectionTest();
    }

    public void disconnect() throws Exception {
        this.is.close();
        this.is = null;
        this.os.close();
        this.os = null;
        this.socket.close();
        this.socket = null;
    }

    public void tuneconnect(CtiCas4Con newconnect) throws IOException, BGException {
        if (!this.host.equals(newconnect.host) || this.port != newconnect.port) {
            throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u043f\u0435\u0440\u0435\u043d\u0430\u0441\u0442\u0440\u0430\u0438\u0432\u0430\u0442\u044c host \u0438 port");
        }
        if (this.timeout != newconnect.timeout) {
            this.socket.setSoTimeout(newconnect.timeout);
        }
        this.smsNumber = newconnect.smsNumber;
        this.commandTimeout = newconnect.commandTimeout;
        this.emailDay = newconnect.emailDay;
        this.emailFrom = newconnect.emailFrom;
        this.osdDay = newconnect.osdDay;
        this.osdAccount = newconnect.osdAccount;
        this.osdFrom = newconnect.osdFrom;
        this.emailEnable = newconnect.emailEnable;
        this.osdEnable = newconnect.osdEnable;
    }

    public void connectionTest() throws BGException, IOException {
        CtiCas4Con.$trace("connectionTest", new Object[0]);
        this.sendRequest(1, new byte[0], 0L);
    }

    private static void $trace(String format, Object ... args) {
        log.info("CtiCas4Con: " + String.format(format, args));
    }

    public void packageAuthorization(long cardNumber, int packageId, Date endTime) throws BGException, IOException {
        CtiCas4Con.$trace("packageAuthorization, cardNumber=%s, packageId=%s, endTime=%s", cardNumber, packageId, endTime);
        ByteSerializer bd = new ByteSerializer(666);
        bd.putTLVInteger(4, 5, this.convertCardnumber(cardNumber));
        bd.putTLVInteger(16, 2, packageId);
        bd.putTLVSTMP(61, 7, endTime);
        this.sendRequest(103, bd.getBuffer(), cardNumber);
    }

    public void packageAuthorization(long cardNumber, List<Integer> packagesId) throws BGException, IOException {
        CtiCas4Con.$trace("packageAuthorization, cardNumber=%s, packagesId=%s", cardNumber, Utils.toString(packagesId));
        ByteSerializer bd = new ByteSerializer(666);
        bd.putTLVInteger(4, 5, this.convertCardnumber(cardNumber));
        for (Integer packageId : packagesId) {
            bd.putTLVInteger(16, 2, packageId.intValue());
        }
        this.sendRequest(15, bd.getBuffer(), cardNumber);
    }

    public void packageCancel(long cardNumber, List<Integer> packagesId) throws BGException, IOException {
        CtiCas4Con.$trace("packageCancel, cardNumber=%s, packagesId=%s", cardNumber, Utils.toString(packagesId));
        ByteSerializer bd = new ByteSerializer(666);
        bd.putTLVInteger(4, 5, this.convertCardnumber(cardNumber));
        for (Integer packageId : packagesId) {
            bd.putTLVInteger(16, 2, packageId.intValue());
        }
        this.sendRequest(16, bd.getBuffer(), cardNumber);
    }

    public void sendSingleUserEmail(long cardNumber, String title, String message, long messageId) throws BGException, IOException {
        CtiCas4Con.$trace("sendSingleUserEmail, cardNumber=%s, title=%s, message=%s, messageId=%s (emailEnable=%b)", cardNumber, title, message, messageId, this.emailEnable);
        if (this.emailEnable) {
            ByteSerializer bd = new ByteSerializer(10000);
            bd.putTLVInteger(4, 5, this.convertCardnumber(cardNumber));
            bd.putTLVInteger(57, 1, 85L);
            bd.putTLVSTMP(26, 7, TimeUtils.nowPlusPeriod((int)12, (int)1));
            bd.putTLVInteger(28, 1, this.emailDay);
            bd.putTLVInteger(27, 1, 0L);
            bd.putTLVStringVariable(29, title, this.emailCharset);
            bd.putTLVStringVariable(30, message, this.emailCharset);
            bd.putTLVStringVariable(31, this.emailFrom, this.emailCharset);
            bd.putTLVInteger(58, 4, messageId);
            this.sendRequest(59, bd.getBuffer(), cardNumber);
        }
    }

    public void sendEmailToAllTheUser(String title, String message, long messageId) throws BGException, IOException {
        CtiCas4Con.$trace("sendEmailToAllTheUser, title=%s, message=%s, messageId=%s (emailEnable=%b)", title, message, messageId, this.emailEnable);
        if (this.emailEnable) {
            ByteSerializer bd = new ByteSerializer(10000);
            bd.putTLVInteger(57, 1, 71L);
            bd.putTLVSTMP(26, 7, TimeUtils.nowPlusPeriod((int)12, (int)1));
            bd.putTLVInteger(28, 1, this.emailDay);
            bd.putTLVInteger(27, 1, 0L);
            bd.putTLVStringVariable(29, title, this.emailCharset);
            bd.putTLVStringVariable(30, message, this.emailCharset);
            bd.putTLVStringVariable(31, this.emailFrom, this.emailCharset);
            bd.putTLVInteger(58, 4, messageId);
            this.sendRequest(61, bd.getBuffer(), 0L);
        }
    }

    public void sentOSDToASingleUser(long cardNumber, String title, String message, long messageId) throws BGException, IOException {
        CtiCas4Con.$trace("sentOSDToASingleUser, cardNumber=%s, title=%s, message=%s, messageId=%s (osdEnable=%b)", cardNumber, title, message, messageId, this.osdEnable);
        if (this.osdEnable) {
            ByteSerializer bd = new ByteSerializer(10000);
            bd.putTLVInteger(4, 5, this.convertCardnumber(cardNumber));
            bd.putTLVInteger(57, 1, 117L);
            bd.putTLVSTMP(26, 7, TimeUtils.nowPlusPeriod((int)12, (int)1));
            bd.putTLVInteger(28, 1, this.osdDay);
            bd.putTLVInteger(27, 1, this.osdAccount);
            bd.putTLVStringVariable(29, title, this.osdCharset);
            bd.putTLVStringVariable(30, message, this.osdCharset);
            bd.putTLVStringVariable(31, this.osdFrom, this.osdCharset);
            bd.putTLVInteger(58, 4, messageId);
            this.sendRequest(59, bd.getBuffer(), cardNumber);
        }
    }

    public void sendOSDToAllTheUsers(String title, String message, long messageId) throws BGException, IOException {
        CtiCas4Con.$trace("sendOSDToAllTheUsers, title=%s, message=%s, messageId=%s (osdEnable=%b)", title, message, messageId, this.osdEnable);
        if (this.osdEnable) {
            ByteSerializer bd = new ByteSerializer(10000);
            bd.putTLVInteger(57, 1, 103L);
            bd.putTLVSTMP(26, 7, TimeUtils.nowPlusPeriod((int)12, (int)1));
            bd.putTLVInteger(28, 1, this.osdDay);
            bd.putTLVInteger(27, 1, this.osdAccount);
            bd.putTLVStringVariable(29, title, this.osdCharset);
            bd.putTLVStringVariable(30, message, this.osdCharset);
            bd.putTLVStringVariable(31, this.osdFrom, this.osdCharset);
            bd.putTLVInteger(58, 4, messageId);
            this.sendRequest(61, bd.getBuffer(), 0L);
        }
    }

    public void cancelAllPackage(long cardNumber) throws BGException, IOException {
        CtiCas4Con.$trace("cancelAllChannelAuthorization, cardNumber=%s", cardNumber);
        ByteSerializer bd = new ByteSerializer(666);
        bd.putTLVInteger(4, 5, this.convertCardnumber(cardNumber));
        this.sendRequest(58, bd.getBuffer(), cardNumber);
    }

    public void registerSmartcard(long cardNumber) throws BGException, IOException {
        CtiCas4Con.$trace("registerSmartcard, cardNumber=%s", cardNumber);
        ByteSerializer bd = new ByteSerializer(666);
        bd.putTLVInteger(4, 5, this.convertCardnumber(cardNumber));
        bd.putTLVStringVariable(6, String.valueOf(cardNumber));
        bd.putTLVStringVariable(7, String.valueOf(this.regionID));
        bd.putTLVInteger(10, 1, 20L);
        bd.putTLVStringVariable(11, String.valueOf(this.gcano));
        bd.putTLVInteger(12, 2, this.ctrcustwd);
        bd.putTLVStringVariable(68, String.valueOf(cardNumber));
        this.sendRequest(101, bd.getBuffer(), cardNumber);
    }

    public void unregisterSmartcard(long cardNumber) throws BGException, IOException {
        CtiCas4Con.$trace("unregisterSmartcard, cardNumber=%s", cardNumber);
        ByteSerializer bd = new ByteSerializer(666);
        bd.putTLVInteger(4, 5, this.convertCardnumber(cardNumber));
        bd.putTLVInteger(13, 1, 85L);
        this.sendRequest(11, bd.getBuffer(), cardNumber);
    }

    public List<Integer> getSubscribeInfo(long cardNumber) throws BGException, IOException {
        CtiCas4Con.$trace("getSubscribeInfo, cardNumber=%s", cardNumber);
        ByteSerializer bd = new ByteSerializer(666);
        bd.putTLVInteger(4, 5, this.convertCardnumber(cardNumber));
        this.sendRequest(36, bd.getBuffer(), cardNumber);
        return this.packageList;
    }
}

