/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.service;

import jakarta.jws.WebService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Channel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.ChannelMapping;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.ChannelService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.ChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.ChannelMappingManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.ServersManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.cerbercrypt.common.service.ChannelService")
public class ChannelServiceImpl
extends AbstractService
implements ChannelService {
    public List<Channel> channelList() throws BGException {
        return new ChannelManager(this.getConnection(), this.moduleId).getChannelList();
    }

    public void deleteChannel(int id) throws BGException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        new ChannelManager(this.getConnection(), this.moduleId).deleteChannel(id);
        new ChannelMappingManager(this.getConnection(), this.moduleId).deleteChannelMappings(id);
    }

    public int updateChannel(Channel channel) throws BGException {
        if (channel == null || Utils.isEmptyString((String)channel.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        new ChannelManager(this.getConnection(), this.moduleId).updateChannel(channel);
        return channel.getId();
    }

    public Channel getChannel(int id) throws BGException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        return new ChannelManager(this.getConnection(), this.moduleId).getChannelById(id);
    }

    public List<IdTitle> getServers() throws BGException {
        return new ServersManager((ParameterMap)this.getModuleSetup()).getServers();
    }

    public List<ChannelMapping> channelMappingTable(int channelId) throws BGException {
        if (channelId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ServersManager man = new ServersManager((ParameterMap)this.getModuleSetup());
        List<ChannelMapping> mappingList = new ChannelMappingManager(this.getConnection(), this.moduleId).getChannelMappingList(channelId);
        for (ChannelMapping mapping : mappingList) {
            mapping.setServerTitle(man.getTitle(mapping.getServerCode()));
        }
        return mappingList;
    }

    public ChannelMapping getChannelMapping(int mappingId) throws BGException {
        if (mappingId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return new ChannelMappingManager(this.getConnection(), this.moduleId).getMappingById(mappingId);
    }

    protected void checkPeriod(Date date1, Date date2) throws BGException {
        boolean result;
        boolean bl = result = date1 == null || date2 == null || TimeUtils.dateBeforeOrEq((Date)date1, (Date)date2);
        if (!result) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434!");
        }
    }

    public void updateChannelMapping(ChannelMapping mapping) throws BGException {
        Channel channel;
        if (mapping.getId() < 0 || mapping.getChannelId() <= 0 || Utils.isBlankString((String)mapping.getChannelCode())) {
            throw new BGIllegalArgumentException();
        }
        this.checkPeriod(mapping.getDateFrom(), mapping.getDateTo());
        ChannelMappingManager manager = new ChannelMappingManager(this.getConnection(), this.moduleId);
        ChannelMapping conflictMapping = manager.findConflictMapping(mapping);
        if (conflictMapping != null && (channel = new ChannelManager(this.getConnection(), this.moduleId).getChannelById(conflictMapping.getChannelId())) != null) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u0435\u0442 \u0441 \u043a\u0430\u043d\u0430\u043b\u043e\u043c " + channel.getTitle());
        }
        try (DigitalTVServiceActivator activator = DigitalTVServiceActivator.newInstance((ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId, Calendar.getInstance());){
            activator.checkChannelMapping(mapping);
        }
        manager.updateMapping(mapping);
    }

    public void deleteChannelMapping(int mappingId) throws BGException {
        if (mappingId <= 0) {
            throw new BGIllegalArgumentException();
        }
        new ChannelMappingManager(this.getConnection(), this.moduleId).deleteMapping(mappingId);
    }
}

