/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.server.bean;

import java.io.File;
import java.sql.Connection;
import ru.bitel.bgbilling.modules.dba.server.bean.ScriptGenerator;
import ru.bitel.bgbilling.server.util.Setup;

public class BashScriptGenerator
extends ScriptGenerator {
    public BashScriptGenerator(Setup setup, Connection con, int mid) {
        super(setup, con, mid);
    }

    @Override
    protected void addScriptHeader() {
        this.script.append("#!/bin/bash\n");
        this.script.append("check_error()\n");
        this.script.append("{\n");
        this.script.append(" if [ \"$?\" -ne \"0\" ]\n");
        this.script.append("  then\n");
        this.script.append("  echo \"Backup error, exiting..\"\n");
        this.script.append("  exit 1\n");
        this.script.append(" fi\n");
        this.script.append("}\n");
    }

    @Override
    protected void addBackupTables() {
        for (String table : this.backupTableList) {
            this.script.append("echo BACKUP " + table + "\n");
            this.script.append(this.mysqlDumpCommand + " " + this.databaseName + " " + table + " > " + this.backupPath + File.separator + table + "\n");
            this.script.append("check_error\n");
        }
    }

    @Override
    protected void addDeleteTables() {
        for (String table : this.deleteTableList) {
            this.script.append("echo DROP " + table + "\n");
            this.script.append(this.mysqlCommand + " " + this.databaseName + " -e \"DROP TABLE IF EXISTS " + table + "\"\n");
        }
    }
}

