/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.dba.server.bean.TableConfigManager;
import ru.bitel.bgbilling.modules.dba.server.bean.TableRefManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public abstract class ScriptGenerator {
    private Connection con;
    private int mid;
    private Calendar currentMonth = new GregorianCalendar();
    private List<String> tableList = new ArrayList<String>();
    protected StringBuilder script = new StringBuilder();
    protected List<String> backupTableList = new ArrayList<String>();
    protected List<String> deleteTableList = new ArrayList<String>();
    protected String mysqlCommand;
    protected String mysqlDumpCommand;
    protected String backupPath;
    protected String databaseName;
    private static final Pattern macrosPattern = Pattern.compile("\\$\\{(\\w+)\\}");
    private static final String PATTERN_YEAR = "yyyy";
    private static final String PATTERN_MONTH = "mm";
    private static final String PATTERN_MID = "mid";
    private static final String PATTERN_DAY = "dd";

    public ScriptGenerator(Setup setup, Connection con, int mid) {
        String dbUrl = setup.get("db.url", null);
        int pos1 = dbUrl.lastIndexOf(47);
        int pos2 = dbUrl.indexOf(63);
        this.databaseName = dbUrl.substring(pos1 + 1, pos2);
        this.con = con;
        this.mid = mid;
    }

    public void setBackupPath(String backupPath) {
        this.backupPath = backupPath;
    }

    public void setMysqlCommand(String mysqlBinPath) {
        this.mysqlCommand = mysqlBinPath;
    }

    public void addBackupTable(String tableName) {
        this.backupTableList.add(tableName);
    }

    public void addDeleteTable(String tableName) {
        this.deleteTableList.add(tableName);
    }

    public String getScript() {
        TableRefManager refManager = new TableRefManager();
        TableConfigManager configManager = new TableConfigManager(this.con, this.mid);
        this.loadTables();
        this.script.setLength(0);
        Map<String, Document> docMap = refManager.getModulesDocMap();
        Map<String, String> configMap = configManager.getConfigItemMap();
        ArrayList<BGModule> moduleList = new ArrayList<BGModule>(ModuleCache.getInstance().getModulesListProcessSorted());
        BGModule kernelModule = new BGModule();
        kernelModule.setId(0);
        kernelModule.setName("kernel");
        moduleList.add(0, kernelModule);
        for (BGModule module : moduleList) {
            int mid = module.getId();
            Document doc = docMap.get(module.getName());
            if (doc == null) continue;
            NodeList tables = doc.getElementsByTagName("table");
            int size = tables.getLength();
            for (int i = 0; i < size; ++i) {
                Element table = (Element)tables.item(i);
                String id = table.getAttribute("id");
                Element defaultEl = XMLUtils.selectElement((Node)table, (String)"default");
                String config = configMap.get(mid + "_" + id);
                Map tableConf = null;
                tableConf = Utils.notBlankString((String)config) ? Utils.stringToPairsHash((String)config) : XMLUtils.attributesToMap((Element)defaultEl);
                this.processTableRef(table, tableConf, mid);
            }
        }
        this.addScriptHeader();
        this.addBackupTables();
        this.addDeleteTables();
        return this.script.toString();
    }

    private void processTableRef(Element table, Map<String, String> config, int mid) {
        String name = table.getAttribute("name");
        int storeMonth = Utils.parseInt((String)config.get("store_month"));
        if (storeMonth <= 0) {
            return;
        }
        boolean saveBeforeDel = !Utils.maskNull((String)config.get("save_before_delete")).equals("false");
        ArrayList<PatternItem> itemList = new ArrayList<PatternItem>();
        int lastEnd = 0;
        Matcher m = macrosPattern.matcher(name);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            if (lastEnd != start) {
                PatternItem textItem = new PatternItem();
                textItem.type = 1;
                textItem.text = name.substring(lastEnd, start);
                itemList.add(textItem);
            }
            String macros = m.group(1);
            PatternItem item = new PatternItem();
            if (macros.equals(PATTERN_YEAR)) {
                item.type = 2;
            } else if (macros.equals(PATTERN_MONTH)) {
                item.type = 3;
            } else if (macros.equals(PATTERN_DAY)) {
                item.type = 4;
            } else if (macros.equals(PATTERN_MID)) {
                item.type = 1;
                item.text = String.valueOf(mid);
            }
            itemList.add(item);
            lastEnd = end;
        }
        if (lastEnd != name.length()) {
            PatternItem textItem = new PatternItem();
            textItem.type = 1;
            textItem.text = name.substring(lastEnd, name.length());
            itemList.add(textItem);
        }
        StringBuilder tableNamePattern = new StringBuilder("^");
        for (PatternItem item : itemList) {
            switch (item.type) {
                case 1: {
                    tableNamePattern.append(item.text);
                    break;
                }
                case 3: {
                    tableNamePattern.append("(\\d{2})");
                    break;
                }
                case 2: {
                    tableNamePattern.append("(\\d{4})");
                    break;
                }
                case 4: {
                    tableNamePattern.append("(\\d{2})");
                }
            }
        }
        tableNamePattern.append("$");
        Pattern tablePattern = Pattern.compile(tableNamePattern.toString());
        for (String tableName : this.tableList) {
            m = tablePattern.matcher(tableName);
            if (!m.find()) continue;
            int pos = 1;
            GregorianCalendar date = new GregorianCalendar();
            int month = 0;
            int year = 0;
            for (PatternItem item : itemList) {
                if (item.type == 3) {
                    month = Utils.parseInt((String)m.group(pos++));
                    continue;
                }
                if (item.type != 2) continue;
                year = Utils.parseInt((String)m.group(pos++));
            }
            if (month <= 0 || month > 12 || year < 2000 || year > 2100) continue;
            date.set(2, month - 1);
            date.set(1, year);
            if (TimeUtils.monthsDelta((Calendar)date, (Calendar)this.currentMonth) < storeMonth) continue;
            this.deleteTableList.add(tableName);
            if (!saveBeforeDel) continue;
            this.backupTableList.add(tableName);
        }
    }

    private void loadTables() {
        this.tableList.clear();
        try {
            String query = "SHOW TABLES";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.tableList.add(rs.getString(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void addScriptHeader();

    protected abstract void addBackupTables();

    protected abstract void addDeleteTables();

    public void setMysqlDumpCommand(String mysqlDumpCommand) {
        this.mysqlDumpCommand = mysqlDumpCommand;
    }

    private static class PatternItem {
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_YEAR = 2;
        public static final int TYPE_MONTH = 3;
        public static final int TYPE_DAY = 4;
        public int type;
        public String text;

        private PatternItem() {
        }
    }
}

