/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.dba.common.bean.TableInfo;
import ru.bitel.bgbilling.modules.dba.common.service.DBAService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.dba.common.service.DBAService")
public class DBAServiceImpl
extends AbstractService
implements DBAService {
    private static final Logger logger = LogManager.getLogger();

    public List<TableInfo> tableInfoList() throws BGException, BGMessageException {
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        List<String> kernelTableNames = Arrays.asList("contract_period_job_log", "data_log_error", "log_function_process", "log_gscript_process", "payment_register_item", "reserve_job_log", "tariff_option_job_log", "web_query_log", "bgs_query_log", "charge_register_item");
        String taskTableName = "dba_table_task_" + this.moduleId;
        Map moduleMap = ModuleCache.getInstance().getModuleMap();
        try (Statement st = this.getConnection().createStatement();
             Statement stTask = this.getConnection().createStatement();
             ResultSet rs = st.executeQuery("SHOW TABLES");
             ResultSet rsTask = stTask.executeQuery("SELECT * FROM " + taskTableName);){
            HashMap<String, Integer> autoValue = new HashMap<String, Integer>();
            JSONArray autoConfig = new JSONArray(ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("dba.auto.archive.config." + this.moduleId), (String)"[]"));
            int len = autoConfig.length();
            for (int index = 0; index < len; ++index) {
                JSONObject json = autoConfig.getJSONObject(index);
                autoValue.put(json.getString("tableNameMask"), json.getInt("autoValue"));
            }
            HashSet<String> taskNameSet = new HashSet<String>();
            while (rsTask.next()) {
                taskNameSet.add(rsTask.getString(1));
            }
            while (rs.next()) {
                String tableNamePrefix;
                String tableName = rs.getString(1);
                if (!tableName.matches(".*_\\d{6}$") && !tableName.matches(".*_\\d{8}$")) continue;
                TableInfo tableInfo = new TableInfo();
                tableInfo.setTableName(tableName);
                tableInfo.setComponentId(Utils.parseInt((String)tableName.replaceAll(".*_(\\d+)_\\d+$", "$1"), (int)-1));
                tableInfo.setInArchive(taskNameSet.contains(tableName));
                tableInfo.setAutoArchive(autoValue.getOrDefault(tableName.replaceAll("^(.+)_\\d+$", "$1"), 0).intValue());
                String componentName = null;
                if (tableInfo.getComponentId() > 0) {
                    BGModule bgModule = moduleMap.getOrDefault(tableInfo.getComponentId(), null);
                    String string = componentName = bgModule != null ? bgModule.getTitle() : null;
                }
                if (componentName == null && kernelTableNames.contains(tableNamePrefix = tableName.replaceAll("(.*)_\\d+$", "$1"))) {
                    tableInfo.setComponentId(0);
                    componentName = "\u042f\u0434\u0440\u043e";
                }
                tableInfo.setComponentName(componentName);
                tableInfos.add(tableInfo);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return tableInfos;
    }

    public void tableInArchiveUpdate(List<String> tableNames, boolean value) throws BGException, BGMessageException {
        if (tableNames == null || tableNames.isEmpty()) {
            return;
        }
        String tableName = "dba_table_task_" + this.moduleId;
        String queryInsert = "INSERT INTO " + tableName + " SET table_name=?";
        String queryDelete = "DELETE FROM " + tableName + " WHERE table_name=?";
        Connection con = this.getConnection();
        try (PreparedStatement psInsert = con.prepareStatement(queryInsert);
             PreparedStatement psDelete = con.prepareStatement(queryDelete);){
            for (String name : tableNames) {
                psDelete.setString(1, name);
                psDelete.execute();
                if (!value) continue;
                psInsert.setString(1, name);
                psInsert.execute();
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void tableAutoarchiveUpdate(Set<String> tableNameMaskSet, int autoValue) throws BGException, BGMessageException {
        if (tableNameMaskSet != null) {
            String name = "dba.auto.archive.config." + this.moduleId;
            String configText = ServerUtils.getSetupValue((Connection)this.getConnection(), (String)name, (String)"[]");
            JSONArray configArray = new JSONArray(configText);
            block0: for (String tableNameMask : tableNameMaskSet) {
                if (autoValue == 0) {
                    int len = configArray.length();
                    for (int index = 0; index < len; ++index) {
                        JSONObject obj = configArray.getJSONObject(index);
                        if (!tableNameMask.equals(obj.optString("tableNameMask"))) continue;
                        configArray.remove(index);
                        continue block0;
                    }
                    continue;
                }
                JSONObject json = null;
                int len = configArray.length();
                for (int index = 0; index < len; ++index) {
                    JSONObject obj = configArray.getJSONObject(index);
                    if (!tableNameMask.equals(obj.optString("tableNameMask"))) continue;
                    json = obj;
                    break;
                }
                if (json == null) {
                    json = new JSONObject();
                    json.put("tableNameMask", (Object)tableNameMask);
                    configArray.put((Object)json);
                }
                json.put("autoValue", autoValue);
            }
            ServerUtils.setSetupValue((Connection)this.getConnection(), (String)name, (String)configArray.toString());
        }
    }
}

