/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.message4user.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.plugins.message4user.common.bean.Message;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;

public class MessageForUsersDao
extends AbstractDao<Message> {
    public MessageForUsersDao(Connection con) {
        super(con, 0, "message_for_users");
    }

    protected Message getFromRS(ResultSet rs) throws SQLException, BGException {
        Message message = new Message();
        message.setId(rs.getInt("id"));
        message.setDateFrom((Date)rs.getTimestamp("date_from"));
        message.setDateTo((Date)rs.getTimestamp("date_to"));
        message.setText(rs.getString("text"));
        message.setRolesIds(Utils.toIntegerSet((String)rs.getString("role_ids")));
        message.setUsers(Utils.toIntegerSet((String)rs.getString("users")));
        message.setMessageTitle(rs.getString("title"));
        message.setTitle(message.getId() + " [" + TimeUtils.format((Date)message.getDateFrom(), (String)"dd.MM.yyyy HH:mm") + " - " + TimeUtils.format((Date)message.getDateTo(), (String)"dd.MM.yyyy HH:mm") + " ] " + message.getMessageTitle());
        return message;
    }

    protected void updateImpl(Message b) throws BGException, SQLException {
        StringBuilder query = new StringBuilder();
        PreparedStatement ps = null;
        if (b.getId() > 0) {
            query.append("UPDATE ");
            query.append(this.tableName);
            query.append(" SET date_to=?, date_from=?, text=?, role_ids=?, title=?, users=? WHERE id=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(7, b.getId());
        } else {
            query.append("INSERT ");
            query.append(this.tableName);
            query.append("(date_to, date_from, text, role_ids, title, users) VALUES(?, ?, ?, ?, ?, ?)");
            ps = this.con.prepareStatement(query.toString());
        }
        ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)b.getDateTo()));
        ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)b.getDateFrom()));
        ps.setString(3, b.getText());
        ps.setString(4, Utils.toString((Iterable)b.getRolesIds(), (String)","));
        ps.setString(5, b.getMessageTitle());
        ps.setString(6, Utils.toString((Iterable)b.getUsers()));
        ps.executeUpdate();
        if (b.getId() < 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    public List<Message> getMessageList() throws BGException {
        List<Object> messageList = new ArrayList<Message>();
        try {
            String query = "SELECT * FROM message_for_users";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            messageList = this.getListFromRS(rs);
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public List<Message> getMessageList(int lastMessageId, int userId) throws BGException {
        List messageList;
        String query = "SELECT * FROM message_for_users WHERE id>? AND now() BETWEEN date_from AND date_to";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, lastMessageId);
            try (ResultSet rs = ps.executeQuery();){
                messageList = this.getListFromRS(rs);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        if (Utils.notEmptyCollection((Collection)messageList)) {
            messageList.removeIf(message -> Utils.notEmptyCollection((Collection)message.getUsers()) && !message.getUsers().contains(userId));
            Optional role = PermissionOfRoles.getRoleByUserId((int)userId);
            if (role.isPresent()) {
                int userRoleId = ((Role)role.get()).getId();
                messageList.removeIf(message -> Utils.notEmptyCollection((Collection)message.getRolesIds()) && !message.getRolesIds().contains(userRoleId));
            }
        }
        return messageList;
    }

    @Deprecated
    public List<Message> getMessageList(int lastMessagId, String userId) throws BGException {
        List<Object> messageList = new ArrayList<Message>();
        try {
            String query = "SELECT * FROM message_for_users WHERE id>? AND users LIKE '" + userId + "' AND now() BETWEEN date_from AND date_to";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, lastMessagId);
            ResultSet rs = ps.executeQuery();
            messageList = this.getListFromRS(rs);
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public void deleteMessage(int messageId) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, messageId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

