/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.message4user.server.bean;

import java.sql.Connection;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.plugins.message4user.common.bean.Message;
import ru.bitel.bgbilling.plugins.message4user.server.bean.MessageForUsersDao;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Preferences;

public class MessageForUsersManager {
    private Connection con = null;

    public MessageForUsersManager(Connection con) {
        this.con = con;
    }

    public List<Message> getMessageList() throws BGException {
        return new MessageForUsersDao(this.con).getMessageList();
    }

    public List<Message> getMessageList(int lastMessageId, int userId) throws BGException {
        return new MessageForUsersDao(this.con).getMessageList(lastMessageId, userId);
    }

    @Deprecated
    public List<Message> getMessageList(int lastMessageId, String userId) throws BGException {
        return new MessageForUsersDao(this.con).getMessageList(lastMessageId, userId);
    }

    public void updateMessage(Message message) throws BGException {
        new MessageForUsersDao(this.con).update(message);
    }

    public int getLastMessageId(int userId) throws BGException {
        User user = UserMap.getUser((Integer)userId);
        String user_config = user.getConfig();
        Preferences userConfig = new Preferences(user_config, "\r\n");
        int lastMessageId = userConfig.getInt("last_message_id", -1);
        if (lastMessageId == -1) {
            userConfig.set("last_message_id", "0");
            user_config = userConfig.toString();
            user.setConfig(user_config);
            UserManager um = new UserManager(this.con);
            um.update((Object)user);
            lastMessageId = 0;
            UserMap.initUserMap((Connection)this.con);
        }
        return lastMessageId;
    }

    public void deleteMessage(int messageId) {
        new MessageForUsersDao(this.con).deleteMessage(messageId);
    }

    public void updateUserConfig(int lastMessageId, int userId) throws BGException {
        User user = UserMap.getUser((Integer)userId);
        String user_config = user.getConfig();
        Preferences userConfig = new Preferences(user_config, "\r\n");
        userConfig.set("last_message_id", String.valueOf(lastMessageId));
        user_config = userConfig.toString();
        user.setConfig(user_config);
        UserManager um = new UserManager(this.con);
        um.update((Object)user);
        UserMap.initUserMap((Connection)this.con);
    }
}

