/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client;

import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class AdditionalUploadFiles
extends JPanel {
    private final JToggleButton showHideButton = new JToggleButton("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b");
    private final JPanel innerPanel = new JPanel(new GridBagLayout());
    private final BGTable table = new BGTable();

    public AdditionalUploadFiles() {
        super(new GridBagLayout());
        this.innerPanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.innerPanel.setVisible(false);
        this.table.setModel((TableModel)new AdditionalFilesTableModel());
        this.add((Component)this.showHideButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.innerPanel, new GridBagConstraints(0, 1, 0, 0, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.showHideButton.addActionListener(e -> this.innerPanel.setVisible(this.showHideButton.isSelected()));
    }

    protected void buildConfig(Preferences config) {
        JSONArray additionalFiles = new JSONArray();
        DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Object filepath = tableModel.getValueAt(i, 0);
            Object pathToFtp = tableModel.getValueAt(i, 1);
            if (filepath == null) continue;
            JSONObject file = new JSONObject();
            file.put("filepath", (Object)filepath.toString());
            file.put("pathToFtp", (Object)(pathToFtp != null ? pathToFtp.toString() : ""));
            additionalFiles.put((Object)file);
        }
        config.set("sorm.upload.additional.files", additionalFiles.toString());
    }

    protected void setData(Preferences config) {
        if (config == null) {
            this.table.setModel((TableModel)new AdditionalFilesTableModel());
            return;
        }
        String json = config.get("sorm.upload.additional.files", "");
        if (Utils.isBlankString((String)json)) {
            return;
        }
        AdditionalFilesTableModel tableModel = new AdditionalFilesTableModel();
        JSONArray data = new JSONArray(json);
        for (int i = 0; i < data.length(); ++i) {
            JSONObject additionalFile = data.getJSONObject(i);
            Object[] row = new String[]{additionalFile.optString("filepath"), additionalFile.optString("pathToFtp")};
            tableModel.insertRow(i, row);
        }
        this.table.setModel((TableModel)tableModel);
    }

    private static final class AdditionalFilesTableModel
    extends DefaultTableModel {
        AdditionalFilesTableModel() {
            this.addColumn("\u041f\u0443\u0442\u044c \u0434\u043e \u0444\u0430\u0439\u043b\u0430 \u0438\u043b\u0438 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438");
            this.addColumn("\u041f\u0443\u0442\u044c \u043d\u0430 FTP");
            for (int i = 0; i < 10; ++i) {
                this.addRow(new String[2]);
            }
        }
    }
}

