/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuListener;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.modules.sorm.client.SormSettingsPanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.InnersStaffPanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.SormBillConfigurePanel;
import ru.bitel.bgbilling.modules.sorm.common.ConnectionStandart;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGComboBoxPopupMenuListener;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public abstract class AbonentsConfigurePanel
extends BGUPanel {
    private JCheckBox active = new JCheckBox("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443");
    private JCheckBox disableAbonentsUpload = new JCheckBox("\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0434\u0430\u043d\u043d\u044b\u0445 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
    private JCheckBox disablePaymentsUpload = new JCheckBox("\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u0445");
    private JCheckBox disableDefaultImpl = new JCheckBox("\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0443\u044e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e");
    private OperatorAddressPanel operatorAddressPanel = new OperatorAddressPanel();
    private ClientContext clientContext;
    private SormProject sormProject;
    private SormSettingsPanel parent;
    private final BGComboBoxPopupMenuListener bgComboBoxPopupMenuListener = new BGComboBoxPopupMenuListener(true, false);
    private static final int TYPE_TEXT = 1;
    private static final int TYPE_INT = 2;
    private static final int TYPE_DATE = 5;
    private static final int TYPE_ADDRESS = 8;
    private static final int TYPE_EMAIL = 9;
    private static final int TYPE_PHONE = 10;
    private BGUComboBox<IdTitle> inetStandartConnection;
    private BGUComboBox<IdTitle> phoneStandartConnection;
    private BGUComboBox<IdTitle> firstNameBox;
    private BGUComboBox<IdTitle> lastNameBox;
    private BGUComboBox<IdTitle> middleNameBox;
    private BGUComboBox<IdTitle> fioBox;
    private BGUComboBox<IdTitle> birthdayBox;
    private BGUComboBox<IdTitle> documentSerial;
    private BGUComboBox<IdTitle> documentNumber;
    private BGUComboBox<IdTitle> whenGive;
    private BGUComboBox<IdTitle> whoGive;
    private BGUComboBox<IdTitle> whoWhenGive;
    private BGUComboBox<IdTitle> contactPhone;
    private BGUComboBox<IdTitle> emailBox;
    private BGUComboBox<IdTitle> address;
    private BGUComboBox<IdTitle> addressCommutators;
    private BGUComboBox<IdTitle> addressUnstruct;
    private BGUComboBox<IdTitle> addressCommutatorsUnstruct;
    private BGUComboBox<IdTitle> fullTitleOrganization;
    private BGUComboBox<IdTitle> innOrganization;
    private BGUComboBox<IdTitle> bankTitleOrganization;
    private BGUComboBox<IdTitle> accountOrganization;
    private BGUComboBox<IdTitle> BIKBankOrganization;
    private BGUComboBox<IdTitle> contactFaceOrganization;
    private BGUComboBox<IdTitle> phoneContactFaceOrganization;
    private BGUComboBox<IdTitle> organizationAddress;
    private BGUComboBox<IdTitle> organizationAddressUnstruct;
    private BGUComboBox<IdTitle> organizationCommutatorsAddress;
    private BGUComboBox<IdTitle> organizationCommutatorsAddressUnstruct;
    private BGUComboBox<IdTitle> organizationAddressBills;
    private BGUComboBox<IdTitle> organizationAddressBillsUnstruct;
    private BGUComboBox<IdTitle> organizationMailAddress;
    private BGUComboBox<IdTitle> organizationMailAddressUnstruct;
    private BGUComboBox<IdTitle> organizationEmail;
    private BGUComboBox<IdTitle> organizationContactPhone;
    private InnersStaffPanel innersStaffPanel;
    private JTextField regionKeyField = new JTextField();
    private JTextField zoneKeyField = new JTextField();
    private final GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(3, 3, 0, 0), 0, 0);
    private List<ContractParameterGroupAttr> parameters;
    private SormBillConfigurePanel sormBillConfigurePanel;
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "refresh"){

        public void actionPerformedImpl(ActionEvent e) {
            if (AbonentsConfigurePanel.this.sormProject == null || Utils.isBlankString((String)AbonentsConfigurePanel.this.sormProject.getConfig())) {
                return;
            }
            AbonentsConfigurePanel.this.active.setSelected(AbonentsConfigurePanel.this.sormProject.isEnable());
            Preferences config = AbonentsConfigurePanel.this.sormProject.getLoadedConfig();
            AbonentsConfigurePanel.this.disableAbonentsUpload.setSelected("1".equals(config.get("sorm.upload.abonents.disable", "0")));
            AbonentsConfigurePanel.this.disablePaymentsUpload.setSelected("1".equals(config.get("sorm.upload.payments.disable", "0")));
            AbonentsConfigurePanel.this.disableDefaultImpl.setSelected("1".equals(config.get("sorm.upload.disable.default", "0")));
            AbonentsConfigurePanel.this.operatorAddressPanel.refresh(config);
            AbonentsConfigurePanel.this.inetStandartConnection.setSelectedItem((Object)ConnectionStandart.getStandart((int)config.getInt("sorm.upload.standart.inetconnection", -1)));
            AbonentsConfigurePanel.this.phoneStandartConnection.setSelectedItem((Object)ConnectionStandart.getStandart((int)config.getInt("sorm.upload.standart.voiceconnection", -1)));
            if (AbonentsConfigurePanel.this.sormBillConfigurePanel != null) {
                AbonentsConfigurePanel.this.sormBillConfigurePanel.setSelected(config);
            }
            AbonentsConfigurePanel.this.regionKeyField.setText(config.get("sorm.upload.address.region.parameter.key"));
            AbonentsConfigurePanel.this.zoneKeyField.setText(config.get("sorm.upload.address.zone.parameter.key"));
            AbonentsConfigurePanel.this.fioBox.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.unstructfio")));
            AbonentsConfigurePanel.this.firstNameBox.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.firstname")));
            AbonentsConfigurePanel.this.lastNameBox.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.lastname")));
            AbonentsConfigurePanel.this.middleNameBox.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.middlename")));
            AbonentsConfigurePanel.this.documentSerial.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.documentserial")));
            AbonentsConfigurePanel.this.documentNumber.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.documentnumber")));
            AbonentsConfigurePanel.this.whoGive.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.documentwhogive")));
            AbonentsConfigurePanel.this.whenGive.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.documentwhengive")));
            AbonentsConfigurePanel.this.whoWhenGive.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.documentunstruct")));
            AbonentsConfigurePanel.this.birthdayBox.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.birthday")));
            AbonentsConfigurePanel.this.contactPhone.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.phone")));
            AbonentsConfigurePanel.this.emailBox.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.email")));
            AbonentsConfigurePanel.this.address.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.address")));
            AbonentsConfigurePanel.this.addressUnstruct.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.unstructaddress")));
            AbonentsConfigurePanel.this.addressCommutators.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.addressinstallcommutator")));
            AbonentsConfigurePanel.this.addressCommutatorsUnstruct.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.fiz.unstructaddressinstallcommutator")));
            AbonentsConfigurePanel.this.fullTitleOrganization.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.fulltitle")));
            AbonentsConfigurePanel.this.bankTitleOrganization.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.banktitle")));
            AbonentsConfigurePanel.this.innOrganization.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.inn")));
            AbonentsConfigurePanel.this.accountOrganization.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.account")));
            AbonentsConfigurePanel.this.BIKBankOrganization.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.bankbik")));
            AbonentsConfigurePanel.this.contactFaceOrganization.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.contactface")));
            AbonentsConfigurePanel.this.phoneContactFaceOrganization.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.contactfacenumber")));
            AbonentsConfigurePanel.this.organizationContactPhone.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.phone")));
            AbonentsConfigurePanel.this.organizationEmail.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.email")));
            AbonentsConfigurePanel.this.organizationAddress.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.address")));
            AbonentsConfigurePanel.this.organizationAddressUnstruct.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.unstructaddress")));
            AbonentsConfigurePanel.this.organizationCommutatorsAddress.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.addresscommutators")));
            AbonentsConfigurePanel.this.organizationCommutatorsAddressUnstruct.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.addresscommutatorsunstruct")));
            AbonentsConfigurePanel.this.organizationAddressBills.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.addressbills")));
            AbonentsConfigurePanel.this.organizationAddressBillsUnstruct.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.addressbillsunstruct")));
            AbonentsConfigurePanel.this.organizationMailAddress.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.addressmail")));
            AbonentsConfigurePanel.this.organizationMailAddressUnstruct.setSelectedItem((Object)AbonentsConfigurePanel.this.getContractParameterById(config.get("sorm.upload.org.unstructaddressmail")));
            try {
                AbonentsConfigurePanel.this.innersStaffPanel.refresh(config);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    };

    public AbonentsConfigurePanel(SormSettingsPanel parent, SormProject sormProject) {
        this.parent = parent;
        this.sormProject = sormProject;
    }

    protected void jbInit() throws BGException {
        this.setLayout(new GridBagLayout());
        this.inetStandartConnection = new BGUComboBox();
        this.inetStandartConnection.addPopupMenuListener((PopupMenuListener)this.bgComboBoxPopupMenuListener);
        Arrays.stream(ConnectionStandart.values()).forEach(i -> this.inetStandartConnection.addItem((Object)new IdTitle(i.ordinal(), i.getGuiTitle())));
        this.inetStandartConnection.setFont(this.parent.comboBoxFont);
        this.phoneStandartConnection = new BGUComboBox();
        this.phoneStandartConnection.addPopupMenuListener((PopupMenuListener)this.bgComboBoxPopupMenuListener);
        Arrays.stream(ConnectionStandart.values()).forEach(i -> this.phoneStandartConnection.addItem((Object)new IdTitle(i.ordinal(), i.getGuiTitle())));
        this.phoneStandartConnection.setFont(this.parent.comboBoxFont);
        this.parameters = ((ContractParameterService)this.getClientContext().getPort(ContractParameterService.class)).contractParameterGroupAttrList();
        this.initComboBoxes();
        this.innersStaffPanel = new InnersStaffPanel(this);
        JPanel fiz = new JPanel(new GridBagLayout());
        fiz.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 2, true), "\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043b\u0438\u0446\u0430"));
        this.constraints.weighty = 0.0;
        fiz.add((Component)this.getFioPanel(), this.constraints);
        fiz.add((Component)this.getDocumentPanel(), this.constraints);
        fiz.add((Component)this.getFizAddressPanel(), this.constraints);
        this.constraints.weighty = 1.0;
        int x = 0;
        int y = 0;
        JPanel organization = new JPanel(new GridBagLayout());
        organization.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 2, true), "\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043b\u0438\u0446\u0430"));
        organization.add((Component)this.getOrganizationMainInfo(), new GridBagConstraints(x, y++, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        organization.add((Component)this.getOrganizationAddressPanel(), new GridBagConstraints(x, y++, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        organization.add((Component)this.innersStaffPanel, new GridBagConstraints(x, y, 1, 1, 1.0, 1.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        x = 0;
        y = 0;
        this.add(this.getCommonSettingsPanel(), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        this.add(fiz, new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 18, 2, new Insets(3, 0, 0, 0), 0, 0));
        this.add(organization, new GridBagConstraints(x, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 3), 0, 0));
    }

    private void initComboBoxes() {
        this.lastNameBox = this.comboBoxWithParameters(this.parameters, 1);
        this.firstNameBox = this.comboBoxWithParameters(this.parameters, 1);
        this.middleNameBox = this.comboBoxWithParameters(this.parameters, 1);
        this.fioBox = this.comboBoxWithParameters(this.parameters, 1);
        this.birthdayBox = this.comboBoxWithParameters(this.parameters, 1, 5);
        this.documentSerial = this.comboBoxWithParameters(this.parameters, 1, 2);
        this.documentNumber = this.comboBoxWithParameters(this.parameters, 1, 2);
        this.whenGive = this.comboBoxWithParameters(this.parameters, 5);
        this.whoGive = this.comboBoxWithParameters(this.parameters, 1);
        this.whoWhenGive = this.comboBoxWithParameters(this.parameters, 1);
        this.contactPhone = this.comboBoxWithParameters(this.parameters, 10, 1);
        this.emailBox = this.comboBoxWithParameters(this.parameters, 9);
        this.address = this.comboBoxWithParameters(this.parameters, 8);
        this.addressCommutators = this.comboBoxWithParameters(this.parameters, 8);
        this.addressUnstruct = this.comboBoxWithParameters(this.parameters, 1);
        this.addressCommutatorsUnstruct = this.comboBoxWithParameters(this.parameters, 1);
        this.fullTitleOrganization = this.comboBoxWithParameters(this.parameters, 1);
        this.innOrganization = this.comboBoxWithParameters(this.parameters, 1);
        this.bankTitleOrganization = this.comboBoxWithParameters(this.parameters, 1);
        this.accountOrganization = this.comboBoxWithParameters(this.parameters, 1);
        this.BIKBankOrganization = this.comboBoxWithParameters(this.parameters, 1);
        this.contactFaceOrganization = this.comboBoxWithParameters(this.parameters, 1);
        this.phoneContactFaceOrganization = this.comboBoxWithParameters(this.parameters, 1, 10);
        this.organizationContactPhone = this.comboBoxWithParameters(this.parameters, 10, 1);
        this.organizationEmail = this.comboBoxWithParameters(this.parameters, 9, 1);
        this.organizationAddress = this.comboBoxWithParameters(this.parameters, 8);
        this.organizationAddressUnstruct = this.comboBoxWithParameters(this.parameters, 1);
        this.organizationCommutatorsAddress = this.comboBoxWithParameters(this.parameters, 8);
        this.organizationCommutatorsAddressUnstruct = this.comboBoxWithParameters(this.parameters, 1);
        this.organizationAddressBills = this.comboBoxWithParameters(this.parameters, 8);
        this.organizationAddressBillsUnstruct = this.comboBoxWithParameters(this.parameters, 1);
        this.organizationMailAddress = this.comboBoxWithParameters(this.parameters, 8);
        this.organizationMailAddressUnstruct = this.comboBoxWithParameters(this.parameters, 1);
    }

    private JPanel getCommonSettingsPanel() {
        JPanel commonSettings = new JPanel(new GridBagLayout());
        commonSettings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 2, true), "\u041e\u0431\u0449\u0435\u0435"));
        commonSettings.add((Component)this.active, this.constraints);
        commonSettings.add((Component)this.disableAbonentsUpload, this.constraints);
        commonSettings.add((Component)this.disablePaymentsUpload, this.constraints);
        commonSettings.add((Component)this.disableDefaultImpl, this.constraints);
        commonSettings.add((Component)((Object)this.operatorAddressPanel), this.constraints);
        commonSettings.add((Component)new JLabel("\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0441\u0432\u044f\u0437\u0438 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0430"), this.constraints);
        commonSettings.add((Component)this.inetStandartConnection, this.constraints);
        commonSettings.add((Component)new JLabel("\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0441\u0432\u044f\u0437\u0438 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438"), this.constraints);
        commonSettings.add((Component)this.phoneStandartConnection, this.constraints);
        SormService sormService = (SormService)this.getClientContext().getPort(SormService.class);
        List billModules = sormService.getInstanceModules("bill");
        if (Utils.notEmptyCollection((Collection)billModules)) {
            this.sormBillConfigurePanel = new SormBillConfigurePanel(this.getClientContext(), billModules);
            commonSettings.add((Component)((Object)this.sormBillConfigurePanel), this.constraints);
        }
        commonSettings.add((Component)this.addressAdditionalParametersPanel(), this.constraints);
        return commonSettings;
    }

    private JPanel addressAdditionalParametersPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel("<html>\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043a \u0432\u044b\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u044b\u043c \u0430\u0434\u0440\u0435\u0441\u0430\u043c<br>(\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e)</html>"), this.constraints);
        p.add((Component)BGSwingUtilites.createHelpLabel((String)"<html>\u0415\u0441\u043b\u0438 \u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c, \u0442\u043e \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0431\u0443\u0434\u0443\u0442 \u0431\u0440\u0430\u0442\u044c\u0441\u044f<br>\u043f\u0440\u0435\u0434\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0438 \u043e\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0435 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u0446\u0438\u0438</html>", (int)-1), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 3), 0, 0));
        p.add((Component)new JLabel("\u041a\u043b\u044e\u0447 \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0443\"\u0420\u0435\u0433\u0438\u043e\u043d\""), this.constraints);
        p.add((Component)this.regionKeyField, this.constraints);
        p.add((Component)new JLabel("\u041a\u043b\u044e\u0447 \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0443\"\u041e\u0431\u043b\u0430\u0441\u0442\u044c\""), this.constraints);
        p.add((Component)this.zoneKeyField, this.constraints);
        return p;
    }

    private JPanel getFioPanel() {
        JPanel fio = new JPanel(new GridBagLayout());
        fio.setBorder(BorderFactory.createTitledBorder("\u0424.\u0418.\u041e."));
        fio.add((Component)new JLabel("\u0424\u0430\u043c\u0438\u043b\u0438\u044f"), this.constraints);
        fio.add((Component)this.lastNameBox, this.constraints);
        fio.add((Component)new JLabel("\u0418\u043c\u044f"), this.constraints);
        fio.add((Component)this.firstNameBox, this.constraints);
        fio.add((Component)new JLabel("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e"), this.constraints);
        fio.add((Component)this.middleNameBox, this.constraints);
        fio.add((Component)new JLabel("\u0424\u0418\u041e \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430 \u043d\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e"), this.constraints);
        fio.add((Component)this.fioBox, this.constraints);
        return fio;
    }

    private JPanel getFizAddressPanel() {
        JPanel addressPanel = new JPanel(new GridBagLayout());
        addressPanel.setBorder(BorderFactory.createTitledBorder("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435"));
        addressPanel.add((Component)new JLabel("\u0422\u0435\u043b\u0435\u0444\u043e\u043d"), this.constraints);
        addressPanel.add((Component)this.contactPhone, this.constraints);
        addressPanel.add((Component)new JLabel("Email"), this.constraints);
        addressPanel.add((Component)this.emailBox, this.constraints);
        addressPanel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438"), this.constraints);
        addressPanel.add((Component)this.address, this.constraints);
        addressPanel.add((Component)new JLabel("\u041d\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439"), this.constraints);
        addressPanel.add((Component)this.addressUnstruct, this.constraints);
        addressPanel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u044f"), this.constraints);
        addressPanel.add((Component)this.addressCommutators, this.constraints);
        addressPanel.add((Component)new JLabel("\u041d\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439"), this.constraints);
        addressPanel.add((Component)this.addressCommutatorsUnstruct, this.constraints);
        return addressPanel;
    }

    private JPanel getDocumentPanel() {
        JPanel document = new JPanel(new GridBagLayout());
        document.setBorder(BorderFactory.createTitledBorder("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442"));
        document.add((Component)new JLabel("\u0421\u0435\u0440\u0438\u044f"), this.constraints);
        document.add((Component)this.documentSerial, this.constraints);
        document.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440"), this.constraints);
        document.add((Component)this.documentNumber, this.constraints);
        document.add((Component)new JLabel("\u041a\u0435\u043c \u0432\u044b\u0434\u0430\u043d"), this.constraints);
        document.add((Component)this.whoGive, this.constraints);
        document.add((Component)new JLabel("\u041a\u043e\u0433\u0434\u0430 \u0432\u044b\u0434\u0430\u043d"), this.constraints);
        document.add((Component)this.whenGive, this.constraints);
        document.add((Component)new JLabel("\u041d\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439"), this.constraints);
        document.add((Component)this.whoWhenGive, this.constraints);
        document.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f"), this.constraints);
        document.add((Component)this.birthdayBox, this.constraints);
        return document;
    }

    private JPanel getOrganizationMainInfo() {
        this.constraints.gridx = 1;
        JPanel organizationMainInfo = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)organizationMainInfo, (String)"\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
        organizationMainInfo.add((Component)new JLabel("\u041f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"), this.constraints);
        organizationMainInfo.add((Component)this.fullTitleOrganization, this.constraints);
        organizationMainInfo.add((Component)new JLabel("\u0418\u041d\u041d \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438"), this.constraints);
        organizationMainInfo.add((Component)this.innOrganization, this.constraints);
        organizationMainInfo.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u0430"), this.constraints);
        organizationMainInfo.add((Component)this.bankTitleOrganization, this.constraints);
        organizationMainInfo.add((Component)new JLabel("\u0420\u0430\u0441\u0447\u0451\u0442\u043d\u044b\u0439 \u0441\u0447\u0451\u0442"), this.constraints);
        organizationMainInfo.add((Component)this.accountOrganization, this.constraints);
        organizationMainInfo.add((Component)new JLabel("\u0411\u0418\u041a \u0431\u0430\u043d\u043a\u0430"), this.constraints);
        organizationMainInfo.add((Component)this.BIKBankOrganization, this.constraints);
        organizationMainInfo.add((Component)new JLabel("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0435 \u043b\u0438\u0446\u043e"), this.constraints);
        organizationMainInfo.add((Component)this.contactFaceOrganization, this.constraints);
        organizationMainInfo.add((Component)new JLabel("\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430"), this.constraints);
        organizationMainInfo.add((Component)this.phoneContactFaceOrganization, this.constraints);
        return organizationMainInfo;
    }

    private JPanel getOrganizationAddressPanel() {
        this.constraints.gridx = 0;
        JPanel organizationAddressPanel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)organizationAddressPanel, (String)"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
        organizationAddressPanel.add((Component)new JLabel("\u0422\u0435\u043b\u0435\u0444\u043e\u043d"), this.constraints);
        organizationAddressPanel.add((Component)this.organizationContactPhone, this.constraints);
        organizationAddressPanel.add((Component)new JLabel("Email"), this.constraints);
        organizationAddressPanel.add((Component)this.organizationEmail, this.constraints);
        organizationAddressPanel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438"), this.constraints);
        organizationAddressPanel.add((Component)this.organizationAddress, this.constraints);
        organizationAddressPanel.add((Component)new JLabel("\u041d\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439"), this.constraints);
        organizationAddressPanel.add((Component)this.organizationAddressUnstruct, this.constraints);
        organizationAddressPanel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u044f"), this.constraints);
        organizationAddressPanel.add((Component)this.organizationCommutatorsAddress, this.constraints);
        organizationAddressPanel.add((Component)new JLabel("\u041d\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439"), this.constraints);
        organizationAddressPanel.add((Component)this.organizationCommutatorsAddressUnstruct, this.constraints);
        organizationAddressPanel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438 \u0441\u0447\u0435\u0442\u043e\u0432"), this.constraints);
        organizationAddressPanel.add((Component)this.organizationAddressBills, this.constraints);
        organizationAddressPanel.add((Component)new JLabel("\u041d\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439"), this.constraints);
        organizationAddressPanel.add((Component)this.organizationAddressBillsUnstruct, this.constraints);
        organizationAddressPanel.add((Component)new JLabel("\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u0430\u0434\u0440\u0435\u0441"), this.constraints);
        organizationAddressPanel.add((Component)this.organizationMailAddress, this.constraints);
        organizationAddressPanel.add((Component)new JLabel("\u041d\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439"), this.constraints);
        organizationAddressPanel.add((Component)this.organizationMailAddressUnstruct, this.constraints);
        return organizationAddressPanel;
    }

    private BGUComboBox<IdTitle> comboBoxWithParameters(List<ContractParameterGroupAttr> parameters, int ... prefTypes) {
        BGUComboBox comboBox = new BGUComboBox();
        comboBox.setFont(this.parent.comboBoxFont);
        ArrayList<IdTitle> idTitleList = new ArrayList<IdTitle>();
        idTitleList.add(new IdTitle(-1, "---------------"));
        for (int prefType : prefTypes) {
            idTitleList.addAll(parameters.stream().filter(i -> i.getType() == prefType).collect(Collectors.toList()));
        }
        comboBox.setData(idTitleList);
        comboBox.addPopupMenuListener((PopupMenuListener)this.bgComboBoxPopupMenuListener);
        return comboBox;
    }

    private IdTitle getContractParameterById(String idFromConfig) {
        ContractParameterGroupAttr contractParameterGroupAttr = new ContractParameterGroupAttr();
        if (Utils.isBlankString((String)idFromConfig)) {
            contractParameterGroupAttr.setId(-1);
            return contractParameterGroupAttr;
        }
        int id = Utils.parseInt((String)idFromConfig, (int)-1);
        Optional<ContractParameterGroupAttr> optional = this.parameters.stream().filter(i -> i.getId() == id).findFirst();
        if (optional.isPresent()) {
            contractParameterGroupAttr = optional.get();
        }
        return contractParameterGroupAttr;
    }

    public void buildConfig(Preferences config) {
        String zoneKey;
        String regionKey;
        this.sormProject.setEnable(this.active.isSelected());
        config.set("sorm.upload.enable", this.active.isSelected() ? "1" : "0");
        config.set("sorm.upload.abonents.disable", this.disableAbonentsUpload.isSelected() ? "1" : "0");
        config.set("sorm.upload.payments.disable", this.disablePaymentsUpload.isSelected() ? "1" : "0");
        config.set("sorm.upload.disable.default", this.disableDefaultImpl.isSelected() ? "1" : "0");
        this.operatorAddressPanel.buildConfig(config);
        config.set("sorm.upload.standart.inetconnection", String.valueOf(this.inetStandartConnection.getSelectedItem() != null ? ((IdTitle)this.inetStandartConnection.getSelectedItem()).getId() : 0));
        config.set("sorm.upload.standart.voiceconnection", String.valueOf(this.phoneStandartConnection.getSelectedItem() != null ? ((IdTitle)this.phoneStandartConnection.getSelectedItem()).getId() : 0));
        if (this.sormBillConfigurePanel != null) {
            this.sormBillConfigurePanel.buildConfig(config);
        }
        if (Utils.notBlankString((String)(regionKey = this.regionKeyField.getText()))) {
            config.set("sorm.upload.address.region.parameter.key", regionKey);
        }
        if (Utils.notBlankString((String)(zoneKey = this.zoneKeyField.getText()))) {
            config.set("sorm.upload.address.zone.parameter.key", zoneKey);
        }
        config.set("sorm.upload.fiz.firstname", String.valueOf(((IdTitle)this.firstNameBox.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.lastname", String.valueOf(((IdTitle)this.lastNameBox.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.middlename", String.valueOf(((IdTitle)this.middleNameBox.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.unstructfio", String.valueOf(((IdTitle)this.fioBox.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.documentserial", String.valueOf(((IdTitle)this.documentSerial.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.documentnumber", String.valueOf(((IdTitle)this.documentNumber.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.documentwhogive", String.valueOf(((IdTitle)this.whoGive.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.documentwhengive", String.valueOf(((IdTitle)this.whenGive.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.documentunstruct", String.valueOf(((IdTitle)this.whoWhenGive.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.birthday", String.valueOf(((IdTitle)this.birthdayBox.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.phone", String.valueOf(((IdTitle)this.contactPhone.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.email", String.valueOf(((IdTitle)this.emailBox.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.address", String.valueOf(((IdTitle)this.address.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.unstructaddress", String.valueOf(((IdTitle)this.addressUnstruct.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.addressinstallcommutator", String.valueOf(((IdTitle)this.addressCommutators.getSelectedItem()).getId()));
        config.set("sorm.upload.fiz.unstructaddressinstallcommutator", String.valueOf(((IdTitle)this.addressCommutatorsUnstruct.getSelectedItem()).getId()));
        config.set("sorm.upload.org.fulltitle", String.valueOf(((IdTitle)this.fullTitleOrganization.getSelectedItem()).getId()));
        config.set("sorm.upload.org.banktitle", String.valueOf(((IdTitle)this.bankTitleOrganization.getSelectedItem()).getId()));
        config.set("sorm.upload.org.inn", String.valueOf(((IdTitle)this.innOrganization.getSelectedItem()).getId()));
        config.set("sorm.upload.org.account", String.valueOf(((IdTitle)this.accountOrganization.getSelectedItem()).getId()));
        config.set("sorm.upload.org.bankbik", String.valueOf(((IdTitle)this.BIKBankOrganization.getSelectedItem()).getId()));
        config.set("sorm.upload.org.contactface", String.valueOf(((IdTitle)this.contactFaceOrganization.getSelectedItem()).getId()));
        config.set("sorm.upload.org.contactfacenumber", String.valueOf(((IdTitle)this.phoneContactFaceOrganization.getSelectedItem()).getId()));
        config.set("sorm.upload.org.phone", String.valueOf(((IdTitle)this.organizationContactPhone.getSelectedItem()).getId()));
        config.set("sorm.upload.org.email", String.valueOf(((IdTitle)this.organizationEmail.getSelectedItem()).getId()));
        config.set("sorm.upload.org.address", String.valueOf(((IdTitle)this.organizationAddress.getSelectedItem()).getId()));
        config.set("sorm.upload.org.unstructaddress", String.valueOf(((IdTitle)this.organizationAddressUnstruct.getSelectedItem()).getId()));
        config.set("sorm.upload.org.addresscommutators", String.valueOf(((IdTitle)this.organizationCommutatorsAddress.getSelectedItem()).getId()));
        config.set("sorm.upload.org.addresscommutatorsunstruct", String.valueOf(((IdTitle)this.organizationCommutatorsAddressUnstruct.getSelectedItem()).getId()));
        config.set("sorm.upload.org.addressbills", String.valueOf(((IdTitle)this.organizationAddressBills.getSelectedItem()).getId()));
        config.set("sorm.upload.org.addressbillsunstruct", String.valueOf(((IdTitle)this.organizationAddressBillsUnstruct.getSelectedItem()).getId()));
        config.set("sorm.upload.org.addressmail", String.valueOf(((IdTitle)this.organizationMailAddress.getSelectedItem()).getId()));
        config.set("sorm.upload.org.unstructaddressmail", String.valueOf(((IdTitle)this.organizationMailAddressUnstruct.getSelectedItem()).getId()));
        this.innersStaffPanel.buildConfig(config);
    }

    protected ClientContext getClientContext() {
        if (this.clientContext == null) {
            this.clientContext = new ClientContext("kernel", 0, ((ClientContext)this.parent.getContext()).getContractId(), null);
        }
        return this.clientContext;
    }

    public SormProject getSormProject() {
        return this.sormProject;
    }

    public void setSormProject(SormProject sormProject) {
        this.sormProject = sormProject;
    }

    class OperatorAddressPanel
    extends BGUPanel {
        JTextField operatorTitle = new JTextField();
        JTextField operatorLocation = new JTextField();
        JTextField index = new JTextField();
        JTextField city = new JTextField();
        JTextField street = new JTextField();
        JTextField house = new JTextField();
        BGCalendarButton startDate = new BGCalendarButton();

        OperatorAddressPanel() {
        }

        protected void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u0414\u0430\u043d\u043d\u044b\u0435 \u043e\u0431 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0435 \u0441\u0432\u044f\u0437\u0438");
            this.add(new JLabel("\u041f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430"), AbonentsConfigurePanel.this.constraints);
            this.add(this.operatorTitle, AbonentsConfigurePanel.this.constraints);
            this.add(new JLabel("<html>\u041c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0441\u0432\u044f\u0437\u0438<br>(\u041f\u0440\u0438\u043c\u0435\u0440: \u0433.\u0423\u0444\u0430, \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0411\u0430\u0448\u043a\u043e\u0440\u0442\u043e\u0441\u0442\u0430\u043d)</html>"), AbonentsConfigurePanel.this.constraints);
            this.add(this.operatorLocation, AbonentsConfigurePanel.this.constraints);
            this.add(this.getAddressPanel(), AbonentsConfigurePanel.this.constraints);
            this.add(new JLabel("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430"), AbonentsConfigurePanel.this.constraints);
            this.add((Component)this.startDate, AbonentsConfigurePanel.this.constraints);
        }

        private JPanel getAddressPanel() {
            JPanel addressPanel = new JPanel(new GridBagLayout());
            BGSwingUtilites.wrapBorder((JPanel)addressPanel, (String)"\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
            addressPanel.add((Component)new JLabel("\u0418\u043d\u0434\u0435\u043a\u0441"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            addressPanel.add((Component)this.index, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            addressPanel.add((Component)new JLabel("\u0413\u043e\u0440\u043e\u0434"), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            addressPanel.add((Component)this.city, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            addressPanel.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u0430"), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            addressPanel.add((Component)this.street, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            addressPanel.add((Component)new JLabel("\u0414\u043e\u043c"), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            addressPanel.add((Component)this.house, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            return addressPanel;
        }

        private void buildConfig(Preferences config) {
            config.set("sorm.upload.operator.title", this.operatorTitle.getText());
            config.set("sorm.upload.operator.location", this.operatorLocation.getText());
            config.set("sorm.upload.operator.address.index", this.index.getText());
            config.set("sorm.upload.operator.address.city", this.city.getText());
            config.set("sorm.upload.operator.address.street", this.street.getText());
            config.set("sorm.upload.operator.address.house", this.house.getText());
            LocalDate date = this.startDate.getLocalDate();
            if (date != null) {
                config.set("sorm.upload.operator.startdate", TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy"));
            }
        }

        private void refresh(Preferences config) {
            this.operatorTitle.setText(config.get("sorm.upload.operator.title"));
            this.operatorLocation.setText(config.get("sorm.upload.operator.location"));
            this.index.setText(config.get("sorm.upload.operator.address.index"));
            this.city.setText(config.get("sorm.upload.operator.address.city"));
            this.street.setText(config.get("sorm.upload.operator.address.street"));
            this.house.setText(config.get("sorm.upload.operator.address.house"));
            LocalDate date = config.getLocalDate("sorm.upload.operator.startdate", null);
            if (date != null) {
                this.startDate.setLocalDate(date);
            }
        }
    }
}

