/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.IdTitle;

public class SormBillConfigurePanel
extends BGUPanel {
    private final GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0);
    private final JPanel mainPanel = new JPanel(new CardLayout());
    private final BGControlPanelListSelect selectModule = new BGControlPanelListSelect(true);
    private JToggleButton configureButton;
    private static final String CONFIGURE = "configure";
    private static final String SELECTED = "selected";
    public final Font comboBoxFont = new Font("Arial", 0, 11);
    private BGUComboBox fullTitle = new BGUComboBox();
    private BGUComboBox address = new BGUComboBox();
    private BGUComboBox inn = new BGUComboBox();
    private BGUComboBox bik = new BGUComboBox();
    private BGUComboBox bankTitle = new BGUComboBox();
    private BGUComboBox account = new BGUComboBox();
    private BGUComboBox[] comboBoxes = new BGUComboBox[]{this.fullTitle, this.address, this.inn, this.bik, this.bankTitle, this.account};
    private final ClientContext clientContext;
    private List<Object> billAttributes;
    private final List<InstalledInstanceModule> installedBillModules;

    SormBillConfigurePanel(ClientContext clientContext, List<InstalledInstanceModule> billModules) {
        this.clientContext = clientContext;
        this.installedBillModules = billModules;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.mainPanel.setVisible(false);
        Arrays.asList(this.comboBoxes).forEach(comboBox -> comboBox.setFont(this.comboBoxFont));
        JPanel configurePanel = new JPanel(new GridBagLayout());
        configurePanel.add((Component)new JLabel("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0441 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430\u043c\u0438 \u043c\u043e\u0434\u0443\u043b\u044f"), this.constraints);
        configurePanel.add((Component)new JLabel("\u041f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438"), this.constraints);
        configurePanel.add((Component)this.fullTitle, this.constraints);
        configurePanel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441"), this.constraints);
        configurePanel.add((Component)this.address, this.constraints);
        configurePanel.add((Component)new JLabel("\u0418\u041d\u041d"), this.constraints);
        configurePanel.add((Component)this.inn, this.constraints);
        configurePanel.add((Component)new JLabel("\u0411\u0418\u041a"), this.constraints);
        configurePanel.add((Component)this.bik, this.constraints);
        configurePanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u0430"), this.constraints);
        configurePanel.add((Component)this.bankTitle, this.constraints);
        configurePanel.add((Component)new JLabel("\u0420\u0430\u0441\u0447\u0451\u0442\u043d\u044b\u0439 \u0441\u0447\u0451\u0442"), this.constraints);
        configurePanel.add((Component)this.account, this.constraints);
        JButton cancel = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        cancel.addActionListener(e -> this.hideShowSelectedModulePanel(false));
        configurePanel.add((Component)cancel, this.constraints);
        JPanel selectedModulePanel = this.getSelectedModulePanel();
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> {
            if (this.getIdSelectedBillModule() < 0) {
                BGToolTip.showErrorMessage((JComponent)this.selectModule, (String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043c\u043e\u0434\u0443\u043b\u044c");
                return;
            }
            this.initComboBoxes();
            this.hideShowSelectedModulePanel(true);
        });
        selectedModulePanel.add((Component)okButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.mainPanel.add((Component)selectedModulePanel, SELECTED);
        this.mainPanel.add((Component)configurePanel, CONFIGURE);
        this.configureButton = new JToggleButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0438\u0437 \u043c\u043e\u0434\u0443\u043b\u044f \u0411\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u044f");
        this.configureButton.addActionListener(e -> {
            if (this.configureButton.isSelected()) {
                this.mainPanel.setVisible(true);
            } else {
                this.mainPanel.setVisible(false);
            }
        });
        this.add(this.configureButton, this.constraints);
        this.add(this.mainPanel, this.constraints);
    }

    private void hideShowSelectedModulePanel(boolean showConfigurePanel) {
        CardLayout cardLayout = (CardLayout)this.mainPanel.getLayout();
        if (showConfigurePanel) {
            cardLayout.show(this.mainPanel, CONFIGURE);
        } else {
            cardLayout.show(this.mainPanel, SELECTED);
        }
    }

    private JPanel getSelectedModulePanel() {
        ClientUtils.buildList((JList)this.selectModule.getList(), this.installedBillModules);
        return this.selectModule;
    }

    private void initComboBoxes() {
        this.billAttributes = new ArrayList<Object>();
        this.billAttributes.add(new IdTitle(-1, "-------------"));
        this.billAttributes.addAll(this.getBillAttributes(this.getIdSelectedBillModule()));
        Arrays.stream(this.comboBoxes).forEach(comboBox -> comboBox.setData(this.billAttributes));
    }

    private List<IdTitle> getBillAttributes(int mid) {
        if (mid > 0) {
            try {
                return ((SormService)this.clientContext.getPort(SormService.class)).getBillAttributeTypeList(mid);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    void buildConfig(Preferences config) {
        boolean isSelected = this.getIdSelectedBillModule() > 0;
        try {
            config.set("sorm.bill.mid", String.valueOf(this.getIdSelectedBillModule()));
            config.set("sorm.bill.attr.fulltitle", isSelected ? this.getSelectedValue(this.fullTitle) : "");
            config.set("sorm.bill.attr.address", isSelected ? this.getSelectedValue(this.address) : "");
            config.set("sorm.bill.attr.inn", isSelected ? this.getSelectedValue(this.inn) : "");
            config.set("sorm.bill.attr.bik", isSelected ? this.getSelectedValue(this.bik) : "");
            config.set("sorm.bill.attr.banktitle", isSelected ? this.getSelectedValue(this.bankTitle) : "");
            config.set("sorm.bill.attr.account", isSelected ? this.getSelectedValue(this.account) : "");
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private String getSelectedValue(BGUComboBox box) throws BGException {
        GuiTitlable selectedType = box.getSelectedItem();
        if (box.getSelectedIndex() > 0 && selectedType != null) {
            try {
                Field nameField = selectedType.getClass().getDeclaredField("title");
                nameField.setAccessible(true);
                String name = (String)nameField.get(selectedType);
                Class<?> idClazz = selectedType.getClass().getSuperclass();
                Field idField = idClazz.getDeclaredField("id");
                idField.setAccessible(true);
                int id = (Integer)idField.get(selectedType);
                if (id > 0) {
                    return name;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new BGException((Throwable)e);
            }
        }
        return "";
    }

    private int getIdSelectedBillModule() {
        int[] selectedIds = this.selectModule.getSelectedIds();
        if (selectedIds != null && selectedIds.length > 0) {
            return selectedIds[0];
        }
        return -1;
    }

    void setSelected(Preferences config) {
        int selectedMid = config.getInt("sorm.bill.mid", -1);
        if (selectedMid > 0) {
            this.selectModule.setListValues(String.valueOf(selectedMid));
            this.configureButton.doClick();
            this.initComboBoxes();
            this.setBillAttrById(this.fullTitle, config.get("sorm.bill.attr.fulltitle"));
            this.setBillAttrById(this.address, config.get("sorm.bill.attr.address"));
            this.setBillAttrById(this.inn, config.get("sorm.bill.attr.inn"));
            this.setBillAttrById(this.bik, config.get("sorm.bill.attr.bik"));
            this.setBillAttrById(this.bankTitle, config.get("sorm.bill.attr.banktitle"));
            this.setBillAttrById(this.account, config.get("sorm.bill.attr.account"));
            this.hideShowSelectedModulePanel(true);
        }
    }

    private void setBillAttrById(BGUComboBox comboBox, String attrName) {
        if (Utils.isBlankString((String)attrName)) {
            comboBox.setSelectedIndex(0);
            return;
        }
        if (Utils.notEmptyCollection(this.billAttributes)) {
            this.billAttributes.forEach(attr -> {
                try {
                    Field field = attr.getClass().getDeclaredField("title");
                    field.setAccessible(true);
                    String name = (String)field.get(attr);
                    if (name.equals(attrName)) {
                        comboBox.setSelectedItem(attr);
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

