/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server;

import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedModuleEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractParamChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractUpdateObjectEvent;
import ru.bitel.bgbilling.kernel.event.events.OnContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.ServiceUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.sorm.server.event.AddContractToUploadEvemt;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadLogsTable;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class Module
extends ModuleBase
implements EventListener<Event> {
    private Logger logger = LogManager.getLogger((String)"ModuleSorm");
    private int moduleId = -1;

    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.sorm.server"};
    }

    public void start(Connection con, BGModule module) throws BGException {
        super.start(con, module);
        this.moduleId = module.getId();
        EventProcessor eventProcessor = EventProcessor.getInstance();
        eventProcessor.addListener((EventListener)this, ContractParamChangedEvent.class);
        eventProcessor.addListener((EventListener)this, ContractStatusChangedEvent.class);
        eventProcessor.addListener((EventListener)this, ServiceUpdateEvent.class);
        eventProcessor.addListener((EventListener)this, OnContractWrapEvent.class);
        eventProcessor.addListener((EventListener)this, ContractModifiedModuleEvent.class);
        eventProcessor.addListener((EventListener)this, ContractCloseEvent.class);
        eventProcessor.addListener((EventListener)this, AddContractToUploadEvemt.class);
        eventProcessor.addListener((EventListener)this, ContractUpdateObjectEvent.class);
        try {
            eventProcessor.addListener((EventListener)this, Class.forName("ru.bitel.bgbilling.modules.inet.server.event.InetServModifiedEvent"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            eventProcessor.addListener((EventListener)this, Class.forName("ru.bitel.bgbilling.modules.voice.common.event.VoiceAccountModifiedEvent"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            eventProcessor.addListener((EventListener)this, Class.forName("ru.bitel.bgbilling.modules.phone.server.event.ClientItemChangedEvent"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            eventProcessor.addListener((EventListener)this, Class.forName("ru.bitel.bgbilling.modules.npay.server.event.ContractNpayChangedEvent"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void notify(Event event, EventListenerContext ctx) throws BGException {
        if (event instanceof ContractModifiedModuleEvent) {
            ContractModifiedModuleEvent modifiedModuleEvent = (ContractModifiedModuleEvent)event;
            if (modifiedModuleEvent.getModifiedModuleType().equals((Object)ContractModifiedModuleEvent.ModifiedModuleType.ADDED) && modifiedModuleEvent.getModuleId() == this.moduleId) {
                this.putChangedContractOnSormTaskTable(event, this.moduleId);
            }
        } else {
            this.putChangedContractOnSormTaskTable(event, this.moduleId);
        }
    }

    private void putChangedContractOnSormTaskTable(Event event, int moduleId) throws BGException {
        int contractId = event.getContractId();
        Calendar time = event.getTime();
        String eventClassName = event.getClass().getName();
        ServerContext serverContext = (ServerContext)ServerContext.get();
        Connection con = serverContext.getConnection();
        if (!this.checkValidContractDate(contractId, con)) {
            return;
        }
        if (contractId > 0 && (event instanceof ContractModifiedModuleEvent || SormUtils.contractHasModule(con, moduleId, contractId))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + " \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0437\u0430\u0434\u0430\u0447 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043d\u0430 \u0421\u041e\u0420\u041c. \u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + eventClassName);
            }
            String tableName = SormUploadLogsTable.getSormChangedContractTable(moduleId);
            try {
                ServerUtils.checkTable((Connection)con, (String)tableName, (String)SormUploadLogsTable.getSormChangedContractTableCreateQuery(moduleId));
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            String query = "INSERT IGNORE INTO " + tableName + " (date, eventClass, contractId) VALUES(?,?,?)";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setTimestamp(1, TimeUtils.convertCalendarToTimestamp((Calendar)time));
                ps.setString(2, eventClassName);
                ps.setInt(3, contractId);
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                this.logger.error((Object)ex);
            }
        }
    }

    private boolean checkValidContractDate(int contractId, Connection connection) throws BGException {
        boolean result = true;
        String query = "select date2 from contract where id=" + contractId;
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                java.util.Date date = TimeUtils.convertSqlDateToDate((Date)rs.getDate(1));
                result = SormUtils.checkThreeYearsAgo(date);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

