/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.server.upload.FtpServerPath;
import ru.bitel.bgbilling.modules.sorm.server.upload.SormProjectUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadFiles;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadVersion;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class PrepareUploadFilesByProject {
    private static final Logger logger = LogManager.getLogger((String)PrepareUploadFilesByProject.class.getSimpleName());
    private final UploadVersion customUploadVersion;
    private final UploadVersion defaultUploadVersion;
    private final SormManufacturer manufacturer;
    private final boolean uploadOnlyPayments;
    private final boolean uploadWithPayments;
    private final Preferences sormProjectConfig;
    private final SormProjectUpload sormProjectUpload;
    private final boolean disableDefaultImpl;

    protected PrepareUploadFilesByProject(SormProjectUpload sormProjectUpload) {
        logger.debug("PrepareUploadFilesByProject init");
        this.sormProjectUpload = sormProjectUpload;
        this.customUploadVersion = sormProjectUpload.customUploadVersion;
        this.defaultUploadVersion = sormProjectUpload.defaultUploadVersion;
        this.manufacturer = sormProjectUpload.manufacturer;
        this.uploadOnlyPayments = sormProjectUpload.uploadOnlyPayments;
        this.uploadWithPayments = sormProjectUpload.enablePaymentsUpload;
        this.sormProjectConfig = sormProjectUpload.config;
        this.disableDefaultImpl = "1".equals(this.sormProjectConfig.get("sorm.upload.disable.default", "0"));
    }

    protected UploadFiles getUploadFiles() throws BGException {
        logger.debug("getUploadFiles");
        boolean disableAbonentsUpload = "1".equals(this.sormProjectConfig.get("sorm.upload.abonents.disable", "0"));
        boolean disablePaymentsUpload = "1".equals(this.sormProjectConfig.get("sorm.upload.payments.disable", "0"));
        if (this.uploadOnlyPayments) {
            UploadFiles uploadFiles = new UploadFiles(this.sormProjectUpload.isFullUpload);
            uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.ABONENT_PAYMENTS)));
            return uploadFiles;
        }
        UploadFiles uploadFiles = new UploadFiles(this.sormProjectUpload.isFullUpload);
        if (!disableAbonentsUpload) {
            uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.ABONENTS)));
        }
        if (!this.manufacturer.equals((Object)SormManufacturer.ELKOM) && !this.manufacturer.equals((Object)SormManufacturer.BASTION)) {
            if (!disableAbonentsUpload) {
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.ABONENTS_ADDRESSES)));
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.ABONENTS_LOGINS)));
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.ABONENTS_IP_NUMBERING)));
            }
            if (this.sormProjectConfig.get("sorm.upload.services.enable", "").equals("1")) {
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.SERVICES)));
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.ABONENT_SERVICES)));
            }
            if (this.sormProjectConfig.get("sorm.upload.ipnumbering.enable", "").equals("1")) {
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.IP_NUMBERING)));
            }
            if (this.sormProjectConfig.get("sorm.upload.switches.enable", "").equals("1") || this.sormProjectConfig.get("sorm.upload.commutators.enable").equals("1")) {
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.SWITCHES)));
            }
            if (this.sormProjectConfig.get("sorm.upload.gateways.enable", "").equals("1")) {
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.GATEWAYS)));
            }
            if (this.sormProjectConfig.get("sorm.upload.bunches.enable", "").equals("1")) {
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.BUNCHES)));
            }
            if (this.sormProjectConfig.get("sorm.upload.phonenumbering.enable", "").equals("1")) {
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.PHONE_NUMBERING)));
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.ABONENTS_PHONE_NUMBERING)));
            } else if (this.manufacturer.equals((Object)SormManufacturer.VASEXPERTS)) {
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.ABONENTS_PHONE_NUMBERING)));
            }
            if (this.sormProjectConfig.get("sorm.upload.documenttype.enable", "").equals("1")) {
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.DOCUMENT_TYPES)));
            }
            if (this.sormProjectConfig.get("sorm.upload.paytype.enable", "").equals("1")) {
                uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.PAYMENT_TYPES)));
            }
            uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.OPERATOR_INFO)));
        }
        if (this.uploadWithPayments && !disablePaymentsUpload) {
            uploadFiles.addFileWithPath(this.invokeAngGetFileWithPath(this.extractMethodFromUploadVersion(UploadVersion.Method.ABONENT_PAYMENTS)));
        }
        List<Pair<String, Path>> otherFiles = this.getOtherFiles();
        otherFiles.addAll(this.getAdditionalFiles());
        for (Pair<String, Path> otherFile : otherFiles) {
            uploadFiles.addFileWithPath((Pair<Path, String>)new Pair((Object)((Path)otherFile.getSecond()), (Object)((String)otherFile.getFirst())));
        }
        try {
            this.removeEmptyFiles(uploadFiles.getFiles());
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
        return uploadFiles;
    }

    private Pair<Path, String> invokeAngGetFileWithPath(Pair<UploadVersion, Method> implementation) throws BGException {
        if (implementation == null) {
            return null;
        }
        Pair result = new Pair();
        try {
            Method implMethod = (Method)implementation.getSecond();
            implMethod.setAccessible(true);
            FtpServerPath serverPath = implMethod.getAnnotation(FtpServerPath.class);
            Path file = (Path)implMethod.invoke(implementation.getFirst(), new Object[0]);
            if (file == null && !this.disableDefaultImpl) {
                implementation = this.extractMethod(this.defaultUploadVersion, UploadVersion.Method.defineByName(implMethod.getName()));
                implMethod = (Method)implementation.getSecond();
                implMethod.setAccessible(true);
                file = (Path)implMethod.invoke(implementation.getFirst(), new Object[0]);
                if (serverPath == null) {
                    serverPath = implMethod.getAnnotation(FtpServerPath.class);
                }
            }
            result.setFirst((Object)file);
            result.setSecond((Object)this.getPathByMethodAnnotation(serverPath));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private String getPathByMethodAnnotation(FtpServerPath ftpServerPath) {
        String result = "";
        if (ftpServerPath != null) {
            String path = ftpServerPath.pathToFtp();
            if (Utils.isBlankString((String)path)) {
                String string = path = this.sormProjectUpload.isFullUpload ? ftpServerPath.pathForFullUpload() : ftpServerPath.pathForIncrementUpload();
            }
            if (Utils.notBlankString((String)path)) {
                result = path;
            }
        }
        return result;
    }

    private Pair<UploadVersion, Method> extractMethodFromUploadVersion(UploadVersion.Method method) {
        UploadVersion implClass = this.customUploadVersion != null ? this.customUploadVersion : this.defaultUploadVersion;
        return this.extractMethod(implClass, method);
    }

    private Pair<UploadVersion, Method> extractMethod(UploadVersion implClass, UploadVersion.Method method) {
        try {
            return new Pair((Object)implClass, (Object)implClass.getClass().getMethod(method.getMethodName(), new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private List<Pair<String, Path>> getOtherFiles() {
        List<Pair<String, Path>> customOtherFiles;
        ArrayList<Pair<String, Path>> otherFilesWithPaths = new ArrayList<Pair<String, Path>>();
        if (this.customUploadVersion != null && Utils.notEmptyCollection(customOtherFiles = this.customUploadVersion.getOtherFiles())) {
            otherFilesWithPaths.addAll(customOtherFiles);
        }
        if (Utils.isEmptyCollection(otherFilesWithPaths)) {
            otherFilesWithPaths.addAll(this.defaultUploadVersion.getOtherFiles());
        }
        return otherFilesWithPaths;
    }

    private List<Pair<String, Path>> getAdditionalFiles() {
        String filesData = this.sormProjectConfig.get("sorm.upload.additional.files", "");
        if (Utils.isBlankString((String)filesData)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, Path>> additionalFiles = new ArrayList<Pair<String, Path>>();
        JSONArray files = new JSONArray(filesData);
        for (int i = 0; i < files.length(); ++i) {
            JSONObject file = files.getJSONObject(i);
            Path filepath = Paths.get(file.optString("filepath"), new String[0]);
            if (!Files.exists(filepath, new LinkOption[0])) {
                logger.error(String.format("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \"%s\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", filepath));
                continue;
            }
            String pathToFtp = Utils.maskBlank((String)file.optString("pathToFtp"), (String)"/");
            logger.debug(String.format("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0444\u0430\u0439\u043b: %s, \u043f\u0443\u0442\u044c \u043d\u0430 FTP: %s", filepath, pathToFtp));
            additionalFiles.add((Pair<String, Path>)new Pair((Object)pathToFtp, (Object)filepath));
        }
        return additionalFiles;
    }

    private void removeEmptyFiles(List<Path> files) throws IOException {
        logger.debug("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u0443\u0441\u0442\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432");
        ArrayList localEmptyFiles = new ArrayList();
        files.removeIf(file -> {
            boolean isNeedDelete = false;
            if (file == null) {
                isNeedDelete = true;
            } else {
                int countLineLimit = 0;
                if (this.manufacturer.equals((Object)SormManufacturer.MFISOFT) || this.manufacturer.equals((Object)SormManufacturer.SPECIALTECHNOLOGY) || this.manufacturer.equals((Object)SormManufacturer.BASTION)) {
                    countLineLimit = 1;
                }
                try {
                    Charset charset = StandardCharsets.UTF_8;
                    if (this.manufacturer.equals((Object)SormManufacturer.NORSITRANS)) {
                        charset = Charset.forName("windows-1251");
                    }
                    isNeedDelete = Files.lines(file, charset).count() <= (long)countLineLimit;
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            if (file != null && isNeedDelete) {
                logger.debug("\u0414\u0430\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d, \u0442.\u043a. \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439: " + file.getFileName().toString());
                localEmptyFiles.add(file);
            }
            return isNeedDelete;
        });
        for (Path localEmptyFile : localEmptyFiles) {
            logger.info("\u0423\u0434\u0430\u043b\u044f\u0435\u043c \u043f\u0443\u0441\u0442\u043e\u0439 \u0444\u0430\u0439\u043b: " + localEmptyFile.toString());
            Files.deleteIfExists(localEmptyFile);
        }
    }
}

