/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class UploadFiles {
    private final FilePathType filePathType;
    private List<Path> files = new ArrayList<Path>();
    private Map<Path, FilePath> filesWithPaths = new HashMap<Path, FilePath>();

    public UploadFiles(boolean isFullUpload) {
        this.filePathType = FilePathType.defineType(isFullUpload);
    }

    public UploadFiles addFile(Path f) {
        this.files.add(f);
        return this;
    }

    public UploadFiles addAll(List<Path> files) {
        this.files.addAll(files);
        return this;
    }

    public void addFileWithPath(Pair<Path, String> fileWithPath) {
        String path;
        if (fileWithPath == null) {
            return;
        }
        Path file = (Path)fileWithPath.getFirst();
        if (file != null) {
            this.files.add(file);
        }
        if (Utils.isBlankString((String)(path = (String)fileWithPath.getSecond()))) {
            return;
        }
        this.filesWithPaths.put(file, new FilePath(file, path, this.filePathType));
    }

    public List<Path> getFiles() {
        return this.files;
    }

    public int filesCount() {
        return this.files.size();
    }

    public Map<Path, FilePath> getFilesWithPaths() {
        return this.filesWithPaths;
    }

    public String getPath(Path file) {
        FilePath filePath = this.filesWithPaths.get(file);
        return filePath == null ? "" : filePath.getPath();
    }

    public static enum FilePathType {
        PATH_FOR_FULL_UPLOAD,
        PATH_FOR_INCREMENT_UPLOAD;


        public static FilePathType defineType(boolean isFullUpload) {
            return isFullUpload ? PATH_FOR_FULL_UPLOAD : PATH_FOR_INCREMENT_UPLOAD;
        }
    }

    public static final class FilePath {
        private Path file;
        private String path;
        private FilePathType filePathType;

        public FilePath() {
        }

        public FilePath(Path file, String path, FilePathType filePathType) {
            this.file = file;
            this.path = path;
            this.filePathType = filePathType;
        }

        public Path getFile() {
            return this.file;
        }

        public String getPath() {
            return this.path;
        }

        public FilePathType getFilePathType() {
            return this.filePathType;
        }
    }
}

