/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.load.bean.Source;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.Bunch;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.ServiceSorm;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.server.bean.DialUpNAS;
import ru.bitel.bgbilling.modules.sorm.server.bean.NumberRange;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;

public class NorsiTransUpload
extends Upload {
    protected final Logger logger = LogManager.getLogger();
    protected final List<Path> otherFiles = new ArrayList<Path>();
    protected final String regionId = this.config.get("sorm.upload.regionid", "1");

    public NorsiTransUpload(int moduleId, SormProject sormProject, boolean isFullUpload) {
        super(moduleId, sormProject, isFullUpload);
    }

    @Override
    public Path abonents() {
        this.logger.info("\u0421\u0442\u0430\u0440\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432. \u0412\u0441\u0435\u0433\u043e \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + this.contracts.size());
        Path inetFile = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.INET_ABONENTS.getTitle(), "%s_%tQ.csv");
        Path phoneFile = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.PHONE_ABONENTS.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvInetFile = SormUtils.getCSVFile(inetFile, "windows-1251");
             SormCSVWriter csvPhoneFile = SormUtils.getCSVFile(phoneFile, "windows-1251");){
            String[] item;
            int inetCount = 0;
            int phoneCount = 0;
            Map<String, List<Integer>> telephoneModules = SormUtils.getTelephoneModulesIds(this.config);
            Map<Integer, List<InetServ>> abonentServices = SormUtils.getPairsAbonentInetServices(this.config, this.contracts, this.serverContext);
            for (SormContract contract : this.contracts) {
                List servList;
                this.helper.setCurrentContract(contract);
                int cid = contract.getContractId();
                if (this.checkInstalledModule(UploadModulesTitle.INET) && Utils.notEmptyCollection((Collection)(servList = (List)abonentServices.getOrDefault(cid, null)))) {
                    for (InetServ inetServ : servList) {
                        String[] item2 = this.getInetItem(cid, inetServ);
                        this.writeItemToFile(item2, cid, NorsiTransFileTitle.INET_ABONENTS.getTitle(), csvInetFile);
                        ++inetCount;
                    }
                }
                if (!this.checkInstalledModule(UploadModulesTitle.VOICE)) continue;
                for (Integer voiceMid : telephoneModules.get(UploadModulesTitle.VOICE.getTitleModule())) {
                    VoiceAccountService accountService = (VoiceAccountService)this.serverContext.getService(VoiceAccountService.class, voiceMid.intValue());
                    List accounts = accountService.voiceAccountList(contract.getContractId(), 0, new Period(contract.getDateFrom(), contract.getDateTo()));
                    for (VoiceAccount account : accounts) {
                        item = this.getPhoneItem(contract.getContractId(), String.valueOf(account.getNumber()), account.getDateFrom());
                        this.writeItemToFile(item, cid, NorsiTransFileTitle.PHONE_ABONENTS.getTitle(), csvPhoneFile);
                        ++phoneCount;
                    }
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.PHONE)) {
                for (Integer phoneMid : telephoneModules.get(UploadModulesTitle.PHONE.getTitleModule())) {
                    ClientItemManager itemManager = new ClientItemManager(this.con, phoneMid.intValue());
                    for (SormContract contract : this.contracts) {
                        this.helper.setCurrentContract(contract);
                        for (ClientItem clientItem : itemManager.getItemList(contract.getContractId(), 1, false)) {
                            for (String number : clientItem.getClientNumbers()) {
                                item = this.getPhoneItem(contract.getContractId(), number, TimeUtils.convertCalendarToDate((Calendar)clientItem.getDate1()));
                                this.writeItemToFile(item, contract.getContractId(), NorsiTransFileTitle.PHONE_ABONENTS.getTitle(), csvPhoneFile);
                                ++phoneCount;
                            }
                        }
                    }
                }
            }
            this.logger.info(String.format("\u0412\u0441\u0435\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e: %d. \u0410\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0430: %d. \u0410\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438: %d", this.contracts.size(), inetCount, phoneCount));
            if (Utils.notEmptyCollection((Collection)this.contracts)) {
                SormUtils.updateContractLogTable(this);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        this.otherFiles.add(phoneFile);
        return inetFile;
    }

    @Override
    public Path abonentsAddresses() {
        return null;
    }

    @Override
    public Path abonentLogins() {
        return null;
    }

    @Override
    public Path services() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430(\u0414\u0412\u041e)");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.SUPPLEMENTARY_SERVICES.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            for (ServiceSorm service : SormUtils.getSelectedServicesForUpload(this.config)) {
                String[] item = new String[6];
                item[0] = this.regionId;
                item[1] = String.valueOf(service.getId());
                item[2] = Utils.isBlankString((String)service.getTitle()) ? "-" : service.getTitle();
                String operatorStartDate = this.config.get("sorm.upload.operator.startdate");
                item[3] = Utils.isBlankString((String)operatorStartDate) ? "01.01.2010" : operatorStartDate;
                item[4] = "";
                item[5] = Utils.maskBlank((String)service.getDescription(), (String)service.getTitle());
                this.writeItemToFile(item, -1, NorsiTransFileTitle.SUPPLEMENTARY_SERVICES.getTitle(), csvFile);
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433(\u0414\u0412\u041e) \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + ex);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentServices() {
        return null;
    }

    @Override
    public Path ipNumbering() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.IP_NUMBERING.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            Map<IpCategory, List<IpResource>> categoriesWithResources = SormUtils.getIPResources(this.config, this.serverContext);
            for (Map.Entry<IpCategory, List<IpResource>> entry : categoriesWithResources.entrySet()) {
                String ipCategoryComment = entry.getKey().getComment();
                for (IpResource ipResource : entry.getValue()) {
                    SubnetUtils subnetUtils = new SubnetUtils(IpNet.newInstance((byte[])ipResource.getAddressFrom(), (byte[])ipResource.getAddressTo()).toString());
                    SubnetUtils.SubnetInfo info = subnetUtils.getInfo();
                    String cidrSignature = info.getCidrSignature();
                    String[] item = new String[6];
                    item[0] = this.regionId;
                    String resourceComment = Utils.notBlankString((String)ipResource.getComment()) ? ipResource.getComment() : "";
                    item[1] = Utils.isBlankString((String)ipCategoryComment) ? resourceComment : ipCategoryComment;
                    item[2] = cidrSignature.substring(0, cidrSignature.indexOf("/"));
                    item[3] = cidrSignature.substring(cidrSignature.indexOf("/") + 1);
                    item[4] = ipResource.getDateFrom() != null ? TimeUtils.formatDate((Date)ipResource.getDateFrom()) : "";
                    item[5] = ipResource.getDateTo() != null ? TimeUtils.formatDate((Date)ipResource.getDateTo()) : "";
                    this.writeItemToFile(item, -1, NorsiTransFileTitle.IP_NUMBERING.getTitle(), csvFile);
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 ip-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + ex);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentsIpNumbering() {
        return null;
    }

    @Override
    public Path switches() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path uploadFile = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.SWITCHES.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(uploadFile, "windows-1251");){
            String[] item;
            if (this.config.get("sorm.upload.switches.enable", "").equals("1")) {
                if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                    List<Device> allInetDevices = SormUtils.getInetDevices(this.config, this.serverContext);
                    Iterator<Device> iterator = allInetDevices.iterator();
                    while (iterator.hasNext()) {
                        Device inetDevice = iterator.next();
                        String[] item2 = this.getSwitchItem(inetDevice.getId(), inetDevice.getDateFrom(), inetDevice.getDateTo(), inetDevice.getComment(), inetDevice, "Ethernet");
                        this.writeItemToFile(item2, -1, NorsiTransFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
                if (this.checkInstalledModule(UploadModulesTitle.DIAL_UP)) {
                    for (DialUpNAS dialUpNAS : SormUtils.getDialUpNasList(this.serverContext, this.config, true)) {
                        item = this.getSwitchItem(dialUpNAS.getId(), dialUpNAS.getDateFrom(), dialUpNAS.getDateTo(), dialUpNAS.getComment(), null, "Ethernet");
                        this.writeItemToFile(item, -1, NorsiTransFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
            }
            if (this.config.get("sorm.upload.commutators.enable").equals("1")) {
                if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                    List<Device> allVoiceDevices = SormUtils.getVoiceDevices(this.config, this.serverContext);
                    Iterator<Device> iterator = allVoiceDevices.iterator();
                    while (iterator.hasNext()) {
                        Device voiceDevice = iterator.next();
                        String[] item2 = this.getSwitchItem(voiceDevice.getId(), voiceDevice.getDateFrom(), voiceDevice.getDateTo(), voiceDevice.getComment(), voiceDevice, "Ethernet");
                        this.writeItemToFile(item2, -1, NorsiTransFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
                if (this.checkInstalledModule(UploadModulesTitle.PHONE)) {
                    for (Source source : SormUtils.getPhoneSources(this.config, this.serverContext)) {
                        item = this.getSwitchItem(source.getId(), TimeUtils.convertCalendarToDate((Calendar)source.getDate1()), TimeUtils.convertCalendarToDate((Calendar)source.getDate2()), source.getComment(), null, "PSTN");
                        this.writeItemToFile(item, -1, NorsiTransFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + ex.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return uploadFile;
    }

    protected String[] getSwitchItem(int id, Date dateFrom, Date dateTo, String comment, Device device, String netType) {
        EntityAttrAddress address = device != null ? SormUtils.getAddressFromDeviceAttributes(device) : null;
        String addressStr = address != null ? address.toString() : "";
        String[] item = new String[]{this.regionId, String.valueOf(id), dateFrom != null ? TimeUtils.formatFullDate((Date)dateFrom) : "", dateTo != null ? TimeUtils.formatFullDate((Date)dateTo) : "", Utils.maskBlank((String)comment, (String)""), netType, "", "0", "1", "", "", "", "", "", "", "", "", "", Utils.isBlankString((String)addressStr) ? this.config.get("sorm.upload.operator.location") : addressStr};
        return item;
    }

    @Override
    public Path gateways() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.GATEWAYS.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                for (Device device : SormUtils.getSelectedGateways(this.config, this.serverContext)) {
                    EntityAttrAddress address = SormUtils.getAddressFromDeviceAttributes(device);
                    House house = address != null ? this.houseDao.get(address.getHouseId()) : null;
                    String host = device.getHost();
                    if (Utils.isBlankString((String)host)) {
                        this.logger.warn("\u041f\u043e\u043b\u0435 host \u0434\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 Inet: " + device.getId() + " \u043f\u0443\u0441\u0442\u043e\u0435 \u0438 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e, \u0442.\u043a. \u0434\u0430\u043d\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c");
                        continue;
                    }
                    this.writeItemToFile(this.getGatewayItem(device.getId(), host, device.getTitle(), device.getDateFrom(), device.getDateTo(), house, address), -1, NorsiTransFileTitle.GATEWAYS.getTitle(), csvFile);
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.DIAL_UP)) {
                for (DialUpNAS nas : SormUtils.getDialUpNasList(this.serverContext, this.config, false)) {
                    this.writeItemToFile(this.getGatewayItem(nas.getId(), nas.getIp(), nas.getTitle(), nas.getDateFrom(), nas.getDateTo(), null, null), 1, NorsiTransFileTitle.GATEWAYS.getTitle(), csvFile);
                }
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e);
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    protected String[] getGatewayItem(int id, String host, String title, Date dateFrom, Date dateTo, House house, EntityAttrAddress address) {
        String[] item = new String[]{this.regionId, host, dateFrom != null ? TimeUtils.formatFullDate((Date)dateFrom) : "", dateTo != null ? TimeUtils.formatFullDate((Date)dateTo) : "", title, "\u0420\u043e\u0441\u0441\u0438\u044f", this.config.get("sorm.upload.regiontitle"), house != null ? house.getAreaTitle() : "", house != null ? house.getCityTitle() : this.config.get("sorm.upload.operator.address.city"), address != null ? address.getTitle() : this.config.get("sorm.upload.operator.address.street"), house != null ? house.getHouse() + house.getFrac() : this.config.get("sorm.upload.operator.address.house"), "7"};
        return item;
    }

    @Override
    public Path bunches() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.BUNCHES.getTitle(), "%s_%tQ.csv");
        List<Bunch> bunches = SormUtils.getBunches(this.config);
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            for (Bunch bunch : bunches) {
                this.writeItemToFile(this.getBunchItem(bunch), -1, NorsiTransFileTitle.BUNCHES.getTitle(), csvFile);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430";
            this.logger.error(text + e);
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    protected String[] getBunchItem(Bunch bunch) {
        String[] item = new String[]{this.regionId, String.valueOf(bunch.getId()), Utils.maskBlank((String)bunch.getIdCommutator(), (String)""), String.valueOf(bunch.getDirectional().getCode()), bunch.getDateStart() == null ? "01.01.2010" : TimeUtils.format((Date)bunch.getDateStart(), (String)"dd.MM.yyyy HH:mm:ss"), bunch.getDateEnd() == null ? "01.01.2010" : TimeUtils.format((Date)bunch.getDateEnd(), (String)"dd.MM.yyyy HH:mm:ss"), bunch.getTitle()};
        return item;
    }

    @Override
    public Path phoneNumbering() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0439 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.PHONE_NUMBERING.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            ArrayList<NumberRange> resources = new ArrayList<NumberRange>();
            if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                resources.addAll(SormUtils.getUploadVoiceNumberingResources(this.config, this.serverContext));
            }
            if (this.checkInstalledModule(UploadModulesTitle.PHONE)) {
                resources.addAll(SormUtils.getUploadPhoneNumberingResources(this.config, this.con));
            }
            for (NumberRange numberRange : resources) {
                String phonePrefix;
                String[] item = new String[20];
                item[0] = this.regionId;
                item[1] = "RUS";
                item[2] = phonePrefix = this.config.get("sorm.upload.operatornumberprefix", "");
                item[3] = this.config.get("sorm.upload.lengthcodeofphone", "");
                item[4] = "7";
                item[5] = "7";
                item[6] = "\u0420\u043e\u0441\u0441\u0438\u044f";
                item[7] = "3";
                item[8] = String.valueOf(numberRange.getFromNumber()).replace(phonePrefix, "");
                item[9] = String.valueOf(numberRange.getToNumber()).replace(phonePrefix, "");
                long numberCountOfRange = numberRange.getToNumber() - numberRange.getFromNumber();
                item[10] = String.valueOf(Integer.max(1, (int)numberCountOfRange));
                item[11] = this.config.get("sorm.upload.operator.location", "");
                item[12] = this.config.get("sorm.upload.operator.title", "");
                item[13] = numberRange.getDateFrom() != null ? TimeUtils.formatDate((Date)numberRange.getDateFrom()) : "01.01.2010";
                item[14] = "";
                item[15] = "";
                item[16] = "250";
                item[17] = "000";
                item[18] = "";
                item[19] = "";
                this.writeItemToFile(item, -1, NorsiTransFileTitle.PHONE_NUMBERING.getTitle(), csvFile);
            }
            this.logger.info("\u041f\u043e \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 = " + resources.size());
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0439 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + ex);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path phoneNumberingAbonents() {
        return null;
    }

    @Override
    public Path documentTypes() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.DOC_TYPE.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            for (IdTitle docType : SormUtils.getDocumentsTypes(this.config, this.cpm)) {
                String[] item = new String[]{this.regionId, String.valueOf(docType.getId()), "01.01.2010", "", docType.getTitle()};
                this.writeItemToFile(item, -1, NorsiTransFileTitle.DOC_TYPE.getTitle(), csvFile);
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + ex);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path paymentTypes() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.PAYMENT_TYPE.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            for (PaymentType paymentType : this.paymentsToUpload.getPaymentTypesToUpload()) {
                int index = 0;
                String[] item = new String[5];
                item[index++] = this.regionId;
                item[index++] = String.valueOf(paymentType.getId());
                item[index++] = "01.01.2010";
                item[index++] = "";
                item[index] = paymentType.getTitle();
                this.writeItemToFile(item, -1, NorsiTransFileTitle.PAYMENT_TYPE.getTitle(), csvFile);
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: ";
            this.logger.info(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentsPayments() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path inetPayments = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.INET_PAYMENT.getTitle(), "%s_%tQ.csv");
        Path phonePayments = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.PHONE_PAYMENT.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter inetCSVFile = SormUtils.getCSVFile(inetPayments, "windows-1251");
             SormCSVWriter phoneCSVFile = SormUtils.getCSVFile(phonePayments, "windows-1251");){
            ContractModuleManager cmm = new ContractModuleManager(this.con);
            List<Payment> payments = this.paymentsToUpload.getPaymentsToUpload(true);
            for (Payment payment : payments) {
                Contract contract = this.contractManager.getContractById(payment.getContractId());
                if (contract == null) continue;
                this.helper.setCurrentContract(contract);
                if (this.isInetContract(contract, cmm)) {
                    this.writeItemToFile(this.getInetPaymentItem(contract, payment), this.helper.getCurrentContract().getContractId(), NorsiTransFileTitle.INET_PAYMENT.getTitle(), inetCSVFile);
                    continue;
                }
                if (!this.isPhoneContract(contract, cmm)) continue;
                this.writeItemToFile(this.getPhonePaymentItem(contract, payment), this.helper.getCurrentContract().getContractId(), NorsiTransFileTitle.PHONE_PAYMENT.getTitle(), phoneCSVFile);
            }
            if (Utils.notEmptyCollection(payments)) {
                this.paymentsToUpload.updatePaymentsLogTable(payments.get(payments.size() - 1).getId());
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            this.logger.error(text + ex.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        this.otherFiles.add(phonePayments);
        return inetPayments;
    }

    @Override
    public Path operatorInfo() {
        return null;
    }

    protected boolean isInetContract(Contract contract, ContractModuleManager contractModuleManager) throws BGException {
        Set contractModuleSet = contractModuleManager.getContractModuleSet(contract.getId());
        List ethernetMids = ((SormService)this.serverContext.getService(SormService.class, this.serverContext.getModuleId())).getInstalledEthernetModules().stream().mapToInt(InstalledInstanceModule::getModuleId).boxed().collect(Collectors.toList());
        for (Integer ethernetMid : ethernetMids) {
            if (!contractModuleSet.contains(ethernetMid)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPhoneContract(Contract contract, ContractModuleManager contractModuleManager) throws BGException {
        Set contractModuleSet = contractModuleManager.getContractModuleSet(contract.getId());
        List<Integer> telephoneModulesIds = ((SormService)this.serverContext.getService(SormService.class, this.serverContext.getModuleId())).getInstalledPhoneModules().stream().mapToInt(InstalledInstanceModule::getModuleId).boxed().toList();
        for (Integer telephoneMid : telephoneModulesIds) {
            if (!contractModuleSet.contains(telephoneMid)) continue;
            return true;
        }
        return false;
    }

    protected String[] getInetPaymentItem(Contract contract, Payment payment) {
        int index = 0;
        String[] item = new String[7];
        item[index++] = this.regionId;
        item[index++] = String.valueOf(payment.getTypeId());
        item[index++] = contract.getTitle();
        item[index++] = "";
        item[index++] = TimeUtils.formatFullDate((Date)payment.getTimeChange());
        item[index++] = Utils.formatBigDecimalSumm((BigDecimal)payment.getSum());
        item[index] = Utils.maskBlank((String)payment.getComment(), (String)"").replace("\n", "");
        return item;
    }

    protected String[] getPhonePaymentItem(Contract contract, Payment payment) {
        int index = 0;
        String[] item = new String[6];
        item[index++] = this.regionId;
        item[index++] = String.valueOf(payment.getTypeId());
        item[index++] = contract.getTitle();
        item[index++] = TimeUtils.formatFullDate((Date)payment.getTimeChange());
        item[index++] = Utils.formatBigDecimalSumm((BigDecimal)payment.getSum());
        item[index] = Utils.maskBlank((String)payment.getComment(), (String)"").replace("\n", "");
        return item;
    }

    @Override
    public List<Pair<String, Path>> getOtherFiles() {
        ArrayList<Pair<String, Path>> result = new ArrayList<Pair<String, Path>>();
        this.otherFiles.forEach(f -> result.add(new Pair(null, f)));
        return result;
    }

    protected String[] getInetItem(Integer contractId, InetServ serv) throws BGException {
        String docType;
        String fioType;
        String phone;
        String[] item = new String[76];
        Contract contract = this.contractManager.getContractById(contractId.intValue());
        String contractTitle = contract.getTitle();
        boolean isFiz = contract.getFc() == 0;
        int status = contract.getStatus();
        String contractDate = TimeUtils.formatFullDate((Date)contract.getDateFrom());
        item[0] = this.regionId;
        item[1] = SormUtils.trimField(Utils.maskBlank((String)serv.getLogin(), (String)"-"), 64);
        item[2] = serv.getAddressFrom() != null ? IpAddress.toString((byte[])serv.getAddressFrom()) : "";
        String email = this.contractDao.getEmailFromContractParameter(contractId.intValue(), this.config.getInt("sorm.upload.fiz.email", -1));
        if (Utils.isBlankString((String)email)) {
            email = this.helper.getStringParam("sorm.upload.org.email");
        }
        item[3] = Utils.maskBlank((String)email, (String)"-").trim().replaceAll("\\n", ",");
        item[4] = phone = isFiz ? this.helper.getPhoneParam("sorm.upload.fiz.phone") : this.helper.getPhoneParam("sorm.upload.org.phone");
        StringBuilder mac = new StringBuilder();
        List macAddressList = serv.getMacAddressList();
        if (Utils.notEmptyCollection((Collection)macAddressList)) {
            for (byte[] macAddress : macAddressList) {
                mac.append(InetServ.macAddressToString((byte[])macAddress)).append(", ");
            }
            if (mac.length() > 0) {
                mac = new StringBuilder(mac.substring(0, mac.length() - 2));
            }
        }
        item[5] = Utils.maskBlank((String)mac.toString(), (String)"").trim();
        item[6] = contractDate;
        item[7] = SormUtils.trimField(contractTitle, 64);
        item[8] = this.helper.contractIsActive() ? "0" : "1";
        item[9] = serv.getDateFrom() != null ? TimeUtils.formatFullDate((Date)serv.getDateFrom()) : contractDate;
        String serviceDateTo = "";
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date defaultDateTo = calendar.getTime();
        if (status != 0 && contract.getDateTo() != null) {
            serviceDateTo = contract.getDateTo().before(defaultDateTo) ? TimeUtils.formatFullDate((Date)contract.getDateTo()) : TimeUtils.formatFullDate((Date)defaultDateTo);
        }
        item[10] = serviceDateTo;
        item[11] = isFiz ? "0" : "1";
        String lastName = this.helper.getLastName();
        String firstName = this.helper.getFirstName();
        String middlename = this.helper.getMiddleName();
        String unstructFio = "";
        if (Utils.notBlankString((String)lastName) && Utils.notBlankString((String)firstName) && Utils.notBlankString((String)middlename)) {
            fioType = "0";
        } else {
            fioType = "1";
            unstructFio = this.helper.getStringParam("sorm.upload.fiz.unstructfio");
        }
        item[12] = isFiz ? fioType : "";
        item[13] = isFiz ? Utils.maskBlank((String)firstName, (String)"") : "";
        item[14] = isFiz ? Utils.maskBlank((String)middlename, (String)"") : "";
        item[15] = isFiz ? Utils.maskBlank((String)lastName, (String)"") : "";
        item[16] = isFiz ? Utils.maskBlank((String)unstructFio, (String)"") : "";
        item[17] = isFiz ? this.helper.getBirthday("dd.MM.yyyy") : "";
        int documentType = 1;
        EntityAttrList attrList = (EntityAttrList)((ContractService)this.serverContext.getService(ContractService.class, 0)).contractParameterGet(contractId.intValue(), this.config.getInt("sorm.upload.documenttype", -1));
        if (attrList != null) {
            documentType = attrList.getValue();
        }
        String series = this.helper.getDocumentSerial().trim().replaceAll("\\s", "").replaceAll(";", "");
        String number = this.helper.getDocumentNumber().trim().replaceAll("\\s", "").replaceAll(";", "");
        String whoGive = this.helper.getDocumentWhoGive().trim();
        String documentDateString = this.helper.getDocumentWhenGive("dd.MM.yyyy");
        Object unstructDoc = "";
        if (Utils.notBlankString((String)series) && Utils.notBlankString((String)number) && Utils.notBlankString((String)whoGive)) {
            docType = isFiz ? "0" : "";
        } else {
            String string = docType = isFiz ? "1" : "";
            if (Utils.isBlankString((String)series) && Utils.isBlankString((String)number) && Utils.isBlankString((String)whoGive)) {
                unstructDoc = this.helper.getStringParam("sorm.upload.fiz.documentunstruct");
            }
            if (Utils.isBlankString((String)unstructDoc)) {
                unstructDoc = series + " " + number + " " + whoGive + " " + documentDateString;
            }
        }
        item[18] = isFiz ? docType : "";
        item[19] = isFiz ? SormUtils.trimField(series, 16) : "";
        item[20] = isFiz ? SormUtils.trimField(number, 16) : "";
        item[21] = isFiz ? SormUtils.trimField(whoGive + " " + documentDateString, 256) : "";
        item[22] = isFiz ? SormUtils.trimField((String)unstructDoc, 256) : "";
        item[23] = isFiz ? String.valueOf(documentType) : "";
        String bankTitle = this.helper.getBankTitle();
        String bankAccount = this.helper.getBankAccount().replaceAll("\u0440/\u0441 ", "").trim();
        item[24] = isFiz ? "" : bankTitle;
        item[25] = isFiz ? "" : bankAccount;
        item[26] = isFiz ? "" : Utils.maskBlank((String)this.helper.getFullTitleOrg(), (String)"-");
        item[27] = isFiz ? "" : Utils.maskBlank((String)this.helper.getINN(), (String)"0000000000").trim();
        item[28] = isFiz ? "" : this.helper.getStringParam("sorm.upload.org.contactface").trim();
        item[29] = isFiz ? "" : SormUtils.trimField(this.helper.getPhoneParam("sorm.upload.org.phone"), 128);
        item[30] = isFiz ? "" : SormUtils.trimField(bankTitle, 256);
        item[31] = isFiz ? "" : SormUtils.trimField(bankAccount.trim(), 30);
        AddressStruct address = this.helper.getAddress();
        boolean addressIsStruct = SormUtils.checkValidAddress(address);
        String region = "";
        String zone = "";
        if (addressIsStruct) {
            region = SormUtils.getParameterOfCity(this, address, "region");
            zone = SormUtils.getParameterOfCity(this, address, "zone");
        }
        item[32] = addressIsStruct ? "0" : "1";
        item[33] = addressIsStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[34] = addressIsStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
        item[35] = addressIsStruct ? region : "";
        item[36] = addressIsStruct ? zone : "";
        item[37] = addressIsStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[38] = addressIsStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[39] = addressIsStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[40] = addressIsStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[41] = addressIsStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        String unstructAddress = SormUtils.trimField(this.helper.getUnstructAddress(), 1024);
        String string = item[42] = addressIsStruct ? "" : unstructAddress;
        if (!addressIsStruct && Utils.isBlankString((String)unstructAddress)) {
            item[32] = "";
        }
        if (addressIsStruct = SormUtils.checkValidAddress(address = this.helper.getCommutatorsAddress())) {
            region = SormUtils.getParameterOfCity(this, address, "region");
            zone = SormUtils.getParameterOfCity(this, address, "zone");
        }
        item[43] = addressIsStruct ? "0" : "1";
        item[44] = addressIsStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[45] = addressIsStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
        item[46] = addressIsStruct ? region : "";
        item[47] = addressIsStruct ? zone : "";
        item[48] = addressIsStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[49] = addressIsStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[50] = addressIsStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[51] = addressIsStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[52] = addressIsStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        unstructAddress = SormUtils.trimField(this.helper.getUnstructCommutatorsAddress(), 1024);
        String string2 = item[53] = addressIsStruct ? "" : unstructAddress;
        if (!addressIsStruct && Utils.isBlankString((String)unstructAddress)) {
            item[43] = "";
        }
        address = this.helper.getAddressBills();
        unstructAddress = this.helper.getUnstructAddressBills();
        addressIsStruct = SormUtils.checkValidAddress(address);
        if (!addressIsStruct && Utils.isBlankString((String)unstructAddress) && !(addressIsStruct = SormUtils.checkValidAddress(address = this.helper.getCommutatorsAddress()))) {
            unstructAddress = this.helper.getUnstructCommutatorsAddress();
        }
        if (addressIsStruct) {
            region = SormUtils.getParameterOfCity(this, address, "region");
            zone = SormUtils.getParameterOfCity(this, address, "zone");
        }
        item[54] = addressIsStruct ? "0" : "1";
        item[55] = addressIsStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[56] = addressIsStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
        item[57] = addressIsStruct ? region : "";
        item[58] = addressIsStruct ? zone : "";
        item[59] = addressIsStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[60] = addressIsStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[61] = addressIsStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[62] = addressIsStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[63] = addressIsStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        String string3 = item[64] = addressIsStruct ? "" : unstructAddress;
        if (!addressIsStruct && Utils.isBlankString((String)unstructAddress)) {
            item[54] = "";
        }
        item[65] = addressIsStruct ? "0" : "1";
        item[66] = addressIsStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[67] = addressIsStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
        item[68] = addressIsStruct ? region : "";
        item[69] = addressIsStruct ? zone : "";
        item[70] = addressIsStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[71] = addressIsStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[72] = addressIsStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[73] = addressIsStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[74] = addressIsStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        unstructAddress = SormUtils.trimField(this.helper.getUnstructAddressBills(), 1024);
        String string4 = item[75] = addressIsStruct ? "" : unstructAddress;
        if (!addressIsStruct && Utils.isBlankString((String)unstructAddress)) {
            item[65] = "";
        }
        return item;
    }

    protected String[] getPhoneItem(int contractId, String phoneNumber, Date dateFrom) throws BGException {
        String docType;
        String fioType;
        Contract contract = this.contractManager.getContractById(contractId);
        String[] item = new String[75];
        String contractTitle = contract.getTitle();
        boolean isFiz = contract.getFc() == 0;
        String contractDate = TimeUtils.formatFullDate((Date)contract.getDateFrom());
        item[0] = this.regionId;
        item[1] = SormUtils.trimField(Utils.maskBlank((String)phoneNumber, (String)"-"), 32);
        item[2] = SormUtils.trimField("", 32);
        item[3] = contractDate;
        item[4] = SormUtils.trimField(contractTitle, 64);
        item[5] = this.helper.contractIsActive() ? "0" : "1";
        item[6] = dateFrom != null ? TimeUtils.formatFullDate((Date)dateFrom) : contractDate;
        String endDate = "";
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        if (contract.getStatus() != 0 && contract.getDateTo() != null) {
            Date defaultDateTo = calendar.getTime();
            endDate = contract.getDateTo().before(defaultDateTo) ? TimeUtils.formatFullDate((Date)contract.getDateTo()) : TimeUtils.formatFullDate((Date)defaultDateTo);
        }
        item[7] = endDate;
        item[8] = isFiz ? "0" : "1";
        String surname = this.helper.getStringParam("sorm.upload.fiz.lastname");
        String name = this.helper.getStringParam("sorm.upload.fiz.firstname");
        String middlename = this.helper.getStringParam("sorm.upload.fiz.middlename");
        Object unstructFio = "";
        if (Utils.notBlankString((String)surname) && Utils.notBlankString((String)name) && Utils.notBlankString((String)middlename)) {
            fioType = isFiz ? "0" : "";
        } else {
            String string = fioType = isFiz ? "1" : "";
            if (Utils.isBlankString((String)surname) || Utils.isBlankString((String)name) || Utils.isBlankString((String)middlename)) {
                unstructFio = this.helper.getStringParam("sorm.upload.fiz.unstructfio");
            }
            if (Utils.isBlankString((String)unstructFio)) {
                unstructFio = surname + " " + name + " " + middlename;
            }
        }
        item[9] = isFiz ? fioType : "";
        item[10] = isFiz ? SormUtils.trimField(name, 128) : "";
        item[11] = isFiz ? SormUtils.trimField(middlename, 128) : "";
        item[12] = isFiz ? SormUtils.trimField(surname, 128) : "";
        item[13] = isFiz ? Utils.maskBlank((String)unstructFio, (String)"-") : "";
        String birthdateString = this.helper.getDateParam("sorm.upload.fiz.birthday", "dd.MM.yyyy");
        if (Utils.isBlankString((String)birthdateString)) {
            birthdateString = this.helper.getStringParam("sorm.upload.fiz.birthday");
        }
        item[14] = isFiz ? birthdateString : "";
        int documentType = 1;
        EntityAttrList attrList = (EntityAttrList)((ContractService)this.serverContext.getService(ContractService.class, 0)).contractParameterGet(contractId, this.config.getInt("sorm.upload.documenttype", -1));
        if (attrList != null) {
            documentType = attrList.getValue();
        }
        String series = this.helper.getStringParam("sorm.upload.fiz.documentserial").replaceAll("\\s", "").replaceAll(";", "");
        String number = this.helper.getStringParam("sorm.upload.fiz.documentnumber").replaceAll("\\s", "").replaceAll(";", "");
        String whoGive = this.helper.getStringParam("sorm.upload.fiz.documentwhogive");
        String documentDateString = this.helper.getDateParam("sorm.upload.fiz.documentwhengive", "dd.MM.yyyy");
        Object unstructDoc = "";
        if (Utils.notBlankString((String)series) && Utils.notBlankString((String)number) && Utils.notBlankString((String)whoGive)) {
            docType = isFiz ? "0" : "";
        } else {
            String string = docType = isFiz ? "1" : "";
            if (Utils.isBlankString((String)series) && Utils.isBlankString((String)number) && Utils.isBlankString((String)whoGive)) {
                unstructDoc = this.helper.getStringParam("sorm.upload.fiz.documentunstruct");
            }
            if (Utils.isBlankString((String)unstructDoc)) {
                unstructDoc = series + " " + number + " " + whoGive + " " + documentDateString;
            }
        }
        item[15] = isFiz ? docType : "";
        item[16] = isFiz ? SormUtils.trimField(series, 16) : "";
        item[17] = isFiz ? SormUtils.trimField(number, 16) : "";
        item[18] = isFiz ? SormUtils.trimField(whoGive + " " + documentDateString, 16) : "";
        item[19] = isFiz ? SormUtils.trimField((String)unstructDoc, 256) : "";
        item[20] = isFiz ? String.valueOf(documentType) : "";
        String bankTitle = this.helper.getBankTitle();
        String bankAccount = this.helper.getBankAccount().replaceAll("\u0440/\u0441 ", "").trim();
        item[21] = bankTitle;
        item[22] = bankAccount;
        String fullNameOrg = this.helper.getFullTitleOrg();
        item[23] = isFiz ? "" : (Utils.isBlankString((String)fullNameOrg) ? "-" : fullNameOrg);
        String inn = this.helper.getINN();
        item[24] = isFiz ? "" : SormUtils.trimField(Utils.maskBlank((String)inn, (String)"0000000000").trim(), 64);
        item[25] = isFiz ? "" : SormUtils.trimField(this.helper.getStringParam("sorm.upload.org.contactface"), 128);
        String phoneOrg = this.helper.getContactFacePhone();
        item[26] = isFiz ? "" : SormUtils.trimField(phoneOrg, 128);
        item[27] = isFiz ? "" : SormUtils.trimField("", 64);
        item[28] = isFiz ? "" : SormUtils.trimField("", 64);
        item[29] = isFiz ? "" : SormUtils.trimField(Utils.maskBlank((String)bankTitle, (String)"").trim(), 256);
        item[30] = isFiz ? "" : SormUtils.trimField(Utils.maskBlank((String)bankAccount, (String)"").trim(), 30);
        AddressStruct address = this.helper.getAddress();
        boolean isAddressStruct = SormUtils.checkValidAddress(address);
        String region = "";
        String zone = "";
        if (isAddressStruct) {
            region = SormUtils.getParameterOfCity(this, address, "region");
            zone = SormUtils.getParameterOfCity(this, address, "zone");
        }
        item[31] = isAddressStruct ? "0" : "1";
        item[32] = isAddressStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[33] = "\u0420\u043e\u0441\u0441\u0438\u044f";
        item[34] = region;
        item[35] = zone;
        item[36] = isAddressStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[37] = isAddressStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[38] = isAddressStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[39] = isAddressStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[40] = isAddressStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        item[41] = isAddressStruct ? "" : SormUtils.trimField(this.helper.getUnstructAddress(), 1024);
        address = this.helper.getCommutatorsAddress();
        isAddressStruct = SormUtils.checkValidAddress(address);
        item[42] = isAddressStruct ? "0" : "1";
        item[43] = isAddressStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[44] = "\u0420\u043e\u0441\u0441\u0438\u044f";
        item[45] = region;
        item[46] = zone;
        item[47] = isAddressStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[48] = isAddressStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[49] = isAddressStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[50] = isAddressStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[51] = isAddressStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        item[52] = isAddressStruct ? "" : SormUtils.trimField(this.helper.getUnstructCommutatorsAddress(), 1024);
        address = this.helper.getAddressBills();
        String unstructBillAddress = this.helper.getUnstructAddressBills();
        isAddressStruct = SormUtils.checkValidAddress(address);
        if (!isAddressStruct && Utils.isBlankString((String)unstructBillAddress) && !(isAddressStruct = SormUtils.checkValidAddress(address = this.helper.getCommutatorsAddress()))) {
            unstructBillAddress = this.helper.getUnstructCommutatorsAddress();
        }
        if (isAddressStruct) {
            region = SormUtils.getParameterOfCity(this, address, "region");
            zone = SormUtils.getParameterOfCity(this, address, "zone");
        }
        item[53] = isAddressStruct ? "0" : "1";
        item[54] = isAddressStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[55] = "\u0420\u043e\u0441\u0441\u0438\u044f";
        item[56] = region;
        item[57] = zone;
        item[58] = isAddressStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[59] = isAddressStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[60] = isAddressStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[61] = isAddressStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[62] = isAddressStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        item[63] = isAddressStruct ? "" : SormUtils.trimField(unstructBillAddress, 1024);
        item[64] = isAddressStruct ? "0" : "1";
        item[65] = isAddressStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[66] = "\u0420\u043e\u0441\u0441\u0438\u044f";
        item[67] = region;
        item[68] = zone;
        item[69] = isAddressStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[70] = isAddressStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[71] = isAddressStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[72] = isAddressStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[73] = isAddressStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        item[74] = isAddressStruct ? "" : SormUtils.trimField(this.helper.getUnstructAddressBills(), 1024);
        return item;
    }
}

