/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.shiftsystems;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.shiftsystems.ShiftSystemsFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;

public class ShiftSystemsUpload
extends Upload {
    private static final Logger logger = LogManager.getLogger((String)ShiftSystemsUpload.class.getSimpleName());
    private List<Pair<String, Path>> otherFiles = new ArrayList<Pair<String, Path>>();

    public ShiftSystemsUpload(int moduleId, SormProject sormProject, boolean isFullUpload) {
        super(moduleId, sormProject, isFullUpload);
    }

    @Override
    public Path abonents() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path fizFile = SormUtils.getUploadFile(this.localUserPath, ShiftSystemsFileTitle.FIZ.getTitle(), "%tY-%tm-%td-%tH-%tM-%tS-%s.csv");
        Path fizContractFile = SormUtils.getUploadFile(this.localUserPath, ShiftSystemsFileTitle.FIZ_CONTRACT.getTitle(), "%tY-%tm-%td-%tH-%tM-%tS-%s.csv");
        Path jurFile = SormUtils.getUploadFile(this.localUserPath, ShiftSystemsFileTitle.JUR.getTitle(), "%tY-%tm-%td-%tH-%tM-%tS-%s.csv");
        Path jurContractFile = SormUtils.getUploadFile(this.localUserPath, ShiftSystemsFileTitle.JUR_CONTRACT.getTitle(), "%tY-%tm-%td-%tH-%tM-%tS-%s.csv");
        int fizCount = 0;
        int jurCount = 0;
        int fizLoginCount = 0;
        int jurLoginCount = 0;
        try (SormCSVWriter fizCSVFile = new SormCSVWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fizFile.toFile()), StandardCharsets.UTF_8), '|', '\u0000');
             SormCSVWriter fizContractCSVFile = new SormCSVWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fizContractFile.toFile()), StandardCharsets.UTF_8), '|', '\u0000');
             SormCSVWriter jurCSVFile = new SormCSVWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jurFile.toFile()), StandardCharsets.UTF_8), '|', '\u0000');
             SormCSVWriter jurContractCSVFile = new SormCSVWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jurContractFile.toFile()), StandardCharsets.UTF_8), '|', '\u0000');){
            Map<Integer, List<InetServ>> abonentServices = SormUtils.getPairsAbonentInetServices(this.config, this.contracts, this.serverContext);
            for (SormContract contract : this.contracts) {
                try {
                    String[] contractItem;
                    this.helper.setCurrentContract(contract);
                    int cid = contract.getContractId();
                    List<InetServ> servList = abonentServices.get(cid);
                    if (Utils.isEmptyCollection(servList) || (contractItem = this.getContractItem(contract)) == null) continue;
                    if (contract.isFiz()) {
                        this.writeItemToFile(contractItem, cid, ShiftSystemsFileTitle.FIZ.getTitle(), fizCSVFile);
                        ++fizCount;
                    } else {
                        jurCSVFile.writeNext(contractItem);
                        this.writeItemToFile(contractItem, cid, ShiftSystemsFileTitle.JUR.getTitle(), jurCSVFile);
                        ++jurCount;
                    }
                    for (InetServ serv : servList) {
                        String[] contractLoginItem = this.getContractLoginItem(contract, serv);
                        if (contractLoginItem == null) continue;
                        if (contract.isFiz()) {
                            this.writeItemToFile(contractLoginItem, cid, ShiftSystemsFileTitle.FIZ_CONTRACT.getTitle(), fizContractCSVFile);
                            ++fizLoginCount;
                            continue;
                        }
                        this.writeItemToFile(contractLoginItem, cid, ShiftSystemsFileTitle.JUR_CONTRACT.getTitle(), jurContractCSVFile);
                        ++jurLoginCount;
                    }
                }
                catch (Exception ex) {
                    logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contract.getContractId() + "\u041e\u0448\u0438\u0431\u043a\u0430: " + ex);
                }
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + e);
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        this.otherFiles.add((Pair<String, Path>)new Pair((Object)ShiftSystemsFileTitle.FIZ_CONTRACT.getFtpDirectory(), (Object)fizContractFile));
        this.otherFiles.add((Pair<String, Path>)new Pair((Object)ShiftSystemsFileTitle.JUR.getFtpDirectory(), (Object)jurFile));
        this.otherFiles.add((Pair<String, Path>)new Pair((Object)ShiftSystemsFileTitle.JUR_CONTRACT.getFtpDirectory(), (Object)jurContractFile));
        logger.info("\u0417\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        logger.info("\u0417\u0430\u043f\u0438\u0441\u0435\u0439 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c:\n\u0424\u0438\u0437.\u043b\u0438\u0446: " + fizCount + "\n\u042e\u0440.\u043b\u0438\u0446: " + jurCount + "\n\u041b\u043e\u0433\u0438\u043d\u043e\u0432 \u0424\u0438\u0437.\u043b\u0438\u0446: " + fizLoginCount + "\n\u041b\u043e\u0433\u0438\u043d\u043e\u0432 \u042e\u0440.\u043b\u0438\u0446: " + jurLoginCount);
        return fizFile;
    }

    private String[] getContractItem(SormContract contract) throws BGException {
        int fieldCount = contract.isFiz() ? 19 : 14;
        String[] item = new String[fieldCount];
        item[0] = String.valueOf(contract.getContractId());
        if (contract.isFiz()) {
            item[1] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.fiz.lastname"), (String)"~");
            item[2] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.fiz.firstname"), (String)"~");
            item[3] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.fiz.middlename"), (String)"~");
            item[4] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.fiz.documentnumber"), (String)"~");
            item[5] = Utils.maskBlank((String)this.helper.getDateParam("sorm.upload.fiz.birthday", "dd.MM.yyyy"), (String)"~");
            String documentType = "";
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                documentType = contractDao.getContractParameterListAsString(contract.getContractId(), this.config.getInt("sorm.upload.documenttype", -1)).orElse("");
            }
            catch (BGException e) {
                logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u0437\u044f\u0442\u044c \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430. " + e.getMessage());
            }
            item[13] = Utils.maskBlank((String)documentType, (String)"~");
            item[14] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.fiz.documentserial"), (String)"~");
            item[15] = Utils.maskBlank((String)this.helper.getDateParam("sorm.upload.fiz.documentwhengive", "dd.MM.yyyy"), (String)"~");
            item[16] = "~";
            item[17] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.fiz.documentwhogive"), (String)"~");
            item[18] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.fiz.email"), (String)"~");
        } else {
            item[1] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.org.fulltitle"), (String)"~");
            item[2] = Utils.maskBlank((String)this.helper.getINN(), (String)"~");
            item[3] = "~";
            item[4] = "~";
            item[5] = "~";
            item[13] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.org.email"), (String)"~");
        }
        AddressStruct address = this.helper.getAddress();
        if (address != null) {
            String region = SormUtils.getParameterOfCity(this, address, "region");
            item[6] = Utils.maskBlank((String)address.getCountry(), (String)"~");
            item[7] = Utils.maskBlank((String)region, (String)"~");
            item[8] = Utils.maskBlank((String)address.getCity(), (String)"~");
            item[9] = Utils.maskBlank((String)address.getArea(), (String)"~");
            item[10] = Utils.maskBlank((String)address.getStreet(), (String)"~");
            item[11] = Utils.maskBlank((String)address.getHouse(), (String)"~") + Utils.maskBlank((String)address.getFrac(), (String)"");
            item[12] = Utils.maskBlank((String)address.getFlat(), (String)"~");
        } else {
            item[6] = "~";
            item[7] = "~";
            item[8] = "~";
            item[9] = "~";
            item[10] = "~";
            item[11] = "~";
            item[12] = "~";
        }
        return item;
    }

    private String[] getContractLoginItem(SormContract contract, InetServ serv) throws BGException {
        String[] item = new String[14];
        try {
            byte[] ip;
            item[0] = String.valueOf(contract.getContractId());
            item[1] = contract.getDateFrom() != null ? TimeUtils.formatDate((Date)contract.getDateFrom()) : "~";
            item[2] = Utils.maskBlank((String)contract.getContractTitle(), (String)"~");
            item[3] = contract.getDateTo() != null ? TimeUtils.formatDate((Date)contract.getDateTo()) : "~";
            item[4] = "1";
            item[5] = "0";
            String login = serv.getLogin();
            if (Utils.isBlankString((String)login) && (ip = serv.getAddressFrom()) != null) {
                login = InetAddress.getByAddress(ip).getHostAddress();
            }
            if (Utils.isBlankString((String)login)) {
                login = String.valueOf(contract.getContractId());
            }
            item[6] = Utils.maskBlank((String)login, (String)"~");
            AddressStruct switchAddress = this.helper.getCommutatorsAddress();
            if (switchAddress != null) {
                String region = SormUtils.getParameterOfCity(this, switchAddress, "region");
                item[7] = Utils.maskBlank((String)switchAddress.getCountry(), (String)"~");
                item[8] = Utils.maskBlank((String)region, (String)"~");
                item[9] = Utils.maskBlank((String)switchAddress.getCity(), (String)"~");
                item[10] = Utils.maskBlank((String)switchAddress.getArea(), (String)"~");
                item[11] = Utils.maskBlank((String)switchAddress.getStreet(), (String)"~");
                item[12] = Utils.maskBlank((String)switchAddress.getHouse(), (String)"~") + Utils.maskBlank((String)switchAddress.getFrac(), (String)"");
                item[13] = Utils.maskBlank((String)switchAddress.getFlat(), (String)"~");
            } else {
                item[7] = "~";
                item[8] = "~";
                item[9] = "~";
                item[10] = "~";
                item[11] = "~";
                item[12] = "~";
                item[13] = "~";
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return item;
    }

    @Override
    public Path abonentsAddresses() {
        return null;
    }

    @Override
    public Path abonentLogins() {
        return null;
    }

    @Override
    public Path services() {
        return null;
    }

    @Override
    public Path abonentServices() {
        return null;
    }

    @Override
    public Path ipNumbering() {
        return null;
    }

    @Override
    public Path abonentsIpNumbering() {
        return null;
    }

    @Override
    public Path switches() {
        return null;
    }

    @Override
    public Path gateways() {
        return null;
    }

    @Override
    public Path bunches() {
        return null;
    }

    @Override
    public Path phoneNumbering() {
        return null;
    }

    @Override
    public Path phoneNumberingAbonents() {
        return null;
    }

    @Override
    public Path documentTypes() {
        return null;
    }

    @Override
    public Path paymentTypes() {
        return null;
    }

    @Override
    public Path abonentsPayments() {
        return null;
    }

    @Override
    public Path operatorInfo() {
        return null;
    }

    @Override
    public List<Pair<String, Path>> getOtherFiles() {
        return this.otherFiles;
    }
}

