/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.specialtehnology;

import au.com.bytecode.opencsv.CSVWriter;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.object.bean.AddressParamValue;
import bitel.billing.server.load.bean.Source;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.Bunch;
import ru.bitel.bgbilling.modules.sorm.common.bean.Directional;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.ServiceSorm;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.upload.mfisoft.MfiSoftPaymentType;
import ru.bitel.bgbilling.modules.sorm.common.upload.specialtehnology.SpecTehPaymentType;
import ru.bitel.bgbilling.modules.sorm.server.bean.DialUpLogin;
import ru.bitel.bgbilling.modules.sorm.server.bean.DialUpNAS;
import ru.bitel.bgbilling.modules.sorm.server.bean.InternalUser;
import ru.bitel.bgbilling.modules.sorm.server.bean.NumberRange;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.service.SormServiceImpl;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.mfisoft.MfiSoftFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.upload.specialtehnology.ItemLog;
import ru.bitel.bgbilling.modules.sorm.server.upload.specialtehnology.SpecTehFileTitles;
import ru.bitel.bgbilling.modules.sorm.server.utils.InternalUserAddressUtils;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadHelper;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadLogsTable;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginInfo;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginInfoManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;

public class SpecTehUpload
extends Upload {
    protected Logger logger = LogManager.getLogger();
    protected final List<ServiceSorm> services = new ArrayList<ServiceSorm>();
    protected final List<Integer> inetServices = new ArrayList<Integer>();
    protected final List<Integer> phoneServices = new ArrayList<Integer>();
    protected final ServiceSorm inetService = new ServiceSorm(1, "\u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442");
    protected final ServiceSorm phoneService = new ServiceSorm(2, "\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u044f");
    protected final Set<ServiceSorm> operatorServices = new HashSet<ServiceSorm>();
    protected final String regionId;
    protected final Map<String, String> itemLogCache = new HashMap<String, String>();
    protected final List<ItemLog> itemsForUpdateLog = new ArrayList<ItemLog>();
    protected final Map<Integer, java.util.Date> lastChangedContractDates = new HashMap<Integer, java.util.Date>();
    protected Path internalUsersFile;

    public SpecTehUpload(int moduleId, SormProject sormProject, boolean isFullUpload) {
        super(moduleId, sormProject, isFullUpload);
        this.regionId = this.config.get("sorm.upload.regionid", "1");
        this.logger.info("REGION_ID \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d = " + this.regionId);
        try {
            ServerUtils.checkTable((Connection)this.con, (String)SormUploadLogsTable.getSpecTehLogTable(moduleId), (String)SormUploadLogsTable.getSpecTehLogTableCreateQuery(moduleId));
            this.checkAndCreateIndexOnLogTable();
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex);
        }
        this.prepareServices();
        if (!isFullUpload) {
            this.loadCacheItemLog();
            this.loadContractLastChangedDates();
        }
    }

    protected void checkAndCreateIndexOnLogTable() throws SQLException {
        boolean hasIndex = false;
        try (Statement st = this.con.createStatement();){
            ResultSet rs = st.executeQuery("SHOW INDEX FROM " + SormUploadLogsTable.getSpecTehLogTable(this.getModuleId()));
            while (rs.next()) {
                if (!"contractId".equals(rs.getString("Key_name"))) continue;
                hasIndex = true;
            }
            if (!hasIndex) {
                st.executeUpdate("ALTER TABLE " + SormUploadLogsTable.getSpecTehLogTable(this.getModuleId()) + " ADD INDEX contractId (contractId)");
            }
        }
    }

    protected void loadContractLastChangedDates() {
        String changedCids = Utils.toString((Iterable)this.contracts.stream().mapToInt(SormContract::getContractId).boxed().collect(Collectors.toList()), (String)",");
        if (Utils.isBlankString((String)changedCids)) {
            return;
        }
        String query = "SELECT contractId, date FROM " + SormUploadLogsTable.getSormChangedContractTable(this.getModuleId()) + " WHERE contractId IN(" + changedCids + ")";
        try (Statement statement = this.serverContext.getConnection().createStatement();){
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                this.lastChangedContractDates.put(rs.getInt("contractId"), TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date")));
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0430\u0442 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: ", (Throwable)ex);
        }
    }

    protected void prepareServices() {
        this.logger.debug("\u0421\u043f\u0435\u0446.\u0422\u0435\u0445\u043d\u043e\u043b\u043e\u0433\u0438\u0438 \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0430 \u0438 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438");
        this.services.addAll(SormUtils.getSelectedServicesForUpload(this.config));
        for (ServiceSorm serviceSorm : this.services) {
            if (serviceSorm.isInetServiceType()) {
                this.inetServices.add(serviceSorm.getId());
            }
            if (!serviceSorm.isPhoneServiceType()) continue;
            this.phoneServices.add(serviceSorm.getId());
        }
        if (Utils.notEmptyCollection(this.inetServices)) {
            this.operatorServices.add(this.inetService);
        }
        if (Utils.notEmptyCollection(this.phoneServices)) {
            this.operatorServices.add(this.phoneService);
        }
        this.logger.info("\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0438 \u0441 \u0443\u0441\u043b\u0443\u0433\u0430\u043c\u0438. \u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442=" + this.inetServices.size() + ", \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u044f=" + this.phoneServices.size());
    }

    protected void loadCacheItemLog() {
        this.logger.debug("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043a\u044d\u0448\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432=" + this.contracts.size());
        if (Utils.isEmptyCollection((Collection)this.contracts)) {
            return;
        }
        String query = "SELECT * FROM " + SormUploadLogsTable.getSpecTehLogTable(this.getModuleId()) + " WHERE sormProjectId=? AND contractId IN(" + Utils.toString(this.contracts.stream().mapToInt(SormContract::getContractId).boxed().toList()) + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, this.sormProject.getId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String data = rs.getString("data");
                if (data == null) continue;
                this.itemLogCache.put(this.getIdentifierString(rs.getInt("contractId"), rs.getString("fileTitle"), rs.getString("meta")), data);
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug("\u041a\u044d\u0448 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
    }

    protected String getIdentifierString(int contractId, String fileTitle, String metaInfoFilter) {
        return "contractId=" + contractId + ",fileTitle=" + fileTitle + ",metaInfoFilter=" + Utils.maskBlank((String)metaInfoFilter, (String)"");
    }

    protected String[] getLogItemFromCache(String identifier) {
        String data = this.itemLogCache.get(identifier);
        return data == null ? null : data.split(";", -1);
    }

    @Override
    public Path abonents() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.ABONENTS.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        this.internalUsersFile = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.ABONENTS_USER.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');
             SormCSVWriter internalUsersFileWriter = SormUtils.getCSVFile(this.internalUsersFile, '\u0000');){
            internalUsersFileWriter.writeNext(new String[]{"ABONENT_ID", "REGION_ID", "USER_NUMBER", "USER_NAME", "RECORD_ACTION", "INTERNAL_ID1"});
            csvFile.writeNext(new String[]{"ID", "REGION_ID", "CONTRACT_DATE", "CONTRACT", "ACCOUNT", "ACTUAL_FROM", "ACTUAL_TO", "ABONENT_TYPE", "NAME_INFO_TYPE", "FAMILY_NAME", "GIVEN_NAME", "INITIAL_NAME", "UNSTRUCT_NAME", "BIRTH_DATE", "IDENT_CARD_TYPE_ID", "IDENT_CARD_TYPE", "IDENT_CARD_SERIAL", "IDENT_CARD_NUMBER", "IDENT_CARD_DESCRIPTION", "IDENT_CARD_UNSTRUCT", "BANK", "BANK_ACCOUNT", "FULL_NAME", "INN", "CONTACT", "PHONE_FAX", "STATUS", "ATTACH", "DETACH", "NETWORK_TYPE", "RECORD_ACTION", "INTERNAL_ID1"});
            List<IdTitle> documentTypes = SormUtils.getDocumentsTypes(this.config, this.cpm);
            String connectionStandard = SormUtils.getConnectionStandart(this.config);
            for (SormContract contract : this.contracts) {
                String[] logItem;
                java.util.Date incrementDateTo;
                this.helper.setCurrentContract(contract);
                int cid = contract.getContractId();
                java.util.Date date = incrementDateTo = this.lastChangedContractDates.containsKey(cid) ? this.lastChangedContractDates.get(cid) : contract.getDateFrom();
                if (!this.isFullUpload && (logItem = this.getLogItemFromCache(this.getIdentifierString(cid, SpecTehFileTitles.ABONENTS.getTitle(), null))) != null) {
                    logItem[30] = "2";
                    csvFile.writeNext(logItem);
                    logItem[6] = SormUtils.formatDateToUTC(incrementDateTo, "yyyy-MM-dd HH:mm:ss");
                    logItem[30] = "1";
                    csvFile.writeNext(logItem);
                }
                try {
                    boolean isFiz = contract.isFiz();
                    String dateFrom = contract.getDateFrom() == null ? "" : TimeUtils.format((java.util.Date)contract.getDateFrom(), (String)"yyyy-MM-dd HH:mm:ss");
                    String contractDateToString = "";
                    if (contract.getDateTo() != null) {
                        java.util.Date contractDateTo = TimeUtils.getEndDay((java.util.Date)contract.getDateTo());
                        contractDateToString = TimeUtils.format((java.util.Date)contractDateTo, (String)"yyyy-MM-dd HH:mm:ss");
                    }
                    String[] item = new String[32];
                    item[0] = String.valueOf(cid);
                    item[1] = this.regionId;
                    item[2] = dateFrom;
                    item[3] = contract.getContractTitle();
                    item[4] = contract.getContractTitle();
                    item[5] = SormUtils.formatDateToUTC(incrementDateTo, "yyyy-MM-dd HH:mm:ss");
                    item[6] = "2049-12-31 23:59:59";
                    String string = item[7] = isFiz ? "42" : "43";
                    if (isFiz) {
                        String firstName = this.helper.getFirstName();
                        String lastName = this.helper.getLastName();
                        String middleName = this.helper.getMiddleName();
                        if (Utils.notBlankString((String)firstName) && Utils.notBlankString((String)lastName) && Utils.notBlankString((String)middleName)) {
                            item[8] = "0";
                            item[9] = lastName;
                            item[10] = firstName;
                            item[11] = middleName;
                            item[12] = "";
                        } else {
                            item[8] = "1";
                            item[9] = "";
                            item[10] = "";
                            item[11] = "";
                            item[12] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.fiz.unstructfio"), (String)(lastName + " " + firstName + " " + middleName));
                        }
                        item[13] = this.helper.getBirthday("yyyy-MM-dd");
                        item[14] = String.valueOf(SormUtils.getDocumentTypeIdOfContract(this.config, this.contractDao, cid, documentTypes));
                        String serial = this.helper.getDocumentSerial();
                        String number = this.helper.getDocumentNumber();
                        String whoGive = this.helper.getDocumentWhoGive();
                        String whenGive = this.helper.getDocumentWhenGive("yyyy-MM-dd");
                        String whoWhenGive = whenGive + " " + (String)whoGive;
                        if (Utils.notBlankString((String)serial) && Utils.notBlankString((String)number) && Utils.notBlankString((String)whoWhenGive)) {
                            item[15] = "0";
                            item[16] = serial.trim();
                            item[17] = number.trim();
                            item[18] = whoWhenGive.trim();
                            item[19] = "";
                        } else {
                            item[15] = "1";
                            item[16] = "";
                            item[17] = "";
                            item[18] = "";
                            item[19] = this.helper.getStringParam("sorm.upload.fiz.documentunstruct");
                        }
                        item[20] = "";
                        item[21] = "";
                        item[22] = "";
                        item[23] = "";
                        item[24] = "";
                        item[25] = "";
                    } else {
                        item[8] = "";
                        item[9] = "";
                        item[10] = "";
                        item[11] = "";
                        item[12] = "";
                        item[13] = "";
                        item[14] = "";
                        item[15] = "";
                        item[16] = "";
                        item[17] = "";
                        item[18] = "";
                        item[19] = "";
                        item[20] = this.helper.getBankTitle();
                        item[21] = this.helper.getBankAccount();
                        item[22] = this.helper.getFullTitleOrg();
                        item[23] = this.helper.getINN();
                        item[24] = this.helper.getStringParam("sorm.upload.org.contactface").trim();
                        String phone = this.helper.getPhoneParam("sorm.upload.org.phone");
                        if (Utils.isBlankString((String)phone)) {
                            phone = this.helper.getPhoneParam("sorm.upload.org.contactfacenumber");
                        }
                        item[25] = phone.replaceAll(";", ",");
                    }
                    item[26] = this.helper.contractIsActive() ? "0" : "1";
                    item[27] = dateFrom;
                    item[28] = Utils.isBlankString((String)contractDateToString) ? "2049-12-31 23:59:59" : contractDateToString;
                    item[29] = connectionStandard;
                    item[30] = "1";
                    item[31] = "";
                    this.writeItemToFile(item, cid, SpecTehFileTitles.ABONENTS.getTitle(), csvFile);
                    this.addItemForUpdateLog(cid, item, SpecTehFileTitles.ABONENTS.getTitle(), "");
                    if (contract.isFiz()) continue;
                    List<InternalUser> internalUserList = SormUtils.getInternalUsers(this.con, this.objectManager, this.valueManager, this.helper, this.config);
                    for (int i = 0; i < internalUserList.size(); ++i) {
                        InternalUser internalUser = internalUserList.get(i);
                        String[] internalItem = Arrays.copyOfRange(item, 0, item.length);
                        internalItem[2] = internalUser.getDateFrom() != null ? SormUtils.formatDateToUTC(internalUser.getDateFrom(), "yyyy-MM-dd HH:mm:ss") : "";
                        internalItem[5] = internalUser.getDateFrom() != null ? SormUtils.formatDateToUTC(internalUser.getDateFrom(), "yyyy-MM-dd HH:mm:ss") : "";
                        internalItem[6] = internalUser.getDateTo() != null ? SormUtils.formatDateToUTC(internalUser.getDateTo(), "yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59";
                        internalItem[7] = "42";
                        internalItem[8] = "0";
                        internalItem[9] = Utils.maskBlank((String)internalUser.getLastName(), (String)"");
                        internalItem[10] = Utils.maskBlank((String)internalUser.getFirstName(), (String)"");
                        internalItem[11] = Utils.maskBlank((String)internalUser.getMiddleName(), (String)"");
                        internalItem[12] = "";
                        internalItem[13] = internalUser.getBirthday() != null ? TimeUtils.formatFullDate((java.util.Date)internalUser.getBirthday().getTime()) : "";
                        int documentTypeId = 1;
                        if (Utils.notBlankString((String)internalUser.getDocumentType())) {
                            for (IdTitle docType : documentTypes) {
                                if (!docType.getTitle().equals(internalUser.getDocumentType())) continue;
                                documentTypeId = docType.getId();
                                break;
                            }
                        }
                        internalItem[14] = String.valueOf(documentTypeId);
                        internalItem[15] = "0";
                        internalItem[16] = Utils.maskBlank((String)internalUser.getDocumentSerial(), (String)"");
                        internalItem[17] = Utils.maskBlank((String)internalUser.getDocumentNumber(), (String)"");
                        Object whoWhenGive = internalUser.getDocumentWhenGive() != null ? TimeUtils.formatFullDate((java.util.Date)internalUser.getDocumentWhenGive().getTime()) : " " + Utils.maskBlank((String)internalUser.getDocumentWhoGive(), (String)"");
                        internalItem[18] = ((String)whoWhenGive).trim();
                        internalItem[19] = "";
                        internalItem[20] = "";
                        internalItem[21] = "";
                        internalItem[22] = "";
                        internalItem[23] = "";
                        internalItem[24] = "";
                        internalItem[25] = "";
                        internalItem[27] = internalUser.getDateFrom() != null ? SormUtils.formatDateToUTC(internalUser.getDateFrom(), "yyyy-MM-dd HH:mm:ss") : dateFrom;
                        internalItem[28] = internalUser.getDateTo() != null ? SormUtils.formatDateToUTC(internalUser.getDateTo(), "yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59";
                        internalItem[31] = internalUser.getId();
                        this.writeItemToFile(internalItem, cid, SpecTehFileTitles.ABONENTS.getTitle(), csvFile);
                        this.writeInternalUserToAbonentUsersFile(contract.getContractId(), internalUser, internalItem, internalUsersFileWriter, i);
                    }
                }
                catch (Exception ex) {
                    this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430: " + cid + " \u041e\u0448\u0438\u0431\u043a\u0430: " + ex);
                }
            }
            if (Utils.notEmptyCollection((Collection)this.contracts)) {
                SormUtils.updateContractLogTable(this);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    protected void writeInternalUserToAbonentUsersFile(int parentContractId, InternalUser internalUser, String[] internalItem, CSVWriter internalUsersFileWriter, int userNumber) {
        String[] logItem = this.getLogItemFromCache(this.getIdentifierString(parentContractId, SpecTehFileTitles.ABONENTS_USER.getTitle(), "internalUser=" + internalUser.getId()));
        if (logItem != null) {
            logItem[4] = "2";
            internalUsersFileWriter.writeNext(logItem);
        }
        String[] item = new String[]{String.valueOf(parentContractId), this.regionId, "00" + userNumber, Utils.maskBlank((String)internalUser.getLastName(), (String)"") + " " + Utils.maskBlank((String)internalUser.getFirstName(), (String)"") + " " + Utils.maskBlank((String)internalUser.getMiddleName(), (String)""), "1", internalItem[31]};
        internalUsersFileWriter.writeNext(item);
        this.addItemForUpdateLog(parentContractId, item, SpecTehFileTitles.ABONENTS_USER.getTitle(), "internalUser=" + internalUser.getId());
    }

    @Override
    public Path abonentsAddresses() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.ABONENTS_ADDR.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"ABONENT_ID", "REGION_ID", "ADDRESS_TYPE_ID", "ADDRESS_TYPE", "ZIP", "COUNTRY", "REGION", "ZONE", "CITY", "STREET", "BUILDING", "BUILD_SECT", "APARTMENT", "UNSTRUCT_INFO", "BEGIN_TIME", "END_TIME", "RECORD_ACTION", "INTERNAL_ID1", "INTERNAL_ID2"});
            List<Pair<Integer, List<Pair<String, Integer>>>> addresses = SormUtils.getAddressList(this.config, this.contracts);
            this.logger.info("\u0412\u0441\u0435\u0433\u043e \u043f\u0430\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0438 \u0430\u0434\u0440\u0435\u0441\u043e\u0432: " + addresses.size());
            for (Pair<Integer, List<Pair<String, Integer>>> addressItem : addresses) {
                try {
                    int cid = (Integer)addressItem.getFirst();
                    Contract contract = this.contractManager.getContractById(cid);
                    this.helper.setCurrentContract(contract);
                    List addressesPids = (List)addressItem.getSecond();
                    for (Pair typeAddressWithPid : addressesPids) {
                        String[] logItem;
                        String addressType = SormUtils.getAddressType((String)typeAddressWithPid.getFirst());
                        java.util.Date incrementDateTo = null;
                        if (!this.isFullUpload && (logItem = this.getLogItemFromCache(this.getIdentifierString(cid, SpecTehFileTitles.ABONENTS_ADDR.getTitle(), addressType))) != null) {
                            logItem[16] = "2";
                            csvFile.writeNext(logItem);
                            incrementDateTo = new java.util.Date();
                            logItem[15] = SormUtils.formatDateToUTC(incrementDateTo, "yyyy-MM-dd HH:mm:ss");
                            logItem[16] = "1";
                            csvFile.writeNext(logItem);
                        }
                        String[] item = new String[19];
                        item[0] = String.valueOf(cid);
                        item[1] = this.regionId;
                        item[2] = addressType;
                        int pid = (Integer)typeAddressWithPid.getSecond();
                        AddressStruct addressStruct = this.helper.getAddressByPid(pid);
                        if (addressStruct != null) {
                            String region = SormUtils.getParameterOfCity(this, addressStruct, "region");
                            String zone = SormUtils.getParameterOfCity(this, addressStruct, "zone");
                            item[3] = "0";
                            item[4] = Utils.maskBlank((String)addressStruct.getIndex(), (String)"").trim();
                            item[5] = Utils.maskBlank((String)addressStruct.getCountry(), (String)"\u0420\u043e\u0441\u0441\u0438\u044f").trim();
                            item[6] = Utils.maskBlank((String)region, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                            item[7] = Utils.maskBlank((String)zone, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                            item[8] = Utils.maskBlank((String)addressStruct.getCity(), (String)"").trim();
                            item[9] = Utils.maskBlank((String)addressStruct.getStreet(), (String)"").trim();
                            item[10] = Utils.maskBlank((String)addressStruct.getHouse(), (String)"").trim();
                            item[11] = Utils.maskBlank((String)addressStruct.getFrac(), (String)"").trim().replaceAll("/", "");
                            item[12] = Utils.maskBlank((String)addressStruct.getFlat(), (String)"").trim();
                            item[13] = "";
                        } else {
                            String unstructAddress = this.helper.getUnstructAddress();
                            if (Utils.isBlankString((String)unstructAddress)) {
                                if (!this.logger.isDebugEnabled()) continue;
                                this.logger.debug("\u0414\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ID=" + cid + " \u043d\u0435\u0442 \u0430\u0434\u0440\u0435\u0441\u0430 \u0434\u043b\u044f \u0442\u0438\u043f\u0430 " + (String)typeAddressWithPid.getFirst() + ". \u0421\u0442\u0440\u043e\u043a\u0430 \u0441 \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u0430");
                                continue;
                            }
                            item[3] = "1";
                            item[4] = "";
                            item[5] = "";
                            item[6] = "";
                            item[7] = "";
                            item[8] = "";
                            item[9] = "";
                            item[10] = "";
                            item[11] = "";
                            item[12] = "";
                            item[13] = unstructAddress.trim();
                        }
                        item[14] = incrementDateTo != null ? SormUtils.formatDateToUTC(incrementDateTo, "yyyy-MM-dd HH:mm:ss") : SormUtils.formatDateToUTC(contract.getDateFrom(), "yyyy-MM-dd HH:mm:ss");
                        item[15] = contract.getDateTo() != null ? SormUtils.formatDateToUTC(contract.getDateTo(), "yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59";
                        item[16] = "1";
                        item[17] = "";
                        item[18] = "";
                        this.writeItemToFile(item, cid, SpecTehFileTitles.ABONENTS_ADDR.getTitle(), csvFile);
                        this.addItemForUpdateLog(cid, item, SpecTehFileTitles.ABONENTS_ADDR.getTitle(), addressType);
                        if (contract.getFc() != 1) continue;
                        for (InternalUser internalUser : SormUtils.getInternalUsers(this.con, this.objectManager, this.valueManager, this.helper, this.config)) {
                            String[] internalItem = new String[19];
                            internalItem[1] = this.regionId;
                            internalItem[2] = "0";
                            AddressParamValue internalUserAddressStruct = internalUser.getAddressStruct();
                            if (internalUserAddressStruct != null) {
                                String region = SormUtils.getParameterOfCity(this, addressStruct, "region");
                                String zone = SormUtils.getParameterOfCity(this, addressStruct, "zone");
                                InternalUserAddressUtils addressUtils = new InternalUserAddressUtils(internalUserAddressStruct, this.con);
                                internalItem[3] = "0";
                                internalItem[4] = Utils.maskBlank((String)addressUtils.getIndex(), (String)"").trim();
                                internalItem[5] = Utils.maskBlank((String)addressUtils.getCountry(), (String)"\u0420\u043e\u0441\u0441\u0438\u044f").trim();
                                internalItem[6] = Utils.maskBlank((String)region, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                                internalItem[7] = Utils.maskBlank((String)zone, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                                internalItem[8] = Utils.maskBlank((String)addressUtils.getCity(), (String)"").trim();
                                internalItem[9] = Utils.maskBlank((String)addressUtils.getStreet(), (String)"").trim();
                                internalItem[10] = Utils.maskBlank((String)addressUtils.getHouse(), (String)"").trim();
                                internalItem[11] = Utils.maskBlank((String)addressUtils.getFrac(), (String)"").trim();
                                internalItem[12] = Utils.maskBlank((String)addressUtils.getFlat(), (String)"").trim();
                                internalItem[13] = "";
                            } else {
                                internalItem[3] = "1";
                                internalItem[4] = "";
                                internalItem[5] = "";
                                internalItem[6] = "";
                                internalItem[7] = "";
                                internalItem[8] = "";
                                internalItem[9] = "";
                                internalItem[10] = "";
                                internalItem[11] = "";
                                internalItem[12] = "";
                                internalItem[13] = Utils.maskBlank((String)internalUser.getAddress(), (String)"").trim();
                            }
                            internalItem[14] = internalUser.getDateFrom() != null ? SormUtils.formatDateToUTC(internalUser.getDateFrom(), "yyyy-MM-dd HH:mm:ss") : "";
                            internalItem[15] = internalUser.getDateTo() != null ? SormUtils.formatDateToUTC(internalUser.getDateTo(), "yyyy-MM-dd HH:mm:ss") : "";
                            internalItem[16] = "1";
                            internalItem[17] = internalUser.getId();
                            internalItem[18] = internalUser.getId();
                            this.writeItemToFile(internalItem, cid, SpecTehFileTitles.ABONENTS_ADDR.getTitle(), csvFile);
                        }
                    }
                }
                catch (Exception ex) {
                    this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0434\u043b\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430: " + addressItem.getFirst());
                }
            }
            this.logger.info("\u0417\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u0441 \u0430\u0434\u0440\u0435\u0441\u0430\u043c\u0438 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        }
        catch (IOException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path abonentLogins() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432(\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u0432) \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.ABONENTS_IDENT.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            String[] item;
            int cid;
            csvFile.writeNext(new String[]{"ABONENT_ID", "REGION_ID", "IDENT_TYPE", "PHONE", "INTERNAL_NUMBER", "IMSI", "IMEI", "ICC", "MIN", "ESN", "EQUIPMENT_TYPE", "MAC", "VPI", "VCI", "LOGIN", "E_MAIL", "PIN", "USER_DOMAIN", "RESERVED", "ORIGINATOR_NAME", "IP_TYPE", "IPV4", "IPV6", "IPV4_MASK", "IPV6_MASK", "BEGIN_TIME", "END_TIME", "LINE_OBJECT", "LINE_CROSS", "LINE_BLOCK", "LINE_PAIR", "LINE_RESERVED", "LOC_TYPE", "LOC_LAC", "LOC_CELL", "LOC_TA", "LOC_CELL_WIRELESS", "LOC_MAC", "LOC_LATITUDE", "LOC_LONGITUDE", "LOC_PROJECTION_TYPE", "RECORD_ACTION", "INTERNAL_ID1", "INTERNAL_ID2"});
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                List<InetServ> servicesList = SormUtils.getInetServices(this.config, this.serverContext, this.contracts);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f Inet. \u0412\u0441\u0435\u0433\u043e \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 InetServ: " + servicesList.size() + " \n\u0412\u0441\u0435\u0433\u043e \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: " + this.contracts.size());
                }
                for (InetServ serv : servicesList) {
                    String[] logItem;
                    cid = serv.getContractId();
                    Contract contract = this.contractManager.getContractById(cid);
                    if (!this.isFullUpload && (logItem = this.getLogItemFromCache(this.getIdentifierString(cid, SpecTehFileTitles.ABONENTS_IDENT.getTitle(), "inetServ=" + serv.getId()))) != null) {
                        logItem[41] = "2";
                        csvFile.writeNext(logItem);
                    }
                    try {
                        byte[] addressFrom = serv.getAddressFrom();
                        InetAddress inetAddress = null;
                        String subnetHex = "";
                        if (addressFrom != null) {
                            inetAddress = InetAddress.getByAddress(addressFrom);
                            SubnetUtils subnetUtils = new SubnetUtils(IpNet.newInstance((byte[])serv.getAddressFrom(), (byte[])serv.getAddressTo()).toString());
                            subnetHex = SormUtils.ip2Hex(subnetUtils.getInfo().getNetmask());
                        }
                        String ipv4 = inetAddress != null ? SormUtils.ip2Hex(inetAddress.getHostAddress()) : "";
                        byte[] mac = serv.getMacAddressListBytes();
                        String macStr = mac != null && mac.length > 0 ? Utils.bytesToString((byte[])mac) : "";
                        item = this.getLoginItem(cid, macStr, serv.getVlan() > 0 ? String.valueOf(serv.getVlan()) : "", serv.getLogin(), null, serv.getComment(), ipv4, serv.getDateFrom(), serv.getDateTo(), "5", subnetHex);
                        this.writeItemToFile(item, cid, SpecTehFileTitles.ABONENTS_IDENT.getTitle(), csvFile);
                        this.addItemForUpdateLog(cid, item, SpecTehFileTitles.ABONENTS_IDENT.getTitle(), "inetServ=" + serv.getId());
                        if (contract.getFc() != 1) continue;
                        this.writeInternalUsers(item, this.helper, csvFile);
                    }
                    catch (Exception ex) {
                        this.logger.error("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432. \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u043b\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430: " + serv.getContractId() + " \u0421\u0435\u0440\u0432\u0438\u0441: " + serv.getTitle() + " \u041e\u0448\u0438\u0431\u043a\u0430: " + ex);
                    }
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.DIAL_UP)) {
                List<DialUpLogin> logins = SormUtils.getDialUpLogins(this.serverContext, this.config, this.contracts);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f DialUp. \u0412\u0441\u0435\u0433\u043e \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435: " + logins.size());
                }
                for (DialUpLogin login : logins) {
                    String[] logItem;
                    cid = login.getCid();
                    if (!this.isFullUpload && (logItem = this.getLogItemFromCache(this.getIdentifierString(cid, SpecTehFileTitles.ABONENTS_IDENT.getTitle(), "dialUpLogin=" + login.getLogin() + ";cid=" + cid))) != null) {
                        logItem[41] = "2";
                        csvFile.writeNext(logItem);
                        logItem[26] = SormUtils.formatDateToUTC(new java.util.Date(), "yyyy-MM-dd HH:mm:ss");
                        logItem[41] = "1";
                        csvFile.writeNext(logItem);
                    }
                    try {
                        InetAddress address;
                        String subnetHex = "";
                        if (Utils.notBlankString((String)login.getIpv4()) && (address = InetAddress.getByName(login.getIpv4())) != null) {
                            SubnetUtils subnetUtils = new SubnetUtils(IpNet.newInstance((byte[])address.getAddress(), null).toString());
                            subnetHex = SormUtils.ip2Hex(subnetUtils.getInfo().getNetmask());
                        }
                        String ipv4 = Utils.isBlankString((String)login.getIpv4()) ? "" : SormUtils.ip2Hex(login.getIpv4());
                        String[] item2 = this.getLoginItem(cid, "", "", login.getLogin(), null, "", ipv4, login.getDateFrom(), login.getDateTo(), "5", subnetHex);
                        this.writeItemToFile(item2, cid, SpecTehFileTitles.ABONENTS_IDENT.getTitle(), csvFile);
                        this.addItemForUpdateLog(cid, item2, SpecTehFileTitles.ABONENTS_IDENT.getTitle(), "dialUpLogin=" + login.getLogin() + ";cid=" + cid);
                        Contract contract = this.contractManager.getContractById(cid);
                        if (contract == null || contract.getFc() != 1) continue;
                        this.writeInternalUsers(item2, this.helper, csvFile);
                    }
                    catch (Exception ex) {
                        this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u043b\u043e\u0433\u0438\u043d\u043e\u043c \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + cid + " \u041e\u0448\u0438\u0431\u043a\u0430: " + ex);
                    }
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                List<Integer> voiceMids = SormUtils.getTelephoneModulesIds(this.config).get(UploadModulesTitle.VOICE.getTitleModule());
                if (Utils.notEmptyCollection(voiceMids) && this.logger.isDebugEnabled()) {
                    this.logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f Voice");
                }
                for (Integer voiceMid : voiceMids) {
                    VoiceAccountService accountService = (VoiceAccountService)this.serverContext.getService(VoiceAccountService.class, voiceMid.intValue());
                    for (SormContract contract : this.contracts) {
                        this.helper.setCurrentContract(contract);
                        List accounts = accountService.voiceAccountList(contract.getContractId(), 0, new Period(contract.getDateFrom(), contract.getDateTo()));
                        for (Object account : accounts) {
                            String login = Utils.maskBlank((String)account.getLogin(), (String)contract.getContractTitle());
                            String number = account.getNumber() > 0L ? String.valueOf(account.getNumber()) : "";
                            item = this.getLoginItem(contract.getContractId(), null, null, login, number, account.getComment(), null, account.getDateFrom(), account.getDateTo(), "2", "");
                            this.writeItemToFile(item, account.getContractId(), SpecTehFileTitles.ABONENTS_IDENT.getTitle(), csvFile);
                            this.writeInternalUsers(item, this.helper, csvFile);
                        }
                    }
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.PHONE)) {
                List<Integer> phoneMids = SormUtils.getTelephoneModulesIds(this.config).get(UploadModulesTitle.PHONE.getTitleModule());
                if (Utils.notEmptyCollection(phoneMids) && this.logger.isDebugEnabled()) {
                    this.logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f Phone");
                }
                for (Integer phoneMid : phoneMids) {
                    ClientItemManager itemManager = new ClientItemManager(this.con, phoneMid.intValue());
                    for (SormContract contract : this.contracts) {
                        this.helper.setCurrentContract(contract);
                        for (ClientItem clientItem : itemManager.getItemList(contract.getContractId(), 1, false)) {
                            for (String number : clientItem.getClientNumbers()) {
                                java.util.Date dateFrom = clientItem.getDate1() != null ? clientItem.getDate1().getTime() : null;
                                java.util.Date dateTo = clientItem.getDate2() != null ? clientItem.getDate2().getTime() : null;
                                String[] item3 = this.getLoginItem(contract.getContractId(), null, null, contract.getContractTitle(), Utils.maskBlank((String)number, (String)""), null, null, dateFrom, dateTo, "2", "");
                                this.writeItemToFile(item3, contract.getContractId(), SpecTehFileTitles.ABONENTS_IDENT.getTitle(), csvFile);
                                this.writeInternalUsers(item3, this.helper, csvFile);
                            }
                        }
                    }
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.VOICE_IP)) {
                List<Integer> voiceIpMids = SormUtils.getTelephoneModulesIds(this.config).get(UploadModulesTitle.VOICE_IP.getTitleModule());
                if (Utils.notEmptyCollection(voiceIpMids) && this.logger.isDebugEnabled()) {
                    this.logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f VoiceIP");
                }
                for (Integer voiceIpMid : voiceIpMids) {
                    LoginInfoManager manager = new LoginInfoManager(this.con, voiceIpMid.intValue());
                    for (SormContract contract : this.contracts) {
                        for (LoginInfo loginInfo : manager.getLoginList(contract.getContractId(), 0)) {
                            String loginAlias = SormUtils.getAlias(this.con, voiceIpMid, loginInfo.getId());
                            String[] item4 = this.getLoginItem(contract.getContractId(), null, null, loginInfo.getLogin(), Utils.maskBlank((String)loginAlias, (String)""), null, null, loginInfo.getDateFrom(), loginInfo.getDateTo(), "2", "");
                            this.writeItemToFile(item4, contract.getContractId(), SpecTehFileTitles.ABONENTS_IDENT.getTitle(), csvFile);
                            this.writeInternalUsers(item4, this.helper, csvFile);
                        }
                    }
                }
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text);
        }
        return file;
    }

    protected String[] getLoginItem(int cid, String macStr, String vlan, String login, String phoneNumber, String comment, String ip, java.util.Date dateFrom, java.util.Date dateTo, String identType, String ip4Mask) {
        String[] item = new String[]{String.valueOf(cid), this.regionId, identType, Utils.maskBlank((String)phoneNumber, (String)""), "", "", "", "", "", "", "0", Utils.notBlankString((String)macStr) ? SormUtils.trimField(macStr.replaceAll(" ", ""), 12) : "", Utils.maskBlank((String)vlan, (String)""), "", login, "", "", "", "", "", Utils.notBlankString((String)ip) ? "0" : "", Utils.maskBlank((String)ip, (String)""), "", Utils.maskBlank((String)ip4Mask, (String)""), "", dateFrom != null ? SormUtils.formatDateToUTC(dateFrom, "yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00", dateTo != null ? SormUtils.formatDateToUTC(dateTo, "yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59", comment == null ? "" : SormUtils.trimField(comment.replaceAll("\n", "").replaceAll(";", ","), 127), "", "", "", "", "", "", "", "", "", "", "", "", "", "1", "", ""};
        return item;
    }

    protected void writeInternalUsers(String[] item, SormUploadHelper helper, CSVWriter csvFile) throws BGException {
        for (InternalUser internalUser : SormUtils.getInternalUsers(this.con, this.objectManager, this.valueManager, helper, this.config)) {
            String[] internalItem = Arrays.copyOfRange(item, 0, item.length);
            internalItem[28] = internalUser.getId();
            internalItem[29] = internalUser.getId();
            this.writeItemToFile(item, helper.getCurrentContract().getContractId(), SpecTehFileTitles.ABONENTS_IDENT.getTitle(), csvFile);
        }
    }

    @Override
    public Path services() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.SUPPLEMENTARY_SERVICE.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"ID", "MNEMONIC", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "REGION_ID"});
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430. \u0412\u0441\u0435\u0433\u043e \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + this.services.size());
                this.logger.debug("\u0423\u0441\u043b\u0443\u0433 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0430 = " + this.inetServices.size());
                this.logger.debug("\u0423\u0441\u043b\u0443\u0433 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438 = " + this.phoneServices.size());
            }
            for (ServiceSorm service : this.operatorServices) {
                try {
                    String dateFrom;
                    String[] item = new String[6];
                    item[0] = String.valueOf(service.getId());
                    String serviceTitle = service.getTitle();
                    item[1] = SormUtils.trimField(serviceTitle, 64);
                    String operatorStartDate = this.config.get("sorm.upload.operator.startdate");
                    if (Utils.notBlankString((String)operatorStartDate)) {
                        java.util.Date date = new SimpleDateFormat("dd.MM.yyyy").parse(operatorStartDate);
                        dateFrom = TimeUtils.format((java.util.Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                    } else {
                        dateFrom = "2005-01-01 00:00:00";
                    }
                    item[2] = dateFrom == null ? "2005-01-01 00:00:00" : dateFrom;
                    item[3] = "2049-12-31 23:59:59";
                    item[4] = Utils.maskBlank((String)service.getDescription(), (String)serviceTitle);
                    item[5] = this.regionId;
                    this.writeItemToFile(item, -1, SpecTehFileTitles.SUPPLEMENTARY_SERVICE.getTitle(), csvFile);
                }
                catch (Exception ex) {
                    this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433\u0438: " + service.getTitle() + "ID: " + service.getId());
                }
            }
        }
        catch (IOException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path abonentServices() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.ABONENTS_SRV.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            String idsServices = Utils.toString(SormUtils.getIdsServices(this.config));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432. \u0412\u044b\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0443\u0441\u043b\u0443\u0433\u0438 \u0434\u043b\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432, \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0435\u0441\u0442\u044c \u043a\u0430\u043a\u0430\u044f-\u043b\u0438\u0431\u043e \u0443\u0441\u043b\u0443\u0433\u0430 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430: " + idsServices);
                this.logger.debug("\u0410\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435: " + this.contracts.size());
            }
            csvFile.writeNext(new String[]{"ABONENT_ID", "REGION_ID", "ID", "BEGIN_TIME", "END_TIME", "PARAMETER", "SRV_CONTRACT", "RECORD_ACTION", "INTERNAL_ID1", "INTERNAL_ID2"});
            List<InstalledInstanceModule> npayModules = new SormServiceImpl().getInstanceModules("npay");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u041c\u043e\u0434\u0443\u043b\u0435\u0439 Npay \u043d\u0430\u0439\u0434\u0451\u043d\u043e: " + npayModules.size());
            }
            for (InstalledInstanceModule npayModule : npayModules) {
                String npayServiceTable = ServerUtils.getModuleTableName((String)"npay_service_object", (int)npayModule.getModuleId());
                String query = "SELECT nso.sid AS sid, s.title AS title, nso.date1 AS date1, nso.date2 AS date2 FROM " + npayServiceTable + " AS nso LEFT JOIN service AS s ON nso.sid=s.id WHERE nso.cid=?";
                if (Utils.notBlankString((String)idsServices)) {
                    query = query + " AND sid IN (" + idsServices + ")";
                }
                PreparedStatement ps = this.con.prepareStatement(query);
                try {
                    for (SormContract contract : this.contracts) {
                        int cid = contract.getContractId();
                        boolean thisContractInetServiceWasProcessed = false;
                        boolean thisContractPhoneServiceWasProcessed = false;
                        ps.setInt(1, cid);
                        ResultSet rs = ps.executeQuery();
                        while (rs.next()) {
                            String[] logItem;
                            int sid = rs.getInt("sid");
                            if (!this.isFullUpload && (logItem = this.getLogItemFromCache(this.getIdentifierString(cid, SpecTehFileTitles.ABONENTS_SRV.getTitle(), "abonentServiceId=" + sid))) != null) {
                                logItem[7] = "2";
                                csvFile.writeNext(logItem);
                            }
                            Date date1 = rs.getDate("date1");
                            Date date2 = rs.getDate("date2");
                            String[] item = new String[10];
                            item[0] = String.valueOf(cid);
                            item[1] = this.regionId;
                            int serviceId = -1;
                            if (this.inetServices.contains(sid) && !thisContractInetServiceWasProcessed) {
                                serviceId = this.inetService.getId();
                                thisContractInetServiceWasProcessed = true;
                            } else if (this.phoneServices.contains(sid) && !thisContractPhoneServiceWasProcessed) {
                                serviceId = this.phoneService.getId();
                                thisContractPhoneServiceWasProcessed = true;
                            }
                            if (serviceId < 0) continue;
                            item[2] = String.valueOf(serviceId);
                            item[3] = date1 != null && date1.before(new java.util.Date()) ? SormUtils.formatDateToUTC(date1, "yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
                            item[4] = date2 != null ? SormUtils.formatDateToUTC(date2, "yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59";
                            item[5] = "";
                            item[6] = String.valueOf(cid);
                            item[7] = "1";
                            item[8] = "";
                            item[9] = "";
                            this.writeItemToFile(item, cid, SpecTehFileTitles.ABONENTS_SRV.getTitle(), csvFile);
                            this.addItemForUpdateLog(cid, item, SpecTehFileTitles.ABONENTS_SRV.getTitle(), "abonentServiceId=" + sid);
                        }
                        rs.close();
                    }
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
        }
        catch (IOException | SQLException | BGException ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            this.logger.error(text + ex.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)ex, text);
        }
        return file;
    }

    @Override
    public Path ipNumbering() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.IP_PLAN.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"DESCRIPTION", "IP_TYPE", "IPV4", "IPV6", "IPV4_MASK", "IPV6_MASK", "BEGIN_TIME", "END_TIME", "REGION_ID"});
            Map<IpCategory, List<IpResource>> categoriesWithResources = SormUtils.getIPResources(this.config, this.serverContext);
            for (Map.Entry<IpCategory, List<IpResource>> entry : categoriesWithResources.entrySet()) {
                String ipCategoryComment = entry.getKey().getComment();
                for (IpResource ip : entry.getValue()) {
                    String cidrNotation = IpNet.newInstance((byte[])ip.getAddressFrom(), (byte[])ip.getAddressTo()).toString();
                    try {
                        SubnetUtils subnetUtils = new SubnetUtils(cidrNotation);
                        SubnetUtils.SubnetInfo info = subnetUtils.getInfo();
                        String[] item = new String[9];
                        String resourceComment = Utils.notBlankString((String)ip.getComment()) ? ip.getComment() : "";
                        item[0] = Utils.isBlankString((String)ipCategoryComment) ? resourceComment : ipCategoryComment;
                        item[1] = "0";
                        item[2] = SormUtils.ip2Hex(info.getAddress());
                        item[3] = "";
                        item[4] = SormUtils.ip2Hex(info.getNetmask());
                        item[5] = "";
                        item[6] = ip.getDateFrom() != null ? SormUtils.formatDateToUTC(ip.getDateFrom(), "yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
                        item[7] = ip.getDateTo() != null ? SormUtils.formatDateToUTC(ip.getDateTo(), "yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59";
                        item[8] = this.regionId;
                        this.writeItemToFile(item, -1, SpecTehFileTitles.IP_PLAN.getTitle(), csvFile);
                    }
                    catch (Exception e) {
                        this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 ip-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u043c: " + ip.getId() + " \u041e\u0448\u0438\u0431\u043a\u0430: " + e);
                    }
                }
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path abonentsIpNumbering() {
        return null;
    }

    @Override
    public Path switches() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.SWITCHES.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            String[] item;
            String[] item2;
            EntityAttrAddress address;
            csvFile.writeNext(new String[]{"SWITCH_ID", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "NETWORK_TYPE", "ADDRESS_TYPE_ID", "ADDRESS_TYPE", "ZIP", "COUNTRY", "REGION", "ZONE", "CITY", "STREET", "BUILDING", "BUILD_SECT", "APARTMENT", "UNSTRUCT_INFO", "SWITCH_SIGN", "SWITCH_TYPE", "REGION_ID"});
            if (this.config.get("sorm.upload.switches.enable", "").equals("1")) {
                if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                    for (Device device : SormUtils.getInetDevices(this.config, this.serverContext)) {
                        address = SormUtils.getAddressFromDeviceAttributes(device);
                        item2 = this.getSwitchItem(device.getId(), device.getTitle(), 4, address != null ? address.toString() : "", device.getDateFrom(), device.getDateTo());
                        this.writeItemToFile(item2, -1, MfiSoftFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
                if (this.checkInstalledModule(UploadModulesTitle.DIAL_UP)) {
                    for (DialUpNAS nas : SormUtils.getDialUpNasList(this.serverContext, this.config, true)) {
                        item = this.getSwitchItem(nas.getId(), nas.getTitle(), 4, nas.getComment(), nas.getDateFrom(), nas.getDateTo());
                        this.writeItemToFile(item, -1, MfiSoftFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
            }
            if (this.config.get("sorm.upload.commutators.enable").equals("1")) {
                if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                    for (Device voiceDevice : SormUtils.getVoiceDevices(this.config, this.serverContext)) {
                        address = SormUtils.getAddressFromDeviceAttributes(voiceDevice);
                        item2 = this.getSwitchItem(voiceDevice.getId(), voiceDevice.getTitle(), 3, address != null ? address.toString() : "", voiceDevice.getDateFrom(), voiceDevice.getDateTo());
                        this.writeItemToFile(item2, -1, MfiSoftFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
                if (this.checkInstalledModule(UploadModulesTitle.PHONE)) {
                    for (Source source : SormUtils.getPhoneSources(this.config, this.serverContext)) {
                        item = this.getSwitchItem(source.getId(), source.getTitle(), 3, source.getComment(), source.getDate1() != null ? source.getDate1().getTime() : null, source.getDate2() != null ? source.getDate2().getTime() : null);
                        this.writeItemToFile(item, -1, MfiSoftFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        return file;
    }

    private String[] getSwitchItem(int id, String title, int netType, String address, java.util.Date dateFrom, java.util.Date dateTo) {
        String[] item = new String[]{String.valueOf(id), dateFrom != null ? TimeUtils.format((java.util.Date)dateFrom, (String)"yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00", dateTo != null ? TimeUtils.format((java.util.Date)dateTo, (String)"yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59", Utils.maskBlank((String)title, (String)""), String.valueOf(netType), "3", Utils.isBlankString((String)address) ? "" : "1", "", "", "", "", "", "", "", "", "", Utils.maskBlank((String)address, (String)""), "", "0", this.regionId};
        return item;
    }

    @Override
    public Path gateways() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.GATEWAY.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"GATE_ID", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "GATE_TYPE", "ADDRESS_TYPE_ID", "ADDRESS_TYPE", "ZIP", "COUNTRY", "REGION", "ZONE", "CITY", "STREET", "BUILDING", "BUILD_SECT", "APARTMENT", "UNSTRUCT_INFO", "REGION_ID"});
            if (this.config.get("sorm.upload.switches.enable", "").equals("1")) {
                if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                    List<Device> inetDevices = SormUtils.getSelectedGateways(this.config, this.serverContext);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0448\u043b\u044e\u0437\u043e\u0432. \u0412\u0441\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0448\u043b\u044e\u0437\u043e\u0432: " + inetDevices.size());
                    }
                    Iterator<Device> iterator = inetDevices.iterator();
                    while (iterator.hasNext()) {
                        Device inetDevice = iterator.next();
                        try {
                            EntityAttrAddress address = SormUtils.getAddressFromDeviceAttributes(inetDevice);
                            House house = address != null ? this.houseDao.get(address.getHouseId()) : null;
                            String[] item = this.getGatewayItem(inetDevice.getId(), inetDevice.getComment(), inetDevice.getDateFrom(), inetDevice.getDateTo(), house, address != null ? address.toString() : "");
                            this.writeItemToFile(item, -1, SpecTehFileTitles.GATEWAY.getTitle(), csvFile);
                        }
                        catch (Exception ex) {
                            this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 InetDevice ID: " + inetDevice.getId());
                        }
                    }
                }
                if (this.checkInstalledModule(UploadModulesTitle.DIAL_UP)) {
                    for (DialUpNAS nas : SormUtils.getDialUpNasList(this.serverContext, this.config, false)) {
                        String[] item = this.getGatewayItem(nas.getId(), nas.getTitle(), nas.getDateFrom(), nas.getDateTo(), null, nas.getComment());
                        this.writeItemToFile(item, -1, SpecTehFileTitles.GATEWAY.getTitle(), csvFile);
                    }
                }
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text);
        }
        return file;
    }

    protected String[] getGatewayItem(int id, String comment, java.util.Date dateFrom, java.util.Date dateTo, House house, String address) {
        String[] item = new String[18];
        item[0] = String.valueOf(id);
        item[1] = dateFrom != null ? SormUtils.formatDateToUTC(dateFrom, "yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
        item[2] = dateTo != null ? SormUtils.formatDateToUTC(dateTo, "yyyy-MM-dd HH:mm:ss") : "2049-12-31 23:59:59";
        item[3] = Utils.maskBlank((String)comment, (String)"");
        item[4] = "7";
        item[5] = "3";
        if (house != null) {
            item[6] = "0";
            item[7] = Utils.maskBlank((String)house.getPostIndex(), (String)"");
            item[8] = "\u0420\u043e\u0441\u0441\u0438\u044f";
            item[9] = this.config.get("sorm.upload.regiontitle");
            item[10] = Utils.maskBlank((String)house.getAreaTitle(), (String)"");
            item[11] = house.getCityTitle();
            item[12] = house.getStreetTitle();
            item[13] = house.getHouse() > 0 ? String.valueOf(house.getHouse()) : "";
            item[14] = Utils.maskBlank((String)house.getFrac(), (String)"");
            item[15] = "";
            item[16] = "";
        } else {
            item[6] = "1";
            item[7] = "";
            item[8] = "";
            item[9] = "";
            item[10] = "";
            item[11] = "";
            item[12] = "";
            item[13] = "";
            item[14] = "";
            item[15] = "";
            item[16] = Utils.notBlankString((String)address) ? address : this.config.get("sorm.upload.operator.location");
        }
        item[17] = this.regionId;
        return item;
    }

    @Override
    public Path bunches() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430.");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.BUNCHES.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"GSM", "MAC", "VPI", "VCI", "SWITCH_ID", "BUNCH_TYPE", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "REGION_ID"});
            List<Bunch> bunches = SormUtils.getBunches(this.config);
            this.logger.info("\u041f\u0443\u0447\u043a\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + bunches.size());
            for (Bunch bunch : bunches) {
                String[] item = new String[10];
                item[0] = String.valueOf(bunch.getId());
                item[1] = Utils.maskBlank((String)bunch.getMac(), (String)"");
                item[2] = "";
                item[3] = "";
                item[4] = Utils.maskBlank((String)bunch.getIdCommutator(), (String)"");
                int directionalCode = bunch.getDirectional().equals((Object)Directional.BIDIRECTIONAL) ? 3 : bunch.getDirectional().ordinal();
                item[5] = String.valueOf(directionalCode);
                item[6] = bunch.getDateStart() != null ? SormUtils.formatDateToUTC(bunch.getDateStart(), "yyyy-MM-dd HH:mm:ss") : "";
                item[7] = bunch.getDateEnd() != null ? SormUtils.formatDateToUTC(bunch.getDateEnd(), "yyyy-MM-dd HH:mm:ss") : "";
                item[8] = Utils.maskBlank((String)bunch.getDescription(), (String)"");
                item[9] = this.regionId;
                this.writeItemToFile(item, -1, SpecTehFileTitles.BUNCHES.getTitle(), csvFile);
            }
        }
        catch (IOException | BGException ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text);
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)ex, text);
        }
        return file;
    }

    @Override
    public Path phoneNumbering() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0439 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        ArrayList<NumberRange> resources = new ArrayList<NumberRange>();
        resources.addAll(SormUtils.getUploadVoiceNumberingResources(this.config, this.serverContext));
        resources.addAll(SormUtils.getUploadPhoneNumberingResources(this.config, this.con));
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.PHONE_PLAN.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"ISO_3166_ALPHA_2", "ISO_3166_ALPHA_3", "COUNTRY_CODE", "NUMBER_PREFIX", "AREA_CODE_LENGTH", "MIN_NUMBER_LENGTH", "MAX_NUMBER_LENGTH", "UTC_MIN", "UTC_MAX", "COUNTRY_DEST", "NETWORK_TYPE", "CAPACITY_FROM", "CAPACITY_TO", "CAPACITY_SIZE", "LOCATION", "OPERATOR_NAME", "BEGIN_TIME", "END_TIME", "MCC", "MNC", "STATUS", "DESCRIPTION", "OPERATOR_CODE", "REGION_ID"});
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u0430\u044f \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u044f. \u0412\u0441\u0435\u0433\u043e \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432: " + resources.size());
            }
            for (NumberRange numberRange : resources) {
                try {
                    String lengthCodeOfPhone;
                    String phoneNumberPrefix = this.config.get("sorm.upload.operatornumberprefix", "");
                    String[] item = new String[]{"ru", "rus", "7", phoneNumberPrefix, lengthCodeOfPhone = this.config.get("sorm.upload.lengthcodeofphone", ""), "7", "7", "-12", "12", "\u0420\u043e\u0441\u0441\u0438\u044f", "3", SormUtils.trimField(String.valueOf(numberRange.getFromNumber()), 15), SormUtils.trimField(String.valueOf(numberRange.getToNumber()), 15), String.valueOf(numberRange.getToNumber() - numberRange.getFromNumber() + 1L), this.config.get("sorm.upload.operator.location"), this.config.get("sorm.upload.operator.title"), numberRange.getDateFrom() == null ? "" : SormUtils.formatDateToUTC(numberRange.getDateFrom(), "yyyy-MM-dd HH:mm:ss"), numberRange.getDateTo() == null ? "" : SormUtils.formatDateToUTC(numberRange.getDateTo(), "yyyy-MM-dd HH:mm:ss"), "250", "", TimeUtils.periodInRange((java.util.Date)new java.util.Date(), (java.util.Date)new java.util.Date(), (java.util.Date)numberRange.getDateFrom(), (java.util.Date)numberRange.getDateTo()) ? "\u0410\u043a\u0442\u0438\u0432\u043d\u0430" : "\u0420\u0435\u0437\u0435\u0440\u0432", Utils.isBlankString((String)numberRange.getComment()) ? "" : numberRange.getComment(), "", this.regionId};
                    this.writeItemToFile(item, -1, SpecTehFileTitles.PHONE_PLAN.getTitle(), csvFile);
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex);
                }
            }
        }
        catch (IOException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0439 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438: ";
            this.logger.error(text);
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path phoneNumberingAbonents() {
        return null;
    }

    @Override
    public Path documentTypes() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.DOC_TYPE.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"DOC_TYPE_ID", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "REGION_ID"});
            for (IdTitle docType : SormUtils.getDocumentsTypes(this.config, this.cpm)) {
                String[] item = new String[]{String.valueOf(docType.getId()), "2005-01-01 00:00:00", "2049-12-31 23:59:59", docType.getTitle(), this.regionId};
                this.writeItemToFile(item, -1, SpecTehFileTitles.DOC_TYPE.getTitle(), csvFile);
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text);
        }
        return file;
    }

    @Override
    public Path paymentTypes() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.PAY_TYPE.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"ID", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "REGION_ID"});
            for (PaymentType paymentType : this.paymentsToUpload.getPaymentTypesToUpload()) {
                String[] item = new String[]{String.valueOf(paymentType.getId()), "2005-01-01 00:00:00", "2049-12-31 23:59:59", paymentType.getTitle(), this.regionId};
                this.writeItemToFile(item, -1, SpecTehFileTitles.PAY_TYPE.getTitle(), csvFile);
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text);
        }
        return file;
    }

    @Override
    public Path abonentsPayments() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.PAYMENTS.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            csvFile.writeNext(new String[]{"REGION_ID", "PAYMENT_TYPE", "PAY_TYPE_ID", "PAYMENT_DATE", "AMOUNT", "AMOUNT_CURRENCY", "PHONE_NUMBER", "ACCOUNT", "ABONENT_ID", "BANK_ACCOUNT", "BANK_NAME", "EXPRESS_CARD_NUMBER", "TERMINAL_ID", "TERMINAL_NUMBER", "LATITUDE", "LONGITUDE", "PROJECTION_TYPE", "CENTER_ID", "DONATED_PHONE_NUMBER", "DONATED_ACCOUNT", "DONATED_INTERNAL_ID1", "DONATED_INTERNAL_ID2", "CARD_NUMBER", "PAY_PARAMS", "PERSON_RECIEVED", "BANK_DIVISION_NAME", "BANK_CARD_ID", "ADDRESS_TYPE_ID", "ADDRESS_TYPE", "ZIP", "COUNTRY", "REGION", "ZONE", "CITY", "STREET", "BUILDING", "BUILD_SECT", "APARTMENT", "UNSTRUCT_INFO", "RECORD_ACTION"});
            List<Payment> payments = this.paymentsToUpload.getPaymentsToUpload(true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + payments.size());
            }
            for (Payment payment : payments) {
                try {
                    String phoneNumber;
                    Contract contract = this.contractManager.getContractById(payment.getContractId());
                    if (contract == null) continue;
                    this.helper.setCurrentContract(contract);
                    int cid = contract.getId();
                    boolean isFiz = contract.getFc() == 0;
                    String[] item = new String[40];
                    item[0] = this.regionId;
                    String paymentType = this.paymentsToUpload.getPaymentTypeCode(payment.getTypeId());
                    boolean isNeedAddress = paymentType.equals(SpecTehPaymentType.BANK_TRANSACTION.getCodeStr()) || paymentType.equals(SpecTehPaymentType.TERMINAL_PAYMENT.getCodeStr()) || paymentType.equals(SpecTehPaymentType.CLIENT_CENTER.getCodeStr());
                    item[1] = paymentType;
                    item[2] = String.valueOf(payment.getTypeId());
                    item[3] = SormUtils.formatDateToUTC(payment.getDate(), "yyyy-MM-dd HH:mm:ss");
                    item[4] = Utils.formatBigDecimalSumm((BigDecimal)payment.getSum());
                    item[5] = "";
                    item[6] = phoneNumber = isFiz ? this.helper.getPhoneParam("sorm.upload.fiz.phone") : this.helper.getPhoneParam("sorm.upload.org.phone");
                    item[7] = contract.getTitle();
                    item[8] = String.valueOf(cid);
                    if (!isFiz && paymentType.equals(SpecTehPaymentType.BANK_TRANSACTION.getCodeStr())) {
                        item[9] = this.helper.getBankAccount();
                        item[10] = this.helper.getBankTitle();
                    } else {
                        item[9] = "";
                        item[10] = "";
                    }
                    item[11] = "";
                    item[12] = paymentType.equals(MfiSoftPaymentType.TERMINAL_PAYMENT.getCodeStr()) ? "0" : "";
                    item[13] = paymentType.equals(MfiSoftPaymentType.TERMINAL_PAYMENT.getCodeStr()) ? "0" : "";
                    item[14] = "";
                    item[15] = "";
                    item[16] = "";
                    String officeAddress = SormUtils.getFullOperatorAddress(this.config);
                    String string = item[17] = paymentType.equals(MfiSoftPaymentType.CLIENT_CENTER.getCodeStr()) ? officeAddress : "";
                    if (paymentType.equals(MfiSoftPaymentType.ANOTHER_CLIENT_ACCOUNT.getCodeStr())) {
                        item[18] = Utils.maskBlank((String)phoneNumber, (String)"");
                        item[19] = contract.getTitle();
                    } else {
                        item[18] = "";
                        item[19] = "";
                    }
                    item[20] = "";
                    item[21] = "";
                    item[22] = "";
                    item[23] = "";
                    item[24] = "";
                    item[25] = "";
                    item[26] = "";
                    AddressStruct address = this.helper.getAddress();
                    if (isNeedAddress && SormUtils.checkValidAddress(address)) {
                        item[27] = "0";
                        item[28] = "0";
                        item[29] = Utils.maskBlank((String)address.getIndex(), (String)"");
                        item[30] = "\u0420\u0424";
                        item[31] = this.config.get("sorm.upload.regiontitle", "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d");
                        item[32] = Utils.maskBlank((String)address.getArea(), (String)"");
                        item[33] = Utils.maskBlank((String)address.getCity(), (String)"");
                        item[34] = Utils.maskBlank((String)address.getStreet(), (String)"");
                        item[35] = Utils.maskBlank((String)address.getHouse(), (String)"");
                        item[36] = Utils.maskBlank((String)address.getFrac(), (String)"");
                        item[37] = Utils.maskBlank((String)address.getFlat(), (String)"");
                        item[38] = "";
                    } else if (isNeedAddress) {
                        item[27] = "0";
                        item[28] = "1";
                        item[29] = "";
                        item[30] = "";
                        item[31] = "";
                        item[32] = "";
                        item[33] = "";
                        item[34] = "";
                        item[35] = "";
                        item[36] = "";
                        item[37] = "";
                        item[38] = Utils.maskBlank((String)this.helper.getUnstructAddress(), (String)"");
                    } else {
                        item[27] = "";
                        item[28] = "";
                        item[29] = "";
                        item[30] = "";
                        item[31] = "";
                        item[32] = "";
                        item[33] = "";
                        item[34] = "";
                        item[35] = "";
                        item[36] = "";
                        item[37] = "";
                        item[38] = "";
                    }
                    item[39] = "1";
                    this.writeItemToFile(item, cid, SpecTehFileTitles.PAYMENTS.getTitle(), csvFile);
                }
                catch (Exception ex) {
                    this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + payment.getId() + " \u0414\u043e\u0433\u043e\u0432\u043e\u0440: " + payment.getContractId() + " \u041e\u0448\u0438\u0431\u043a\u0430: " + ex);
                }
            }
            if (Utils.notEmptyCollection(payments)) {
                this.paymentsToUpload.updatePaymentsLogTable(payments.get(payments.size() - 1).getId());
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path operatorInfo() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0431 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0435");
        Path uploadFile = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.REGIONS.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        try (SormCSVWriter csvWriter = SormUtils.getCSVFile(uploadFile, '\u0000');){
            csvWriter.writeNext(new String[]{"ID", "BEGIN_TIME", "END_TIME", "DESCRIPTION", "MCC", "MNC"});
            String[] item = new String[6];
            item[0] = this.regionId;
            LocalDate startDate = this.config.getLocalDate("sorm.upload.operator.startdate", null);
            item[1] = startDate != null ? SormUtils.formatDateToUTC(TimeUtils.convertLocalDateToDate((LocalDate)startDate), "yyyy-MM-dd HH:mm:ss") : "2005-01-01 00:00:00";
            item[2] = "2049-12-31 23:59:59";
            item[3] = this.config.get("sorm.upload.operator.title") + " " + this.config.get("sorm.upload.operator.location");
            item[4] = "";
            item[5] = "";
            this.writeItemToFile(item, -1, SpecTehFileTitles.REGIONS.getTitle(), csvWriter);
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u0444\u0438\u043b\u0438\u0430\u043b\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text);
        }
        return uploadFile;
    }

    @Override
    public List<Pair<String, Path>> getOtherFiles() {
        ArrayList<Pair<String, Path>> otherFiles = new ArrayList<Pair<String, Path>>();
        otherFiles.add(new Pair(null, (Object)this.IPGateway()));
        otherFiles.add(new Pair(null, (Object)this.internalUsersFile));
        return otherFiles;
    }

    protected Path IPGateway() {
        this.logger.info("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 IP_GATEWAY");
        Path file = SormUtils.getUploadFile(this.localUserPath, SpecTehFileTitles.IP_GATEWAY.getTitle(), "%s_%tY%tm%td_%tH%tM.txt");
        if (this.checkInstalledModule(UploadModulesTitle.INET)) {
            List<Device> inetDevices = SormUtils.getSelectedGateways(this.config, this.serverContext);
            if (Utils.isEmptyCollection(inetDevices)) {
                return file;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u0412\u0441\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u0434\u043b\u044f \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f IP_GATEWAY: " + inetDevices.size());
            }
            try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
                csvFile.writeNext(new String[]{"GATE_ID", "IP_TYPE", "IPV4", "IPV6", "IP_PORT", "REGION_ID"});
                for (Device inetDevice : inetDevices) {
                    String[] item = SormUtils.getIPGatewayItem(inetDevice, this.regionId);
                    if (item == null) continue;
                    this.writeItemToFile(item, -1, SpecTehFileTitles.IP_GATEWAY.getTitle(), csvFile);
                }
            }
            catch (IOException | BGException ex) {
                String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430 IP_GATEWAY: ";
                this.logger.error(text + ex.getMessage());
                SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)ex, text);
            }
        }
        return file;
    }

    protected void addItemForUpdateLog(int contractId, String[] item, String fileTitle, String metaInfo) {
        ItemLog itemLog = new ItemLog();
        itemLog.contractId = contractId;
        itemLog.fileTitle = fileTitle;
        itemLog.metaInfoFilter = metaInfo;
        itemLog.data = item;
        this.itemsForUpdateLog.add(itemLog);
    }

    protected void updateLogItems() throws BGException {
        String tableName = SormUploadLogsTable.getSpecTehLogTable(this.getModuleId());
        if (this.isFullUpload) {
            this.clearLogTable(tableName);
        } else {
            this.removeOldEntries(tableName);
        }
        String query = "INSERT INTO " + tableName + " SET data=?, fileTitle=?, meta=?, contractId=?, sormProjectId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (ItemLog itemLog : this.itemsForUpdateLog) {
                String[] item = itemLog.data;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < item.length; ++i) {
                    sb.append(item[i]);
                    if (i + 1 >= item.length) continue;
                    sb.append(";");
                }
                int index = 1;
                ps.setString(index++, sb.toString());
                ps.setString(index++, itemLog.fileTitle);
                ps.setString(index++, Utils.maskBlank((String)itemLog.metaInfoFilter, (String)""));
                ps.setInt(index++, itemLog.contractId);
                ps.setInt(index++, this.sormProject.getId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected void removeOldEntries(String tableName) {
        String deleteQuery = "delete from " + tableName + " where contractId=? AND sormProjectId=? AND meta=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(deleteQuery);){
            for (ItemLog itemLog : this.itemsForUpdateLog) {
                psDelete.setInt(1, itemLog.contractId);
                psDelete.setInt(2, this.sormProject.getId());
                psDelete.setString(3, Utils.maskBlank((String)itemLog.metaInfoFilter, (String)""));
                psDelete.addBatch();
            }
            psDelete.executeBatch();
        }
        catch (SQLException ex) {
            this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0440\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043a\u044d\u0448\u0430: ", (Throwable)ex);
        }
    }

    protected void clearLogTable(String tableName) {
        try (Statement statement = this.getConnection().createStatement();){
            statement.executeUpdate("DELETE FROM " + tableName + " WHERE id>0");
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
        }
    }

    @Override
    public void closeResources() {
        try {
            this.logger.debug("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0432 \u0442\u0430\u0431\u0438\u043b\u0446\u0443 \u0441 \u043b\u043e\u0433\u043e\u043c. \u0417\u0430\u043f\u0438\u0441\u0435\u0439=" + this.itemsForUpdateLog.size());
            this.updateLogItems();
        }
        catch (BGException e) {
            this.logger.error((Object)e);
        }
        super.closeResources();
    }
}

