/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.DialogComboBoxFilter;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.IdTitle;

public abstract class ElementEditorPanel
extends JPanel {
    protected final BotManagerService botManagerService;

    protected ElementEditorPanel(BotManagerService botManagerService) {
        this.botManagerService = botManagerService;
        this.setLayout(new GridBagLayout());
        this.init();
    }

    protected abstract void init();

    protected abstract void setElementToPanel(BotDialogElement var1);

    protected abstract void insertDataOfPanelToElement(BotDialogElement var1);

    private static final class BotManagerFileFilter
    extends FileFilter {
        private BotManagerFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return true;
        }

        @Override
        public String getDescription() {
            return "";
        }
    }

    public static class EmptyElementEditor
    extends ElementEditorPanel {
        public EmptyElementEditor(BotManagerService botManagerService) {
            super(botManagerService);
        }

        @Override
        protected void init() {
            JLabel infoLabel = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430");
            infoLabel.setFont(new Font("SansSerif", 1, 25));
            this.add((Component)infoLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        protected void setElementToPanel(BotDialogElement element) {
        }

        @Override
        protected void insertDataOfPanelToElement(BotDialogElement element) {
        }
    }

    protected static class AttachmentElementEditor
    extends ElementEditorPanel {
        private BGFileChooser fileChooser;
        private File currentFile;
        private JLabel fileLabel;
        private JLabel fileTitleLabel;
        private JTextArea description;

        protected AttachmentElementEditor(BotManagerService botManagerService) {
            super(botManagerService);
        }

        @Override
        protected void init() {
            JButton selectFile = new JButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0444\u0430\u0439\u043b");
            this.fileChooser = new BGFileChooser((Component)this);
            JPanel filePanel = this.getFilePanel();
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setFileFilter((FileFilter)new BotManagerFileFilter());
            selectFile.addActionListener(e -> {
                if (this.fileChooser.showOpenDialog() == 0) {
                    this.currentFile = this.fileChooser.getSelectedFile();
                    if (this.currentFile != null) {
                        if (this.getFileSizeToMB(this.currentFile) > 20.0) {
                            ClientUtils.showErrorMessageDialog((String)"\u0424\u0430\u0439\u043b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u0435\u0435 20\u043c\u0431.");
                        } else {
                            this.fileLabel.setIcon(ClientUtils.getIcon((String)"src_nojava"));
                            this.fileTitleLabel.setText(this.currentFile.getName());
                        }
                    }
                }
            });
            this.description = new JTextArea();
            this.add((Component)selectFile, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
            this.add((Component)filePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 3, 3));
            this.add((Component)new JScrollPane(this.description), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 3, 3, 3), 0, 0));
        }

        private JPanel getFilePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            BGSwingUtilites.wrapBorder((JPanel)panel, (String)"\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
            this.fileLabel = new JLabel();
            this.fileTitleLabel = new JLabel();
            panel.add((Component)this.fileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.fileTitleLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private double getFileSizeToMB(File file) {
            if (file == null) {
                return 0.0;
            }
            return (double)file.length() / 1048576.0;
        }

        @Override
        protected void setElementToPanel(BotDialogElement element) {
            this.description.setText(element.getJSONConfig().optString("text"));
            this.fileTitleLabel.setText(element.getJSONConfig().optString("attachmentFileTitle"));
            try {
                byte[] file = this.botManagerService.getFile(element.getId());
                if (file != null) {
                    this.fileLabel.setIcon(ClientUtils.getIcon((String)"src_nojava"));
                }
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        @Override
        protected void insertDataOfPanelToElement(BotDialogElement element) {
            JSONObject config = element.getJSONConfig();
            config.put("text", (Object)this.description.getText());
            config.put("attachmentFileTitle", (Object)this.fileTitleLabel.getText());
            element.setConfigElement(config.toString());
            if (this.currentFile != null) {
                try {
                    this.botManagerService.setFile(element, this.getFileBytes(this.currentFile));
                }
                catch (IOException | BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
        }

        private byte[] getFileBytes(File file) throws IOException {
            if (file == null) {
                return new byte[0];
            }
            byte[] bytes = new byte[(int)file.length()];
            try (FileInputStream fis = new FileInputStream(file);){
                fis.read(bytes);
            }
            return bytes;
        }
    }

    protected static class LinkElementEditor
    extends ElementEditorPanel {
        private JTextField titleLink;
        private JTextField link;

        protected LinkElementEditor(BotManagerService botManagerService) {
            super(botManagerService);
        }

        @Override
        protected void init() {
            this.titleLink = new JTextField();
            this.link = new JTextField();
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435(\u0435\u0441\u043b\u0438 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e, \u0442\u043e \u0431\u0443\u0434\u0435\u0442 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0441\u044b\u043b\u043a\u0430)"), constraints);
            this.add((Component)this.titleLink, constraints);
            this.add((Component)new JLabel("\u0421\u0441\u044b\u043b\u043a\u0430"), constraints);
            this.add((Component)this.link, constraints);
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        protected void setElementToPanel(BotDialogElement element) {
            this.titleLink.setText(element.getJSONConfig().optString("linkTitle"));
            this.link.setText(element.getJSONConfig().optString("text"));
        }

        @Override
        protected void insertDataOfPanelToElement(BotDialogElement element) {
            JSONObject config = element.getJSONConfig();
            config.put("linkTitle", (Object)this.titleLink.getText());
            config.put("text", (Object)this.link.getText());
            config.put("element_type", element.getElementType().ordinal());
            element.setConfigElement(config.toString());
        }
    }

    protected static class ButtonElementEditor
    extends ElementEditorPanel {
        JTextField buttonTitle;
        JCheckBox isInlineButton;
        DialogComboBoxFilter.DialogGroupComboBoxFilter groupDialogFilter;
        DialogComboBoxFilter.BotDialogComboBoxFilter dialogsFilter;
        List<BotDialog> dialogsList;
        ItemListener dialogGroupsFilterListener = e -> {
            if (e.getStateChange() == 1) {
                this.dialogsList.clear();
                try {
                    IdTitle selectedDialogGroup = (IdTitle)this.groupDialogFilter.getSelectedItem();
                    if (selectedDialogGroup != null && selectedDialogGroup.getId() == 0) {
                        this.dialogsList.addAll(this.botManagerService.getDialogs());
                    } else {
                        this.dialogsList.addAll(this.botManagerService.getDialogsByGroupId(selectedDialogGroup.getId()));
                    }
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                this.dialogsFilter.setData(this.dialogsList.stream().map(a -> a.toIdTitle()).toList());
            }
        };

        protected ButtonElementEditor(BotManagerService botManagerService) {
            super(botManagerService);
        }

        @Override
        protected void init() {
            try {
                this.dialogsList = new ArrayList<BotDialog>();
                this.dialogsList.addAll(this.botManagerService.getDialogs());
                this.groupDialogFilter = new DialogComboBoxFilter.DialogGroupComboBoxFilter(this.dialogGroupsFilterListener, this.botManagerService.getDialogGroups());
                this.dialogsFilter = new DialogComboBoxFilter.BotDialogComboBoxFilter(null, this.dialogsList);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.buttonTitle = new JTextField();
            this.isInlineButton = new JCheckBox();
            this.isInlineButton.setText("\u041a\u043d\u043e\u043f\u043a\u0430 \u0442\u0438\u043f\u0430 Inline");
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 0, 0, 0), 0, 0);
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430 \u043a\u043d\u043e\u043f\u043a\u0435"), constraints);
            this.add((Component)this.buttonTitle, constraints);
            this.add((Component)this.isInlineButton, constraints);
            this.add((Component)new JLabel("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0438\u0430\u043b\u043e\u0433\u0438 \u0438\u0437 \u0433\u0440\u0443\u043f\u043f\u044b"), constraints);
            this.add((Component)((Object)this.groupDialogFilter), constraints);
            this.add((Component)new JLabel("\u041f\u043e \u043d\u0430\u0436\u0430\u0442\u0438\u044e \u043a\u043d\u043e\u043f\u043a\u0438 \u0432\u044b\u0437\u0432\u0430\u0442\u044c \u0434\u0438\u0430\u043b\u043e\u0433"), constraints);
            this.add((Component)((Object)this.dialogsFilter), constraints);
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        protected void setElementToPanel(BotDialogElement element) {
            JSONObject config = element.getJSONConfig();
            this.buttonTitle.setText(config.optString("text", ""));
            this.isInlineButton.setSelected(element.getJSONConfig().optBoolean("isInline"));
            int nextDialogId = config.optInt("dialogProcessingClassPath", -1);
            if (nextDialogId > 0) {
                this.dialogsList.stream().filter(dialog -> dialog.getId() == nextDialogId).findFirst().ifPresent(dialog -> this.dialogsFilter.setSelectedItem(dialog));
            }
        }

        @Override
        protected void insertDataOfPanelToElement(BotDialogElement element) {
            JSONObject config = element.getJSONConfig();
            config.put("text", (Object)this.buttonTitle.getText());
            config.put("isInline", this.isInlineButton.isSelected());
            IdTitle selectedDialog = (IdTitle)this.dialogsFilter.getSelectedItem();
            if (selectedDialog != null && selectedDialog.getId() > 0) {
                config.put("dialogProcessingClassPath", selectedDialog.getId());
            }
            element.setConfigElement(config.toString());
        }
    }

    protected static class TextElementEditor
    extends ElementEditorPanel {
        private JTextArea text;

        protected TextElementEditor(BotManagerService botManagerService) {
            super(botManagerService);
        }

        @Override
        protected void init() {
            this.text = new JTextArea();
            this.text.setLineWrap(true);
            JScrollPane textScrollPane = new JScrollPane();
            textScrollPane.setHorizontalScrollBarPolicy(31);
            textScrollPane.getViewport().add(this.text);
            this.add((Component)textScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 0), 0, 0));
        }

        @Override
        protected void setElementToPanel(BotDialogElement element) {
            JSONObject config = element.getJSONConfig();
            this.text.setText(config.optString("text"));
        }

        @Override
        protected void insertDataOfPanelToElement(BotDialogElement element) {
            JSONObject config = element.getJSONConfig();
            config.put("text", (Object)this.text.getText());
            config.put("element_type", element.getElementType().ordinal());
            element.setConfigElement(config.toString());
        }
    }
}

