/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bots;

import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.BotSession;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.message.ResponseOnMessage;

public class TelegramRuntimeBot
extends RuntimeBot {
    private static final Logger logger = LogManager.getLogger();
    public static final String TELEGRAM_BOT_TOKEN_CONFIG_KEY = "telegrambot.token";
    public static final String TELEGRAM_BOT_WEBHOOK_URL = "telegrambot.webhook.url";
    private final String TELEGRAM_API_URL;
    private TelegramLongPollBot longPollingBot;
    private BotSession botSession;

    public TelegramRuntimeBot(Bot bot, int moduleId) throws BGException {
        super(bot, moduleId);
        this.TELEGRAM_API_URL = "https://api.telegram.org/bot" + bot.getToken();
    }

    @Override
    public void initBot() throws BGException {
        try {
            if (this.botId < 0) {
                throw new BGException("BotId < 0 in RuntimeBot");
            }
            if (this.moduleId < 0) {
                throw new BGException("ModuleId < 0 in RuntimeBot");
            }
            this.longPollingBot = new TelegramLongPollBot();
            this.botSession = new TelegramBotsApi(DefaultBotSession.class).registerBot((LongPollingBot)this.longPollingBot);
        }
        catch (TelegramApiException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void startBot() {
        try {
            if (this.botSession == null) {
                logger.error("BotSession is null! \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0442\u0430\u0440\u0442\u043e\u0432\u0430\u0442\u044c \u0431\u043e\u0442\u0430");
                return;
            }
            if (this.botSession.isRunning()) {
                logger.info("\u0411\u043e\u0442 id=" + this.botId + " \u0437\u0430\u043f\u0443\u0449\u0435\u043d!");
            } else {
                logger.info("\u0417\u0430\u043f\u0443\u0441\u043a \u0431\u043e\u0442\u0430 id=" + this.botId);
                this.botSession.start();
            }
        }
        catch (IllegalStateException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void stopBot() {
        if (this.botSession != null) {
            logger.info("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0431\u043e\u0442\u0430 id=" + this.botId);
            this.botSession.stop();
        }
    }

    public TelegramLongPollBot getLongPollingBot() {
        return this.longPollingBot;
    }

    public class TelegramLongPollBot
    extends TelegramLongPollingBot {
        private final ResponseOnMessage responseOnMessage;
        private Stack<SendDocument> attachments = new Stack();

        TelegramLongPollBot() throws BGException {
            this.responseOnMessage = new ResponseOnMessage(TelegramRuntimeBot.this);
        }

        public void onUpdateReceived(Update update) {
            long chatId = -1L;
            String messageText = "";
            int messageId = -1;
            if (update.hasMessage()) {
                chatId = update.getMessage().getChatId();
                messageText = update.getMessage().getText();
            } else if (update.getCallbackQuery() != null) {
                chatId = update.getCallbackQuery().getFrom().getId();
                messageText = update.getCallbackQuery().getData();
                messageId = update.getCallbackQuery().getMessage().getMessageId();
            }
            this.messageNew(chatId, messageText, messageId);
        }

        public void messageNew(long chatId, String messageText, int messageId) {
            try {
                this.messageNew(this.responseOnMessage.response(chatId, messageText, messageId));
            }
            catch (BGException ex) {
                logger.error((Object)ex);
            }
        }

        public void messageNew(BotApiMethod<?> message) {
            try {
                this.execute(message);
                while (!this.attachments.empty()) {
                    this.execute(this.attachments.pop());
                }
            }
            catch (TelegramApiException ex) {
                logger.error((Object)ex);
            }
        }

        public String getBotToken() {
            return TelegramRuntimeBot.this.token;
        }

        public String getBotUsername() {
            return TelegramRuntimeBot.this.title;
        }

        public void addAttachment(SendDocument attachment) {
            this.attachments.push(attachment);
        }
    }
}

