package ru.bitel.bgbilling.modules.botmanager.dyn.auth;

import java.sql.Connection;
import java.util.Date;

import org.json.JSONObject;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;

public class ContractDataAfterAuth
    implements DialogProcessing
{
    private final static int FIRST_NAME_PID = 195;
    private final static int LAST_NAME_PID = 194;

    @Override
    public void preDialog( ServerContext serverContext, JSONObject chatData )
        throws BGException
    {
        int cid = chatData.optInt( CONTRACT_ID, -1 );
        if ( cid > 0 )
        {
            Connection connection = serverContext.getConnection();
            try ( ContractManager cm = new ContractManager( connection );
                  BalanceUtils balanceUtils = new BalanceUtils( serverContext.getConnection() ) )
            {
                Contract contract = cm.getContractById( cid );
                if ( contract != null )
                {
                    try ( ContractDao contractDao = new ContractDao( connection, User.USER_SERVER ) )
                    {
                        JSONObject macros = new JSONObject();
                        macros.put( "firstName", contractDao.getContractParameterTextAsString( cid, FIRST_NAME_PID ).orElse( "" ) );
                        macros.put( "lastName", contractDao.getContractParameterTextAsString( cid, LAST_NAME_PID ).orElse( "" ) );
                        macros.put( "status", contract.getStatus() == 0 ? "Активен" : "Приостановлен" );
                        macros.put( "balance", balanceUtils.getBalance( new Date(), cid ).toString() );
                        chatData.put( MACROS, macros );
                    }
                }
            }
        }
    }

    @Override
    public void processDialog( ServerContext serverContext, JSONObject chatData, String inputMessage )
    {}

    @Override
    public String title()
    {
        return "Отображение данных диалога после авторизации";
    }
}