/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.server.protocols.yd;

import bitel.billing.server.Server;
import bitel.billing.server.util.MailMsg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.modules.buyemoney.common.BuyemoneyStatus;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.BuyemoneyPayment;
import ru.bitel.bgbilling.modules.buyemoney.server.mail.MailSendRegistry;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolCurrency;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolManager;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.TransactionResult;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.yd.YdProtocolException;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.security.EyelessHostnameVerifier;
import ru.bitel.common.security.EyelessSSLSocketFactory;
import ru.bitel.common.security.GnuPG;
import ru.bitel.common.util.BGMoney;

public class YDProtocol
extends ProtocolCurrency {
    private static final String ENCODING = "windows-1251";

    @Override
    public TransactionResult transact(int transactId, String to, BGMoney sum, String comment) throws Exception {
        if (!YDProtocol.checkNumberPurse(to)) {
            throw new YdProtocolException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430 '" + to + "'");
        }
        String url = this.getProtocolParameter("url");
        String curcode = this.getProtocolParameter("curcode");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("ACT_CD", "1002");
        parameters.put("VERSION", "2.02");
        parameters.put("TR_NR", String.valueOf(transactId));
        parameters.put("DSTACNT_NR", to);
        parameters.put("TR_AMT", sum.toString());
        parameters.put("CUR_CD", curcode);
        Map<String, String> reply = this.doRequest(url, parameters, "TR_NR&ACT_CD&DSTACNT_NR&TR_AMT&CUR_CD");
        TransactionResult result = this.checkReply(reply);
        result.setTransactId(transactId);
        if (result.getStatus() != BuyemoneyStatus.OK) {
            return result;
        }
        parameters.clear();
        parameters.put("ACT_CD", "1");
        parameters.put("VERSION", "2.02");
        parameters.put("TR_NR", String.valueOf(transactId));
        parameters.put("DSTACNT_NR", to);
        parameters.put("TR_AMT", sum.toString());
        parameters.put("CUR_CD", curcode);
        parameters.put("CONT", (String)(comment != null ? comment.substring(0, Math.min(comment.length(), 128)) : "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u044b, \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f " + transactId));
        reply = this.doRequest(url, parameters, "TR_NR&ACT_CD&DSTACNT_NR&TR_AMT&CUR_CD&CONT");
        result = this.checkReply(reply);
        result.setTransactId(transactId);
        try {
            Date date = YDProtocol.getPerformedDate(reply);
            result.setDate(date);
        }
        catch (Exception e) {
            result.setStatus(BuyemoneyStatus.NEW);
            result.setComment("\u0411\u044b\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0434\u0430\u0442\u044b " + e.getMessage());
            result.setDate(null);
        }
        return result;
    }

    @Override
    public TransactionResult getResult(long transactId) throws Exception {
        String url = this.getProtocolParameter("url");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("ACT_CD", "1001");
        parameters.put("VERSION", "2.02");
        parameters.put("TR_NR", String.valueOf(transactId));
        Map<String, String> reply = this.doRequest(url, parameters, "TR_NR&ACT_CD");
        TransactionResult result = this.checkReply(reply);
        Date date = YDProtocol.getPerformedDate(reply);
        result.setDate(date);
        result.setTransactId(transactId);
        return result;
    }

    @Override
    public void getResults(Collection<TransactionResult> transactions) throws Exception {
        for (TransactionResult result : transactions) {
            TransactionResult resultNew = this.getResult(result.getTransactId());
            result.setStatus(resultNew.getStatus());
            result.setComment(resultNew.getComment());
            result.setDate(resultNew.getDate());
        }
    }

    @Override
    public Map<String, String> getInfo() throws Exception {
        String url = this.getProtocolParameter("url");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("ACT_CD", "1003");
        parameters.put("VERSION", "2.02");
        Map<String, String> reply = this.doRequest(url, parameters, "ACT_CD");
        TransactionResult result = this.checkReply(reply);
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("\u0411\u0430\u043b\u0430\u043d\u0441", (String)(result.getStatus() == BuyemoneyStatus.OK ? this.getBalance(reply).toString() : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e (\u0441\u0442\u0430\u0442\u0443\u0441: " + result.getStatus().getTitle() + ", \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: " + result.getComment() + ")"));
        return info;
    }

    @Override
    public void sendRegistry(Collection<BuyemoneyPayment> payments, Date yesterday, Preferences serverSetup, int moduleId) throws Exception {
        String registryMail = this.getProtocolParameter("registryMail");
        String filename = this.getProtocolParameter("Agent_ID") + "_" + TimeUtils.format((Date)yesterday, (String)"yyyyMMdd");
        String subject = "\u0420\u0435\u0435\u0441\u0442\u0440 \u043f\u0440\u0438\u043d\u044f\u0442\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439, " + TimeUtils.format((Date)yesterday, (String)"yyyy-MM-dd") + ", " + this.getProtocolParameter("Agent_name") + ".";
        int count = 0;
        BGMoney countSum = BGMoney.ZERO;
        StringBuilder table = new StringBuilder(1024);
        for (BuyemoneyPayment payment : payments) {
            if (payment.getStatus() != BuyemoneyStatus.OK) continue;
            table.append(TimeUtils.format((Date)payment.getDate(), (String)"dd.MM.yyyy")).append("\t").append(TimeUtils.format((Date)payment.getDate(), (String)"HH:mm:ss")).append("\t").append(payment.getId()).append("\t").append(payment.getPurse()).append("\t").append(payment.getSumcur().toString()).append("\r\n");
            ++count;
            countSum = countSum.add(payment.getSumcur());
        }
        StringBuilder registry = new StringBuilder(1024);
        registry.append("Agent_ID:").append(this.getProtocolParameter("Agent_ID")).append("\r\n");
        registry.append("Agent_name:").append(this.getProtocolParameter("Agent_name")).append("\r\n");
        registry.append("\u0421ontract_number:").append(this.getProtocolParameter("\u0421ontract_number")).append("\r\n");
        registry.append("Total:").append(count).append("\t").append(countSum.toString()).append("\r\n");
        if (count > 0) {
            registry.append("Table:Date\tTime\tTransaction\tAccount\tAmount\r\n");
            registry.append((CharSequence)table);
        }
        String reportBody = this.signAndEncrypt(registry.toString());
        MailSendRegistry mailData = new MailSendRegistry();
        mailData.setModuleId(moduleId);
        mailData.setRecipients(registryMail);
        mailData.setSubject(subject);
        mailData.addPart("file", "attachment", "text/plain", filename, reportBody.getBytes(ENCODING));
        new MailMsg(serverSetup).sendMessage((MailData)mailData);
        this.log.info("successful send mail to " + registryMail);
    }

    private TransactionResult checkReply(Map<String, String> reply) throws YdProtocolException {
        int RES_CD = Utils.parseInt((String)reply.get("RES_CD"), (int)-1);
        int ERR_CD = Utils.parseInt((String)reply.get("ERR_CD"), (int)-1);
        switch (RES_CD) {
            case 0: {
                return new TransactionResult(BuyemoneyStatus.OK, "\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e");
            }
            case 1: {
                return new TransactionResult(BuyemoneyStatus.NEW, "\u0412 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438");
            }
            case 3: {
                switch (ERR_CD) {
                    case 0: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041f\u043e \u043a\u043e\u0434\u0443 \u043e\u0448\u0438\u0431\u043a\u0438 \"\u041e\u0448\u0438\u0431\u043e\u043a \u043d\u0435\u0442\", \u043d\u043e \u0441\u0443\u0434\u044f \u043f\u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0443 - \u0435\u0441\u0442\u044c (RES_CD=3, ERR_CD=0)");
                    }
                    case 14: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u0430 \u0432\u0430\u043b\u044e\u0442\u0430 (CUR_CD).");
                    }
                    case 16: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u0434\u0430\u043d \u0441\u0447\u0435\u0442 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 (DSTACNT_NR). \u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0441\u0443\u043c\u043c\u0435 \u0438\u043b\u0438 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0441\u0447\u0435\u0442\u0430.");
                    }
                    case 17: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u0430 \u0441\u0443\u043c\u043c\u0430 (TR_AMT).");
                    }
                    case 18: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u0434\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438  (TR_NR).");
                    }
                    case 20: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 (ACT_CD).");
                    }
                    case 22: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b (\u043a\u0440\u043e\u043c\u0435 SIGN).");
                    }
                    case 24: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u0412\u0430\u043b\u044e\u0442\u0430 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0447\u0435\u0442\u0443.");
                    }
                    case 25: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043b\u0438\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430.");
                    }
                    case 26: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (TR_NR), \u043d\u043e \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u0443\u0436\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u043b\u0430\u0441\u044c.");
                    }
                    case 50: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u043e\u0434\u043f\u0438\u0441\u044c (SIGN).");
                    }
                    case 51: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041f\u043e\u0434\u043f\u0438\u0441\u044c \u043d\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0430 (\u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430).");
                    }
                    case 53: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u0417\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u043c \u0421\u0438\u0441\u0442\u0435\u043c\u0435 PGP-\u043a\u043b\u044e\u0447\u043e\u043c.");
                    }
                    case 55: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u0418\u0441\u0442\u0435\u043a \u0441\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0443\u0431\u043b\u0438\u0447\u043d\u043e\u0433\u043e PGP-\u043a\u043b\u044e\u0447\u0430 \u0418\u0421 \u0410\u0433\u0435\u043d\u0442\u0430.");
                    }
                    case 56: {
                        throw new YdProtocolException(RES_CD, ERR_CD, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u043e\u0434\u043f\u0438\u0441\u0438(SIGN). \u041f\u043e\u0434\u043f\u0438\u0441\u044c \u043d\u0435 \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u043d\u0430 \u043a\u0430\u043a PGP-sign.");
                    }
                    case 40: {
                        return new TransactionResult(BuyemoneyStatus.FAIL, "\u0421\u0447\u0435\u0442 \u0437\u0430\u043a\u0440\u044b\u0442.");
                    }
                    case 41: {
                        return new TransactionResult(BuyemoneyStatus.FAIL, "\u0421\u0447\u0435\u0442 \u0432 \u0421\u0438\u0441\u0442\u0435\u043c\u0435 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d. \u0417\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u043d\u0435\u0433\u043e \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b.");
                    }
                    case 42: {
                        return new TransactionResult(BuyemoneyStatus.FAIL, "\u0421\u0447\u0435\u0442\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
                    }
                    case 43: {
                        return new TransactionResult(BuyemoneyStatus.FAIL, "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0435\u0434\u0438\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0437\u0430\u0447\u0438\u0441\u043b\u044f\u0435\u043c\u0443\u044e \u0441\u0443\u043c\u043c\u0443.");
                    }
                    case 44: {
                        return new TransactionResult(BuyemoneyStatus.FAIL, "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0441\u0443\u043c\u043c\u0443 \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0439 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 \u0432\u0440\u0435\u043c\u0435\u043d\u0438. \u0414\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043f\u043e \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0449\u0430\u0442\u044c\u0441\u044f \u043a \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0443.");
                    }
                    case 45: {
                        return new TransactionResult(BuyemoneyStatus.FAIL, "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438.");
                    }
                    case 30: {
                        return new TransactionResult(BuyemoneyStatus.NEW, "\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u0421\u0438\u0441\u0442\u0435\u043c\u044b.");
                    }
                    case 19: {
                        return new TransactionResult(BuyemoneyStatus.FAIL, "\u0412 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0437\u0430\u0434\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 (TR_NR), \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u043b\u0441\u044f.");
                    }
                }
                throw new YdProtocolException(RES_CD, ERR_CD, "\u041d\u0435\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430. RES_CD=3, ERR_CD=" + ERR_CD);
            }
            case 30: {
                return new TransactionResult(BuyemoneyStatus.NEW, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430. \u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u0431\u043e\u0439 \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u0421\u0438\u0441\u0442\u0435\u043c\u044b.");
            }
        }
        throw new YdProtocolException(RES_CD, ERR_CD, "\u041d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 RES_CD=" + RES_CD);
    }

    private static Date getPerformedDate(Map<String, String> reply) throws YdProtocolException {
        Object strDate = reply.get("PERFORMED_DT");
        if (strDate != null) {
            try {
                strDate = ((String)strDate).substring(0, ((String)strDate).length() - 3) + ((String)strDate).substring(((String)strDate).length() - 2);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                return df.parse((String)strDate);
            }
            catch (ParseException e) {
                throw new YdProtocolException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 PERFORMED_DT=" + (String)strDate + ". " + e.getMessage());
            }
        }
        return null;
    }

    private BGMoney getBalance(Map<String, String> reply) throws YdProtocolException {
        String strBalsnce = reply.get("BALANCE");
        if (strBalsnce != null) {
            try {
                return new BGMoney(strBalsnce);
            }
            catch (NumberFormatException e) {
                throw new YdProtocolException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 BALANCE=" + strBalsnce + ". " + e.getMessage());
            }
        }
        return null;
    }

    private Map<String, String> doRequest(String formurl, Map<String, String> parameters, String signedParams) throws YdProtocolException {
        HashMap<String, String> document;
        block12: {
            document = null;
            HttpURLConnection con = null;
            try {
                StringBuilder sb = new StringBuilder();
                StringTokenizer st = new StringTokenizer(signedParams, "&");
                while (st.hasMoreTokens()) {
                    String paramValue = parameters.get(st.nextToken());
                    if (paramValue == null) {
                        throw new YdProtocolException("error signed params to invoke doRequest");
                    }
                    sb.append(paramValue);
                    if (!st.hasMoreTokens()) continue;
                    sb.append("&");
                }
                parameters.put("SIGN", this.makeSign(sb.toString()));
                HttpsURLConnection.setDefaultSSLSocketFactory(EyelessSSLSocketFactory.INSTANCE);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)EyelessHostnameVerifier.INSTANCE);
                URL url = new URL(formurl);
                con = (HttpsURLConnection)url.openConnection();
                con.setConnectTimeout(10000);
                con.setReadTimeout(10000);
                con.setRequestMethod("POST");
                con.setDoOutput(true);
                con.setDoInput(true);
                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                con.setAllowUserInteraction(true);
                PrintStream ps = new PrintStream(con.getOutputStream(), true);
                for (Map.Entry<String, String> param : parameters.entrySet()) {
                    ps.print(param.getKey());
                    ps.print('=');
                    ps.print(URLEncoder.encode(param.getValue(), ENCODING));
                    ps.print('&');
                }
                ps.flush();
                ps.close();
                if (con.getResponseCode() == 200) {
                    String signedText = YDProtocol.convertStreamToString(con.getInputStream());
                    String text = this.verifySign(signedText);
                    document = new HashMap<String, String>();
                    StringTokenizer tokenLine = new StringTokenizer(text, "\n");
                    while (tokenLine.hasMoreTokens()) {
                        String line = tokenLine.nextToken();
                        this.log.debug(line);
                        int eqPos = line.indexOf("=");
                        if (eqPos == -1) continue;
                        document.put(line.substring(0, eqPos), line.substring(eqPos + 1));
                    }
                    break block12;
                }
                throw new YdProtocolException("HTTP response code '" + con.getResponseCode() + "' not equals HTTP_OK");
            }
            catch (Exception e) {
                if (e instanceof YdProtocolException) {
                    throw (YdProtocolException)((Object)e);
                }
                throw new YdProtocolException(e.toString());
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) throws IOException {
        String result = "";
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                reader.close();
            }
            finally {
                is.close();
            }
            result = sb.toString();
        }
        return result;
    }

    private static boolean checkNumberPurse(String number) {
        try {
            if (number == null || number.isEmpty()) {
                return false;
            }
            int N = Integer.parseInt(number.substring(0, 1));
            if (N == 0) {
                return false;
            }
            if (number.length() < N + 4) {
                return false;
            }
            if (number.endsWith("00")) {
                return false;
            }
            String X = number.substring(1, 1 + N);
            int Z = Integer.parseInt(number.substring(number.length() - 2, number.length()));
            String Y = number.substring(1 + N, number.length() - 2);
            if (Y.length() > 20) {
                return false;
            }
            if (YDProtocol.AccountNumberRedundancy(X, Y) != Z) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static int AccountNumberRedundancy(String x, String y) throws Exception {
        int Ti;
        int i;
        int[] Xi = new int[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            Xi[i2] = i2 < x.length() ? Integer.parseInt(x.substring(x.length() - 1 - i2, x.length() - i2)) : 0;
        }
        int[] Yi = new int[20];
        for (int i3 = 0; i3 < 20; ++i3) {
            Yi[i3] = i3 < y.length() ? Integer.parseInt(y.substring(y.length() - 1 - i3, y.length() - i3)) : 0;
        }
        int Z = 0;
        int A = 70;
        for (i = 0; i < 20; ++i) {
            Ti = Yi[i] == 0 ? 10 : Yi[i];
            Z = (Z + Ti * A % 99) % 99;
            A = A * 13 % 99;
        }
        for (i = 20; i < 30; ++i) {
            Ti = Xi[i - 20] == 0 ? 10 : Xi[i - 20];
            Z = (Z + Ti * A % 99) % 99;
            A = A * 13 % 99;
        }
        return ++Z;
    }

    private String makeSign(String text) throws BGException {
        String passPhrase = this.getProtocolParameter("GpgPassPhrase");
        String publickeyFile = this.getProtocolParameter("publickeyFile");
        String privatekeyFile = this.getProtocolParameter("privatekeyFile");
        GnuPG pgp = new GnuPG(publickeyFile, privatekeyFile);
        try {
            return pgp.clearSign(text.getBytes("utf-8"), null, passPhrase);
        }
        catch (Exception e) {
            throw new YdProtocolException("error signing message", e);
        }
    }

    private String verifySign(String signedText) throws BGException {
        String publickeyFile = this.getProtocolParameter("publickeyFile");
        String privatekeyFile = this.getProtocolParameter("privatekeyFile");
        GnuPG pgp = new GnuPG(publickeyFile, privatekeyFile);
        try {
            if (pgp.verifySignature(signedText, "")) {
                Pattern pattern = Pattern.compile("-----BEGIN PGP SIGNED MESSAGE-----\nHash:.+\n\n(.*)\n-----BEGIN PGP SIGNATURE-----", 42);
                Matcher matcher = pattern.matcher(signedText);
                String results = null;
                if (matcher.find()) {
                    results = matcher.group(1);
                }
                if (results == null) {
                    throw new YdProtocolException("error parse signed message");
                }
                return results;
            }
            throw new YdProtocolException("error sign");
        }
        catch (Exception e) {
            throw new YdProtocolException("error verify sign", e);
        }
    }

    private String signAndEncrypt(String text) throws BGException {
        String passPhrase = this.getProtocolParameter("GpgPassPhrase");
        String publickeyFile = this.getProtocolParameter("publickeyFile");
        String privatekeyFile = this.getProtocolParameter("privatekeyFile");
        String registryGpgKeyID = this.getProtocolParameter("registryGpgKeyID");
        GnuPG pgp = new GnuPG(publickeyFile, privatekeyFile);
        try {
            return pgp.signAndEncrypt(text.getBytes("utf-8"), null, registryGpgKeyID, passPhrase);
        }
        catch (Exception e) {
            throw new YdProtocolException("error encrypt&signing message", e);
        }
    }

    public static void main(String[] args) throws Exception {
        String config = "currency.1.title=yandex RUR\ncurrency.1.code=yandex RUR\ncurrency.1.protocol=ru.bitel.bgbilling.modules.buyemoney.server.protocols.yd.YDProtocol\ncurrency.1.url=https://bo-demo02.yamoney.ru/onlinegates/maglan.aspx\ncurrency.1.curcode=10643\ncurrency.1.GpgPassPhrase=123456\ncurrency.1.GpgFullPath=/usr/bin/gpg\ncurrency.1.pursePid=35\ncurrency.1.chargeType=55\ncurrency.1.chargeCommentTemplate=\u041f\u043e\u043a\u0443\u043f\u043a\u0430 ${sumcur} ${cur} \u0437\u0430 ${sumtotal} (\u043a\u0443\u0440\u0441 ${rateprice}, \u0434\u0430\u0442\u0430 ${date}, \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f ${id})\ncurrency.1.transactCommentTemplate=${contract} (${contract_comment}), \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f ${id}\ncurrency.1.registryMail=dimon@bitel.ru\ncurrency.1.Agent_ID=123456\ncurrency.1.Agent_name=\u041e\u041e\u041e \u00ab\u041f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435\u00bb\ncurrency.1.\u0421ontract_number=2000.998.001\ncurrency.1.registryGpgKeyID=BCD3ACEF";
        Preferences setup = new Preferences(config, "\n");
        ProtocolManager protocolManager = new ProtocolManager((ParameterMap)setup, LogManager.getLogger());
        ProtocolCurrency protocolCurrency = protocolManager.getProtocols().get(1);
        Server.initSetup();
        ArrayList<BuyemoneyPayment> list = new ArrayList<BuyemoneyPayment>();
        BuyemoneyPayment payment = new BuyemoneyPayment();
        payment.setSumcur(new BGMoney(10L));
        payment.setDate(new Date());
        payment.setPurse("123456789");
        payment.setStatus(BuyemoneyStatus.OK);
        payment.setId(123);
        list.add(payment);
        protocolCurrency.sendRegistry(list, new Date(), (Preferences)Setup.getSetup(), 0);
    }
}

