/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import bitel.billing.server.contract.object.bean.ObjectManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterTask;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterCallManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterTaskManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionGetRegisterProblem
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        RegisterProblem ri;
        int id = this.getIntParameter("id", -1);
        Date time = TimeUtils.parseDate((String)this.getParameter("time"), (String)"dd.MM.yyyy HH:mm:ss");
        boolean historyMode = this.getBooleanParameter("historymode", false);
        if (id < 0 || historyMode && time == null) {
            throw new BGIllegalArgumentException();
        }
        ObjectManager om = new ObjectManager(this.con);
        RegisterProblemManager rm = new RegisterProblemManager(this.con);
        RegisterProblem registerProblem = ri = historyMode ? rm.getHistoryEntry(id, time.getTime()) : rm.getProblemByID(id);
        if (ri != null) {
            List callList;
            Element register_item = this.createElement(this.rootNode, "problem");
            register_item.setAttribute("executors", Utils.toString((Iterable)ri.getExecutors()));
            register_item.setAttribute("status", String.valueOf(ri.getStatus()));
            register_item.setAttribute("category", String.valueOf(ri.getCategoryId()));
            register_item.setAttribute("group", String.valueOf(ri.getGroupId()));
            register_item.setAttribute("urgency", String.valueOf(ri.getUrgency()));
            Element comment = this.createElement(register_item, "comment");
            this.stringToLines(comment, ri.getComment());
            Element resolution = this.createElement(register_item, "resolution");
            this.stringToLines(resolution, ri.getResolution());
            if (!historyMode && (callList = ri.getCalls()) != null) {
                StringBuffer calls = new StringBuffer();
                for (RegisterCall call : callList) {
                    ContractObject object;
                    if (calls.length() != 0) {
                        calls.append("\n");
                    }
                    calls.append("[");
                    calls.append(call.getId());
                    calls.append("] ");
                    calls.append(call.getContractTitle());
                    if (call.getObjectId() <= 0 || (object = om.getObject(call.getObjectId())) == null) continue;
                    calls.append(" (");
                    calls.append(object.getTitle());
                    calls.append(")");
                }
                register_item.setAttribute("calls", calls.toString());
            }
            Element used_groups = this.createElement(this.rootNode, "used_groups");
            for (String userdGroup : rm.getProblemUsedGroups(id)) {
                this.addListItem(used_groups, "", userdGroup);
            }
            List tList = ri.getTasks();
            if (tList != null) {
                RegisterTaskManager rtm = new RegisterTaskManager(this.con);
                RegisterCallManager rcm = new RegisterCallManager(this.con);
                Element taskList = this.createElement(this.rootNode, "task_list");
                List<RegisterCall> problemCallList = rcm.getProblemCallList(id);
                try (ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());){
                    Contract contract = null;
                    for (String t : tList) {
                        RegisterTask task = rtm.getTaskById(Integer.valueOf(t));
                        StringBuilder sb = new StringBuilder();
                        sb.append(String.valueOf(task.getContractId()));
                        if (Utils.notBlankString((String)task.getComment())) {
                            sb.append(" ( ");
                            sb.append(task.getComment());
                            sb.append(" )");
                        }
                        sb.append(" [ ");
                        sb.append(String.valueOf(t));
                        sb.append(" ]");
                        this.addListItem(taskList, String.valueOf(t), sb.toString());
                    }
                    for (RegisterCall rc : problemCallList) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: ");
                        sb.append(String.valueOf(rc.getContractId()));
                        contract = (Contract)contractDao.get(rc.getContractId());
                        if (contract == null) continue;
                        if (Utils.notBlankString((String)contract.getComment())) {
                            sb.append(" ( ");
                            sb.append(contract.getComment());
                            sb.append(" )");
                        }
                        this.addListItem(taskList, "new:" + contract.getId(), sb.toString());
                    }
                }
            }
        }
    }
}

