/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterSubject;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class RegisterSubjectManager {
    private Connection con;

    public RegisterSubjectManager(Connection con) {
        this.con = con;
    }

    public RegisterSubject getRegisterSubjectById(int id) throws BGException {
        RegisterSubject result = null;
        String query = "SELECT * FROM register_subject WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateRegisterSubject(String id, RegisterSubject value) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (id.equals("new")) {
                query = "INSERT INTO register_subject (title, gid, ac) VALUES (?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE register_subject SET title=?, gid=?, ac=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(4, Utils.parseInt((String)id, (int)-1));
            }
            ps.setString(1, value.getTitle());
            ps.setInt(2, value.getGroupId());
            ps.setInt(3, value.isAutoClose() ? 1 : 0);
            ps.executeUpdate();
            if (id.equals("new")) {
                value.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            } else {
                value.setId(Utils.parseInt((String)id, (int)-1));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteRegisterSubject(int id) throws BGException {
        String query = "DELETE FROM register_subject WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException();
        }
    }

    public List<RegisterSubject> getRegisterSubjectList() throws BGException {
        ArrayList<RegisterSubject> result = new ArrayList<RegisterSubject>();
        String query = "SELECT * FROM register_subject ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private RegisterSubject getFromRS(ResultSet rs) throws SQLException {
        return RegisterSubject.builder().setId(rs.getInt("id")).setGroupId(rs.getInt("gid")).setTitle(rs.getString("title")).setAutoClose(rs.getInt("ac") == 1).build();
    }
}

