/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.gar.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.gar.common.model.GarAddressType;
import ru.bitel.bgbilling.plugins.gar.common.model.GarLoadedHistoryEntry;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class GarAddressDao
extends AbstractDao<GarLoadedHistoryEntry> {
    private static final String LOADED_ADDRESS_TABLE_NAME = "gar_loaded_address";

    public GarAddressDao(Connection connection) {
        super(connection, 0, LOADED_ADDRESS_TABLE_NAME);
    }

    protected GarLoadedHistoryEntry getFromRS(ResultSet rs) throws SQLException, BGException {
        GarLoadedHistoryEntry historyEntry = new GarLoadedHistoryEntry();
        historyEntry.setId(rs.getInt("id"));
        historyEntry.setGarObjectId(rs.getLong("gar_object_id"));
        historyEntry.setGarObjectTitle(rs.getString("address_object_title"));
        historyEntry.setBgObjectId(rs.getInt("bg_entity_id"));
        historyEntry.setGarAddressType(GarAddressType.defineType((int)rs.getInt("address_object_type")));
        historyEntry.setLoadedTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("loaded_datetime")));
        historyEntry.setUserId(rs.getInt("user_id"));
        return historyEntry;
    }

    protected void updateImpl(GarLoadedHistoryEntry historyEntry) throws BGException, SQLException {
        String query = "INSERT INTO gar_loaded_address SET gar_object_id=?, bg_entity_id=?, address_object_type=?, address_object_title=?, loaded_datetime=?, userId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, historyEntry.getGarObjectId());
            ps.setInt(2, historyEntry.getGarAddressType().ordinal());
            ps.setInt(3, historyEntry.getBgObjectId());
            ps.setString(4, historyEntry.getGarObjectTitle());
            ps.setTimestamp(5, TimeUtils.convertDateToTimestamp((Date)(historyEntry.getLoadedTime() == null ? new Date() : historyEntry.getLoadedTime())));
            ps.setInt(6, historyEntry.getUserId());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<GarLoadedHistoryEntry> searchEntriesByGarObjectId(long garObjectId) throws BGException {
        return super.list("gar_object_id=?", null, new Object[]{garObjectId});
    }

    public void searchEntries(Date dateFrom, Date dateTo, SearchResult<GarLoadedHistoryEntry> searchResult) throws BGException {
        ArrayList<GarLoadedHistoryEntry> result = new ArrayList<GarLoadedHistoryEntry>();
        searchResult.setList(result);
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName;
        if (dateFrom != null || dateTo != null) {
            query = query + " WHERE ";
            if (dateFrom != null) {
                query = query + "loaded_datetime>?" + (dateTo != null ? " AND " : "");
            }
            if (dateTo != null) {
                query = query + "loaded_datetime<?";
            }
        }
        query = query + " ORDER BY id";
        if (page != null) {
            query = query + page.sqlLimit();
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            if (dateFrom != null || dateTo != null) {
                if (dateFrom != null) {
                    ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)dateFrom));
                }
                if (dateTo != null) {
                    ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)dateTo));
                }
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

