/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.gar.server.service;

import java.util.Collection;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.plugins.gar.common.model.GarAddressHouse;
import ru.bitel.bgbilling.plugins.gar.common.model.GarAddressStreet;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class GarLoader {
    private final AddressService addressService;
    private final int countryId;

    public GarLoader(int countryId, ServerContext serverContext) throws BGException {
        this.addressService = (AddressService)serverContext.getService(AddressService.class, 0);
        this.countryId = countryId;
    }

    protected City findCityByTitle(String cityName) throws BGException {
        List cityList = this.addressService.searchCityList(this.countryId, cityName, null, null).getList();
        return Utils.isEmptyCollection((Collection)cityList) ? null : (City)cityList.get(0);
    }

    protected int saveCityInDBIfNotExists(String cityName) throws BGException {
        if (this.findCityByTitle(cityName) == null) {
            return this.saveCityInDB(cityName);
        }
        return -1;
    }

    private int saveCityInDB(String cityName) throws BGException {
        City newCity = new City();
        newCity.setCountryId(this.countryId);
        newCity.setTitle(cityName);
        return this.addressService.cityUpdate(newCity);
    }

    protected int saveStreetInDBIfNotExists(int cityId, String streetTitle) throws BGException {
        List streets = this.addressService.searchStreetList(cityId, streetTitle, null, null).getList();
        if (Utils.isEmptyCollection((Collection)streets)) {
            return this.saveStreetInDB(cityId, streetTitle);
        }
        return -1;
    }

    private int saveStreetInDB(int cityId, String streetTitle) throws BGException {
        City city = this.addressService.cityGet(cityId);
        if (city == null) {
            throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0443\u043b\u0438\u0446\u0443 \u0432 \u0431\u0430\u0437\u0443 \u0434\u0430\u043d\u043d\u044b\u0445, \u0442.\u043a. \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u0430\u0441\u0435\u043b\u0451\u043d\u043d\u044b\u0439 \u043f\u0443\u043d\u043a\u0442. cityId=" + cityId);
        }
        Street street = new Street();
        street.setCity(city);
        street.setTitle(streetTitle);
        return this.addressService.streetUpdate(street);
    }

    protected void saveHousesByStreet(int bgStreetId, GarAddressStreet street) throws BGException {
        Street bgStreet = this.addressService.streetGet(bgStreetId);
        if (street != null && bgStreet != null && Utils.notEmptyCollection((Collection)street.getHouses())) {
            for (GarAddressHouse house : street.getHouses()) {
                House newHouse = new House();
                newHouse.setPostIndex(house.getPostIndex());
                newHouse.setStreetId(bgStreetId);
                newHouse.setStreetTitle(bgStreet.getTitle());
                newHouse.setCityId(bgStreet.getCity().getId());
                newHouse.setHouseAndFrac(house.getTitle());
                this.addressService.houseUpdate(newHouse);
            }
        }
    }
}

